/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.ui.common.IOperativeSetAware;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.column.EventSelectionFactory;
import com.jrockit.mc.flightrecorder.ui.components.graph.ChartConfiguration;
import com.jrockit.mc.flightrecorder.ui.components.graph.EventGraphTree;
import com.jrockit.mc.flightrecorder.ui.components.graph.GraphEvents;
import com.jrockit.mc.flightrecorder.ui.components.graph.LabelFormatter;
import com.jrockit.mc.flightrecorder.ui.components.graph.LabelFormatterAction;
import com.jrockit.mc.flightrecorder.ui.components.graph.Marquee;
import com.jrockit.mc.flightrecorder.ui.components.graph.RegionSelectAction;
import com.jrockit.mc.flightrecorder.ui.components.graph.RegionZoomAction;
import com.jrockit.mc.flightrecorder.ui.components.graph.RulerLine;
import com.jrockit.mc.flightrecorder.ui.components.graph.RulerMarker;
import com.jrockit.mc.flightrecorder.ui.components.graph.RulerModel;
import com.jrockit.mc.flightrecorder.ui.components.graph.StackTraceCopyAction;
import com.jrockit.mc.flightrecorder.ui.components.graph.SwingComponentWrapperCanvas;
import com.jrockit.mc.flightrecorder.ui.components.graph.ThreadEvents;
import com.jrockit.mc.flightrecorder.ui.components.graph.ThreadGraphRulerModel;
import com.jrockit.mc.flightrecorder.ui.components.graph.TooltipVerbosity;
import com.jrockit.mc.flightrecorder.ui.components.graph.TransitionDrawer;
import com.jrockit.mc.flightrecorder.ui.components.graph.TreeLeafFilter;
import com.jrockit.mc.flightrecorder.ui.components.graph.TreeNodeWrapper;
import com.jrockit.mc.flightrecorder.ui.components.graph.XRangeRuler;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.AWTRenderer;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.ObjectLocator;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderingComponent;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.SelectionVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.TooltipVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIComponentChange;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIModel;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.VisibilityVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.menus.OperativeSetMenu;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.range.RangeController;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeRespository;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.CheckedVisitor;
import com.jrockit.mc.flightrecorder.util.AlwaysTrueFilter;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.accessibility.AccessibilityConstants;
import com.jrockit.mc.ui.accessibility.MCAccessibleListener;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import com.jrockit.mc.ui.fields.FieldFilter;
import com.jrockit.mc.ui.fields.FilterMatcher;
import com.jrockit.mc.ui.handlers.MCContextMenuManager;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.MCToolBarManager;
import com.jrockit.mc.ui.misc.SelectionProvider;
import com.jrockit.mc.ui.misc.ToolTipManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.FormText;

public class ThreadGraphComponent
extends AbstractUIComponent
implements Marquee.ISelectedRegionListener,
UIComponentChange,
INavigatorSelectionChangeListener,
ITypeVisibilityChange,
IOperativeSetAware,
ITypeVisibilitySupport {
    private static Color filterColorForeground = UIPlugin.getDefault().getFontColorToolkit().getFilterForegroundColor();
    private static Color filterColorBackground = UIPlugin.getDefault().getFontColorToolkit().getFilterBackgroundColor();
    private static int GRAPH_TOOL_REGION_ZOOM = 1;
    private static int GRAPH_TOOL_REGION_SELECT = 2;
    private static final double GRAPH_MIDDLE = 0.5;
    private int m_graphTool = GRAPH_TOOL_REGION_ZOOM;
    private Composite eventGraphComposite;
    private SwingComponentWrapperCanvas canvas;
    private EventGraphTree tree;
    private Slider slider;
    private Text filterText;
    private XRangeRuler xRangeRuler;
    private VisibilityVisitor m_filter;
    private Menu m_pupupMenu;
    private Composite eventComposite;
    private Scale yScale;
    private boolean m_mightHaveGraphSelection;
    private ObjectLocator m_objectLocator;
    private ThreadGraphRulerModel m_threadGraphRuler;
    private boolean m_redraw = true;
    protected TransitionDrawer m_transitionDrawer;
    private ISelectionProvider m_selectionProvider;
    private RangeController m_rangeController;
    private Point m_lastContextMenuPress;

    private void setGraphTool(int tool) {
        this.m_graphTool = tool;
    }

    public boolean supportsToolbar() {
        return true;
    }

    public boolean initialize(IServiceLocator serviceLocator) {
        boolean initOK = super.initialize(serviceLocator);
        this.m_selectionProvider = new SelectionProvider();
        this.m_filter = new VisibilityVisitor(this.getChartConfig());
        UIModel model = new UIModel(serviceLocator, this.getChartConfig());
        model.initialize();
        serviceLocator.registerService((Object)model);
        serviceLocator.registerService((Object)new OperativeSetService(serviceLocator));
        this.getSite().activate();
        return initOK;
    }

    private FlightRecording getFlightRecording() {
        return (FlightRecording)this.getServiceLocator().getService(FlightRecording.class);
    }

    public void initializeToolbar(MCToolBarManager toolbar) {
        super.initializeToolbar(toolbar);
        RegionZoomAction rza = new RegionZoomAction();
        rza.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty()) && Boolean.TRUE.equals(event.getNewValue())) {
                    ThreadGraphComponent.this.setGraphTool(GRAPH_TOOL_REGION_ZOOM);
                }
            }
        });
        rza.setChecked(true);
        RegionSelectAction rsa = new RegionSelectAction();
        rsa.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty()) && Boolean.TRUE.equals(event.getNewValue())) {
                    ThreadGraphComponent.this.setGraphTool(GRAPH_TOOL_REGION_SELECT);
                }
            }
        });
        rsa.setChecked(false);
        this.setGraphTool(GRAPH_TOOL_REGION_ZOOM);
        toolbar.add((IAction)rza);
        toolbar.add((IAction)rsa);
    }

    protected UIModel getUIModel() {
        return (UIModel)this.getServiceLocator().getService(UIModel.class);
    }

    public Control createPart(Composite parent) {
        Composite clientComposite = this.getFormToolkit().createComposite(parent, 0);
        clientComposite.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        if (this.getChartConfig().getAllowFiltering()) {
            GridData gd1 = new GridData(4, 128, true, false);
            Composite filterComposite = this.createFilterComposite(clientComposite);
            filterComposite.setLayoutData((Object)gd1);
            this.getFormToolkit().paintBordersFor(filterComposite);
            ++layout.numColumns;
        }
        if (this.getChartConfig().getAllowTransitions()) {
            GridData gd2 = new GridData(4, 0x1000000, false, false);
            Button showTransitioButton = this.createTransitionButton(clientComposite);
            showTransitioButton.setLayoutData((Object)gd2);
            ++layout.numColumns;
        }
        if (this.getChartConfig().getAllowBackdrop()) {
            GridData gd3 = new GridData(4, 0x1000000, false, false);
            Button gcBackdropButton = this.createShowGCButton(clientComposite);
            gcBackdropButton.setLayoutData((Object)gd3);
            ++layout.numColumns;
        }
        if (this.getChartConfig().getAllowOperativeSet()) {
            GridData gd4 = new GridData(4, 0x1000000, false, false);
            Button operativeSetButton = this.createWorksetButton(clientComposite);
            operativeSetButton.setLayoutData((Object)gd4);
            ++layout.numColumns;
        }
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.horizontalSpan = layout.numColumns == 0 ? 1 : layout.numColumns;
        this.eventComposite = this.createEventGraph(clientComposite);
        this.eventComposite.setLayoutData((Object)gd5);
        this.getFormToolkit().paintBordersFor(this.eventComposite);
        clientComposite.setLayout((Layout)layout);
        this.eventComposite.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.getFormToolkit().paintBordersFor(clientComposite);
        this.initializePart();
        this.setupSelectionProvider();
        return clientComposite;
    }

    private void setupSelectionProvider() {
        this.getSite().setSelectionProvider(this.m_selectionProvider);
    }

    private ISelectionProvider getSelectionProvider() {
        return this.m_selectionProvider;
    }

    protected Button createTransitionButton(Composite clientComposite) {
        Button transitionButton = this.getFormToolkit().createButton(clientComposite, Messages.TRACK_COMPONENT_SHOW_TRANISTION_BUTTON_TEXT, 32);
        transitionButton.setSelection(this.getChartConfig().getShowTransition());
        final class ShowTransitionButtonListener
        extends SelectionAdapter {
            private final /* synthetic */ Button val$transitionButton;

            ShowTransitionButtonListener(Button button) {
                this.val$transitionButton = button;
            }

            public void widgetSelected(SelectionEvent e) {
                if (!this.val$transitionButton.isDisposed()) {
                    ThreadGraphComponent.this.getChartConfig().setShowTransitions(this.val$transitionButton.getSelection());
                    ThreadGraphComponent.this.getUIModel().getUIComponents().markComponentsDirty(false);
                }
            }
        }
        transitionButton.addSelectionListener((SelectionListener)new ShowTransitionButtonListener(transitionButton));
        return transitionButton;
    }

    protected Button createShowGCButton(Composite clientComposite) {
        Button gcBackdropButton = this.getFormToolkit().createButton(clientComposite, Messages.TRACK_COMPONENT_BUTTON_SHOW_GC_BACKDROP_TEXT, 32);
        gcBackdropButton.setSelection(this.getChartConfig().isGCBackdropVisible());
        final class WorkSetButtonListener
        extends SelectionAdapter {
            private final /* synthetic */ Button val$gcBackdropButton;

            WorkSetButtonListener(Button button) {
                this.val$gcBackdropButton = button;
            }

            public void widgetSelected(SelectionEvent e) {
                if (!this.val$gcBackdropButton.isDisposed()) {
                    ThreadGraphComponent.this.getChartConfig().setGCBackdropVisible(this.val$gcBackdropButton.getSelection());
                    ThreadGraphComponent.this.getUIModel().updateGCTrackVisibility();
                    ThreadGraphComponent.this.getUIModel().getUIComponents().markComponentsDirty(true);
                    ThreadGraphComponent.this.markStructuralDirty();
                }
            }
        }
        gcBackdropButton.addSelectionListener((SelectionListener)new WorkSetButtonListener(gcBackdropButton));
        return gcBackdropButton;
    }

    private ChartConfiguration getChartConfig() {
        return (ChartConfiguration)this.getComponentSettings().getChildObject("chartConfiguration", ChartConfiguration.class);
    }

    private int getGraphTool() {
        return this.m_graphTool;
    }

    private Button createWorksetButton(Composite clientComposite) {
        Button workSetSelectionButton = this.getFormToolkit().createButton(clientComposite, Messages.OPERATIVE_SET_SHOW_ONLY_SET_BUTTON_TEXT, 32);
        workSetSelectionButton.setSelection(this.m_filter.getShowOnlyWorkSet());
        final class WorkSetButtonListener
        extends SelectionAdapter {
            private final /* synthetic */ Button val$workSetSelectionButton;

            WorkSetButtonListener(Button button) {
                this.val$workSetSelectionButton = button;
            }

            public void widgetSelected(SelectionEvent e) {
                if (!this.val$workSetSelectionButton.isDisposed()) {
                    ThreadGraphComponent.this.m_filter.setShowOnlyWorkSet(this.val$workSetSelectionButton.getSelection());
                    ThreadGraphComponent.this.getUIModel().getUIComponents().markComponentsDirty(true);
                }
            }
        }
        workSetSelectionButton.addSelectionListener((SelectionListener)new WorkSetButtonListener(workSetSelectionButton));
        return workSetSelectionButton;
    }

    public void change(boolean structuralChange, boolean nonStructuralChange) {
        this.updateAll();
    }

    private Menu createContextMenu(final Composite container) {
        MCContextMenuManager menuManager = new MCContextMenuManager(this.getComponentDescriptor().getIdentifier());
        container.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                ThreadGraphComponent.this.m_lastContextMenuPress = e.display.map(null, (Control)container, e.x, e.y);
            }
        });
        menuManager.addMenuListener(new IMenuListener((MenuManager)menuManager){
            private final /* synthetic */ MenuManager val$menuManager;
            {
                this.val$menuManager = menuManager;
            }

            public void menuAboutToShow(IMenuManager manager) {
                OperativeSetService os = ThreadGraphComponent.this.getOperativeSetService();
                os.setSelectedRange(ThreadGraphComponent.this.getUIModel().getRangeMananger().getSelectedRange());
                if (((ThreadGraphComponent)ThreadGraphComponent.this).m_lastContextMenuPress.x > ((ThreadGraphComponent)ThreadGraphComponent.this).tree.leftColumnWidth) {
                    os.setEventFactory(new GraphEvents(ThreadGraphComponent.this.m_filter, ThreadGraphComponent.this.getRecording()));
                } else {
                    os.setEventFactory(new ThreadEvents(ThreadGraphComponent.this.tree, ThreadGraphComponent.this.m_filter, ThreadGraphComponent.this.getUIModel().getRangeMananger().getSelectedRange()));
                }
                this.val$menuManager.add((IContributionItem)new OperativeSetMenu(os));
            }
        });
        menuManager.addMenuListener(new IMenuListener((MenuManager)menuManager){
            private final /* synthetic */ MenuManager val$menuManager;
            {
                this.val$menuManager = menuManager;
            }

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)ThreadGraphComponent.this.createFormatterMenu(this.val$menuManager));
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GraphEvents events = new GraphEvents(ThreadGraphComponent.this.m_filter, ThreadGraphComponent.this.getRecording());
                Iterator<IEvent> iterator = events.iterator();
                if (iterator.hasNext()) {
                    iterator.next();
                    if (iterator.hasNext()) {
                        manager.add((IAction)new StackTraceCopyAction(events, false));
                    } else {
                        manager.add((IAction)new StackTraceCopyAction(events, true));
                    }
                }
            }
        });
        menuManager.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu((MenuManager)menuManager, this.getSelectionProvider());
        Menu menu = menuManager.createContextMenu((Control)container);
        container.setMenu(menu);
        return menu;
    }

    private MenuManager createFormatterMenu(MenuManager menuManager) {
        MenuManager menu = new MenuManager(Messages.THREAD_GRAPH_COMPONENT_LABEL_MENU_TEXT);
        for (LabelFormatter formatter : this.tree.getLabelDrawer().getFormatters()) {
            this.addFormatterAction(menu, formatter);
        }
        return menu;
    }

    private void addFormatterAction(MenuManager menu, final LabelFormatter formatter) {
        final LabelFormatterAction action = new LabelFormatterAction(this.tree.getLabelDrawer(), formatter);
        menu.add((IAction)action);
        this.tree.getLabelDrawer().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                action.setChecked(ThreadGraphComponent.this.tree.getLabelDrawer().getFormatter() == formatter);
            }
        });
    }

    protected Collection<IEvent> getGCEvents() {
        SelectionVisitor v = new SelectionVisitor(this.getUIModel().getRangeMananger().getTotalRange(), AlwaysTrueFilter.getInstance());
        v.visit(this.getUIModel().getUIComponents().getGarbageCollector());
        ArrayList<IEvent> list = new ArrayList<IEvent>(v.getSelection().size());
        Iterator<IEvent> it = v.getSelection().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    protected boolean isGCSelected() {
        Object[] data;
        Object[] objectArray = data = this.tree.getSelectedData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof UIGarbageCollector) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void addTooltipVerbosity(Menu menu, String name, final TooltipVerbosity verbosity) {
        MenuItem menuItem = new MenuItem(menu, 16);
        TooltipVerbosity verbosityLevel = this.getChartConfig().getTooltipVerbosity();
        menuItem.setSelection(verbosity == verbosityLevel);
        menuItem.setText(name);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThreadGraphComponent.this.getChartConfig().setTooltipVerbosity(verbosity);
            }
        });
    }

    protected ArrayList<IEvent> getGraphSelection() {
        ArrayList<IEvent> list = new ArrayList<IEvent>();
        if (this.m_mightHaveGraphSelection) {
            for (IEvent event : this.getUIModel().getRangeMananger().getEventsInTotalRange()) {
                if (!EventToolkit.isPartOfGraphSelecion(event)) continue;
                list.add(event);
            }
        }
        return list;
    }

    public void clearTreeSelection() {
        this.tree.clearSelection();
    }

    private Composite createFilterComposite(Composite parent) {
        Composite filterComposite = this.getFormToolkit().createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        filterComposite.setLayout((Layout)layout);
        GridData gd0 = new GridData(16384, 0x1000000, false, false);
        Label label = this.getFormToolkit().createLabel(filterComposite, Messages.TRACK_COMPONENT_LABEL_FILTER_THREAD_NAMES_TEXT);
        label.setLayoutData((Object)gd0);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        this.filterText = this.getFormToolkit().createText(filterComposite, "", 0);
        this.filterText.setLayoutData((Object)gd2);
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && e.keyCode == 13) {
                    ThreadGraphComponent.this.updateFilter();
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ThreadGraphComponent.this.updateFilter();
            }
        });
        this.filterText.setToolTipText(Messages.THREAD_GRAPH_COMPONENT_TOOLTIP_TEXT);
        return filterComposite;
    }

    private void updateFilter() {
        this.tree.setFilter(new FieldTreeFilter(this.filterText.getText()));
        this.clearGraphSelection();
        this.getUIModel().getUIComponents().markComponentsDirty(false);
        this.markStructuralDirty();
        String text = this.filterText.getText().trim();
        if (text.length() == 0 && this.filterText.getBackground().equals((Object)filterColorBackground)) {
            this.filterText.setBackground(null);
            this.filterText.setForeground(null);
        } else if (text.length() > 0 && !this.filterText.getBackground().equals((Object)filterColorBackground)) {
            this.filterText.setBackground(filterColorBackground);
            this.filterText.setForeground(filterColorForeground);
        }
    }

    private Composite createEventGraph(Composite parent) {
        this.eventGraphComposite = this.getFormToolkit().createComposite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.eventGraphComposite.setLayout((Layout)layout);
        this.eventGraphComposite.addTraverseListener((TraverseListener)new SimpleTraverseListener(true));
        this.xRangeRuler = new XRangeRuler(this.eventGraphComposite, 0, this.getRecording().getTimeRange().getStartTimestamp());
        GridData xRangeLayoutData = new GridData(4, 128, true, false, 2, 1);
        xRangeLayoutData.heightHint = this.xRangeRuler.getHeight();
        this.xRangeRuler.setLayoutData(xRangeLayoutData);
        this.xRangeRuler.addTraverseListener((TraverseListener)new SimpleTraverseListener(true));
        this.m_objectLocator = new ObjectLocator(0);
        AWTRenderer renderer = new AWTRenderer(this.m_objectLocator, this.getChartConfig(), this.m_filter);
        RenderingComponent renderingComponent = new RenderingComponent(renderer);
        this.tree = new EventGraphTree(renderingComponent);
        this.canvas = new SwingComponentWrapperCanvas(this.eventGraphComposite, this.tree);
        Listener wheelListener = new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
                int offset = event.widget == ThreadGraphComponent.this.yScale ? ((ThreadGraphComponent)ThreadGraphComponent.this).yScale.getBounds().y : 0;
                double partOfHeightScaleCenter = (double)(offset + event.y) / (double)((ThreadGraphComponent)ThreadGraphComponent.this).canvas.getBounds().height;
                ThreadGraphComponent.this.updateControls(event.count, event.stateMask, partOfHeightScaleCenter);
            }
        };
        this.getFormToolkit().adapt((Composite)this.canvas);
        GridLayout canvasLayout = new GridLayout(1, false);
        canvasLayout.marginHeight = 0;
        canvasLayout.marginWidth = 0;
        canvasLayout.horizontalSpacing = 0;
        canvasLayout.verticalSpacing = 0;
        this.canvas.setLayout((Layout)canvasLayout);
        this.canvas.setLayoutData(new GridData(4, 4, true, true));
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1 && (e.stateMask & SWT.MOD4) == 0) {
                    if (e.x < ((ThreadGraphComponent)ThreadGraphComponent.this).tree.leftColumnWidth) {
                        ThreadGraphComponent.this.clearGraphSelection();
                    } else {
                        ThreadGraphComponent.this.clearTreeSelection();
                    }
                    ThreadGraphComponent.this.tree.performClick(e.x, e.y, (e.stateMask & 0x20000) != 0, (e.stateMask & SWT.MOD1) != 0);
                    ThreadGraphComponent.this.updateAll();
                }
            }
        });
        this.canvas.addListener(37, wheelListener);
        this.canvas.addTraverseListener((TraverseListener)new SimpleTraverseListener(true));
        this.m_pupupMenu = this.createContextMenu((Composite)this.canvas);
        this.tree.getLabelDrawer().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ThreadGraphComponent.this.refresh();
            }
        });
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            MCAccessibleListener mcAccessibleListener = new MCAccessibleListener();
            mcAccessibleListener.setName("Thread Graph");
            mcAccessibleListener.setComponentType(AccessibilityConstants.COMPONENT_TYPE_GRAPH);
            this.canvas.getAccessible().addAccessibleListener((AccessibleListener)mcAccessibleListener);
        }
        Marquee marquee = new Marquee((Composite)this.canvas);
        marquee.addSelectedRegionListener(this);
        this.slider = new Slider(this.eventGraphComposite, 512);
        this.getFormToolkit().adapt((Control)this.slider, false, false);
        this.slider.setLayoutData((Object)new GridData(131072, 4, false, true));
        this.slider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ThreadGraphComponent.this.m_redraw) {
                    ThreadGraphComponent.this.canvas.setClipStart(ThreadGraphComponent.this.slider.getSelection());
                    ThreadGraphComponent.this.canvas.redraw(0, 0, ((ThreadGraphComponent)ThreadGraphComponent.this).canvas.getSize().x, ((ThreadGraphComponent)ThreadGraphComponent.this).canvas.getSize().y, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.slider.setMinimum(0);
        this.yScale = new Scale((Composite)this.canvas, 512);
        this.getFormToolkit().adapt((Control)this.yScale, false, false);
        Color c = new Color((Device)this.canvas.getDisplay(), 255, 255, 255);
        this.yScale.setBackground(c);
        c.dispose();
        GridData gd = new GridData(131072, 1024, true, true);
        this.yScale.setSize(20, 40);
        gd.minimumHeight = 40;
        gd.minimumWidth = 20;
        gd.heightHint = 100;
        this.yScale.setLayoutData((Object)gd);
        this.yScale.addListener(37, wheelListener);
        this.yScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
                DisplayToolkit.safeAsyncExec((Widget)ThreadGraphComponent.this.slider, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ThreadGraphComponent.this.scaleMoved(0.5);
                    }
                });
            }
        });
        this.yScale.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                    int steps = event.keyCode == 0x1000001 ? 1 : -1;
                    ThreadGraphComponent.this.updateControls(steps, event.stateMask, 0.5);
                }
            }
        });
        this.yScale.setMinimum(this.tree.getMinimumRowHeight());
        this.yScale.setMaximum(150);
        this.yScale.setSelection(this.yScale.getMaximum() - this.tree.getRowHeight());
        this.scaleMoved(0.5);
        new ToolTipManager((Composite)this.canvas, (ToolTipManager.ToolTipProvider)new GraphTooltipProvider());
        return this.eventGraphComposite;
    }

    private void updateControls(final int steps, int stateMask, final double partOfHeightScaleCenter) {
        if ((stateMask & SWT.MOD1) != 0) {
            DisplayToolkit.safeAsyncExec((Widget)this.yScale, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ThreadGraphComponent.this.yScale.setSelection(ThreadGraphComponent.this.yScale.getSelection() - steps);
                    ThreadGraphComponent.this.scaleMoved(partOfHeightScaleCenter);
                }
            });
        } else {
            DisplayToolkit.safeAsyncExec((Widget)this.slider, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ThreadGraphComponent.this.slider.setSelection(ThreadGraphComponent.this.slider.getSelection() - steps * ThreadGraphComponent.this.slider.getIncrement());
                    ThreadGraphComponent.this.scaleMoved(partOfHeightScaleCenter);
                }
            });
        }
    }

    private void scaleMoved(double partOfHeightScaleCenter) {
        int oldHeight = this.tree.getPreferredSize().height;
        this.tree.setRowHeight(this.yScale.getMaximum() + this.yScale.getMinimum() - this.yScale.getSelection());
        int newHeight = this.tree.getPreferredSize().height;
        double change = (double)newHeight / (double)oldHeight;
        double preservedHeight = (double)this.slider.getThumb() * partOfHeightScaleCenter;
        double scaleCenter = ((double)this.slider.getSelection() + preservedHeight) * change;
        this.slider.setMaximum(newHeight);
        this.slider.setSelection((int)(scaleCenter - preservedHeight + 0.5));
        this.updateIncrements();
        this.updateAll();
    }

    private FlightRecording getRecording() {
        return (FlightRecording)this.getServiceLocator().getService(FlightRecording.class);
    }

    public void addAction(IAction action, String imageName) {
        MenuItem item = new MenuItem(this.m_pupupMenu, 0);
        String keyFormat = this.format(action.getAccelerator());
        if (keyFormat != null) {
            item.setText(String.valueOf(action.getText()) + '\t' + keyFormat);
        } else {
            item.setText(action.getText());
        }
        item.setImage(UIPlugin.getDefault().getImage(imageName));
        item.setAccelerator(action.getAccelerator());
        ActionSelector s = new ActionSelector(action);
        item.addSelectionListener((SelectionListener)s);
        this.yScale.addKeyListener((KeyListener)s);
    }

    private String format(int accelerator) {
        if ((accelerator & 0x10000) != 0) {
            String alt = SWTKeySupport.getKeyFormatterForPlatform().format(65536);
            int keyAccelerator = accelerator & 0xFFFEFFFF;
            String key = SWTKeySupport.getKeyFormatterForPlatform().format(keyAccelerator);
            if (alt != null) {
                return String.valueOf(alt) + "+" + key;
            }
        }
        return SWTKeySupport.getKeyFormatterForPlatform().format(accelerator);
    }

    protected void refresh() {
        this.tree.setData(this.getUIModel(), this.m_filter);
        this.updateAll();
    }

    private void updateAll() {
        this.eventGraphComposite.layout(true);
        int thumbSize = this.canvas.getSize().y;
        int maxSize = Math.max(this.tree.getPreferredSize().height, thumbSize);
        int maxSelection = maxSize - thumbSize;
        if (this.slider.getSelection() > maxSelection) {
            this.slider.setSelection(maxSelection);
        }
        this.slider.setMaximum(maxSize);
        this.slider.setThumb(thumbSize);
        this.canvas.setClipStart(this.slider.getSelection());
        this.xRangeRuler.setRange(this.getUIModel().getRangeMananger().getSelectedRange().getStartTimestamp(), this.getUIModel().getRangeMananger().getSelectedRange().getEndTimestamp());
        this.xRangeRuler.setEndMargin(this.eventGraphComposite.getSize().x - this.canvas.getSize().x);
        this.xRangeRuler.setStartPixel(this.tree.getLeftColumnWidth());
        this.eventGraphComposite.redraw(0, 0, this.eventGraphComposite.getSize().x, this.eventGraphComposite.getSize().y, true);
        if (this.m_threadGraphRuler != null) {
            this.m_threadGraphRuler.isOnScreen();
            this.m_threadGraphRuler.updateDeviceInformation(this.canvas.getSize().x, this.tree.getLeftColumnWidth());
        }
    }

    public void markStructuralDirty() {
        this.m_filter.clearCache();
        this.markDirty();
    }

    public boolean dispose(IServiceLocator locator) {
        super.dispose(locator);
        this.getUIModel().getUIComponents().removeListener(this);
        this.m_threadGraphRuler.dispose();
        return true;
    }

    @Override
    public void onChange(long startTime, long endTime) {
        this.getUIModel().getRangeMananger().setSelectedRange(this, (ITimeRange)new TimeRange(startTime, endTime));
        this.updateAll();
    }

    public void refreshPart() {
        if (this.isStale()) {
            this.tree.setData(this.getUIModel(), this.m_filter);
            this.updateAll();
        }
    }

    private boolean isStale() {
        return false;
    }

    protected void initializePart() {
        this.eventGraphComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ThreadGraphComponent.this.updateAll();
            }
        });
        this.tree.setData(this.getUIModel(), this.m_filter);
        this.tree.expandAll();
        this.getUIModel().getUIComponents().addListener(this);
        MenuItem showRuler = new MenuItem(this.canvas.getMenu(), 0);
        showRuler.setText(Messages.TRACK_COMPONENT_SHOW_RULER_AT_CENTER_MENU_TEXT);
        showRuler.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThreadGraphComponent.this.m_threadGraphRuler.show();
            }
        });
        this.m_transitionDrawer = new TransitionDrawer(this.getUIModel().getRecording(), this.getUIModel().getRangeMananger(), this.getChartConfig(), this.m_filter);
        this.tree.setTransitionDrawer(this.m_transitionDrawer);
        RulerModel rulerModel = new RulerModel(false, 0, this.getTree().getLeftColumnWidth(), 1024);
        this.m_threadGraphRuler = new ThreadGraphRulerModel(this.getUIModel().getRangeMananger(), rulerModel);
        new RulerLine((Composite)this.canvas, rulerModel);
        new RulerMarker((Composite)this.xRangeRuler, rulerModel);
        this.updateIncrements();
    }

    @Override
    public void onUIComponentChange(boolean structural) {
        if (structural) {
            this.markStructuralDirty();
        } else {
            this.markDirty();
        }
    }

    private ITimeRange getRangeFromDeviceCoordinates(int startX, int endX) {
        int size = this.tree.getWidth() - this.tree.getLeftColumnWidth();
        long start = this.fromDeviceToWorld(startX - this.tree.getLeftColumnWidth(), this.getUIModel().getRangeMananger().getSelectedRange(), size);
        long end = this.fromDeviceToWorld(endX - this.tree.getLeftColumnWidth(), this.getUIModel().getRangeMananger().getSelectedRange(), size);
        return new TimeRange(start, end);
    }

    private long fromDeviceToWorld(int pixel, ITimeRange worldRange, int deviceSize) {
        double normalized = (double)pixel / (double)deviceSize;
        long world_size = worldRange.getEndTimestamp() - worldRange.getStartTimestamp();
        return (long)((double)worldRange.getStartTimestamp() + normalized * (double)world_size);
    }

    private boolean zoomIn(int stateMask, Rectangle rectangle) {
        if (rectangle.width > 3 && rectangle.x > this.tree.getLeftColumnWidth()) {
            ITimeRange range = this.getRangeFromDeviceCoordinates(rectangle.x, rectangle.x + rectangle.width);
            if (range.getDuration() > 10L) {
                this.getUIModel().getRangeMananger().setSelectedRange(this, range);
                this.m_rangeController.setRange(range, true);
            }
            try {
                this.setRedraw(false);
                this.scaleBetweenYValues(rectangle.y, rectangle.y + rectangle.height);
                return true;
            }
            finally {
                this.setRedraw(true);
                this.updateAll();
            }
        }
        return false;
    }

    private void setRedraw(boolean redraw) {
        this.m_redraw = redraw;
    }

    private void scaleBetweenYValues(int yStartOnScreenControl, int yEndOnScreenControl) {
        int totalScreenHeight = this.canvas.getSize().y;
        int newScreenHeight = yEndOnScreenControl - yStartOnScreenControl;
        float magFactor = (float)totalScreenHeight / (float)newScreenHeight;
        int newRowHeight = (int)((float)this.tree.getRowHeight() * magFactor);
        if (newRowHeight > this.yScale.getMaximum()) {
            newRowHeight = this.yScale.getMaximum();
            magFactor = (float)newRowHeight / (float)this.tree.getRowHeight();
        }
        this.tree.setRowHeight(newRowHeight);
        this.yScale.setSelection(this.yScale.getMaximum() - this.tree.getRowHeight());
        int thumbSize = this.canvas.getSize().y;
        int maxSize = Math.max(this.tree.getPreferredSize().height, thumbSize);
        int selection = (int)((float)(this.slider.getSelection() + yStartOnScreenControl) * magFactor);
        int maxSelection = maxSize - thumbSize;
        this.updateIncrements();
        this.slider.setMaximum(maxSize);
        this.slider.setThumb(thumbSize);
        this.slider.setSelection(selection > maxSelection ? maxSelection : selection);
    }

    private void updateIncrements() {
        int thumbSize = this.canvas.getSize().y;
        this.slider.setIncrement(this.tree.getRowHeight());
        this.slider.setPageIncrement(Math.max(thumbSize - this.tree.getRowHeight(), this.tree.getRowHeight()));
    }

    EventGraphTree getTree() {
        return this.tree;
    }

    public List<IEvent> getSelectedObjects(int leftSWT, int rightSWT, int topSWT, int bottomSWT) {
        Point topleft = this.tree.translateSWTCoordToSwingCoord(leftSWT, topSWT);
        Point bottomRight = this.tree.translateSWTCoordToSwingCoord(rightSWT, bottomSWT);
        if (topleft.x >= this.tree.leftColumnWidth && topleft.y > 0) {
            SelectionVisitor selectionVisitor = new SelectionVisitor(this.getRangeFromDeviceCoordinates(topleft.x, bottomRight.x), this.m_filter);
            Visitable lastVisitable = null;
            int size = this.m_objectLocator.getSize();
            int n = topleft.y;
            while (n < bottomRight.y && n < size) {
                Visitable v = this.m_objectLocator.getObjectAt(n);
                if (v != null && v != lastVisitable) {
                    v.accept(selectionVisitor);
                }
                lastVisitable = v;
                ++n;
            }
            return selectionVisitor.getSelection();
        }
        return new ArrayList<IEvent>();
    }

    @Override
    public void onRegionSelect(int stateMask, Rectangle region) {
        if (region.width < 2 && region.height < 2) {
            this.select(stateMask, region);
            return;
        }
        if (this.getGraphTool() == GRAPH_TOOL_REGION_SELECT) {
            this.select(stateMask, region);
            return;
        }
        if (this.getGraphTool() == GRAPH_TOOL_REGION_ZOOM && this.zoomIn(stateMask, region)) {
            return;
        }
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    private void select(int stateMask, Rectangle region) {
        if (stateMask == 4711) {
            if (!this.regionPartOfSelection(region)) {
                this.clearGraphSelection();
                this.setGraphSelection(region, true);
            }
        } else if ((stateMask & SWT.MOD1) != 0) {
            this.setGraphSelection(region, true);
        } else if ((stateMask & 0x10000) != 0) {
            this.setGraphSelection(region, false);
        } else {
            this.clearGraphSelection();
            this.setGraphSelection(region, true);
        }
        this.getUIModel().getUIComponents().markComponentsDirty(false);
    }

    private boolean regionPartOfSelection(Rectangle region) {
        List<IEvent> c = this.getSelectedObjects(region.x, region.x + region.width + 1, region.y, region.y + region.height + 1);
        if (c.isEmpty()) {
            return false;
        }
        return EventToolkit.isPartOfGraphSelecion(c.get(0));
    }

    private void setGraphSelection(Rectangle region, boolean add) {
        List<IEvent> c = this.getSelectedObjects(region.x, region.x + region.width + 1, region.y, region.y + region.height + 1);
        if (add && c.size() != 0) {
            this.m_mightHaveGraphSelection = true;
        }
        for (IEvent event : c) {
            if (add) {
                EventToolkit.setPartOfGraphSelection(event);
                continue;
            }
            EventToolkit.setNotPartOfGraphSelection(event);
        }
        this.getSelectionProvider().setSelection(EventSelectionFactory.createSelectionWithFirstEvent(c));
    }

    private OperativeSetService getOperativeSetService() {
        return (OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class);
    }

    protected ISelectionProvider getWorkbenchPartSite() {
        return ((IWorkbenchPartSite)this.getServiceLocator().getService("workbenchPartSite")).getSelectionProvider();
    }

    private void clearGraphSelection() {
        if (this.m_mightHaveGraphSelection) {
            for (IEvent event : this.getUIModel().getRangeMananger().getEventsInTotalRange()) {
                EventToolkit.setNotPartOfGraphSelection(event);
            }
        }
        this.m_mightHaveGraphSelection = false;
    }

    protected void initializeUI() {
        this.m_filter.clearCache();
        TimeRange r = new TimeRange(this.getStartService().getStartTimestamp(), this.getStartService().getEndTimestamp());
        UIScope c = (UIScope)this.getServiceLocator().getService(UIScope.class);
        this.m_rangeController = new RangeController(c, this, (ITimeRange)r);
        if (this.getChartConfig().getEventTypes().getUserFilterConstrained()) {
            this.updateUserConstrainedEventVisibility();
        } else {
            this.updateEventVisibility();
        }
    }

    private StartService getStartService() {
        return (StartService)this.getServiceLocator().getService(StartService.class);
    }

    public boolean initializeToolTip(FormText text, int x, int y) {
        String transitionTooltipText;
        ChartConfiguration config = this.getChartConfig();
        Point p = this.getTree().translateSWTCoordToSwingCoord(x, y);
        p.x -= this.tree.leftColumnWidth;
        if (this.getChartConfig().getShowTransition() && (transitionTooltipText = this.m_transitionDrawer.getTooltipTextAt(p.x, p.y)) != null) {
            text.setText(transitionTooltipText, true, false);
            return true;
        }
        if (p.x > 0 && p.y > 0 && p.y < this.m_objectLocator.getSize()) {
            TooltipVisitor toolTipsVisitor = new TooltipVisitor(this.getRangeFromDeviceCoordinates(x, x + 1), this.m_filter, p.x, text, config, this.getUIModel().getRecording());
            Visitable v = this.m_objectLocator.getObjectAt(p.y);
            if (v != null && v.accept(toolTipsVisitor)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void onTypeVisibilityChange() {
        if (this.getChartConfig().getEventTypes().getUserFilterConstrained()) {
            this.updateUserConstrainedEventVisibility();
            this.getUIModel().getUIComponents().markComponentsDirty(true);
        }
    }

    private void updateEventVisibility() {
        EventTypeAcceptor eta = new EventTypeAcceptor(this.getServiceLocator(), this.getChartConfig().getEventTypes());
        Set<IEventType> accepted = eta.getAcceptedSet();
        for (IEventType ie : this.getFlightRecording().getEventTypes()) {
            EventToolkit.setVisible(ie, accepted.contains(ie));
        }
        this.getUIModel().updateGCTrackVisibility();
    }

    private void updateUserConstrainedEventVisibility() {
        TypeRespository tr = (TypeRespository)this.getServiceLocator().getService(TypeRespository.class);
        CheckedVisitor visitor = new CheckedVisitor();
        visitor.visit(tr.getRootFolder());
        HashSet<String> s = new HashSet<String>();
        for (TypeDescriptor td : visitor.getChecked()) {
            s.add(td.getPath());
        }
        for (IEventType ie : this.getFlightRecording().getEventTypes()) {
            EventToolkit.setVisible(ie, s.contains(ie.getPath()));
        }
        this.getUIModel().updateGCTrackVisibility();
    }

    @Override
    public void operativeSetChange() {
        if (this.getChartConfig().getAllowOperativeSet()) {
            this.getUIModel().getUIComponents().markComponentsDirty(true);
            this.markStructuralDirty();
        }
    }

    @Override
    public boolean isTypeChangeEnabled() {
        return this.getChartConfig().getEventTypes().getUserFilterConstrained();
    }

    @Override
    public EventTypeDescriptorRepository getEventTypeDescriptorRepository() {
        return this.getChartConfig().getEventTypes();
    }

    private static class ActionSelector
    extends SelectionAdapter
    implements KeyListener {
        private final IAction action;

        private ActionSelector(IAction action) {
            this.action = action;
        }

        public void widgetSelected(SelectionEvent e) {
            this.action.run();
        }

        public void keyPressed(KeyEvent e) {
            int keyAcc = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
            if (keyAcc != 0 && keyAcc == this.action.getAccelerator()) {
                this.action.run();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    static class FieldTreeFilter
    extends FieldFilter
    implements TreeLeafFilter {
        private final String filterTextString;

        public FieldTreeFilter(String fieldText) {
            this.filterTextString = FilterMatcher.autoAddKleene((String)fieldText, (FilterMatcher.Where)FilterMatcher.Where.AFTER);
        }

        @Override
        public boolean accept(TreeNodeWrapper wrapper) {
            return FilterMatcher.getInstance().matchCaseUnsensitive(wrapper.getName(), this.filterTextString);
        }
    }

    class GraphTooltipProvider
    implements ToolTipManager.ToolTipProvider {
        GraphTooltipProvider() {
        }

        public boolean initializeToolTip(FormText text, int x, int y) {
            String transitionTooltipText;
            Visitable v;
            ChartConfiguration config = ThreadGraphComponent.this.getChartConfig();
            Point p = ThreadGraphComponent.this.getTree().translateSWTCoordToSwingCoord(x, y);
            p.x -= ((ThreadGraphComponent)ThreadGraphComponent.this).tree.leftColumnWidth;
            TooltipVisitor toolTipsVisitor = new TooltipVisitor(ThreadGraphComponent.this.getRangeFromDeviceCoordinates(x, x + 1), ThreadGraphComponent.this.m_filter, p.x, text, config, ThreadGraphComponent.this.getUIModel().getRecording());
            Object object = ThreadGraphComponent.this.tree.getElementBelowMousePoint(x, y);
            if (object instanceof Visitable && (v = (Visitable)object).accept(toolTipsVisitor)) {
                return true;
            }
            if (ThreadGraphComponent.this.getChartConfig().getShowTransition() && (transitionTooltipText = ThreadGraphComponent.this.m_transitionDrawer.getTooltipTextAt(p.x, p.y)) != null) {
                text.setText(transitionTooltipText, true, false);
                return true;
            }
            return p.x > 0 && p.y > 0 && p.y < ThreadGraphComponent.this.m_objectLocator.getSize() && (v = ThreadGraphComponent.this.m_objectLocator.getObjectAt(p.y)) != null && v.accept(toolTipsVisitor);
        }
    }
}

