/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.flightrecorder.ui.components.graph.GraphHelper;
import com.jrockit.mc.flightrecorder.ui.components.graph.RulerModel;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;

public class RulerMarker
implements PaintListener,
DisposeListener,
MouseListener,
Observer {
    private static final int DEFAULT_ARROW_WIDTH = 10;
    private static final int DEAFULT_ARROW_HEIGHT = 5;
    private final Composite m_parent;
    private final Color m_activatorColor;
    private final RulerModel m_rulerModel;
    private final int[] m_markerPolygon;

    public RulerMarker(Composite parent, RulerModel rulerModel) {
        this.m_parent = parent;
        this.m_rulerModel = rulerModel;
        this.m_parent.addDisposeListener((DisposeListener)this);
        this.m_parent.addPaintListener((PaintListener)this);
        this.m_parent.addMouseListener((MouseListener)this);
        this.m_activatorColor = new Color((Device)parent.getDisplay(), GraphHelper.DEFAULT_FOREGROUND_COLOR.getRGBColor());
        this.m_rulerModel.addObserver(this);
        this.m_markerPolygon = new int[8];
    }

    public void paintControl(PaintEvent e) {
        if (this.m_rulerModel.isVisible() && this.m_rulerModel.getPosition() > this.m_rulerModel.getMinimumPosition() && e.x < this.m_rulerModel.getMaximumPosition()) {
            Rectangle rect = this.m_parent.getClientArea();
            e.gc.setBackground(this.m_activatorColor);
            e.gc.setForeground(this.m_activatorColor);
            this.fillMarkerPolygon(this.m_rulerModel.getPosition(), rect.y);
            e.gc.fillPolygon(this.m_markerPolygon);
            e.gc.drawLine(this.m_rulerModel.getPosition(), rect.y, this.m_rulerModel.getPosition(), rect.y + rect.height);
        }
    }

    private void fillMarkerPolygon(int x, int y) {
        this.m_markerPolygon[0] = x;
        this.m_markerPolygon[1] = y + this.getArrowHeight();
        this.m_markerPolygon[2] = x - this.getArrowWidth() / 2;
        this.m_markerPolygon[3] = y;
        this.m_markerPolygon[4] = x + this.getArrowWidth() / 2 + 1;
        this.m_markerPolygon[5] = y;
        this.m_markerPolygon[6] = x;
        this.m_markerPolygon[7] = y + this.getArrowHeight();
    }

    private int getArrowHeight() {
        return 5;
    }

    private int getArrowWidth() {
        return 10;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.m_activatorColor != null && !this.m_activatorColor.isDisposed()) {
            this.m_activatorColor.dispose();
        }
        this.m_parent.removePaintListener((PaintListener)this);
        this.m_rulerModel.deleteObserver(this);
    }

    private boolean isInsideActivator(int x, int y) {
        Region r = new Region();
        r.add(this.m_markerPolygon);
        return r.contains(x, y);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button != 1 || (e.stateMask & SWT.MOD4) != 0) {
            return;
        }
        if (e.x > this.m_rulerModel.getMinimumPosition()) {
            if (this.m_rulerModel.isVisible() && this.isInsideActivator(e.x, e.y)) {
                this.m_rulerModel.setVisible(false);
            } else if (this.isInsidePositionRegion(e.x, e.y)) {
                this.m_rulerModel.setPosition(e.x);
                this.m_rulerModel.setVisible(true);
            }
            this.m_rulerModel.notifyObservers();
        }
    }

    public boolean isInsidePositionRegion(int x, int y) {
        return x > this.m_rulerModel.getMinimumPosition() && x < this.m_rulerModel.getMaximumPosition();
    }

    public void mouseUp(MouseEvent e) {
    }

    @Override
    public void update(Observable o, Object arg) {
        this.m_parent.redraw();
    }
}

