/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.fields;

import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.fields.EventTypeField;
import com.jrockit.mc.flightrecorder.ui.components.fields.ProducerField;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptor;
import com.jrockit.mc.ui.model.fields.CaptionField;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.FieldFactory;
import com.jrockit.mc.ui.model.fields.IFieldListener;

public final class EventFieldToolkit {
    public static Field createField(InformationDescriptor infoDescriptor, String attributeIdentifier, int index) {
        Field field = EventFieldToolkit.createFLRFields(infoDescriptor.getAttributeIdentifier(), index);
        if (field == null) {
            if (!infoDescriptor.getCaption()) {
                field = FieldFactory.createFromDisplayUnitWithIndexIdentifier((UnitDescriptor)infoDescriptor.getUnit(), (String)infoDescriptor.getAttributeIdentifier(), (int)index);
            } else {
                field = new CaptionField(index);
                field.IDENTIFIER = String.valueOf(infoDescriptor.getAttributeIdentifier()) + "." + index;
            }
        }
        field.setName(infoDescriptor.getName());
        field.setDescription(infoDescriptor.getDescription());
        field.setBoolean("wrap", !infoDescriptor.getDisableLineWrap());
        return field;
    }

    public static Field createField(ColumnDescriptor column, String identifier, int index) {
        Field field = EventFieldToolkit.createFLRFields(column.getAttributeIdentifier(), index);
        if (field == null) {
            field = FieldFactory.createFromDisplayUnitWithIndexIdentifier((UnitDescriptor)column.getUnit(), (String)column.getAttributeIdentifier(), (int)index);
        }
        EventFieldToolkit.setupField(column, field);
        EventFieldToolkit.hookColumnField(field, column);
        return field;
    }

    public static void setupField(ColumnDescriptor column, Field field) {
        field.setProperty("bold", column.getEmphasized());
        field.setName(column.getName());
        field.setDescription(column.getDescription());
        field.setVisible(column.isVisible());
        field.setMinWidth(column.getMinimumWidth());
        field.setWidthWeight(column.getWeight());
        field.setSortOrder(column.isPreferredSortOrderAscending());
    }

    public static void hookColumnField(Field field, final ColumnDescriptor column) {
        field.addListener(new IFieldListener(){

            public void changed(Field field, Object property) {
                column.setVisible(field.isVisible());
                column.setMinimumWidth(field.getMinWidth());
                column.setWeight(field.getWidthWeight());
            }
        });
    }

    private static Field createFLRFields(String identifier, int index) {
        if ("(eventType)".equals(identifier) || "eventSetting".equals(identifier)) {
            return new EventTypeField(index);
        }
        if ("(producer)".equals(identifier)) {
            return new ProducerField(index);
        }
        return null;
    }
}

