/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.common;

import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.common.Constants;

public class Toolkit {
    public static UnitDescriptor createUnit(IField field) {
        UnitDescriptor ud = new UnitDescriptor();
        for (ContentType ct : UnitLookup.getAllContentTypes()) {
            if (!ct.getIdentifier().equals(field.getContentType())) continue;
            ud.setDisplayUnit(ct.getDisplayUnit("auto"));
            return ud;
        }
        if ("metadata".equals(field.getContentType())) {
            ud.setDisplayUnit(UnitLookup.PLAIN_TEXT.getDisplayUnit("auto"));
            return ud;
        }
        if (Constants.CONTENT_TYPE_THREAD.equals(field.getContentType())) {
            ud.setDisplayUnit(UnitLookup.THREAD.getDisplayUnit("auto"));
            return ud;
        }
        if (Constants.CONTENT_TYPE_CLASS.equals(field.getContentType())) {
            ud.setDisplayUnit(UnitLookup.CLASS.getDisplayUnit("auto"));
            return ud;
        }
        if ("method".equals(field.getContentType())) {
            ud.setDisplayUnit(UnitLookup.METHOD.getDisplayUnit("auto"));
            return ud;
        }
        if (field.getType() == FieldType.STRING) {
            ud.setDisplayUnit(UnitLookup.PLAIN_TEXT.getDisplayUnit("auto"));
            return ud;
        }
        ud.setDisplayUnit(UnitLookup.UNKNOWN.getDisplayUnit("auto"));
        return ud;
    }
}

