/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.EditorOnlyDisplayer;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.awt.StatusDisplayer;

final class AutoHideStatusText
implements ChangeListener,
Runnable {
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JLabel lblStatus = new JLabel();
    private String text;

    private AutoHideStatusText(JFrame jFrame) {
        Border border = UIManager.getBorder("Nb.ScrollPane.border");
        if (null == border) {
            border = BorderFactory.createEtchedBorder();
        }
        this.panel.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.panel.add((Component)this.lblStatus, "Center");
        jFrame.getLayeredPane().add((Component)this.panel, (Object)101);
        StatusDisplayer.getDefault().addChangeListener((ChangeListener)this);
        this.lblStatus.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (AutoHideStatusText.isWindowMinimizedAtBottom()) {
                    AutoHideStatusText.this.text = null;
                    AutoHideStatusText.this.run();
                }
            }
        });
        jFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                AutoHideStatusText.this.run();
            }
        });
    }

    static void install(JFrame jFrame) {
        new AutoHideStatusText(jFrame);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.text = StatusDisplayer.getDefault().getStatusText();
        String string = this.lblStatus.getText();
        if (this.text == null ? string == null : this.text.equals(string)) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        this.lblStatus.setText(this.text);
        if (EditorOnlyDisplayer.getInstance().isActive()) {
            return;
        }
        if (null == this.text || this.text.isEmpty()) {
            this.panel.setVisible(false);
            Container container = this.panel.getParent();
            if (container instanceof JLayeredPane) {
                JLayeredPane jLayeredPane = (JLayeredPane)container;
                jLayeredPane.moveToBack(this.panel);
            }
        } else {
            this.panel.setVisible(true);
            Container container = this.panel.getParent();
            Dimension dimension = this.panel.getPreferredSize();
            Rectangle rectangle = container.getBounds();
            this.panel.setBounds(rectangle.x - 1, rectangle.y + rectangle.height - dimension.height + 1, dimension.width, dimension.height + 1);
            if (container instanceof JLayeredPane) {
                JLayeredPane jLayeredPane = (JLayeredPane)container;
                jLayeredPane.moveToFront(this.panel);
            }
        }
    }

    private static boolean isWindowMinimizedAtBottom() {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode("bottomSlidingSide");
        return null != modeImpl && !modeImpl.getOpenedTopComponentsIDs().isEmpty();
    }
}

