/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.core.windows.FloatingWindowTransparencyManager;
import org.netbeans.core.windows.nativeaccess.NativeWindowSystem;
import org.netbeans.core.windows.options.WinSysOptionsPanelController;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class WinSysPanel
extends JPanel {
    protected final WinSysOptionsPanelController controller;
    private final Preferences prefs = NbPreferences.forModule(WinSysPanel.class);
    private final boolean isAquaLaF = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private boolean defMultiRow;
    private int defTabPlacement;
    private int defaultLookAndFeelIndex;
    private final ArrayList<UIManager.LookAndFeelInfo> lafs = new ArrayList(10);
    private ButtonGroup buttonGroup1;
    private JCheckBox checkMaximizeNativeLaF;
    private JCheckBox checkMultiRow;
    private JComboBox comboLaf;
    private JCheckBox isAlphaFloating;
    private JCheckBox isCloseActivatesMostRecentDocument;
    private JCheckBox isDragImage;
    private JCheckBox isDragImageAlpha;
    private JCheckBox isNewDocumentOpensNextToActiveTab;
    private JCheckBox isSnapScreenEdges;
    private JCheckBox isSnapping;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblLaf;
    private JLabel lblRestart;
    private JPanel panelDocTabs;
    private JPanel panelLaF;
    private JPanel panelLaFCombo;
    private JPanel panelSeparator;
    private JPanel panelSeparator1;
    private JPanel panelTabs;
    private JRadioButton radioBottom;
    private JRadioButton radioLeft;
    private JRadioButton radioRight;
    private JRadioButton radioTop;
    private static Notification restartNotification;
    private static final String COLOR_MODEL_CLASS_NAME = "org.netbeans.modules.options.colors.ColorModel";
    private static final String DARK_COLOR_THEME_NAME = "Norway Today";

    protected WinSysPanel(final WinSysOptionsPanelController winSysOptionsPanelController) {
        this.controller = winSysOptionsPanelController;
        this.initComponents();
        boolean bl = WinSysPanel.isMacJDK7();
        this.isDragImage.setEnabled(!bl);
        this.isDragImageAlpha.setEnabled(!bl);
        this.isAlphaFloating.setEnabled(!bl);
        this.checkMaximizeNativeLaF.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                winSysOptionsPanelController.changed();
            }
        });
        this.initLookAndFeel();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : this.lafs) {
            defaultComboBoxModel.addElement(lookAndFeelInfo.getName());
        }
        this.comboLaf.setModel(defaultComboBoxModel);
        this.comboLaf.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                winSysOptionsPanelController.changed();
            }
        });
        this.initTabsPanel(this.panelTabs);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.isDragImage = new JCheckBox();
        this.isAlphaFloating = new JCheckBox();
        this.isSnapping = new JCheckBox();
        this.isDragImageAlpha = new JCheckBox();
        this.isSnapScreenEdges = new JCheckBox();
        this.panelDocTabs = new JPanel();
        this.isCloseActivatesMostRecentDocument = new JCheckBox();
        this.isNewDocumentOpensNextToActiveTab = new JCheckBox();
        this.panelTabs = new JPanel();
        this.jLabel1 = new JLabel();
        this.radioTop = new JRadioButton();
        this.radioBottom = new JRadioButton();
        this.radioLeft = new JRadioButton();
        this.radioRight = new JRadioButton();
        this.checkMultiRow = new JCheckBox();
        this.panelSeparator = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.panelSeparator1 = new JPanel();
        this.jSeparator2 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.panelLaF = new JPanel();
        this.checkMaximizeNativeLaF = new JCheckBox();
        this.panelLaFCombo = new JPanel();
        this.comboLaf = new JComboBox();
        this.lblLaf = new JLabel();
        this.lblRestart = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.isDragImage, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_DragWindowImage"));
        this.isDragImage.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsDragWindowTooltip"));
        this.isDragImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WinSysPanel.this.isDragImageActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.isDragImage, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isAlphaFloating, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_TransparentFloatingWindows"));
        this.isAlphaFloating.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaFloatingTooltip"));
        this.isAlphaFloating.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WinSysPanel.this.isAlphaFloatingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add((Component)this.isAlphaFloating, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isSnapping, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_SnapFloatingWindows"));
        this.isSnapping.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsSnappingTooltip"));
        this.isSnapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WinSysPanel.this.isSnappingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)this.isSnapping, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isDragImageAlpha, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_TransparentDragWindow"));
        this.isDragImageAlpha.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaDragTooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.isDragImageAlpha, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isSnapScreenEdges, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_SnapToScreenEdges"));
        this.isSnapScreenEdges.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsSnapScreenEdgesTooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)this.isSnapScreenEdges, gridBagConstraints);
        this.panelDocTabs.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.isCloseActivatesMostRecentDocument, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_CloseActivatesRecentDocument"));
        this.isCloseActivatesMostRecentDocument.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"TIP_CloseActivatesMostRecentDocument"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.panelDocTabs.add((Component)this.isCloseActivatesMostRecentDocument, gridBagConstraints);
        this.isCloseActivatesMostRecentDocument.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.isCloseActivatesMostRecentDocument.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.isNewDocumentOpensNextToActiveTab, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.isNewDocumentOpensNextToActiveTab.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.panelDocTabs.add((Component)this.isNewDocumentOpensNextToActiveTab, gridBagConstraints);
        this.panelTabs.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.panelTabs.add((Component)this.jLabel1, gridBagConstraints);
        this.buttonGroup1.add(this.radioTop);
        this.radioTop.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioTop, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.radioTop.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelTabs.add((Component)this.radioTop, gridBagConstraints);
        this.buttonGroup1.add(this.radioBottom);
        Mnemonics.setLocalizedText((AbstractButton)this.radioBottom, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.radioBottom.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelTabs.add((Component)this.radioBottom, gridBagConstraints);
        this.buttonGroup1.add(this.radioLeft);
        Mnemonics.setLocalizedText((AbstractButton)this.radioLeft, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.radioLeft.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelTabs.add((Component)this.radioLeft, gridBagConstraints);
        this.buttonGroup1.add(this.radioRight);
        Mnemonics.setLocalizedText((AbstractButton)this.radioRight, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.radioRight.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelTabs.add((Component)this.radioRight, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.checkMultiRow, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.checkMultiRow.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelTabs.add((Component)this.checkMultiRow, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.panelDocTabs.add((Component)this.panelTabs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelDocTabs, gridBagConstraints);
        this.panelSeparator.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        this.panelSeparator.add((Component)this.jSeparator1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.panelSeparator.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add((Component)this.panelSeparator, gridBagConstraints);
        this.panelSeparator1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        this.panelSeparator1.add((Component)this.jSeparator2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.panelSeparator1.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add((Component)this.panelSeparator1, gridBagConstraints);
        this.panelLaF.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.checkMaximizeNativeLaF, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.checkMaximizeNativeLaF.text"));
        this.checkMaximizeNativeLaF.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.checkMaximizeNativeLaF.toolTipText"));
        this.panelLaF.add((Component)this.checkMaximizeNativeLaF, "West");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelLaF, gridBagConstraints);
        this.panelLaFCombo.setLayout(new BorderLayout(3, 0));
        this.panelLaFCombo.add((Component)this.comboLaf, "Center");
        this.lblLaf.setLabelFor(this.comboLaf);
        Mnemonics.setLocalizedText((JLabel)this.lblLaf, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.lblLaf.text"));
        this.panelLaFCombo.add((Component)this.lblLaf, "West");
        Mnemonics.setLocalizedText((JLabel)this.lblRestart, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.lblRestart.text"));
        this.panelLaFCombo.add((Component)this.lblRestart, "After");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelLaFCombo, gridBagConstraints);
    }

    private void isDragImageActionPerformed(ActionEvent actionEvent) {
        this.updateDragSection();
        this.controller.changed();
    }

    private void isAlphaFloatingActionPerformed(ActionEvent actionEvent) {
        this.controller.changed();
    }

    private void isSnappingActionPerformed(ActionEvent actionEvent) {
        this.updateSnapSection();
        this.controller.changed();
    }

    protected void load() {
        boolean bl;
        boolean bl2 = Utilities.getOperatingSystem() != 8;
        boolean bl3 = WinSysPanel.isMacJDK7();
        this.isDragImage.setSelected(this.prefs.getBoolean("dnd.dragimage", bl2 && !bl3));
        this.isDragImageAlpha.setSelected(this.prefs.getBoolean("transparency.dragimage", bl2 && !bl3));
        this.isAlphaFloating.setSelected(this.prefs.getBoolean("transparency.floating", !bl3));
        this.isSnapping.setSelected(this.prefs.getBoolean("snapping", true));
        this.isSnapScreenEdges.setSelected(this.prefs.getBoolean("snapping.screenedges", true));
        this.isCloseActivatesMostRecentDocument.setSelected(this.prefs.getBoolean("editor.closing.activates.recent", true));
        this.isNewDocumentOpensNextToActiveTab.setSelected(this.prefs.getBoolean("editor.open.next.to.active", false));
        this.updateDragSection();
        this.updateSnapSection();
        this.updateFloatingSection();
        this.defMultiRow = this.prefs.getBoolean("document.tabs.multirow", false);
        this.checkMultiRow.setSelected(this.defMultiRow);
        this.defTabPlacement = this.prefs.getInt("document.tabs.placement", 1);
        switch (this.defTabPlacement) {
            case 3: {
                this.radioBottom.setSelected(true);
                break;
            }
            case 2: {
                this.radioLeft.setSelected(true);
                break;
            }
            case 4: {
                this.radioRight.setSelected(true);
                break;
            }
            default: {
                this.radioTop.setSelected(true);
            }
        }
        this.checkMaximizeNativeLaF.setSelected(this.prefs.getBoolean("laf.maximize.native", false));
        if (this.isAquaLaF) {
            this.checkMultiRow.setSelected(false);
            this.checkMultiRow.setEnabled(false);
            this.radioLeft.setEnabled(false);
            this.radioRight.setEnabled(false);
            if (this.radioLeft.isSelected() || this.radioRight.isSelected()) {
                this.radioTop.setSelected(true);
            }
        }
        this.defaultLookAndFeelIndex = this.lafs.indexOf((bl = this.isForcedLaF()) ? this.getCurrentLaF() : this.getPreferredLaF());
        this.comboLaf.setSelectedIndex(this.defaultLookAndFeelIndex);
        this.comboLaf.setEnabled(!bl);
    }

    protected boolean store() {
        this.prefs.putBoolean("dnd.dragimage", this.isDragImage.isSelected());
        this.prefs.putBoolean("transparency.dragimage", this.isDragImageAlpha.isSelected());
        this.prefs.putBoolean("transparency.floating", this.isAlphaFloating.isSelected());
        FloatingWindowTransparencyManager.getDefault().update();
        this.prefs.putBoolean("snapping", this.isSnapping.isSelected());
        this.prefs.putBoolean("snapping.screenedges", this.isSnapScreenEdges.isSelected());
        this.prefs.putBoolean("editor.closing.activates.recent", this.isCloseActivatesMostRecentDocument.isSelected());
        this.prefs.putBoolean("editor.open.next.to.active", this.isNewDocumentOpensNextToActiveTab.isSelected());
        this.prefs.putBoolean("laf.maximize.native", this.checkMaximizeNativeLaF.isSelected());
        System.setProperty("nb.native.filechooser", this.checkMaximizeNativeLaF.isSelected() ? "true" : "false");
        boolean bl = false;
        bl = this.checkMultiRow.isSelected() != this.defMultiRow;
        this.prefs.putBoolean("document.tabs.multirow", this.checkMultiRow.isSelected());
        int n = 1;
        if (this.radioBottom.isSelected()) {
            n = 3;
        } else if (this.radioLeft.isSelected()) {
            n = 2;
        } else if (this.radioRight.isSelected()) {
            n = 4;
        }
        this.prefs.putInt("document.tabs.placement", n);
        bl |= n != this.defTabPlacement;
        int n2 = this.comboLaf.getSelectedIndex();
        if (n2 != this.defaultLookAndFeelIndex && !this.isForcedLaF()) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = this.lafs.get(this.comboLaf.getSelectedIndex());
            NbPreferences.root().node("laf").put("laf", lookAndFeelInfo.getClassName());
            this.askForRestart();
        }
        return bl;
    }

    boolean valid() {
        return true;
    }

    protected void initTabsPanel(JPanel jPanel) {
    }

    private void updateDragSection() {
        boolean bl = NativeWindowSystem.getDefault().isWindowAlphaSupported();
        boolean bl2 = this.isDragImage.isSelected();
        this.isDragImageAlpha.setEnabled(bl && bl2);
        if (bl) {
            this.isDragImageAlpha.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaDragTooltip"));
        } else {
            this.isDragImageAlpha.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"NoAlphaSupport"));
        }
    }

    private void updateSnapSection() {
        this.isSnapScreenEdges.setEnabled(this.isSnapping.isSelected());
    }

    private void updateFloatingSection() {
        boolean bl = NativeWindowSystem.getDefault().isWindowAlphaSupported();
        this.isAlphaFloating.setEnabled(bl);
        if (bl) {
            this.isAlphaFloating.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaFloatingTooltip"));
        } else {
            this.isAlphaFloating.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"NoAlphaSupport"));
        }
    }

    private static boolean isMacJDK7() {
        String string;
        return Utilities.isMac() && null != (string = System.getProperty("java.version")) && string.startsWith("1.7");
    }

    private void initLookAndFeel() {
        this.lafs.clear();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            this.lafs.add(lookAndFeelInfo);
        }
    }

    private boolean isForcedLaF() {
        return null != System.getProperty("nb.laf.forced");
    }

    private UIManager.LookAndFeelInfo getCurrentLaF() {
        UIManager.LookAndFeelInfo lookAndFeelInfo = null;
        String string = UIManager.getLookAndFeel().getClass().getName();
        boolean bl = "Aqua".equals(UIManager.getLookAndFeel().getID());
        for (UIManager.LookAndFeelInfo lookAndFeelInfo2 : this.lafs) {
            if (!string.equals(lookAndFeelInfo2.getClassName()) && (!bl || !lookAndFeelInfo2.getClassName().contains("apple.laf.AquaLookAndFeel"))) continue;
            lookAndFeelInfo = lookAndFeelInfo2;
            break;
        }
        return lookAndFeelInfo;
    }

    private UIManager.LookAndFeelInfo getPreferredLaF() {
        String string = NbPreferences.root().node("laf").get("laf", null);
        if (null == string) {
            return this.getCurrentLaF();
        }
        UIManager.LookAndFeelInfo lookAndFeelInfo = null;
        boolean bl = "Aqua".equals(UIManager.getLookAndFeel().getID());
        for (UIManager.LookAndFeelInfo lookAndFeelInfo2 : this.lafs) {
            if (!string.equals(lookAndFeelInfo2.getClassName()) && (!bl || !lookAndFeelInfo2.getClassName().contains("apple.laf.AquaLookAndFeel"))) continue;
            lookAndFeelInfo = lookAndFeelInfo2;
            break;
        }
        return lookAndFeelInfo;
    }

    private void askForRestart() {
        if (null != restartNotification) {
            restartNotification.clear();
        }
        restartNotification = NotificationDisplayer.getDefault().notify(NbBundle.getMessage(WinSysPanel.class, (String)"Hint_RESTART_IDE"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/core/windows/resources/restart.png", (boolean)true), this.createRestartNotificationDetails(), this.createRestartNotificationDetails(), NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.INFO);
    }

    void selectDarkLookAndFeel() {
        this.comboLaf.requestFocusInWindow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WinSysPanel.this.comboLaf.setPopupVisible(true);
            }
        });
    }

    private boolean isChangeEditorColorsPossible() {
        if (!this.isDarkLookAndFeel()) {
            return false;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == classLoader) {
            classLoader = WinSysPanel.class.getClassLoader();
        }
        try {
            Class<?> clazz = classLoader.loadClass(COLOR_MODEL_CLASS_NAME);
            Object obj = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("getCurrentProfile", new Class[0]);
            Object object = method.invoke(obj, new Object[0]);
            return object != null && !DARK_COLOR_THEME_NAME.equals(object);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void switchEditorColorsProfile() {
        if (!this.isChangeEditorColorsPossible()) {
            return;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == classLoader) {
            classLoader = WinSysPanel.class.getClassLoader();
        }
        try {
            Class<?> clazz = classLoader.loadClass(COLOR_MODEL_CLASS_NAME);
            Object obj = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("setCurrentProfile", String.class);
            method.invoke(obj, DARK_COLOR_THEME_NAME);
        }
        catch (Exception exception) {
            Logger.getLogger(WinSysPanel.class.getName()).log(Level.INFO, "Cannot change editor colors profile.", exception);
        }
    }

    private JComponent createRestartNotificationDetails() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(NbBundle.getMessage(WinSysPanel.class, (String)"Descr_Restart"));
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jPanel.add((Component)jLabel, "Center");
        final JCheckBox jCheckBox = new JCheckBox(NbBundle.getMessage(WinSysPanel.class, (String)"Hint_ChangeEditorColors"));
        if (this.isChangeEditorColorsPossible()) {
            jCheckBox.setSelected(true);
            jCheckBox.setOpaque(false);
            jPanel.add((Component)jCheckBox, "South");
        }
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (null != restartNotification) {
                    restartNotification.clear();
                    restartNotification = null;
                }
                if (jCheckBox.isSelected()) {
                    WinSysPanel.this.switchEditorColorsProfile();
                }
                LifecycleManager.getDefault().markForRestart();
                LifecycleManager.getDefault().exit();
            }
        });
        return jPanel;
    }

    private boolean isDarkLookAndFeel() {
        String string = NbPreferences.root().node("laf").get("laf", null);
        if (null == string) {
            return false;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == classLoader) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> clazz = classLoader.loadClass(string);
            LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
            return lookAndFeel.getDefaults().getBoolean("nb.dark.theme");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

