/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LayerUI;
import org.netbeans.core.windows.TopComponentTracker;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.filesystems.FileUtil;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class EditorOnlyDisplayer {
    private static EditorOnlyDisplayer theInstance;
    private final PropertyChangeListener registryListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EditorOnlyDisplayer.this.onRegistryChange(propertyChangeEvent);
        }
    };
    private Container originalContentPane = null;
    private boolean originalShowEditorToolbar = true;

    private EditorOnlyDisplayer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditorOnlyDisplayer getInstance() {
        Class<EditorOnlyDisplayer> clazz = EditorOnlyDisplayer.class;
        synchronized (EditorOnlyDisplayer.class) {
            if (null == theInstance) {
                theInstance = new EditorOnlyDisplayer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    public boolean isActive() {
        return null != this.originalContentPane;
    }

    public void setActive(boolean bl) {
        if (bl == this.isActive()) {
            return;
        }
        if (this.isActive()) {
            this.cancel();
        } else {
            this.activate();
        }
    }

    private void onRegistryChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            if (this.switchCurrentEditor()) {
                return;
            }
            this.cancel();
        }
    }

    private boolean switchCurrentEditor() {
        final TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null == topComponent || !TopComponentTracker.getDefault().isEditorTopComponent(topComponent)) {
            return false;
        }
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        JFrame jFrame = (JFrame)windowManagerImpl.getMainWindow();
        if (SwingUtilities.isDescendingFrom((Component)topComponent, jFrame.getContentPane())) {
            return true;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)topComponent, "Center");
        jFrame.setContentPane(jPanel);
        jFrame.invalidate();
        jFrame.revalidate();
        jFrame.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                topComponent.requestFocusInWindow();
            }
        });
        return true;
    }

    private void cancel() {
        TopComponent.getRegistry().removePropertyChangeListener(this.registryListener);
        JFrame jFrame = (JFrame)WindowManagerImpl.getInstance().getMainWindow();
        jFrame.setContentPane(this.originalContentPane);
        this.originalContentPane = null;
        EditorOnlyDisplayer.setShowEditorToolbar(this.originalShowEditorToolbar);
        final TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null != topComponent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    topComponent.requestFocusInWindow();
                }
            });
        }
    }

    private void activate() {
        assert (null == this.originalContentPane);
        final TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null == topComponent || !TopComponentTracker.getDefault().isEditorTopComponent(topComponent)) {
            return;
        }
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        JFrame jFrame = (JFrame)windowManagerImpl.getMainWindow();
        this.originalContentPane = jFrame.getContentPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)topComponent, "Center");
        jFrame.setContentPane(jPanel);
        jFrame.invalidate();
        jFrame.revalidate();
        jFrame.repaint();
        windowManagerImpl.getRegistry().addPropertyChangeListener(this.registryListener);
        this.originalShowEditorToolbar = EditorOnlyDisplayer.setShowEditorToolbar(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                topComponent.requestFocusInWindow();
            }
        });
    }

    private static boolean setShowEditorToolbar(boolean bl) {
        JMenuItem jMenuItem;
        boolean bl2 = true;
        Action action = (Action)FileUtil.getConfigObject((String)"Editors/Actions/toggle-toolbar.instance", Action.class);
        if (null != action && action instanceof Presenter.Menu && (jMenuItem = ((Presenter.Menu)action).getMenuPresenter()) instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenuItem;
            bl2 = jCheckBoxMenuItem.isSelected();
            if (jCheckBoxMenuItem.isSelected() != bl) {
                try {
                    action.actionPerformed(new ActionEvent(jMenuItem, 0, ""));
                }
                catch (Exception exception) {
                    Logger.getLogger(EditorOnlyDisplayer.class.getName()).log(Level.FINE, null, exception);
                }
            }
        }
        return bl2;
    }

    private static class EditorLayerUI
    extends LayerUI<JPanel> {
        private EditorLayerUI() {
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            graphics.setColor(Color.red);
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            graphics.drawRect(n - 30, 10, 20, 20);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent, JLayer<? extends JPanel> jLayer) {
            super.processMouseMotionEvent(mouseEvent, jLayer);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent, JLayer<? extends JPanel> jLayer) {
            if (mouseEvent.getID() == 500 && mouseEvent.getButton() == 1) {
                Point point = mouseEvent.getPoint();
                Component component = mouseEvent.getComponent();
                int n = component.getWidth();
                int n2 = component.getHeight();
                Rectangle rectangle = new Rectangle(n - 30, 10, 20, 20);
                if (rectangle.contains(point)) {
                    mouseEvent.consume();
                    EditorOnlyDisplayer.getInstance().cancel();
                }
            }
        }

        @Override
        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            ((JLayer)jComponent).setLayerEventMask(48L);
        }

        @Override
        public void uninstallUI(JComponent jComponent) {
            super.uninstallUI(jComponent);
            ((JLayer)jComponent).setLayerEventMask(0L);
        }
    }
}

