/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.linux.LinuxAppBundler;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.windows.WindowsBundlerParam;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class BundleParams {
    protected final Map<String, ? super Object> params;
    public static final String PARAM_RUNTIME = "runtime";
    public static final String PARAM_APP_RESOURCES = "appResources";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_BUNDLE_FORMAT = "bundleFormat";
    public static final String PARAM_ICON = "icon";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_VENDOR = "vendor";
    public static final String PARAM_EMAIL = "email";
    public static final String PARAM_COPYRIGHT = "copyright";
    public static final String PARAM_IDENTIFIER = "identifier";
    public static final String PARAM_SHORTCUT = "shortcutHint";
    public static final String PARAM_MENU = "menuHint";
    public static final String PARAM_VERSION = "appVersion";
    public static final String PARAM_CATEGORY = "applicationCategory";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_LICENSE_TYPE = "licenseType";
    public static final String PARAM_LICENSE_FILE = "licenseFile";
    public static final String PARAM_SYSTEM_WIDE = "systemWide";
    public static final String PARAM_SERVICE_HINT = "serviceHint";
    public static final String PARAM_APPLICATION_CLASS = "applicationClass";
    private String mainJar = null;
    private String mainJarClassPath = null;
    private boolean useFXPackaging = true;

    public BundleParams() {
        this.params = new HashMap<String, Object>();
    }

    public BundleParams(Map<String, ?> map) {
        this.params = new HashMap(map);
    }

    public void addAllBundleParams(Map<String, ? super Object> map) {
        this.params.putAll(map);
    }

    public <C> C fetchParam(BundlerParamInfo<C> bundlerParamInfo) {
        return bundlerParamInfo.fetchFrom(this.params);
    }

    public <C> C fetchParamWithDefault(Class<C> clazz, C c, String ... stringArray) {
        for (String string : stringArray) {
            Object object = this.params.get(string);
            if (clazz.isInstance(object)) {
                return (C)object;
            }
            if (!this.params.containsKey(stringArray) || object != null) continue;
            return null;
        }
        return c;
    }

    public <C> C fetchParam(Class<C> clazz, String ... stringArray) {
        return this.fetchParamWithDefault(clazz, null, stringArray);
    }

    public Map<String, ? super Object> getBundleParamsAsMap() {
        return new HashMap<String, Object>(this.params);
    }

    public void setJvmargs(List<String> list) {
        this.putUnlessNullOrEmpty(StandardBundlerParam.JVM_OPTIONS.getID(), list);
    }

    public void setJvmUserArgs(Map<String, String> map) {
        this.putUnlessNullOrEmpty(StandardBundlerParam.USER_JVM_OPTIONS.getID(), map);
    }

    public void setJvmProperties(Map<String, String> map) {
        this.putUnlessNullOrEmpty(StandardBundlerParam.JVM_PROPERTIES.getID(), map);
    }

    public String getApplicationID() {
        return this.fetchParam(StandardBundlerParam.IDENTIFIER);
    }

    public String getPreferencesID() {
        return this.fetchParam(StandardBundlerParam.PREFERENCES_ID);
    }

    public String getTitle() {
        return this.fetchParam(StandardBundlerParam.TITLE);
    }

    public void setTitle(String string) {
        this.putUnlessNull(PARAM_TITLE, string);
    }

    public String getApplicationClass() {
        return this.fetchParam(StandardBundlerParam.MAIN_CLASS);
    }

    public void setApplicationClass(String string) {
        this.putUnlessNull(PARAM_APPLICATION_CLASS, string);
    }

    public String getAppVersion() {
        return this.fetchParam(StandardBundlerParam.VERSION);
    }

    public void setAppVersion(String string) {
        this.putUnlessNull(PARAM_VERSION, string);
    }

    public String getDescription() {
        return this.fetchParam(StandardBundlerParam.DESCRIPTION);
    }

    public void setDescription(String string) {
        this.putUnlessNull(PARAM_DESCRIPTION, string);
    }

    public String getLicenseType() {
        return this.fetchParam(StandardBundlerParam.LICENSE_TYPE);
    }

    public void setLicenseType(String string) {
        this.putUnlessNull(PARAM_LICENSE_TYPE, string);
    }

    public void addLicenseFile(String string) {
        List<String> list = this.fetchParam(StandardBundlerParam.LICENSE_FILE);
        if (list == null || list.isEmpty()) {
            list = new ArrayList<String>();
            this.params.put(PARAM_LICENSE_FILE, list);
        }
        list.add(string);
    }

    public Boolean getSystemWide() {
        return this.fetchParam(StandardBundlerParam.SYSTEM_WIDE);
    }

    public void setSystemWide(Boolean bl) {
        this.putUnlessNull(PARAM_SYSTEM_WIDE, bl);
    }

    public void setServiceHint(Boolean bl) {
        this.putUnlessNull(PARAM_SERVICE_HINT, bl);
    }

    public RelativeFileSet getRuntime() {
        return BundleParams.getRuntime(this.params);
    }

    public static RelativeFileSet getRuntime(Map<String, ? super Object> map) {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("linux")) {
            return LinuxAppBundler.LINUX_RUNTIME.fetchFrom(map);
        }
        if (string.contains("os x")) {
            return MacAppBundler.MAC_RUNTIME.fetchFrom(map);
        }
        if (string.startsWith("win")) {
            return WindowsBundlerParam.WIN_RUNTIME.fetchFrom(map);
        }
        return null;
    }

    public boolean isShortcutHint() {
        return this.fetchParam(StandardBundlerParam.SHORTCUT_HINT);
    }

    public void setShortcutHint(Boolean bl) {
        this.putUnlessNull(PARAM_SHORTCUT, bl);
    }

    public boolean isMenuHint() {
        return this.fetchParam(StandardBundlerParam.MENU_HINT);
    }

    public void setMenuHint(Boolean bl) {
        this.putUnlessNull(PARAM_MENU, bl);
    }

    public String getName() {
        return this.fetchParam(StandardBundlerParam.APP_NAME);
    }

    public void setName(String string) {
        this.putUnlessNull(PARAM_NAME, string);
    }

    public Bundler.BundleType getType() {
        return this.fetchParam(Bundler.BundleType.class, PARAM_TYPE);
    }

    public void setType(Bundler.BundleType bundleType) {
        this.putUnlessNull(PARAM_TYPE, (Object)bundleType);
    }

    public String getBundleFormat() {
        return this.fetchParam(String.class, PARAM_BUNDLE_FORMAT);
    }

    public void setBundleFormat(String string) {
        this.putUnlessNull(PARAM_BUNDLE_FORMAT, string);
    }

    public boolean getVerbose() {
        return this.fetchParam(StandardBundlerParam.VERBOSE);
    }

    public void setVerbose(Boolean bl) {
        this.putUnlessNull(StandardBundlerParam.VERBOSE.getID(), bl);
    }

    public List<String> getLicenseFile() {
        return this.fetchParam(StandardBundlerParam.LICENSE_FILE);
    }

    public List<String> getJvmargs() {
        return (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(this.params);
    }

    private static boolean checkJDKRoot(File file) {
        File file2 = new File(file, "jre/lib/rt.jar");
        if (!file2.exists()) {
            Log.verbose("rt.jar is not found at " + file2.getAbsolutePath());
            return false;
        }
        File file3 = new File(file, "jre/lib/ext/jfxrt.jar");
        if (!file3.exists() && !(file3 = new File(file, "jre/lib/jfxrt.jar")).exists()) {
            Log.verbose("jfxrt.jar is not found at " + file3.getAbsolutePath());
            return false;
        }
        File file4 = new File(file, "lib/tools.jar");
        if (!file4.exists()) {
            Log.verbose("tools.jar is not found at " + file4.getAbsolutePath());
            return false;
        }
        return true;
    }

    public static File validateRuntimeLocation(File file) {
        File file2;
        if (file == null) {
            return null;
        }
        boolean bl = System.getProperty("os.name").toLowerCase().contains("os x");
        File file3 = new File(file, "lib/rt.jar");
        if (file3.exists()) {
            file2 = file.getParentFile();
        } else {
            File file4;
            if (bl && (file4 = new File(file, "Contents/Home")).exists() && file4.isDirectory()) {
                file = file4;
            }
            file2 = file;
        }
        if (!BundleParams.checkJDKRoot(file2)) {
            throw new RuntimeException("Can not find JDK artifacts in specified location: " + file.getAbsolutePath());
        }
        return new File(file2, "jre");
    }

    public void setRuntime(File file) {
        if ((file = BundleParams.validateRuntimeLocation(file)) == null) {
            Log.verbose("No Java runtime to embed. Package will need system Java.");
            this.params.put(PARAM_RUNTIME, null);
            return;
        }
        this.doSetRuntime(file);
    }

    private void doSetRuntime(File file) {
        this.params.put(PARAM_RUNTIME, file.toString());
    }

    public RelativeFileSet getAppResource() {
        return this.fetchParam(StandardBundlerParam.APP_RESOURCES);
    }

    public void setAppResource(RelativeFileSet relativeFileSet) {
        this.putUnlessNull(PARAM_APP_RESOURCES, relativeFileSet);
    }

    public File getIcon() {
        return this.fetchParam(StandardBundlerParam.ICON);
    }

    public void setIcon(File file) {
        this.putUnlessNull(PARAM_ICON, file);
    }

    public String getApplicationCategory() {
        return this.fetchParam(StandardBundlerParam.CATEGORY);
    }

    public void setApplicationCategory(String string) {
        this.putUnlessNull(PARAM_CATEGORY, string);
    }

    public String getMainClassName() {
        String string = this.getApplicationClass();
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String getCopyright() {
        return this.fetchParam(StandardBundlerParam.COPYRIGHT);
    }

    public void setCopyright(String string) {
        this.putUnlessNull(PARAM_COPYRIGHT, string);
    }

    public String getIdentifier() {
        return this.fetchParam(StandardBundlerParam.IDENTIFIER);
    }

    public void setIdentifier(String string) {
        this.putUnlessNull(PARAM_IDENTIFIER, string);
    }

    public boolean useJavaFXPackaging() {
        if (this.mainJar == null) {
            this.getMainApplicationJar();
        }
        return this.useFXPackaging;
    }

    public String getAppClassPath() {
        if (this.mainJar == null) {
            this.getMainApplicationJar();
        }
        if (this.useFXPackaging || this.mainJarClassPath == null) {
            return "";
        }
        return this.mainJarClassPath;
    }

    public String getMainApplicationJar() {
        if (this.mainJar != null) {
            return this.mainJar;
        }
        RelativeFileSet relativeFileSet = this.getAppResource();
        String string = this.getApplicationClass();
        if (relativeFileSet == null || string == null) {
            return null;
        }
        File file = relativeFileSet.getBaseDirectory();
        for (String string2 : relativeFileSet.getIncludedFiles()) {
            try {
                JarFile jarFile = new JarFile(new File(file, string2));
                Manifest manifest = jarFile.getManifest();
                Attributes attributes = manifest != null ? manifest.getMainAttributes() : null;
                if (attributes == null) continue;
                boolean bl = string.equals(attributes.getValue(Attributes.Name.MAIN_CLASS));
                boolean bl2 = string.equals(attributes.getValue("JavaFX-Application-Class"));
                if (!bl && !bl2) continue;
                this.useFXPackaging = bl2;
                this.mainJar = string2;
                this.mainJarClassPath = attributes.getValue(Attributes.Name.CLASS_PATH);
                return this.mainJar;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public String getVendor() {
        return this.fetchParam(StandardBundlerParam.VENDOR);
    }

    public void setVendor(String string) {
        this.putUnlessNull(PARAM_VENDOR, string);
    }

    public String getEmail() {
        return this.fetchParam(String.class, PARAM_EMAIL);
    }

    public void setEmail(String string) {
        this.putUnlessNull(PARAM_EMAIL, string);
    }

    public void putUnlessNull(String string, Object object) {
        if (object != null) {
            this.params.put(string, object);
        }
    }

    public void putUnlessNullOrEmpty(String string, Collection collection) {
        if (collection != null && !collection.isEmpty()) {
            this.params.put(string, collection);
        }
    }

    public void putUnlessNullOrEmpty(String string, Map map) {
        if (map != null && !map.isEmpty()) {
            this.params.put(string, map);
        }
    }
}

