/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.windows;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.windows.WinResources;
import com.oracle.tools.packager.windows.WindowsBundlerParam;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class WinAppBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(WinAppBundler.class.getName());
    public static final BundlerParamInfo<File> CONFIG_ROOT = new WindowsBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, map -> {
        File file = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)map), "windows");
        file.mkdirs();
        return file;
    }, (string, map) -> null);
    private static final String EXECUTABLE_NAME = "WinLauncher.exe";
    private static final String TOOL_ICON_SWAP = "IconSwap.exe";
    public static final BundlerParamInfo<URL> RAW_EXECUTABLE_URL = new WindowsBundlerParam<URL>(I18N.getString("param.raw-executable-url.name"), I18N.getString("param.raw-executable-url.description"), "win.launcher.url", URL.class, map -> WinResources.class.getResource(EXECUTABLE_NAME), (string, map) -> {
        try {
            return new URL((String)string);
        }
        catch (MalformedURLException malformedURLException) {
            Log.info(malformedURLException.toString());
            return null;
        }
    });
    public static final BundlerParamInfo<Boolean> REBRAND_EXECUTABLE = new WindowsBundlerParam<Boolean>(I18N.getString("param.rebrand-executable.name"), I18N.getString("param.rebrand-executable.description"), "win.launcher.rebrand", Boolean.class, map -> Boolean.TRUE, (string, map) -> Boolean.valueOf(string));
    public static final BundlerParamInfo<File> ICON_ICO = new StandardBundlerParam<File>(I18N.getString("param.icon-ico.name"), I18N.getString("param.icon-ico.description"), "icon.ico", File.class, map -> {
        File file = (File)StandardBundlerParam.ICON.fetchFrom((Map<String, Object>)map);
        if (file != null && !file.getName().toLowerCase().endsWith(".ico")) {
            Log.info(MessageFormat.format(I18N.getString("message.icon-not-ico"), file));
            return null;
        }
        return file;
    }, (string, map) -> new File((String)string));
    public static final String WIN_BUNDLER_PREFIX = "package/windows/";
    private static final String TEMPLATE_APP_ICON = "javalogo_white_48.ico";

    public WinAppBundler() {
        this.baseResourceLoader = WinResources.class;
    }

    File getConfigRoot(Map<String, ? super Object> map) {
        return CONFIG_ROOT.fetchFrom(map);
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            return this.doValidate(map);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    boolean doValidate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            throw new UnsupportedPlatformException();
        }
        StandardBundlerParam.validateMainClassInfoFromAppResources(map);
        if (WinResources.class.getResource(TOOL_ICON_SWAP) == null) {
            throw new ConfigException(I18N.getString("error.no-windows-resources"), I18N.getString("error.no-windows-resources.advice"));
        }
        if (StandardBundlerParam.MAIN_JAR.fetchFrom(map) == null) {
            throw new ConfigException(I18N.getString("error.no-application-jar"), I18N.getString("error.no-application-jar.advice"));
        }
        this.testRuntime(WindowsBundlerParam.WIN_RUNTIME.fetchFrom(map), new String[]{"bin\\\\[^\\\\]+\\\\jvm.dll", "lib\\\\rt.jar"});
        if (((Boolean)StandardBundlerParam.USE_FX_PACKAGING.fetchFrom(map)).booleanValue()) {
            this.testRuntime(WindowsBundlerParam.WIN_RUNTIME.fetchFrom(map), new String[]{"lib\\ext\\jfxrt.jar", "lib\\jfxrt.jar"});
        }
        WinAppBundler.testRuntimeBitArchitecture(map);
        return true;
    }

    private static void testRuntimeBitArchitecture(Map<String, ? super Object> map) throws ConfigException {
        if ("true".equalsIgnoreCase(System.getProperty("fxpackager.disableBitArchitectureMismatchCheck"))) {
            Log.debug(I18N.getString("message.disable-bit-architecture-check"));
            return;
        }
        if (WindowsBundlerParam.BIT_ARCH_64.fetchFrom(map) != WindowsBundlerParam.BIT_ARCH_64_RUNTIME.fetchFrom(map)) {
            throw new ConfigException(I18N.getString("error.bit-architecture-mismatch"), I18N.getString("error.bit-architecture-mismatch.advice"));
        }
    }

    private static File getRootDir(File file, Map<String, ? super Object> map) {
        return new File(file, (String)StandardBundlerParam.APP_NAME.fetchFrom(map));
    }

    public static File getLauncher(File file, Map<String, ? super Object> map) {
        return new File(WinAppBundler.getRootDir(file, map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".exe");
    }

    private File getConfig_AppIcon(Map<String, ? super Object> map) {
        return new File(this.getConfigRoot(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".ico");
    }

    protected void cleanupConfigFiles(Map<String, ? super Object> map) {
        if (this.getConfig_AppIcon(map) != null) {
            this.getConfig_AppIcon(map).delete();
        }
    }

    private void prepareConfigFiles(Map<String, ? super Object> map) throws IOException {
        File file = this.getConfig_AppIcon(map);
        File file2 = ICON_ICO.fetchFrom(map);
        if (file2 != null && file2.exists()) {
            this.fetchResource(WIN_BUNDLER_PREFIX + file.getName(), I18N.getString("resource.application-icon"), file2, file, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)));
        } else {
            this.fetchResource(WIN_BUNDLER_PREFIX + file.getName(), I18N.getString("resource.application-icon"), TEMPLATE_APP_ICON, file, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)));
        }
    }

    public boolean bundle(Map<String, ? super Object> map, File file) {
        return this.doBundle(map, file, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File doBundle(Map<String, ? super Object> map, File file, boolean bl) {
        Object object;
        block13: {
            block11: {
                if (!file.isDirectory() && !file.mkdirs()) {
                    throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
                }
                if (!file.canWrite()) {
                    throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
                }
                try {
                    File file2;
                    if (!bl) {
                        Log.info(MessageFormat.format(I18N.getString("message.creating-app-bundle"), StandardBundlerParam.APP_NAME.fetchFrom(map), file.getAbsolutePath()));
                    }
                    this.prepareConfigFiles(map);
                    File file3 = WinAppBundler.getRootDir(file, map);
                    IOUtils.deleteRecursive(file3);
                    file3.mkdirs();
                    File file4 = new File(file3, "app");
                    file4.mkdirs();
                    this.copyApplication(map, file4);
                    File file5 = new File(file4, "package.cfg");
                    file5.createNewFile();
                    this.writePkgInfo(map, file5);
                    File file6 = WinAppBundler.getLauncher(file, map);
                    IOUtils.copyFromURL(RAW_EXECUTABLE_URL.fetchFrom(map), file6);
                    file6.setExecutable(true, false);
                    if (REBRAND_EXECUTABLE.fetchFrom(map).booleanValue() && this.getConfig_AppIcon(map).exists()) {
                        file2 = File.createTempFile("iconswap", ".exe");
                        file2.delete();
                        IOUtils.copyFromURL(WinResources.class.getResource(TOOL_ICON_SWAP), file2);
                        file2.setExecutable(true, false);
                        file2.deleteOnExit();
                        file6.setWritable(true);
                        object = new ProcessBuilder(file2.getAbsolutePath(), this.getConfig_AppIcon(map).getAbsolutePath(), file6.getAbsolutePath());
                        IOUtils.exec((ProcessBuilder)object, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
                        file6.setReadOnly();
                        file2.delete();
                    }
                    file2 = new File(file3, "runtime");
                    this.copyRuntime(map, file2);
                    IOUtils.copyFile(this.getConfig_AppIcon(map), new File(WinAppBundler.getRootDir(file, map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".ico"));
                    if (!bl) {
                        Log.info(MessageFormat.format(I18N.getString("message.result-dir"), file.getAbsolutePath()));
                    }
                    object = file3;
                    if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block11;
                }
                catch (IOException iOException) {
                    File file7;
                    block14: {
                        block12: {
                            try {
                                Log.info("Exception: " + iOException);
                                Log.debug(iOException);
                                file7 = null;
                                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block12;
                            }
                            catch (Throwable throwable) {
                                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), this.getConfigRoot(map).getAbsolutePath()));
                                } else {
                                    this.cleanupConfigFiles(map);
                                }
                                throw throwable;
                            }
                            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), this.getConfigRoot(map).getAbsolutePath()));
                            break block14;
                        }
                        this.cleanupConfigFiles(map);
                    }
                    return file7;
                }
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), this.getConfigRoot(map).getAbsolutePath()));
                break block13;
            }
            this.cleanupConfigFiles(map);
        }
        return object;
    }

    private void copyApplication(Map<String, ? super Object> map, File file) throws IOException {
        RelativeFileSet relativeFileSet = (RelativeFileSet)StandardBundlerParam.APP_RESOURCES.fetchFrom(map);
        if (relativeFileSet == null) {
            throw new RuntimeException("Null app resources?");
        }
        File file2 = relativeFileSet.getBaseDirectory();
        for (String string : relativeFileSet.getIncludedFiles()) {
            IOUtils.copyFile(new File(file2, string), new File(file, string));
        }
    }

    private void writePkgInfo(Map<String, ? super Object> map, File file) throws FileNotFoundException {
        Object object22;
        file.delete();
        PrintStream printStream = new PrintStream(file);
        printStream.println("app.mainjar=" + ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(map)).getIncludedFiles().iterator().next());
        printStream.println("app.version=" + (String)StandardBundlerParam.VERSION.fetchFrom(map));
        printStream.println("app.id=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map));
        printStream.println("app.preferences.id=" + (String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(map));
        if (((Boolean)StandardBundlerParam.USE_FX_PACKAGING.fetchFrom(map)).booleanValue()) {
            printStream.println("app.mainclass=" + "com.javafx.main.Main".replaceAll("\\.", "/"));
        } else {
            printStream.println("app.mainclass=" + ((String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map)).replaceAll("\\.", "/"));
        }
        printStream.println("app.classpath=" + (String)StandardBundlerParam.CLASSPATH.fetchFrom(map));
        List list = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(map);
        int n = 1;
        for (Object object22 : list) {
            printStream.println("jvmarg." + n + "=" + (String)object22);
            ++n;
        }
        Map map2 = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(map);
        for (Map.Entry object3 : map2.entrySet()) {
            printStream.println("jvmarg." + n + "=-D" + (String)object3.getKey() + "=" + (String)object3.getValue());
            ++n;
        }
        object22 = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(map);
        n = 1;
        for (Map.Entry entry : object22.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                Log.info(I18N.getString("message.jvm-user-arg-is-null"));
            } else {
                printStream.println("jvmuserarg." + n + ".name=" + (String)entry.getKey());
                printStream.println("jvmuserarg." + n + ".value=" + (String)entry.getValue());
            }
            ++n;
        }
        printStream.close();
    }

    private void copyRuntime(Map<String, ? super Object> map, File file) throws IOException {
        RelativeFileSet relativeFileSet = WindowsBundlerParam.WIN_RUNTIME.fetchFrom(map);
        if (relativeFileSet == null) {
            return;
        }
        file.mkdirs();
        File file2 = relativeFileSet.getBaseDirectory();
        File file3 = new File(file, file2.getName());
        Set<String> set = relativeFileSet.getIncludedFiles();
        for (String string : set) {
            IOUtils.copyFile(new File(file2, string), new File(file3, string));
        }
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "windows.app";
    }

    @Override
    public String getBundleType() {
        return "IMAGE";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return WinAppBundler.getAppBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getAppBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.APP_RESOURCES, ICON_ICO, StandardBundlerParam.JVM_OPTIONS, StandardBundlerParam.JVM_PROPERTIES, StandardBundlerParam.MAIN_CLASS, StandardBundlerParam.MAIN_JAR, StandardBundlerParam.CLASSPATH, StandardBundlerParam.PREFERENCES_ID, StandardBundlerParam.USER_JVM_OPTIONS, StandardBundlerParam.VERSION, WindowsBundlerParam.WIN_RUNTIME);
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.doBundle(map, file, false);
    }
}

