/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.mac.MacDaemonBundler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public abstract class MacBaseInstallerBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacBaseInstallerBundler.class.getName());
    public static final BundlerParamInfo<MacAppBundler> APP_BUNDLER = new StandardBundlerParam<MacAppBundler>(I18N.getString("param.app-bundler.name"), I18N.getString("param.app-bundle.description"), "mac.app.bundler", MacAppBundler.class, map -> new MacAppBundler(), (string, map) -> null);
    public final BundlerParamInfo<File> APP_IMAGE_BUILD_ROOT = new StandardBundlerParam<File>(I18N.getString("param.app-image-build-root.name"), I18N.getString("param.app-image-build-root.description"), "mac.app.imageRoot", File.class, map -> {
        File file = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)map);
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, this.getID() + ".image");
    }, (string, map) -> new File((String)string));
    public static final StandardBundlerParam<File> MAC_APP_IMAGE = new StandardBundlerParam<File>(I18N.getString("param.app-image.name"), I18N.getString("param.app-image.description"), "mac.app.image", File.class, map -> null, (string, map) -> new File((String)string));
    public static final BundlerParamInfo<MacDaemonBundler> DAEMON_BUNDLER = new StandardBundlerParam<MacDaemonBundler>(I18N.getString("param.daemon-bundler.name"), I18N.getString("param.daemon-bundler.description"), "mac.daemon.bundler", MacDaemonBundler.class, map -> new MacDaemonBundler(), (string, map) -> null);
    public final BundlerParamInfo<File> DAEMON_IMAGE_BUILD_ROOT = new StandardBundlerParam<File>(I18N.getString("param.daemon-image-build-root.name"), I18N.getString("param.daemon-image-build-root.description"), "mac.daemon.image", File.class, map -> {
        File file = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)map);
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, this.getID() + ".daemon");
    }, (string, map) -> new File((String)string));
    public static final BundlerParamInfo<File> CONFIG_ROOT = new StandardBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, map -> {
        File file = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)map), "macosx");
        file.mkdirs();
        return file;
    }, (string, map) -> null);
    public static final BundlerParamInfo<String> SIGNING_KEY_USER = new StandardBundlerParam<String>(I18N.getString("param.signing-key-name.name"), I18N.getString("param.signing-key-name.description"), "mac.signing-key-user-name", String.class, map -> "", null);
    public static final BundlerParamInfo<String> INSTALLER_NAME = new StandardBundlerParam<String>(I18N.getString("param.installer-name.name"), I18N.getString("param.installer-name.description"), "mac.installerName", String.class, map -> {
        String string = (String)StandardBundlerParam.APP_NAME.fetchFrom((Map<String, Object>)map);
        if (string == null) {
            return null;
        }
        String string2 = (String)StandardBundlerParam.VERSION.fetchFrom((Map<String, Object>)map);
        if (string2 == null) {
            return string;
        }
        return string + "-" + string2;
    }, (string, map) -> string);

    public static File getPredefinedImage(Map<String, ? super Object> map) {
        File file = null;
        if (MAC_APP_IMAGE.fetchFrom(map) != null) {
            file = (File)MAC_APP_IMAGE.fetchFrom(map);
            Log.debug("Using App Image from " + file);
            if (!file.exists()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("message.app-image-dir-does-not-exist"), MAC_APP_IMAGE.getID(), file.toString()));
            }
        }
        return file;
    }

    protected void validateAppImageAndBundeler(Map<String, ? super Object> map) throws ConfigException, UnsupportedPlatformException {
        if (MAC_APP_IMAGE.fetchFrom(map) != null) {
            File file = (File)MAC_APP_IMAGE.fetchFrom(map);
            if (!file.exists()) {
                throw new ConfigException(MessageFormat.format(I18N.getString("message.app-image-dir-does-not-exist"), MAC_APP_IMAGE.getID(), file.toString()), MessageFormat.format(I18N.getString("message.app-image-dir-does-not-exist.advice"), MAC_APP_IMAGE.getID()));
            }
            if (StandardBundlerParam.APP_NAME.fetchFrom(map) == null) {
                throw new ConfigException(I18N.getString("message.app-image-requires-app-name"), I18N.getString("message.app-image-requires-app-name.advice"));
            }
            if (StandardBundlerParam.IDENTIFIER.fetchFrom(map) == null) {
                throw new ConfigException(I18N.getString("message.app-image-requires-identifier"), I18N.getString("message.app-image-requires-identifier.advice"));
            }
        } else {
            APP_BUNDLER.fetchFrom(map).doValidate(map);
        }
    }

    protected File prepareAppBundle(Map<String, ? super Object> map) {
        File file = MacBaseInstallerBundler.getPredefinedImage(map);
        if (file != null) {
            return file;
        }
        File file2 = this.APP_IMAGE_BUILD_ROOT.fetchFrom(map);
        return APP_BUNDLER.fetchFrom(map).doBundle(map, file2, true);
    }

    protected File prepareDaemonBundle(Map<String, ? super Object> map) throws ConfigException {
        File file = this.DAEMON_IMAGE_BUILD_ROOT.fetchFrom(map);
        return DAEMON_BUNDLER.fetchFrom(map).doBundle(map, file, true);
    }

    public static void signAppBundle(Map<String, ? super Object> map, File file, String string, String string2) throws IOException {
        MacBaseInstallerBundler.signAppBundle(map, file, string, string2, null, null);
    }

    public static void signAppBundle(Map<String, ? super Object> map, File file, String string, String string2, String string3, String string4) throws IOException {
        Path path2;
        AtomicReference atomicReference = new AtomicReference();
        Files.walk(file.toPath(), new FileVisitOption[0]).filter(path -> path.toString().endsWith(".jar") || path.toString().endsWith(".dylib")).forEach(path -> {
            if (atomicReference.get() != null) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList("codesign", "-f"));
            if (string != null) {
                arrayList.add("-s");
                arrayList.add(string);
            }
            if (string3 != null) {
                arrayList.add("--entitlements");
                arrayList.add(string3);
            }
            arrayList.add("-vvvv");
            arrayList.add(path.toString());
            try {
                Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, new LinkOption[0]);
                File file = path.toFile();
                file.setWritable(true, true);
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
                Files.setPosixFilePermissions(path, set);
            }
            catch (IOException iOException) {
                atomicReference.set(iOException);
            }
        });
        IOException iOException = (IOException)atomicReference.get();
        if (iOException != null) {
            throw iOException;
        }
        Files.find(file.toPath().resolve("Contents"), Integer.MAX_VALUE, (path, basicFileAttributes) -> Files.isExecutable(path) && Files.isRegularFile(path, new LinkOption[0]), new FileVisitOption[0]).filter(path -> !path.toString().endsWith(".dylib") && !path.toString().contains("/Contents/MacOS/")).forEachOrdered(path -> {
            if (atomicReference.get() != null) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList("codesign", "--deep", "-f"));
            if (string != null) {
                arrayList.add("-s");
                arrayList.add(string);
            }
            if (string4 != null) {
                arrayList.add("--entitlements");
                arrayList.add(string4);
            }
            arrayList.add("-vvvv");
            arrayList.add(path.toString());
            try {
                Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, new LinkOption[0]);
                File file = path.toFile();
                file.setWritable(true, true);
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
                Files.setPosixFilePermissions(path, set);
            }
            catch (IOException iOException) {
                atomicReference.set(iOException);
            }
        });
        iOException = (IOException)atomicReference.get();
        if (iOException != null) {
            throw iOException;
        }
        Consumer<Path> consumer = path -> {
            if (atomicReference.get() != null) {
                return;
            }
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                 PrintStream printStream = new PrintStream(byteArrayOutputStream);){
                ProcessBuilder processBuilder = new ProcessBuilder("/usr/libexec/PlistBuddy", "-c", "Print :CFBundleIdentifier", path.resolve("Contents/Info.plist").toString());
                IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map), false, printStream);
                String string3 = byteArrayOutputStream.toString();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList("codesign", "-s", string, "-f", "--prefix", string2, "-vvvv"));
                if (string != null) {
                    arrayList.add("-s");
                    arrayList.add(string);
                }
                arrayList.add(path.toString());
                processBuilder = new ProcessBuilder(arrayList);
                IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            }
            catch (IOException iOException) {
                atomicReference.set(iOException);
            }
        };
        Path path3 = file.toPath().resolve("Contents/PlugIns");
        if (Files.isDirectory(path3, new LinkOption[0])) {
            Files.list(path3).forEach(consumer);
            iOException = (IOException)atomicReference.get();
            if (iOException != null) {
                throw iOException;
            }
        }
        if (Files.isDirectory(path2 = file.toPath().resolve("Contents/Frameworks"), new LinkOption[0])) {
            Files.list(path2).forEach(consumer);
            iOException = (IOException)atomicReference.get();
            if (iOException != null) {
                throw iOException;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList("codesign", "-s", string, "--deep", "-f"));
        if (string3 != null) {
            arrayList.add("--entitlements");
            arrayList.add(string3);
        }
        arrayList.add("-vvvv");
        arrayList.add(file.toString());
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList.toArray(new String[arrayList.size()]));
        IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(MacAppBundler.getAppBundleParameters());
        linkedHashSet.addAll(Arrays.asList(APP_BUNDLER, CONFIG_ROOT, this.APP_IMAGE_BUILD_ROOT, MAC_APP_IMAGE));
        return linkedHashSet;
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }
}

