/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.linux;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.JreUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class LinuxAppBundler
extends AbstractBundler {
    private static final ResourceBundle I18N;
    protected static final String LINUX_BUNDLER_PREFIX;
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    public static final BundlerParamInfo<File> ICON_PNG;
    public static final BundlerParamInfo<URL> RAW_EXECUTABLE_URL;
    public static final BundlerParamInfo<JreUtils.Rule[]> LINUX_JRE_RULES;
    public static final BundlerParamInfo<RelativeFileSet> LINUX_RUNTIME;

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            return this.doValidate(map);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    boolean doValidate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            throw new UnsupportedPlatformException();
        }
        StandardBundlerParam.validateMainClassInfoFromAppResources(map);
        if (RAW_EXECUTABLE_URL.fetchFrom(map) == null) {
            throw new ConfigException(I18N.getString("error.no-linux-resources"), I18N.getString("error.no-linux-resources.advice"));
        }
        if (StandardBundlerParam.MAIN_JAR.fetchFrom(map) == null) {
            throw new ConfigException(I18N.getString("error.no-application-jar"), I18N.getString("error.no-application-jar.advice"));
        }
        this.testRuntime(LINUX_RUNTIME.fetchFrom(map), new String[]{"lib/[^/]+/[^/]+/libjvm.so", "lib/rt.jar"});
        if (((Boolean)StandardBundlerParam.USE_FX_PACKAGING.fetchFrom(map)).booleanValue()) {
            this.testRuntime(LINUX_RUNTIME.fetchFrom(map), new String[]{"lib/ext/jfxrt.jar", "lib/jfxrt.jar"});
        }
        return true;
    }

    public static File getRootDir(File file, Map<String, ? super Object> map) {
        return new File(file, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map));
    }

    File doBundle(Map<String, ? super Object> map, File file, boolean bl) {
        try {
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
            }
            if (!file.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
            }
            File file2 = new File(file, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map));
            IOUtils.deleteRecursive(file2);
            file2.mkdirs();
            if (!bl) {
                Log.info(MessageFormat.format(I18N.getString("message.creating-bundle-location"), file2.getAbsolutePath()));
            }
            File file3 = new File(file2, "runtime");
            File file4 = new File(file2, "app");
            file4.mkdirs();
            File file5 = new File(LinuxAppBundler.getRootDir(file, map), (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map));
            IOUtils.copyFromURL(RAW_EXECUTABLE_URL.fetchFrom(map), file5);
            file5.setExecutable(true, false);
            file5.setWritable(true, true);
            File file6 = new File(file4, "package.cfg");
            file6.createNewFile();
            this.writePkgInfo(map, file6);
            this.copyRuntime(map, file3);
            this.copyApplication(map, file4);
            return file2;
        }
        catch (IOException iOException) {
            Log.info("Exception: " + iOException);
            Log.debug(iOException);
            return null;
        }
    }

    private void copyApplication(Map<String, ? super Object> map, File file) throws IOException {
        RelativeFileSet relativeFileSet = (RelativeFileSet)StandardBundlerParam.APP_RESOURCES.fetchFrom(map);
        if (relativeFileSet == null) {
            throw new RuntimeException("Null app resources?");
        }
        File file2 = relativeFileSet.getBaseDirectory();
        for (String string : relativeFileSet.getIncludedFiles()) {
            IOUtils.copyFile(new File(file2, string), new File(file, string));
        }
    }

    private void writePkgInfo(Map<String, ? super Object> map, File file) throws FileNotFoundException {
        Object object22;
        file.delete();
        PrintStream printStream = new PrintStream(file);
        printStream.println("app.mainjar=" + ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(map)).getIncludedFiles().iterator().next());
        printStream.println("app.version=" + (String)StandardBundlerParam.VERSION.fetchFrom(map));
        if (((Boolean)StandardBundlerParam.USE_FX_PACKAGING.fetchFrom(map)).booleanValue()) {
            printStream.println("app.mainclass=" + "com.javafx.main.Main".replaceAll("\\.", "/"));
        } else {
            printStream.println("app.mainclass=" + ((String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map)).replaceAll("\\.", "/"));
        }
        printStream.println("app.classpath=" + (String)StandardBundlerParam.CLASSPATH.fetchFrom(map));
        List list = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(map);
        int n = 1;
        for (Object object22 : list) {
            printStream.println("jvmarg." + n + "=" + (String)object22);
            ++n;
        }
        Map map2 = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(map);
        for (Map.Entry object3 : map2.entrySet()) {
            printStream.println("jvmarg." + n + "=-D" + (String)object3.getKey() + "=" + (String)object3.getValue());
            ++n;
        }
        printStream.println("app.preferences.id=" + (String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(map));
        object22 = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(map);
        n = 1;
        for (Map.Entry entry : object22.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                Log.info(I18N.getString("message.jvm-user-arg-is-null"));
            } else {
                printStream.println("jvmuserarg." + n + ".name=" + (String)entry.getKey());
                printStream.println("jvmuserarg." + n + ".value=" + (String)entry.getValue());
            }
            ++n;
        }
        printStream.close();
    }

    private void copyRuntime(Map<String, ? super Object> map, File file) throws IOException {
        RelativeFileSet relativeFileSet = LINUX_RUNTIME.fetchFrom(map);
        if (relativeFileSet == null) {
            return;
        }
        file.mkdirs();
        File file2 = relativeFileSet.getBaseDirectory();
        File file3 = new File(file, file2.getName());
        Set<String> set = relativeFileSet.getIncludedFiles();
        for (String string : set) {
            IOUtils.copyFile(new File(file2, string), new File(file3, string));
        }
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "linux.app";
    }

    @Override
    public String getBundleType() {
        return "IMAGE";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return LinuxAppBundler.getAppBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getAppBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.APP_RESOURCES, StandardBundlerParam.JVM_OPTIONS, StandardBundlerParam.JVM_PROPERTIES, LINUX_RUNTIME, StandardBundlerParam.MAIN_CLASS, StandardBundlerParam.MAIN_JAR, StandardBundlerParam.CLASSPATH, StandardBundlerParam.PREFERENCES_ID, StandardBundlerParam.USER_JVM_OPTIONS, StandardBundlerParam.VERSION);
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.doBundle(map, file, false);
    }

    private static /* synthetic */ RelativeFileSet lambda$static$69(String string, Map map) {
        return JreUtils.extractJreAsRelativeFileSet(string, LINUX_JRE_RULES.fetchFrom(map));
    }

    private static /* synthetic */ RelativeFileSet lambda$static$68(Map map) {
        return JreUtils.extractJreAsRelativeFileSet(System.getProperty("java.home"), LINUX_JRE_RULES.fetchFrom(map));
    }

    private static /* synthetic */ JreUtils.Rule[] lambda$static$67(String string, Map map) {
        return null;
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

