/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public class StandardBundlerParam<T>
extends BundlerParamInfo<T> {
    public static final String MANIFEST_JAVAFX_MAIN = "JavaFX-Application-Class";
    private static final ResourceBundle I18N = ResourceBundle.getBundle(StandardBundlerParam.class.getName());
    public static final StandardBundlerParam<RelativeFileSet> APP_RESOURCES = new StandardBundlerParam<RelativeFileSet>(I18N.getString("param.app-resources.name"), I18N.getString("param.app-resource.description"), "appResources", RelativeFileSet.class, null, null);
    public static final StandardBundlerParam<File> ICON = new StandardBundlerParam<File>(I18N.getString("param.icon-file.name"), I18N.getString("param.icon-file.description"), "icon", File.class, map -> null, (string, map) -> new File((String)string));
    public static final StandardBundlerParam<String> MAIN_CLASS = new StandardBundlerParam<String>(I18N.getString("param.main-class.name"), I18N.getString("param.main-class.description"), "applicationClass", String.class, map -> {
        StandardBundlerParam.extractMainClassInfoFromAppResources(map);
        return (String)map.get("applicationClass");
    }, (string, map) -> string);
    public static final StandardBundlerParam<String> APP_NAME = new StandardBundlerParam<String>(I18N.getString("param.app-name.name"), I18N.getString("param.app-name.description"), "name", String.class, map -> {
        String string = (String)MAIN_CLASS.fetchFrom((Map<String, Object>)map);
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }, (string, map) -> string);
    private static Pattern TO_FS_NAME = Pattern.compile("[^-a-zA-Z0-9.]");
    public static final StandardBundlerParam<String> APP_FS_NAME = new StandardBundlerParam<String>(I18N.getString("param.app-fs-name.name"), I18N.getString("param.app-fs-name.description"), "name.fs", String.class, map -> TO_FS_NAME.matcher((CharSequence)APP_NAME.fetchFrom((Map<String, Object>)map)).replaceAll(""), (string, map) -> string);
    public static final StandardBundlerParam<String> VENDOR = new StandardBundlerParam<String>(I18N.getString("param.vendor.name"), I18N.getString("param.vendor.description"), "vendor", String.class, map -> I18N.getString("param.vendor.default"), (string, map) -> string);
    public static final StandardBundlerParam<String> CATEGORY = new StandardBundlerParam<String>(I18N.getString("param.category.name"), I18N.getString("param.category.description"), "applicationCategory", String.class, map -> I18N.getString("param.category.default"), (string, map) -> string);
    public static final StandardBundlerParam<String> DESCRIPTION = new StandardBundlerParam<String>(I18N.getString("param.description.name"), I18N.getString("param.description.description"), "description", String.class, map -> map.containsKey(APP_NAME.getID()) ? (String)APP_NAME.fetchFrom((Map<String, Object>)map) : I18N.getString("param.description.default"), (string, map) -> string);
    public static final StandardBundlerParam<String> COPYRIGHT = new StandardBundlerParam<String>(I18N.getString("param.copyright.name"), I18N.getString("param.copyright.description"), "copyright", String.class, map -> MessageFormat.format(I18N.getString("param.copyright.default"), new Date()), (string, map) -> string);
    public static final StandardBundlerParam<RelativeFileSet> MAIN_JAR = new StandardBundlerParam<RelativeFileSet>(I18N.getString("param.main-jar.name"), I18N.getString("param.main-jar.description"), "mainJar", RelativeFileSet.class, map -> {
        StandardBundlerParam.extractMainClassInfoFromAppResources(map);
        return (RelativeFileSet)map.get("mainJar");
    }, (string, map) -> {
        File file = ((RelativeFileSet)APP_RESOURCES.fetchFrom((Map<String, Object>)map)).getBaseDirectory();
        File file2 = new File(file, (String)string);
        if (!file2.exists()) {
            throw new IllegalArgumentException(new ConfigException(MessageFormat.format(I18N.getString("error.main-jar-does-not-exist"), string), I18N.getString("error.main-jar-does-not-exist.advice")));
        }
        return new RelativeFileSet(file, new LinkedHashSet<File>(Arrays.asList(file2)));
    });
    public static final StandardBundlerParam<String> CLASSPATH = new StandardBundlerParam<String>(I18N.getString("param.classpath.name"), I18N.getString("param.classpath.description"), "classpath", String.class, map -> {
        StandardBundlerParam.extractMainClassInfoFromAppResources(map);
        String string = (String)map.get("classpath");
        return string == null ? "" : string;
    }, (string, map) -> string.replace(File.pathSeparator, " "));
    public static final StandardBundlerParam<Boolean> USE_FX_PACKAGING = new StandardBundlerParam<Boolean>(I18N.getString("param.use-javafx-packaging.name"), I18N.getString("param.use-javafx-packaging.description"), "fxPackaging", Boolean.class, map -> {
        StandardBundlerParam.extractMainClassInfoFromAppResources(map);
        Boolean bl = (Boolean)map.get("fxPackaging");
        return bl == null ? Boolean.FALSE : bl;
    }, (string, map) -> Boolean.valueOf(string));
    public static final StandardBundlerParam<List<String>> JVM_OPTIONS = new StandardBundlerParam<List>(I18N.getString("param.jvm-options.name"), I18N.getString("param.jvm-options.description"), "jvmOptions", List.class, map -> Collections.emptyList(), (string, map) -> Arrays.asList(string.split("\\s+")));
    public static final StandardBundlerParam<Map<String, String>> JVM_PROPERTIES = new StandardBundlerParam<Map>(I18N.getString("param.jvm-system-properties.name"), I18N.getString("param.jvm-system-properties.description"), "jvmProperties", Map.class, map -> Collections.emptyMap(), (string, map) -> {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Properties properties = new Properties();
            properties.load(new StringReader((String)string));
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                hashMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashMap;
    });
    public static final StandardBundlerParam<Map<String, String>> USER_JVM_OPTIONS = new StandardBundlerParam<Map>(I18N.getString("param.user-jvm-options.name"), I18N.getString("param.user-jvm-options.description"), "userJvmOptions", Map.class, map -> Collections.emptyMap(), (string, map) -> {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Properties properties = new Properties();
            properties.load(new StringReader((String)string));
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                hashMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashMap;
    });
    public static final StandardBundlerParam<String> TITLE = new StandardBundlerParam<String>(I18N.getString("param.title.name"), I18N.getString("param.title.description"), "title", String.class, APP_NAME::fetchFrom, (string, map) -> string);
    public static final StandardBundlerParam<String> VERSION = new StandardBundlerParam<String>(I18N.getString("param.version.name"), I18N.getString("param.version.description"), "appVersion", String.class, map -> I18N.getString("param.version.default"), (string, map) -> string);
    public static final StandardBundlerParam<Boolean> SYSTEM_WIDE = new StandardBundlerParam<Boolean>(I18N.getString("param.system-wide.name"), I18N.getString("param.system-wide.description"), "systemWide", Boolean.class, map -> null, (string, map) -> string == null || "null".equalsIgnoreCase((String)string) ? null : Boolean.valueOf(string));
    public static final StandardBundlerParam<Boolean> SERVICE_HINT = new StandardBundlerParam<Boolean>(I18N.getString("param.service-hint.name"), I18N.getString("param.service-hint.description"), "serviceHint", Boolean.class, map -> false, (string, map) -> string == null || "null".equalsIgnoreCase((String)string) ? true : Boolean.valueOf(string));
    public static final StandardBundlerParam<Boolean> START_ON_INSTALL = new StandardBundlerParam<Boolean>(I18N.getString("param.start-on-install.name"), I18N.getString("param.start-on-install.description"), "startOnInstall", Boolean.class, map -> false, (string, map) -> string == null || "null".equalsIgnoreCase((String)string) ? true : Boolean.valueOf(string));
    public static final StandardBundlerParam<Boolean> STOP_ON_UNINSTALL = new StandardBundlerParam<Boolean>(I18N.getString("param.stop-on-uninstall.name"), I18N.getString("param.stop-on-uninstall.description"), "stopOnUninstall", Boolean.class, map -> true, (string, map) -> string == null || "null".equalsIgnoreCase((String)string) ? true : Boolean.valueOf(string));
    public static final StandardBundlerParam<Boolean> RUN_AT_STARTUP = new StandardBundlerParam<Boolean>(I18N.getString("param.run-at-startup.name"), I18N.getString("param.run-at-startup.description"), "runAtStartup", Boolean.class, map -> false, (string, map) -> string == null || "null".equalsIgnoreCase((String)string) ? true : Boolean.valueOf(string));
    public static final StandardBundlerParam<Boolean> SHORTCUT_HINT = new StandardBundlerParam<Boolean>(I18N.getString("param.desktop-shortcut-hint.name"), I18N.getString("param.desktop-shortcut-hint.description"), "shortcutHint", Boolean.class, map -> false, (string, map) -> string == null || "null".equalsIgnoreCase((String)string) ? false : Boolean.valueOf(string));
    public static final StandardBundlerParam<Boolean> MENU_HINT = new StandardBundlerParam<Boolean>(I18N.getString("param.menu-shortcut-hint.name"), I18N.getString("param.menu-shortcut-hint.description"), "menuHint", Boolean.class, map -> true, (string, map) -> string == null || "null".equalsIgnoreCase((String)string) ? true : Boolean.valueOf(string));
    public static final StandardBundlerParam<List<String>> LICENSE_FILE = new StandardBundlerParam<List>(I18N.getString("param.license-file.name"), I18N.getString("param.license-file.description"), "licenseFile", List.class, map -> Collections.emptyList(), (string, map) -> Arrays.asList(string.split(",")));
    public static final BundlerParamInfo<String> LICENSE_TYPE = new StandardBundlerParam<String>(I18N.getString("param.license-type.name"), I18N.getString("param.license-type.description"), "licenseType", String.class, map -> I18N.getString("param.license-type.default"), (string, map) -> string);
    public static final StandardBundlerParam<File> BUILD_ROOT = new StandardBundlerParam<File>(I18N.getString("param.build-root.name"), I18N.getString("param.build-root.description"), "buildRoot", File.class, map -> {
        try {
            return Files.createTempDirectory("fxbundler", new FileAttribute[0]).toFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }, (string, map) -> new File((String)string));
    public static final StandardBundlerParam<String> IDENTIFIER = new StandardBundlerParam<String>(I18N.getString("param.identifier.name"), I18N.getString("param.identifier.description"), "identifier", String.class, map -> {
        String string = (String)MAIN_CLASS.fetchFrom((Map<String, Object>)map);
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n >= 1) {
            return string.substring(0, n);
        }
        return string;
    }, (string, map) -> string);
    public static final StandardBundlerParam<String> PREFERENCES_ID = new StandardBundlerParam<String>(I18N.getString("param.preferences-id.name"), I18N.getString("param.preferences-id.description"), "preferencesID", String.class, map -> ((String)IDENTIFIER.fetchFrom((Map<String, Object>)map)).replace('.', '/'), (string, map) -> string);
    public static final StandardBundlerParam<Boolean> VERBOSE = new StandardBundlerParam<Boolean>(I18N.getString("param.verbose.name"), I18N.getString("param.verbose.description"), "verbose", Boolean.class, map -> false, (string, map) -> string == null || "null".equalsIgnoreCase((String)string) ? true : Boolean.valueOf(string));

    public StandardBundlerParam(String string, String string2, String string3, Class<T> clazz, Function<Map<String, ? super Object>, T> function, BiFunction<String, Map<String, ? super Object>, T> biFunction) {
        this.name = string;
        this.description = string2;
        this.id = string3;
        this.valueType = clazz;
        this.defaultValueFunction = function;
        this.stringConverter = biFunction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractMainClassInfoFromAppResources(Map<String, ? super Object> map) {
        File file;
        Collection<String> collection;
        Object object;
        boolean bl = map.containsKey(MAIN_CLASS.getID());
        boolean bl2 = map.containsKey(MAIN_JAR.getID());
        boolean bl3 = map.containsKey(CLASSPATH.getID());
        if (bl && bl2 && bl3) {
            return;
        }
        if (bl2) {
            object = (RelativeFileSet)MAIN_JAR.fetchFrom(map);
            collection = ((RelativeFileSet)object).getIncludedFiles();
            file = ((RelativeFileSet)object).getBaseDirectory();
        } else if (bl3) {
            collection = Arrays.asList(((String)CLASSPATH.fetchFrom(map)).split("\\s+"));
            file = ((RelativeFileSet)APP_RESOURCES.fetchFrom(map)).getBaseDirectory();
        } else {
            object = (RelativeFileSet)APP_RESOURCES.fetchFrom(map);
            if (object == null) {
                return;
            }
            collection = ((RelativeFileSet)object).getIncludedFiles();
            file = ((RelativeFileSet)object).getBaseDirectory();
        }
        object = (String)map.get(MAIN_CLASS.getID());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Attributes attributes;
                File file2;
                block18: {
                    String string2;
                    String string3;
                    block19: {
                        JarFile jarFile;
                        Manifest manifest;
                        if (!string.toLowerCase().endsWith(".jar") || !(file2 = new File(file, string)).exists() || (attributes = (manifest = (jarFile = new JarFile(file2)).getManifest()) != null ? manifest.getMainAttributes() : null) == null) continue;
                        string3 = attributes.getValue(Attributes.Name.MAIN_CLASS);
                        string2 = attributes.getValue(MANIFEST_JAVAFX_MAIN);
                        if (!bl) break block19;
                        if (((String)object).equals(string2)) {
                            map.put(USE_FX_PACKAGING.getID(), (Object)true);
                            break block18;
                        } else if (((String)object).equals(string3)) {
                            map.put(USE_FX_PACKAGING.getID(), (Object)false);
                            break block18;
                        } else {
                            if (string2 != null) {
                                Log.info(MessageFormat.format(I18N.getString("message.fx-app-does-not-match-specified-main"), string, string2, object));
                            }
                            if (string3 == null) continue;
                            Log.info(MessageFormat.format(I18N.getString("message.main-class-does-not-match-specified-main"), string, string3, object));
                            continue;
                        }
                    }
                    if (string2 != null) {
                        map.put(USE_FX_PACKAGING.getID(), (Object)true);
                        map.put(MAIN_CLASS.getID(), string2);
                    } else {
                        if (string3 == null) continue;
                        map.put(USE_FX_PACKAGING.getID(), (Object)false);
                        map.put(MAIN_CLASS.getID(), string3);
                    }
                }
                if (!bl2) {
                    if (file == null) {
                        file = file2.getParentFile();
                    }
                    map.put(MAIN_JAR.getID(), new RelativeFileSet(file, new LinkedHashSet<File>(Arrays.asList(file2))));
                }
                if (bl3) return;
                String string4 = attributes.getValue(Attributes.Name.CLASS_PATH);
                map.put(CLASSPATH.getID(), string4 == null ? "" : string4);
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void validateMainClassInfoFromAppResources(Map<String, ? super Object> map) throws ConfigException {
        boolean bl = map.containsKey(MAIN_CLASS.getID());
        boolean bl2 = map.containsKey(MAIN_JAR.getID());
        boolean bl3 = map.containsKey(CLASSPATH.getID());
        if (bl && bl2 && bl3) {
            return;
        }
        StandardBundlerParam.extractMainClassInfoFromAppResources(map);
        if (!map.containsKey(MAIN_CLASS.getID())) {
            if (bl2) {
                throw new ConfigException(MessageFormat.format(I18N.getString("error.no-main-class-with-main-jar"), MAIN_JAR.fetchFrom(map)), MessageFormat.format(I18N.getString("error.no-main-class-with-main-jar.advice"), MAIN_JAR.fetchFrom(map)));
            }
            if (bl3) {
                throw new ConfigException(I18N.getString("error.no-main-class-with-classpath"), I18N.getString("error.no-main-class-with-classpath.advice"));
            }
            throw new ConfigException(I18N.getString("error.no-main-class"), I18N.getString("error.no-main-class.advice"));
        }
    }
}

