/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.Log;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;

public class RelativeFileSet {
    private File basedir;
    Set<String> files = new LinkedHashSet<String>();

    public RelativeFileSet(File file, Set<File> set) {
        this.basedir = file;
        String string = this.basedir.getAbsolutePath();
        for (File file2 : set) {
            String string2 = file2.getAbsolutePath();
            if (!string2.startsWith(string)) {
                throw new RuntimeException("File " + file2.getAbsolutePath() + " does not belong to " + string);
            }
            if (string2.equals(string)) continue;
            this.files.add(string2.substring(string.length() + 1));
        }
    }

    public boolean contains(String[] stringArray) {
        boolean bl = true;
        for (String string : stringArray) {
            if (this.files.contains(string)) continue;
            Log.debug("  Runtime does not contain [" + string + "]");
            bl = false;
        }
        return bl;
    }

    public boolean contains(String string) {
        if (this.files.contains(string)) {
            return true;
        }
        Log.debug("  Runtime does not contain [" + string + "]");
        return false;
    }

    public File getBaseDirectory() {
        return this.basedir;
    }

    public Set<String> getIncludedFiles() {
        return this.files;
    }

    public void dump() {
        Log.verbose("\n=========\nBasedir: " + this.basedir + "\n");
        for (String string : this.files) {
            Log.verbose("  " + string);
        }
        Log.verbose("\n========");
    }

    public String toString() {
        return "RelativeFileSet{basedir:" + this.basedir + ", files:" + this.files + "}";
    }
}

