/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.InvalidBundlerParamException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class EnumeratedBundlerParam<T>
extends BundlerParamInfo<T> {
    private Map<String, T> possibleValues;
    private boolean strict;

    public EnumeratedBundlerParam(String string, String string2, String string3, Class<T> clazz, Function<Map<String, ? super Object>, T> function, BiFunction<String, Map<String, ? super Object>, T> biFunction, Map<String, T> map, boolean bl) {
        this.name = string;
        this.description = string2;
        this.id = string3;
        this.valueType = clazz;
        this.defaultValueFunction = function;
        this.stringConverter = biFunction;
        this.possibleValues = map;
        this.strict = bl;
    }

    public boolean isInPossibleValues(T t) {
        return this.possibleValues.values().contains(t);
    }

    public Set<String> getDisplayableKeys() {
        return Collections.unmodifiableSet(this.possibleValues.keySet());
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isLoose() {
        return !this.isStrict();
    }

    public T validatedFetchFrom(Map<String, ? super Object> map) throws InvalidBundlerParamException {
        if (this.isStrict()) {
            Object t = this.fetchFrom(map);
            if (!this.isInPossibleValues(t)) {
                throw new InvalidBundlerParamException("Parameter " + t.toString() + " not in valid set of values for BundlerParam " + this.name);
            }
            return t;
        }
        return this.fetchFrom(map);
    }
}

