/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.masterfs.providers.Notifier;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.masterfs.watcher.FOFile;
import org.netbeans.modules.masterfs.watcher.NotifierAccessor;
import org.netbeans.modules.masterfs.watcher.NotifierKeyRef;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public final class Watcher
extends AnnotationProvider {
    static final Logger LOG = Logger.getLogger(Watcher.class.getName());
    private static final Map<FileObject, int[]> MODIFIED = new WeakHashMap<FileObject, int[]>();
    private final Ext<?> ext;
    private final Object lock = "org.netbeans.io.suspend".intern();
    private Set<FileObject> pending;
    private static RequestProcessor RP = new RequestProcessor("Pending refresh", 1);
    private RequestProcessor.Task refreshTask = RP.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set set;
            Iterator iterator = Watcher.this.lock;
            synchronized (iterator) {
                int n;
                set = Watcher.this.pending;
                if (set == null) {
                    return;
                }
                while ((n = Integer.getInteger("org.netbeans.io.suspend", 0).intValue()) > 0) {
                    String string = String.valueOf(set.size());
                    System.setProperty("org.netbeans.io.pending", string);
                    LOG.log(Level.FINE, "Suspend count {0} pending {1}", new Object[]{n, string});
                    try {
                        Watcher.this.lock.wait(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.log(Level.FINE, null, interruptedException);
                    }
                }
                System.getProperties().remove("org.netbeans.io.pending");
                Watcher.this.pending = null;
            }
            LOG.log(Level.FINE, "Refreshing {0} directories", set.size());
            for (FileObject fileObject : set) {
                if (Watcher.isLocked(fileObject)) {
                    Watcher.this.enqueue(fileObject);
                    continue;
                }
                LOG.log(Level.FINEST, "Refreshing {0}", fileObject);
                fileObject.refresh();
            }
            LOG.fine("Refresh finished");
        }
    });

    public Watcher() {
        if (Boolean.getBoolean("org.netbeans.modules.masterfs.watcher.disable")) {
            this.ext = null;
            return;
        }
        this.ext = this.make(Watcher.getNotifierForPlatform());
    }

    private static Ext<?> ext() {
        Watcher watcher = (Watcher)Lookup.getDefault().lookup(Watcher.class);
        return watcher == null ? null : watcher.ext;
    }

    public static boolean isEnabled() {
        return Watcher.ext() != null;
    }

    public static boolean isWatched(FileObject fileObject) {
        Ext<?> ext = Watcher.ext();
        if (ext == null) {
            return false;
        }
        if (fileObject.isData()) {
            fileObject = fileObject.getParent();
        }
        return ((Ext)ext).isWatched(fileObject);
    }

    public static void register(FileObject fileObject) {
        Ext<?> ext = Watcher.ext();
        if (ext == null) {
            return;
        }
        if (fileObject.isData()) {
            fileObject = fileObject.getParent();
        }
        ext.register(fileObject);
    }

    public static void unregister(FileObject fileObject) {
        Ext<?> ext = Watcher.ext();
        if (ext == null) {
            return;
        }
        if (fileObject.isData() && !(fileObject = fileObject.getParent()).isFolder()) {
            return;
        }
        ext.unregister(fileObject);
    }

    public static File wrap(File file, FileObject fileObject) {
        if (file instanceof FOFile) {
            return file;
        }
        return new FOFile(file, fileObject);
    }

    @Override
    public String annotateName(String string, Set<? extends FileObject> set) {
        return null;
    }

    @Override
    public Image annotateIcon(Image image, int n, Set<? extends FileObject> set) {
        return null;
    }

    @Override
    public String annotateNameHtml(String string, Set<? extends FileObject> set) {
        return null;
    }

    @Override
    public Action[] actions(Set<? extends FileObject> set) {
        return null;
    }

    @Override
    public InterceptionListener getInterceptionListener() {
        return this.ext;
    }

    public static void shutdown() {
        if (Watcher.isEnabled()) {
            try {
                Watcher.ext().shutdown();
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Error on shutdown", iOException);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.INFO, "Error on shutdown", interruptedException);
            }
        }
    }

    private <KEY> Ext<KEY> make(Notifier<KEY> notifier) {
        return notifier == null ? null : new Ext<KEY>(notifier);
    }

    final void clearQueue() throws IOException {
        this.ext.clearQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(FileObject fileObject) {
        assert (fileObject != null);
        Object object = this.lock;
        synchronized (object) {
            if (this.pending == null) {
                this.refreshTask.schedule(1500);
                this.pending = new WeakSet();
            }
            this.pending.add(fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueAll(Set<FileObject> set) {
        assert (set != null);
        assert (!set.contains(null)) : "No nulls";
        Object object = this.lock;
        synchronized (object) {
            if (this.pending == null) {
                this.refreshTask.schedule(1500);
                this.pending = new WeakSet();
            }
            this.pending.addAll(set);
        }
    }

    private static Notifier<?> getNotifierForPlatform() {
        for (Lookup.Item item : Lookup.getDefault().lookupResult(Notifier.class).allItems()) {
            try {
                Notifier notifier = (Notifier)item.getInstance();
                if (notifier == null) continue;
                NotifierAccessor.getDefault().start(notifier);
                return notifier;
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Notifier {0} refused to be initialized", item.getType());
                LOG.log(Level.FINE, null, iOException);
            }
            catch (Exception exception) {
                LOG.log(Level.INFO, "Exception while instantiating " + item, exception);
            }
            catch (LinkageError linkageError) {
                LOG.log(Level.INFO, "Linkage error for " + item, linkageError);
            }
        }
        return null;
    }

    public static synchronized void lock(FileObject fileObject) {
        int[] nArray;
        if (fileObject.isData()) {
            fileObject = fileObject.getParent();
        }
        if ((nArray = MODIFIED.get(fileObject)) == null) {
            nArray = new int[]{0};
            MODIFIED.put(fileObject, nArray);
        }
        nArray[0] = nArray[0] + 1;
    }

    static synchronized boolean isLocked(FileObject fileObject) {
        return MODIFIED.get(fileObject) != null;
    }

    public static synchronized void unlock(FileObject fileObject) {
        int[] nArray;
        if (fileObject.isData()) {
            fileObject = fileObject.getParent();
        }
        if ((nArray = MODIFIED.get(fileObject)) == null) {
            return;
        }
        nArray[0] = nArray[0] - 1;
        if (nArray[0] == 0) {
            MODIFIED.remove(fileObject);
        }
    }

    private class Ext<KEY>
    extends ProvidedExtensions
    implements Runnable {
        private final ReferenceQueue<FileObject> REF = new ReferenceQueue();
        private final Notifier<KEY> impl;
        private final Object LOCK = new Object();
        private final Set<NotifierKeyRef> references = new HashSet<NotifierKeyRef>();
        private final Thread watcher;
        private volatile boolean shutdown;

        public Ext(Notifier<KEY> notifier) {
            this.impl = notifier;
            this.watcher = new Thread((Runnable)this, "File Watcher");
            this.watcher.start();
        }

        @Override
        public long refreshRecursively(File file, long l, List<? super File> list) {
            assert (file instanceof FOFile);
            FileObject fileObject = ((FOFile)file).fo;
            if (fileObject == null && !file.exists()) {
                return -1L;
            }
            assert (fileObject != null) : "No fileobject for " + file;
            this.register(fileObject);
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isWatched(FileObject fileObject) {
            if (!fileObject.isFolder()) assert (fileObject.isValid()) : "Should be a folder: " + fileObject + " type: " + fileObject.getClass();
            try {
                this.clearQueue();
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Exception while clearing the queue", iOException);
            }
            Object object = this.LOCK;
            synchronized (object) {
                NotifierKeyRef<Object> notifierKeyRef = new NotifierKeyRef<Object>(fileObject, null, null, this.impl);
                return this.getReferences().contains(notifierKeyRef);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void register(FileObject fileObject) {
            if (fileObject.isValid() && !fileObject.isFolder()) {
                LOG.log(Level.INFO, "Should be a folder: {0} data: {1} folder: {2} valid: {3}", new Object[]{fileObject, fileObject.isData(), fileObject.isFolder(), fileObject.isValid()});
            }
            try {
                this.clearQueue();
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Exception while clearing the queue", iOException);
            }
            Object object = this.LOCK;
            synchronized (object) {
                NotifierKeyRef<Object> notifierKeyRef = new NotifierKeyRef<Object>(fileObject, null, null, this.impl);
                if (this.getReferences().contains(notifierKeyRef)) {
                    return;
                }
                try {
                    this.getReferences().add(new NotifierKeyRef<KEY>(fileObject, NotifierAccessor.getDefault().addWatch(this.impl, fileObject.getPath()), this.REF, this.impl));
                }
                catch (IOException iOException) {
                    Level level = fileObject.isValid() ? Level.WARNING : Level.FINE;
                    LOG.log(level, "Cannot add filesystem watch for {0}: {1}", new Object[]{fileObject.getPath(), iOException});
                    LOG.log(Level.FINE, null, iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void unregister(FileObject fileObject) {
            assert (!fileObject.isValid() || fileObject.isFolder()) : "If valid, it should be a folder: " + fileObject + " clazz: " + fileObject.getClass();
            Object object = this.LOCK;
            synchronized (object) {
                final NotifierKeyRef[] notifierKeyRefArray = new NotifierKeyRef[1];
                NotifierKeyRef notifierKeyRef = new NotifierKeyRef<KEY>(fileObject, null, null, this.impl){

                    @Override
                    public boolean equals(Object object) {
                        if (super.equals(object)) {
                            notifierKeyRefArray[0] = (NotifierKeyRef)object;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int hashCode() {
                        return super.hashCode();
                    }
                };
                if (!this.references.contains(notifierKeyRef)) {
                    return;
                }
                assert (notifierKeyRefArray[0] != null);
                this.getReferences().remove(notifierKeyRefArray[0]);
                try {
                    notifierKeyRefArray[0].removeWatch();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Cannot remove filesystem watch for {0}", fileObject.getPath());
                    LOG.log(Level.INFO, "Exception", iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void clearQueue() throws IOException {
            NotifierKeyRef notifierKeyRef;
            while ((notifierKeyRef = (NotifierKeyRef)this.REF.poll()) != null) {
                Object object = this.LOCK;
                synchronized (object) {
                    this.getReferences().remove(notifierKeyRef);
                    notifierKeyRef.removeWatch();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    Object object;
                    Object object3;
                    Serializable serializable;
                    this.clearQueue();
                    String string = NotifierAccessor.getDefault().nextEvent(this.impl);
                    LOG.log(Level.FINEST, "nextEvent: {0}", string);
                    if (string == null) {
                        serializable = new HashSet();
                        object3 = this.LOCK;
                        synchronized (object3) {
                            for (NotifierKeyRef notifierKeyRef : this.getReferences()) {
                                object = notifierKeyRef.get();
                                if (object == null) continue;
                                serializable.add(object);
                            }
                        }
                        Watcher.this.enqueueAll((Set)((Object)serializable));
                        continue;
                    }
                    serializable = new File(string);
                    object3 = FileObjectFactory.getInstance(serializable);
                    Object object4 = ((FileObjectFactory)object3).getCachedOnly((File)serializable);
                    if (object4 == null) {
                        object4 = ((FileObjectFactory)object3).getCachedOnly(((File)serializable).getParentFile());
                    }
                    if (object4 == null) continue;
                    Object object2 = this.LOCK;
                    synchronized (object2) {
                        object = new NotifierKeyRef<Object>((FileObject)object4, null, null, (Notifier<Object>)this.impl);
                        if (this.getReferences().contains(object)) {
                            Watcher.this.enqueue(object4);
                        }
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (InterruptedException interruptedException) {
                    if (this.shutdown) continue;
                    LOG.log(Level.INFO, "Interrupted", interruptedException);
                }
                catch (Throwable throwable) {
                    LOG.log(Level.INFO, "Error dispatching FS changes", throwable);
                }
            }
        }

        final void shutdown() throws IOException, InterruptedException {
            this.shutdown = true;
            this.watcher.interrupt();
            NotifierAccessor.getDefault().stop(this.impl);
            this.watcher.join(1000L);
        }

        private Set<NotifierKeyRef> getReferences() {
            assert (Thread.holdsLock(this.LOCK));
            return this.references;
        }
    }
}

