/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public final class WinXPViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 8;
    private static final int TXT_Y_PAD = 3;
    private static final int ICON_X_PAD = 2;
    private static final int BUMP_X_PAD = 3;
    private static final int BUMP_Y_PAD_UPPER = 5;
    private static final int BUMP_Y_PAD_BOTTOM = 3;
    private static final int HIGHLIGHTED_RAISE = 1;
    private static boolean colorsReady = false;
    private static Color unselFillBrightC;
    private static Color unselFillDarkC;
    private static Color selFillC;
    private static Color focusFillBrightC;
    private static Color focusFillDarkC;
    private static Color txtC;
    private static Color borderC;
    private static Color bottomBorderC;
    private static Color selBorderC;
    private static Color bgFillC;
    private static Map<Integer, String[]> buttonIconPaths;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private WinXPViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(100, 17);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinXPViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        WinXPViewTabDisplayerUI.initColors();
        WinXPViewTabDisplayerUI.initIcons();
        jComponent.setOpaque(true);
    }

    @Override
    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 17 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 3;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    @Override
    protected void paintDisplayerBackground(Graphics graphics, JComponent jComponent) {
        int n = this.getDataModel().size();
        int n2 = this.getLayoutModel().getX(n - 1);
        boolean bl = false;
        int n3 = jComponent.getWidth() - (n2 += this.getLayoutModel().getW(n - 1) - 5);
        int n4 = jComponent.getHeight();
        ColorUtil.paintXpTabHeader(0, graphics, n2, 0, n3);
        Color color = borderC;
        graphics.setColor(color);
        graphics.drawLine(n2 + n3 - 1, 3, n2 + n3 - 1, n4 - 2);
        graphics.setColor(bottomBorderC);
        graphics.drawLine(n2, n4 - 1, n2 + n3 - 1, n4 - 1);
    }

    @Override
    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        int n6;
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        if (!this.isTabInFront(n) && this.isMoreThanOne()) {
            ++n3;
            --n5;
        }
        int n7 = n4;
        if (this.isSelected(n)) {
            Component component = this.getControlButtons();
            if (null != component) {
                Dimension dimension = component.getPreferredSize();
                if (n4 < dimension.width + 2) {
                    component.setVisible(false);
                } else {
                    component.setVisible(true);
                    n7 = n4 - (dimension.width + 2 + 8);
                    component.setLocation(n2 + n7 + 8, n3 + (n5 - dimension.height) / 2);
                }
            }
        } else {
            n7 = n4 - 16;
        }
        int n8 = n6 = !this.isTabInFront(n) && this.isMoreThanOne() ? 1 : 0;
        if (this.isUseStretchingTabs()) {
            ColorUtil.paintXpTabDragTexture(this.getDisplayer(), graphics, n2 + 3, n3 + 5, n5 - 8 + n6);
        }
        boolean bl = false;
        WinsysInfoForTabbedContainer winsysInfoForTabbedContainer = this.displayer.getContainerWinsysInfo();
        if (null != winsysInfoForTabbedContainer && winsysInfoForTabbedContainer.isSlidedOutContainer()) {
            bl = false;
        }
        if (this.isTabBusy(n) && !bl) {
            Icon icon = BusyTabsSupport.getDefault().getBusyIcon(this.isSelected(n));
            n7 -= icon.getIconWidth() - 3 - 8;
            icon.paintIcon(this.displayer, graphics, n2 + 8, n3 + (n5 - icon.getIconHeight()) / 2);
            n2 += icon.getIconWidth() + 3;
        }
        HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)(n2 + 8), (int)(n3 + fontMetrics.getAscent() + 3), (int)n7, (int)n5, (Font)this.getTxtFont(), (Color)txtC, (int)1, (boolean)true);
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = n == 0;
        boolean bl2 = this.isTabHighlighted(n);
        graphics.translate(n2, n3);
        ColorUtil.paintXpTabHeader(bl2 ? 1 : 0, graphics, 0, 0, n4);
        Color color = bl2 ? selBorderC : borderC;
        graphics.setColor(color);
        if (bl) {
            graphics.drawLine(0, 3, 0, n5 - 2);
        }
        graphics.drawLine(n4 - 1, 3, n4 - 1, n5 - 2);
        graphics.setColor(bottomBorderC);
        graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        n3 += 3;
        --n4;
        n5 -= 4;
        boolean bl = this.isSelected(n);
        boolean bl2 = bl && this.isActive();
        boolean bl3 = this.isAttention(n);
        if (bl2 && !bl3) {
            ColorUtil.xpFillRectGradient((Graphics2D)graphics, n2, n3, n4, n5, focusFillBrightC, focusFillDarkC);
        } else if (bl && this.isMoreThanOne() && !bl3) {
            graphics.setColor(selFillC);
            graphics.fillRect(n2, n3, n4, n5);
        } else if (bl3) {
            Color color = new Color(255, 255, 128);
            Color color2 = new Color(230, 200, 64);
            ColorUtil.xpFillRectGradient((Graphics2D)graphics, n2, n3, n4, n5, color, color2);
        } else {
            ColorUtil.xpFillRectGradient((Graphics2D)graphics, n2, n3, n4, n5, unselFillBrightC, unselFillDarkC);
        }
    }

    @Override
    protected Font getTxtFont() {
        Font font = UIManager.getFont("Label.font");
        if (null == font) {
            font = super.getTxtFont();
        }
        if (!font.isBold()) {
            font = font.deriveFont(1);
        }
        return font;
    }

    private boolean isTabHighlighted(int n) {
        if (n < 0) {
            return false;
        }
        if (((OwnController)this.getController()).getMouseIndex() == n) {
            return true;
        }
        return this.isTabInFront(n) && this.isMoreThanOne();
    }

    private boolean isTabInFront(int n) {
        if (n < 0) {
            return false;
        }
        return this.isSelected(n) && (this.isActive() || this.isMoreThanOne());
    }

    private boolean isMoreThanOne() {
        return this.getDataModel().size() > 1;
    }

    private static void initColors() {
        if (!colorsReady) {
            txtC = UIManager.getColor("TabbedPane.foreground");
            selFillC = UIManager.getColor("TabbedPane.highlight");
            focusFillBrightC = UIManager.getColor("tab_focus_fill_bright");
            focusFillDarkC = UIManager.getColor("tab_focus_fill_dark");
            unselFillBrightC = UIManager.getColor("tab_unsel_fill_bright");
            unselFillDarkC = UIManager.getColor("tab_unsel_fill_dark");
            borderC = UIManager.getColor("tab_border");
            bottomBorderC = UIManager.getColor("tab_bottom_border");
            selBorderC = UIManager.getColor("tab_sel_border");
            bgFillC = UIManager.getColor("workplace_fill");
            colorsReady = true;
        }
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] stringArray;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            stringArray = new String[]{"org/openide/awt/resources/xp_bigclose_enabled.png", "org/openide/awt/resources/xp_bigclose_pressed.png", stringArray[0], "org/openide/awt/resources/xp_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_slideright_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/xp_slideright_rollover.png"};
            buttonIconPaths.put(6, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_slideleft_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/xp_slideleft_rollover.png"};
            buttonIconPaths.put(5, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_slidebottom_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/xp_slidebottom_rollover.png"};
            buttonIconPaths.put(7, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/xp_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_restore_group_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_restore_group_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/xp_restore_group_rollover.png"};
            buttonIconPaths.put(11, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_minimize_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_minimize_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/xp_minimize_rollover.png"};
            buttonIconPaths.put(12, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        WinXPViewTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }

    @Override
    public void postTabAction(TabActionEvent tabActionEvent) {
        super.postTabAction(tabActionEvent);
        if ("maximize".equals(tabActionEvent.getActionCommand())) {
            ((OwnController)this.getController()).updateHighlight(-1);
        }
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex = -1;

        private OwnController() {
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            Point point = mouseEvent.getPoint();
            if (!mouseEvent.getSource().equals(WinXPViewTabDisplayerUI.this.displayer)) {
                point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, WinXPViewTabDisplayerUI.this.displayer);
            }
            this.updateHighlight(WinXPViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (!this.inControlButtonsRect(mouseEvent.getPoint())) {
                this.updateHighlight(-1);
            }
        }

        private void updateHighlight(int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (n == this.lastIndex) {
                return;
            }
            TabLayoutModel tabLayoutModel = WinXPViewTabDisplayerUI.this.getLayoutModel();
            Rectangle rectangle = null;
            if (n != -1) {
                n5 = tabLayoutModel.getX(n);
                n4 = tabLayoutModel.getY(n);
                n3 = tabLayoutModel.getW(n);
                n2 = tabLayoutModel.getH(n);
                rectangle = new Rectangle(n5, n4, n3, n2);
            }
            if (this.lastIndex != -1 && this.lastIndex < WinXPViewTabDisplayerUI.this.getDataModel().size()) {
                n5 = tabLayoutModel.getX(this.lastIndex);
                n4 = tabLayoutModel.getY(this.lastIndex);
                n3 = tabLayoutModel.getW(this.lastIndex);
                n2 = tabLayoutModel.getH(this.lastIndex);
                rectangle = rectangle != null ? rectangle.union(new Rectangle(n5, n4, n3, n2)) : new Rectangle(n5, n4, n3, n2);
            }
            if (rectangle != null) {
                WinXPViewTabDisplayerUI.this.getDisplayer().repaint(rectangle);
            }
            this.lastIndex = n;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            this.mouseMoved(mouseEvent);
        }
    }
}

