/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.logging.NbLogging;
import org.openide.util.RequestProcessor;

public final class PrintStreamLogger
extends PrintStream
implements Runnable {
    private Logger log;
    private final StringBuilder sb = new StringBuilder();
    private static RequestProcessor RP = new RequestProcessor("StdErr Flush");
    private RequestProcessor.Task flush = RP.create((Runnable)this, true);

    private PrintStreamLogger(Logger logger) {
        super(new ByteArrayOutputStream());
        this.log = logger;
    }

    public static boolean isLogger(PrintStream printStream) {
        return printStream.getClass().getName().equals(PrintStreamLogger.class.getName());
    }

    public static PrintStream create(String string) {
        return new PrintStreamLogger(Logger.getLogger(string));
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (RP.isRequestProcessorThread()) {
            return;
        }
        String string = new String(byArray, n, n2);
        this.print(string);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) {
        if (RP.isRequestProcessorThread()) {
            return;
        }
        StringBuilder stringBuilder = this.sb;
        synchronized (stringBuilder) {
            this.sb.append((char)n);
        }
        this.checkFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String string) {
        if (NbLogging.DEBUG != null && !NbLogging.wantsMessage(string)) {
            new Exception().printStackTrace(NbLogging.DEBUG);
        }
        StringBuilder stringBuilder = this.sb;
        synchronized (stringBuilder) {
            this.sb.append(string);
        }
        this.checkFlush();
    }

    @Override
    public void println(String string) {
        this.print(string);
        this.print(System.getProperty("line.separator"));
    }

    @Override
    public void println(Object object) {
        String string = String.valueOf(object);
        this.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        boolean bl;
        StringBuilder stringBuilder = this.sb;
        synchronized (stringBuilder) {
            bl = this.sb.length() == 0;
        }
        if (!bl) {
            try {
                this.flush.schedule(0);
                this.flush.waitFinished(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.flush();
    }

    private void checkFlush() {
        try {
            this.flush.schedule(100);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block3: while (true) {
            String string;
            int n;
            StringBuilder stringBuilder = this.sb;
            synchronized (stringBuilder) {
                if (this.sb.length() == 0) {
                    break;
                }
                n = -1;
                for (int i = this.sb.length() - 1; i >= 0; --i) {
                    if (this.sb.charAt(i) != '\n') continue;
                    n = i;
                    break;
                }
                if (n == -1) {
                    break;
                }
                string = this.sb.substring(0, n + 1);
                this.sb.delete(0, n + 1);
            }
            int n2 = 0;
            while (true) {
                if (n2 >= string.length()) continue block3;
                n = string.indexOf(10, n2);
                this.log.log(Level.INFO, string.substring(n2, n + 1));
                n2 = n + 1;
            }
            break;
        }
    }
}

