/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.DisplayChangedListener;
import sun.awt.LightweightFrame;
import sun.security.action.GetPropertyAction;
import sun.swing.LightweightContent;
import sun.swing.SwingAccessor;
import sun.swing.SwingUtilities2;

public final class JLightweightFrame
extends LightweightFrame
implements RootPaneContainer {
    private final JRootPane rootPane = new JRootPane();
    private LightweightContent content;
    private Component component;
    private JPanel contentPane;
    private BufferedImage bbImage;
    private volatile int scaleFactor = 1;
    private static boolean copyBufferEnabled;
    private int[] copyBuffer;
    private PropertyChangeListener layoutSizeListener;
    private SwingUtilities2.RepaintListener repaintListener;

    public JLightweightFrame() {
        copyBufferEnabled = "true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.jlf.copyBufferEnabled", "true")));
        this.add((Component)this.rootPane, "Center");
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        if (this.getGraphicsConfiguration().isTranslucencyCapable()) {
            this.setBackground(new Color(0, 0, 0, 0));
        }
        this.layoutSizeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Dimension dimension = (Dimension)propertyChangeEvent.getNewValue();
                if ("preferredSize".equals(propertyChangeEvent.getPropertyName())) {
                    JLightweightFrame.this.content.preferredSizeChanged(dimension.width, dimension.height);
                } else if ("maximumSize".equals(propertyChangeEvent.getPropertyName())) {
                    JLightweightFrame.this.content.maximumSizeChanged(dimension.width, dimension.height);
                } else if ("minimumSize".equals(propertyChangeEvent.getPropertyName())) {
                    JLightweightFrame.this.content.minimumSizeChanged(dimension.width, dimension.height);
                }
            }
        };
        this.repaintListener = (jComponent, n, n2, n3, n4) -> {
            Window window = SwingUtilities.getWindowAncestor(jComponent);
            if (window != this) {
                return;
            }
            Point point = SwingUtilities.convertPoint(jComponent, n, n2, window);
            Rectangle rectangle = new Rectangle(point.x, point.y, n3, n4).intersection(new Rectangle(0, 0, this.bbImage.getWidth() / this.scaleFactor, this.bbImage.getHeight() / this.scaleFactor));
            if (!rectangle.isEmpty()) {
                this.notifyImageUpdated(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        };
        SwingAccessor.getRepaintManagerAccessor().addRepaintListener(RepaintManager.currentManager(this), this.repaintListener);
    }

    @Override
    public void dispose() {
        SwingAccessor.getRepaintManagerAccessor().removeRepaintListener(RepaintManager.currentManager(this), this.repaintListener);
        super.dispose();
    }

    public void setContent(LightweightContent lightweightContent) {
        if (lightweightContent == null) {
            System.err.println("JLightweightFrame.setContent: content may not be null!");
            return;
        }
        this.content = lightweightContent;
        this.component = lightweightContent.getComponent();
        Dimension dimension = this.component.getPreferredSize();
        lightweightContent.preferredSizeChanged(dimension.width, dimension.height);
        dimension = this.component.getMaximumSize();
        lightweightContent.maximumSizeChanged(dimension.width, dimension.height);
        dimension = this.component.getMinimumSize();
        lightweightContent.minimumSizeChanged(dimension.width, dimension.height);
        this.initInterior();
    }

    @Override
    public Graphics getGraphics() {
        if (this.bbImage == null) {
            return null;
        }
        Graphics2D graphics2D = this.bbImage.createGraphics();
        graphics2D.setBackground(this.getBackground());
        graphics2D.setColor(this.getForeground());
        graphics2D.setFont(this.getFont());
        graphics2D.scale(this.scaleFactor, this.scaleFactor);
        return graphics2D;
    }

    @Override
    public void grabFocus() {
        if (this.content != null) {
            this.content.focusGrabbed();
        }
    }

    @Override
    public void ungrabFocus() {
        if (this.content != null) {
            this.content.focusUngrabbed();
        }
    }

    @Override
    public int getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void notifyDisplayChanged(int n) {
        if (n != this.scaleFactor) {
            if (!copyBufferEnabled) {
                this.content.paintLock();
            }
            try {
                if (this.bbImage != null) {
                    this.resizeBuffer(this.getWidth(), this.getHeight(), n);
                }
            }
            finally {
                if (!copyBufferEnabled) {
                    this.content.paintUnlock();
                }
            }
            this.scaleFactor = n;
        }
        if (this.getPeer() instanceof DisplayChangedListener) {
            ((DisplayChangedListener)((Object)this.getPeer())).displayChanged();
        }
        this.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getPeer() instanceof DisplayChangedListener) {
            ((DisplayChangedListener)((Object)this.getPeer())).displayChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncCopyBuffer(boolean bl, int n, int n2, int n3, int n4, int n5) {
        this.content.paintLock();
        try {
            int[] nArray = ((DataBufferInt)this.bbImage.getRaster().getDataBuffer()).getData();
            if (bl) {
                this.copyBuffer = new int[nArray.length];
            }
            int n6 = this.bbImage.getWidth();
            n *= n5;
            n2 *= n5;
            n3 *= n5;
            n4 *= n5;
            for (int i = 0; i < n4; ++i) {
                int n7 = (n2 + i) * n6 + n;
                System.arraycopy(nArray, n7, this.copyBuffer, n7, n3);
            }
        }
        finally {
            this.content.paintUnlock();
        }
    }

    private void notifyImageUpdated(int n, int n2, int n3, int n4) {
        if (copyBufferEnabled) {
            this.syncCopyBuffer(false, n, n2, n3, n4, this.scaleFactor);
        }
        this.content.imageUpdated(n, n2, n3, n4);
    }

    private void initInterior() {
        this.contentPane = new JPanel(){

            @Override
            public void paint(Graphics graphics) {
                if (!copyBufferEnabled) {
                    JLightweightFrame.this.content.paintLock();
                }
                try {
                    super.paint(graphics);
                    final Rectangle rectangle = graphics.getClipBounds() != null ? graphics.getClipBounds() : new Rectangle(0, 0, JLightweightFrame.this.contentPane.getWidth(), JLightweightFrame.this.contentPane.getHeight());
                    rectangle.x = Math.max(0, rectangle.x);
                    rectangle.y = Math.max(0, rectangle.y);
                    rectangle.width = Math.min(JLightweightFrame.this.contentPane.getWidth(), rectangle.width);
                    rectangle.height = Math.min(JLightweightFrame.this.contentPane.getHeight(), rectangle.height);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Rectangle rectangle2 = JLightweightFrame.this.contentPane.getBounds().intersection(rectangle);
                            JLightweightFrame.this.notifyImageUpdated(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        }
                    });
                }
                finally {
                    if (!copyBufferEnabled) {
                        JLightweightFrame.this.content.paintUnlock();
                    }
                }
            }

            @Override
            protected boolean isPaintingOrigin() {
                return true;
            }
        };
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add(this.component);
        if ("true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.jlf.contentPaneTransparent", "false")))) {
            this.contentPane.setOpaque(false);
        }
        this.setContentPane(this.contentPane);
        this.contentPane.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                Component component = JLightweightFrame.this.component;
                if (containerEvent.getChild() == component) {
                    component.addPropertyChangeListener("preferredSize", JLightweightFrame.this.layoutSizeListener);
                    component.addPropertyChangeListener("maximumSize", JLightweightFrame.this.layoutSizeListener);
                    component.addPropertyChangeListener("minimumSize", JLightweightFrame.this.layoutSizeListener);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = JLightweightFrame.this.component;
                if (containerEvent.getChild() == component) {
                    component.removePropertyChangeListener(JLightweightFrame.this.layoutSizeListener);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (n3 == 0 || n4 == 0) {
            return;
        }
        if (!copyBufferEnabled) {
            this.content.paintLock();
        }
        try {
            boolean bl = this.bbImage == null;
            int n5 = n3;
            int n6 = n4;
            if (this.bbImage != null) {
                int n7 = this.bbImage.getWidth() / this.scaleFactor;
                int n8 = this.bbImage.getHeight() / this.scaleFactor;
                if (n3 != n7 || n4 != n8) {
                    bl = true;
                    if (this.bbImage != null) {
                        int n9 = n7;
                        int n10 = n8;
                        if (n9 >= n5 && n10 >= n6) {
                            bl = false;
                        } else {
                            n5 = n9 >= n5 ? n9 : Math.max((int)((double)n9 * 1.2), n3);
                            n6 = n10 >= n6 ? n10 : Math.max((int)((double)n10 * 1.2), n4);
                        }
                    }
                }
            }
            if (bl) {
                this.resizeBuffer(n5, n6, this.scaleFactor);
                return;
            }
            this.content.imageReshaped(0, 0, n3, n4);
        }
        finally {
            if (!copyBufferEnabled) {
                this.content.paintUnlock();
            }
        }
    }

    private void resizeBuffer(int n, int n2, int n3) {
        this.bbImage = new BufferedImage(n * n3, n2 * n3, 3);
        int[] nArray = ((DataBufferInt)this.bbImage.getRaster().getDataBuffer()).getData();
        if (copyBufferEnabled) {
            this.syncCopyBuffer(true, 0, 0, n, n2, n3);
            nArray = this.copyBuffer;
        }
        this.content.imageBufferReset(nArray, 0, 0, n, n2, n * n3, n3);
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    @Override
    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    @Override
    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    @Override
    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    @Override
    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    @Override
    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    @Override
    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    private void updateClientCursor() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        Component component = SwingUtilities.getDeepestComponentAt(this, point.x, point.y);
        if (component != null) {
            this.content.setCursor(component.getCursor());
        }
    }

    static {
        SwingAccessor.setJLightweightFrameAccessor(new SwingAccessor.JLightweightFrameAccessor(){

            @Override
            public void updateCursor(JLightweightFrame jLightweightFrame) {
                jLightweightFrame.updateClientCursor();
            }
        });
        copyBufferEnabled = "true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.jlf.copyBufferEnabled", "true")));
    }
}

