/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import sun.management.AgentConfigurationError;
import sun.management.ConnectorAddressLink;
import sun.management.jdp.JdpController;
import sun.management.jdp.JdpException;
import sun.management.jmxremote.ConnectorBootstrap;
import sun.misc.VMSupport;

public class Agent {
    private static Properties mgmtProps;
    private static ResourceBundle messageRB;
    private static final String CONFIG_FILE = "com.sun.management.config.file";
    private static final String SNMP_PORT = "com.sun.management.snmp.port";
    private static final String JMXREMOTE = "com.sun.management.jmxremote";
    private static final String JMXREMOTE_PORT = "com.sun.management.jmxremote.port";
    private static final String RMI_PORT = "com.sun.management.jmxremote.rmi.port";
    private static final String ENABLE_THREAD_CONTENTION_MONITORING = "com.sun.management.enableThreadContentionMonitoring";
    private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String SNMP_ADAPTOR_BOOTSTRAP_CLASS_NAME = "sun.management.snmp.AdaptorBootstrap";
    private static final String JDP_DEFAULT_ADDRESS = "224.0.23.178";
    private static final int JDP_DEFAULT_PORT = 7095;
    private static JMXConnectorServer jmxServer;

    private static Properties parseString(String string) {
        Properties properties = new Properties();
        if (string != null) {
            for (String string2 : string.split(",")) {
                String string3;
                String[] stringArray = string2.split("=", 2);
                String string4 = stringArray[0].trim();
                String string5 = string3 = stringArray.length > 1 ? stringArray[1].trim() : "";
                if (!string4.startsWith("com.sun.management.")) {
                    Agent.error("agent.err.invalid.option", string4);
                }
                properties.setProperty(string4, string3);
            }
        }
        return properties;
    }

    public static void premain(String string) throws Exception {
        Agent.agentmain(string);
    }

    public static void agentmain(String string) throws Exception {
        if (string == null || string.length() == 0) {
            string = JMXREMOTE;
        }
        Properties properties = Agent.parseString(string);
        Properties properties2 = new Properties();
        String string2 = properties.getProperty(CONFIG_FILE);
        Agent.readConfiguration(string2, properties2);
        properties2.putAll(properties);
        Agent.startAgent(properties2);
    }

    private static synchronized void startLocalManagementAgent() {
        Properties properties = VMSupport.getAgentProperties();
        if (properties.get(LOCAL_CONNECTOR_ADDRESS_PROP) == null) {
            JMXConnectorServer jMXConnectorServer = ConnectorBootstrap.startLocalConnectorServer();
            String string = jMXConnectorServer.getAddress().toString();
            properties.put(LOCAL_CONNECTOR_ADDRESS_PROP, string);
            try {
                ConnectorAddressLink.export(string);
            }
            catch (Exception exception) {
                Agent.warning("agent.err.exportaddress.failed", exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startRemoteManagementAgent(String string) throws Exception {
        String string2;
        if (jmxServer != null) {
            throw new RuntimeException(Agent.getText("agent.err.invalid.state", "Agent already started"));
        }
        Properties properties = Agent.parseString(string);
        Properties properties2 = new Properties();
        String string3 = System.getProperty(CONFIG_FILE);
        Agent.readConfiguration(string3, properties2);
        Properties properties3 = System.getProperties();
        Object object = properties3;
        synchronized (object) {
            properties2.putAll(properties3);
        }
        object = properties.getProperty(CONFIG_FILE);
        if (object != null) {
            Agent.readConfiguration((String)object, properties2);
        }
        properties2.putAll(properties);
        String string4 = properties2.getProperty(ENABLE_THREAD_CONTENTION_MONITORING);
        if (string4 != null) {
            ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(true);
        }
        if ((string2 = properties2.getProperty(JMXREMOTE_PORT)) != null) {
            jmxServer = ConnectorBootstrap.startRemoteConnectorServer(string2, properties2);
            Agent.startDiscoveryService(properties2);
        }
    }

    private static synchronized void stopRemoteManagementAgent() throws Exception {
        JdpController.stopDiscoveryService();
        if (jmxServer != null) {
            ConnectorBootstrap.unexportRegistry();
            jmxServer.stop();
            jmxServer = null;
        }
    }

    private static void startAgent(Properties properties) throws Exception {
        String string = properties.getProperty(SNMP_PORT);
        String string2 = properties.getProperty(JMXREMOTE);
        String string3 = properties.getProperty(JMXREMOTE_PORT);
        String string4 = properties.getProperty(ENABLE_THREAD_CONTENTION_MONITORING);
        if (string4 != null) {
            ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(true);
        }
        try {
            if (string != null) {
                Agent.loadSnmpAgent(string, properties);
            }
            if (string2 != null || string3 != null) {
                if (string3 != null) {
                    jmxServer = ConnectorBootstrap.startRemoteConnectorServer(string3, properties);
                    Agent.startDiscoveryService(properties);
                }
                Agent.startLocalManagementAgent();
            }
        }
        catch (AgentConfigurationError agentConfigurationError) {
            Agent.error(agentConfigurationError.getError(), agentConfigurationError.getParams());
        }
        catch (Exception exception) {
            Agent.error(exception);
        }
    }

    private static void startDiscoveryService(Properties properties) throws IOException {
        String string = properties.getProperty("com.sun.management.jdp.port");
        String string2 = properties.getProperty("com.sun.management.jdp.address");
        String string3 = properties.getProperty("com.sun.management.jmxremote.autodiscovery");
        boolean bl = false;
        if (string3 == null) {
            bl = string != null;
        } else {
            try {
                bl = Boolean.parseBoolean(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AgentConfigurationError("Couldn't parse autodiscovery argument");
            }
        }
        if (bl) {
            InetAddress inetAddress;
            try {
                inetAddress = string2 == null ? InetAddress.getByName(JDP_DEFAULT_ADDRESS) : InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw new AgentConfigurationError("Unable to broadcast to requested address", unknownHostException);
            }
            int n = 7095;
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AgentConfigurationError("Couldn't parse JDP port argument");
                }
            }
            String string4 = properties.getProperty(JMXREMOTE_PORT);
            String string5 = properties.getProperty(RMI_PORT);
            JMXServiceURL jMXServiceURL = jmxServer.getAddress();
            String string6 = jMXServiceURL.getHost();
            String string7 = string5 != null ? String.format("service:jmx:rmi://%s:%s/jndi/rmi://%s:%s/jmxrmi", string6, string5, string6, string4) : String.format("service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi", string6, string4);
            String string8 = properties.getProperty("com.sun.management.jdp.name");
            try {
                JdpController.startDiscoveryService(inetAddress, n, string8, string7);
            }
            catch (JdpException jdpException) {
                throw new AgentConfigurationError("Couldn't start JDP service", jdpException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadManagementProperties() {
        Properties properties;
        Properties properties2 = new Properties();
        String string = System.getProperty(CONFIG_FILE);
        Agent.readConfiguration(string, properties2);
        Properties properties3 = properties = System.getProperties();
        synchronized (properties3) {
            properties2.putAll(properties);
        }
        return properties2;
    }

    public static synchronized Properties getManagementProperties() {
        if (mgmtProps == null) {
            String string = System.getProperty(CONFIG_FILE);
            String string2 = System.getProperty(SNMP_PORT);
            String string3 = System.getProperty(JMXREMOTE);
            String string4 = System.getProperty(JMXREMOTE_PORT);
            if (string == null && string2 == null && string3 == null && string4 == null) {
                return null;
            }
            mgmtProps = Agent.loadManagementProperties();
        }
        return mgmtProps;
    }

    private static void loadSnmpAgent(String string, Properties properties) {
        try {
            Class<?> clazz = Class.forName(SNMP_ADAPTOR_BOOTSTRAP_CLASS_NAME, true, null);
            Method method = clazz.getMethod("initialize", String.class, Properties.class);
            method.invoke(null, string, properties);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new UnsupportedOperationException("Unsupported management property: com.sun.management.snmp.port", reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UnsupportedOperationException("Unsupported management property: com.sun.management.snmp.port", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readConfiguration(String string, Properties properties) {
        Object object;
        Object object2;
        if (string == null) {
            object2 = System.getProperty("java.home");
            if (object2 == null) {
                throw new Error("Can't find java.home ??");
            }
            object = new StringBuffer((String)object2);
            ((StringBuffer)object).append(File.separator).append("lib");
            ((StringBuffer)object).append(File.separator).append("management");
            ((StringBuffer)object).append(File.separator).append("management.properties");
            string = ((StringBuffer)object).toString();
        }
        if (!((File)(object2 = new File(string))).exists()) {
            Agent.error("agent.err.configfile.notfound", string);
        }
        object = null;
        try {
            object = new FileInputStream((File)object2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            properties.load(bufferedInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Agent.error("agent.err.configfile.failed", fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            Agent.error("agent.err.configfile.failed", iOException.getMessage());
        }
        catch (SecurityException securityException) {
            Agent.error("agent.err.configfile.access.denied", string);
        }
        finally {
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    Agent.error("agent.err.configfile.closed.failed", string);
                }
            }
        }
    }

    public static void startAgent() throws Exception {
        String string;
        String string2 = System.getProperty("com.sun.management.agent.class");
        if (string2 == null) {
            Properties properties = Agent.getManagementProperties();
            if (properties != null) {
                Agent.startAgent(properties);
            }
            return;
        }
        String[] stringArray = string2.split(":");
        if (stringArray.length < 1 || stringArray.length > 2) {
            Agent.error("agent.err.invalid.agentclass", "\"" + string2 + "\"");
        }
        String string3 = stringArray[0];
        String string4 = string = stringArray.length == 2 ? stringArray[1] : null;
        if (string3 == null || string3.length() == 0) {
            Agent.error("agent.err.invalid.agentclass", "\"" + string2 + "\"");
        }
        if (string3 != null) {
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string3);
                Method method = clazz.getMethod("premain", String.class);
                method.invoke(null, string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Agent.error("agent.err.agentclass.notfound", "\"" + string3 + "\"");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Agent.error("agent.err.premain.notfound", "\"" + string3 + "\"");
            }
            catch (SecurityException securityException) {
                Agent.error("agent.err.agentclass.access.denied");
            }
            catch (Exception exception) {
                String string5 = exception.getCause() == null ? exception.getMessage() : exception.getCause().getMessage();
                Agent.error("agent.err.agentclass.failed", string5);
            }
        }
    }

    public static void error(String string) {
        String string2 = Agent.getText(string);
        System.err.print(Agent.getText("agent.err.error") + ": " + string2);
        throw new RuntimeException(string2);
    }

    public static void error(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            Agent.error(string);
        } else {
            StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(" " + stringArray[i]);
            }
            Agent.error(string, stringBuffer.toString());
        }
    }

    public static void error(String string, String string2) {
        String string3 = Agent.getText(string);
        System.err.print(Agent.getText("agent.err.error") + ": " + string3);
        System.err.println(": " + string2);
        throw new RuntimeException(string3);
    }

    public static void error(Exception exception) {
        exception.printStackTrace();
        System.err.println(Agent.getText("agent.err.exception") + ": " + exception.toString());
        throw new RuntimeException(exception);
    }

    public static void warning(String string, String string2) {
        System.err.print(Agent.getText("agent.err.warning") + ": " + Agent.getText(string));
        System.err.println(": " + string2);
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle("sun.management.resources.agent");
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for management agent is missing");
        }
    }

    public static String getText(String string) {
        if (messageRB == null) {
            Agent.initResource();
        }
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing management agent resource bundle: key = \"" + string + "\"";
        }
    }

    public static String getText(String string, String ... stringArray) {
        String string2;
        if (messageRB == null) {
            Agent.initResource();
        }
        if ((string2 = messageRB.getString(string)) == null) {
            string2 = "missing resource key: key = \"" + string + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        return MessageFormat.format(string2, stringArray);
    }

    static {
        jmxServer = null;
    }
}

