/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import sun.awt.image.ImageCache;
import sun.awt.image.MultiResolutionImage;
import sun.awt.image.ToolkitImage;

public class MultiResolutionBufferedImage
extends BufferedImage
implements MultiResolutionImage {
    private final BiFunction<Integer, Integer, Image> mapper;
    private final Dimension2D[] sizes;
    private int availableInfo;

    public MultiResolutionBufferedImage(Image image, BiFunction<Integer, Integer, Image> biFunction) {
        this(image, new Dimension[]{new Dimension(image.getWidth(null), image.getHeight(null))}, biFunction);
    }

    public MultiResolutionBufferedImage(Image image, Dimension2D[] dimension2DArray, BiFunction<Integer, Integer, Image> biFunction) {
        super(image.getWidth(null), image.getHeight(null), 3);
        this.sizes = dimension2DArray;
        this.mapper = biFunction;
        this.availableInfo = MultiResolutionBufferedImage.getInfo(image);
        Graphics graphics = this.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
    }

    @Override
    public Image getResolutionVariant(int n, int n2) {
        ImageCacheKey imageCacheKey;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (n3 == n && n4 == n2) {
            return this;
        }
        ImageCache imageCache = ImageCache.getInstance();
        Image image = imageCache.getImage(imageCacheKey = new ImageCacheKey(this, n, n2));
        if (image == null) {
            image = this.mapper.apply(n, n2);
            imageCache.setImage(imageCacheKey, image);
            MultiResolutionBufferedImage.preload(image, this.availableInfo);
        }
        return image;
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Arrays.stream(this.sizes).map((? super T dimension2D) -> this.getResolutionVariant((int)dimension2D.getWidth(), (int)dimension2D.getHeight())).collect(Collectors.toList());
    }

    public MultiResolutionBufferedImage map(Function<Image, Image> function) {
        return new MultiResolutionBufferedImage(function.apply(this), this.sizes, (n, n2) -> (Image)function.apply(this.getResolutionVariant((int)n, (int)n2)));
    }

    @Override
    public int getWidth(ImageObserver imageObserver) {
        this.availableInfo |= 1;
        return super.getWidth(imageObserver);
    }

    @Override
    public int getHeight(ImageObserver imageObserver) {
        this.availableInfo |= 2;
        return super.getHeight(imageObserver);
    }

    @Override
    public Object getProperty(String string, ImageObserver imageObserver) {
        this.availableInfo |= 4;
        return super.getProperty(string, imageObserver);
    }

    private static int getInfo(Image image2) {
        if (image2 instanceof ToolkitImage) {
            return ((ToolkitImage)image2).getImageRep().check((image, n, n2, n3, n4, n5) -> false);
        }
        return 0;
    }

    private static void preload(Image image, final int n) {
        if (n != 0 && image instanceof ToolkitImage) {
            ((ToolkitImage)image).preload(new ImageObserver(){
                int flags;
                {
                    this.flags = n;
                }

                @Override
                public boolean imageUpdate(Image image, int n6, int n2, int n3, int n4, int n5) {
                    this.flags &= ~n6;
                    return this.flags != 0 && (n6 & 0xC0) == 0;
                }
            });
        }
    }

    private static class ImageCacheKey
    implements ImageCache.PixelsKey {
        private final int pixelCount;
        private final int hash;
        private final int w;
        private final int h;
        private final Image baseImage;

        ImageCacheKey(Image image, int n, int n2) {
            this.baseImage = image;
            this.w = n;
            this.h = n2;
            this.pixelCount = n * n2;
            this.hash = this.hash();
        }

        @Override
        public int getPixelCount() {
            return this.pixelCount;
        }

        private int hash() {
            int n = this.baseImage.hashCode();
            n = 31 * n + this.w;
            n = 31 * n + this.h;
            return n;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof ImageCacheKey) {
                ImageCacheKey imageCacheKey = (ImageCacheKey)object;
                return this.baseImage == imageCacheKey.baseImage && this.w == imageCacheKey.w && this.h == imageCacheKey.h;
            }
            return false;
        }
    }
}

