/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.AbstractSpinedBuffer;
import java.util.stream.PipelineHelper;
import java.util.stream.Sink;
import java.util.stream.SpinedBuffer;
import java.util.stream.StreamOpFlag;

class StreamSpliterators {
    StreamSpliterators() {
    }

    private static abstract class AbstractWrappingSpliterator<P_IN, P_OUT, T_BUFFER extends AbstractSpinedBuffer>
    implements Spliterator<P_OUT> {
        final boolean isParallel;
        final PipelineHelper<P_OUT> ph;
        private Supplier<Spliterator<P_IN>> spliteratorSupplier;
        Spliterator<P_IN> spliterator;
        Sink<P_IN> bufferSink;
        BooleanSupplier pusher;
        long nextToConsume;
        T_BUFFER buffer;
        boolean finished;

        AbstractWrappingSpliterator(PipelineHelper<P_OUT> pipelineHelper, Supplier<Spliterator<P_IN>> supplier, boolean bl) {
            this.ph = pipelineHelper;
            this.spliteratorSupplier = supplier;
            this.spliterator = null;
            this.isParallel = bl;
        }

        AbstractWrappingSpliterator(PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl) {
            this.ph = pipelineHelper;
            this.spliteratorSupplier = null;
            this.spliterator = spliterator;
            this.isParallel = bl;
        }

        final void init() {
            if (this.spliterator == null) {
                this.spliterator = this.spliteratorSupplier.get();
                this.spliteratorSupplier = null;
            }
        }

        final boolean doAdvance() {
            boolean bl;
            if (this.buffer == null) {
                if (this.finished) {
                    return false;
                }
                this.init();
                this.initPartialTraversalState();
                this.nextToConsume = 0L;
                this.bufferSink.begin(this.spliterator.getExactSizeIfKnown());
                return this.fillBuffer();
            }
            ++this.nextToConsume;
            boolean bl2 = bl = this.nextToConsume < ((AbstractSpinedBuffer)this.buffer).count();
            if (!bl) {
                this.nextToConsume = 0L;
                ((AbstractSpinedBuffer)this.buffer).clear();
                bl = this.fillBuffer();
            }
            return bl;
        }

        abstract AbstractWrappingSpliterator<P_IN, P_OUT, ?> wrap(Spliterator<P_IN> var1);

        abstract void initPartialTraversalState();

        @Override
        public Spliterator<P_OUT> trySplit() {
            if (this.isParallel && !this.finished) {
                this.init();
                Spliterator<P_IN> spliterator = this.spliterator.trySplit();
                return spliterator == null ? null : this.wrap(spliterator);
            }
            return null;
        }

        private boolean fillBuffer() {
            while (((AbstractSpinedBuffer)this.buffer).count() == 0L) {
                if (!this.bufferSink.cancellationRequested() && this.pusher.getAsBoolean()) continue;
                if (this.finished) {
                    return false;
                }
                this.bufferSink.end();
                this.finished = true;
            }
            return true;
        }

        @Override
        public final long estimateSize() {
            this.init();
            return this.spliterator.estimateSize();
        }

        @Override
        public final long getExactSizeIfKnown() {
            this.init();
            return StreamOpFlag.SIZED.isKnown(this.ph.getStreamAndOpFlags()) ? this.spliterator.getExactSizeIfKnown() : -1L;
        }

        @Override
        public final int characteristics() {
            this.init();
            int n = StreamOpFlag.toCharacteristics(StreamOpFlag.toStreamFlags(this.ph.getStreamAndOpFlags()));
            if ((n & 0x40) != 0) {
                n &= 0xFFFFBFBF;
                n |= this.spliterator.characteristics() & 0x4040;
            }
            return n;
        }

        @Override
        public Comparator<? super P_OUT> getComparator() {
            if (!this.hasCharacteristics(4)) {
                throw new IllegalStateException();
            }
            return null;
        }

        public final String toString() {
            return String.format("%s[%s]", this.getClass().getName(), this.spliterator);
        }
    }

    static abstract class ArrayBuffer {
        int index;

        ArrayBuffer() {
        }

        void reset() {
            this.index = 0;
        }

        static final class OfDouble
        extends OfPrimitive<DoubleConsumer>
        implements DoubleConsumer {
            final double[] array;

            OfDouble(int n) {
                this.array = new double[n];
            }

            @Override
            public void accept(double d) {
                this.array[this.index++] = d;
            }

            @Override
            void forEach(DoubleConsumer doubleConsumer, long l) {
                int n = 0;
                while ((long)n < l) {
                    doubleConsumer.accept(this.array[n]);
                    ++n;
                }
            }
        }

        static final class OfInt
        extends OfPrimitive<IntConsumer>
        implements IntConsumer {
            final int[] array;

            OfInt(int n) {
                this.array = new int[n];
            }

            @Override
            public void accept(int n) {
                this.array[this.index++] = n;
            }

            @Override
            public void forEach(IntConsumer intConsumer, long l) {
                int n = 0;
                while ((long)n < l) {
                    intConsumer.accept(this.array[n]);
                    ++n;
                }
            }
        }

        static final class OfLong
        extends OfPrimitive<LongConsumer>
        implements LongConsumer {
            final long[] array;

            OfLong(int n) {
                this.array = new long[n];
            }

            @Override
            public void accept(long l) {
                this.array[this.index++] = l;
            }

            @Override
            public void forEach(LongConsumer longConsumer, long l) {
                int n = 0;
                while ((long)n < l) {
                    longConsumer.accept(this.array[n]);
                    ++n;
                }
            }
        }

        static abstract class OfPrimitive<T_CONS>
        extends ArrayBuffer {
            int index;

            OfPrimitive() {
            }

            @Override
            void reset() {
                this.index = 0;
            }

            abstract void forEach(T_CONS var1, long var2);
        }

        static final class OfRef<T>
        extends ArrayBuffer
        implements Consumer<T> {
            final Object[] array;

            OfRef(int n) {
                this.array = new Object[n];
            }

            @Override
            public void accept(T t) {
                this.array[this.index++] = t;
            }

            public void forEach(Consumer<? super T> consumer, long l) {
                int n = 0;
                while ((long)n < l) {
                    Object object = this.array[n];
                    consumer.accept(object);
                    ++n;
                }
            }
        }
    }

    static class DelegatingSpliterator<T, T_SPLITR extends Spliterator<T>>
    implements Spliterator<T> {
        private final Supplier<? extends T_SPLITR> supplier;
        private T_SPLITR s;

        DelegatingSpliterator(Supplier<? extends T_SPLITR> supplier) {
            this.supplier = supplier;
        }

        T_SPLITR get() {
            if (this.s == null) {
                this.s = (Spliterator)this.supplier.get();
            }
            return this.s;
        }

        public T_SPLITR trySplit() {
            return (T_SPLITR)this.get().trySplit();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            return this.get().tryAdvance(consumer);
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            this.get().forEachRemaining(consumer);
        }

        @Override
        public long estimateSize() {
            return this.get().estimateSize();
        }

        @Override
        public int characteristics() {
            return this.get().characteristics();
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.get().getComparator();
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.get().getExactSizeIfKnown();
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.get() + "]";
        }

        static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, Spliterator.OfDouble>
        implements Spliterator.OfDouble {
            OfDouble(Supplier<Spliterator.OfDouble> supplier) {
                super(supplier);
            }
        }

        static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, Spliterator.OfInt>
        implements Spliterator.OfInt {
            OfInt(Supplier<Spliterator.OfInt> supplier) {
                super(supplier);
            }
        }

        static final class OfLong
        extends OfPrimitive<Long, LongConsumer, Spliterator.OfLong>
        implements Spliterator.OfLong {
            OfLong(Supplier<Spliterator.OfLong> supplier) {
                super(supplier);
            }
        }

        static class OfPrimitive<T, T_CONS, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>>
        extends DelegatingSpliterator<T, T_SPLITR>
        implements Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> {
            OfPrimitive(Supplier<? extends T_SPLITR> supplier) {
                super(supplier);
            }

            @Override
            public boolean tryAdvance(T_CONS T_CONS) {
                return ((Spliterator.OfPrimitive)this.get()).tryAdvance(T_CONS);
            }

            @Override
            public void forEachRemaining(T_CONS T_CONS) {
                ((Spliterator.OfPrimitive)this.get()).forEachRemaining(T_CONS);
            }
        }
    }

    static final class DistinctSpliterator<T>
    implements Spliterator<T>,
    Consumer<T> {
        private static final Object NULL_VALUE = new Object();
        private final Spliterator<T> s;
        private final ConcurrentHashMap<T, Boolean> seen;
        private T tmpSlot;

        DistinctSpliterator(Spliterator<T> spliterator) {
            this(spliterator, new ConcurrentHashMap());
        }

        private DistinctSpliterator(Spliterator<T> spliterator, ConcurrentHashMap<T, Boolean> concurrentHashMap) {
            this.s = spliterator;
            this.seen = concurrentHashMap;
        }

        @Override
        public void accept(T t) {
            this.tmpSlot = t;
        }

        private T mapNull(T t) {
            return (T)(t != null ? t : NULL_VALUE);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            while (this.s.tryAdvance(this)) {
                if (this.seen.putIfAbsent(this.mapNull(this.tmpSlot), Boolean.TRUE) != null) continue;
                consumer.accept(this.tmpSlot);
                this.tmpSlot = null;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            this.s.forEachRemaining(object -> {
                if (this.seen.putIfAbsent(this.mapNull(object), Boolean.TRUE) == null) {
                    consumer.accept(object);
                }
            });
        }

        @Override
        public Spliterator<T> trySplit() {
            Spliterator<T> spliterator = this.s.trySplit();
            return spliterator != null ? new DistinctSpliterator<T>(spliterator, this.seen) : null;
        }

        @Override
        public long estimateSize() {
            return this.s.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.s.characteristics() & 0xFFFFBFAB | 1;
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.s.getComparator();
        }
    }

    static final class DoubleWrappingSpliterator<P_IN>
    extends AbstractWrappingSpliterator<P_IN, Double, SpinedBuffer.OfDouble>
    implements Spliterator.OfDouble {
        DoubleWrappingSpliterator(PipelineHelper<Double> pipelineHelper, Supplier<Spliterator<P_IN>> supplier, boolean bl) {
            super(pipelineHelper, supplier, bl);
        }

        DoubleWrappingSpliterator(PipelineHelper<Double> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl) {
            super(pipelineHelper, spliterator, bl);
        }

        @Override
        AbstractWrappingSpliterator<P_IN, Double, ?> wrap(Spliterator<P_IN> spliterator) {
            return new DoubleWrappingSpliterator<P_IN>((PipelineHelper<Double>)this.ph, spliterator, this.isParallel);
        }

        @Override
        void initPartialTraversalState() {
            SpinedBuffer.OfDouble ofDouble = new SpinedBuffer.OfDouble();
            this.buffer = ofDouble;
            this.bufferSink = this.ph.wrapSink(ofDouble::accept);
            this.pusher = () -> this.spliterator.tryAdvance(this.bufferSink);
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            return (Spliterator.OfDouble)super.trySplit();
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            Objects.requireNonNull(doubleConsumer);
            boolean bl = this.doAdvance();
            if (bl) {
                doubleConsumer.accept(((SpinedBuffer.OfDouble)this.buffer).get(this.nextToConsume));
            }
            return bl;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            if (this.buffer == null && !this.finished) {
                Objects.requireNonNull(doubleConsumer);
                this.init();
                this.ph.wrapAndCopyInto(doubleConsumer::accept, this.spliterator);
                this.finished = true;
            } else {
                while (this.tryAdvance(doubleConsumer)) {
                }
            }
        }
    }

    static abstract class InfiniteSupplyingSpliterator<T>
    implements Spliterator<T> {
        long estimate;

        protected InfiniteSupplyingSpliterator(long l) {
            this.estimate = l;
        }

        @Override
        public long estimateSize() {
            return this.estimate;
        }

        @Override
        public int characteristics() {
            return 1024;
        }

        static final class OfDouble
        extends InfiniteSupplyingSpliterator<Double>
        implements Spliterator.OfDouble {
            final DoubleSupplier s;

            OfDouble(long l, DoubleSupplier doubleSupplier) {
                super(l);
                this.s = doubleSupplier;
            }

            @Override
            public boolean tryAdvance(DoubleConsumer doubleConsumer) {
                Objects.requireNonNull(doubleConsumer);
                doubleConsumer.accept(this.s.getAsDouble());
                return true;
            }

            @Override
            public Spliterator.OfDouble trySplit() {
                if (this.estimate == 0L) {
                    return null;
                }
                return new OfDouble(this.estimate >>>= 1, this.s);
            }
        }

        static final class OfInt
        extends InfiniteSupplyingSpliterator<Integer>
        implements Spliterator.OfInt {
            final IntSupplier s;

            OfInt(long l, IntSupplier intSupplier) {
                super(l);
                this.s = intSupplier;
            }

            @Override
            public boolean tryAdvance(IntConsumer intConsumer) {
                Objects.requireNonNull(intConsumer);
                intConsumer.accept(this.s.getAsInt());
                return true;
            }

            @Override
            public Spliterator.OfInt trySplit() {
                if (this.estimate == 0L) {
                    return null;
                }
                return new OfInt(this.estimate >>>= 1, this.s);
            }
        }

        static final class OfLong
        extends InfiniteSupplyingSpliterator<Long>
        implements Spliterator.OfLong {
            final LongSupplier s;

            OfLong(long l, LongSupplier longSupplier) {
                super(l);
                this.s = longSupplier;
            }

            @Override
            public boolean tryAdvance(LongConsumer longConsumer) {
                Objects.requireNonNull(longConsumer);
                longConsumer.accept(this.s.getAsLong());
                return true;
            }

            @Override
            public Spliterator.OfLong trySplit() {
                if (this.estimate == 0L) {
                    return null;
                }
                return new OfLong(this.estimate >>>= 1, this.s);
            }
        }

        static final class OfRef<T>
        extends InfiniteSupplyingSpliterator<T> {
            final Supplier<T> s;

            OfRef(long l, Supplier<T> supplier) {
                super(l);
                this.s = supplier;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                Objects.requireNonNull(consumer);
                consumer.accept(this.s.get());
                return true;
            }

            @Override
            public Spliterator<T> trySplit() {
                if (this.estimate == 0L) {
                    return null;
                }
                return new OfRef<T>(this.estimate >>>= 1, this.s);
            }
        }
    }

    static final class IntWrappingSpliterator<P_IN>
    extends AbstractWrappingSpliterator<P_IN, Integer, SpinedBuffer.OfInt>
    implements Spliterator.OfInt {
        IntWrappingSpliterator(PipelineHelper<Integer> pipelineHelper, Supplier<Spliterator<P_IN>> supplier, boolean bl) {
            super(pipelineHelper, supplier, bl);
        }

        IntWrappingSpliterator(PipelineHelper<Integer> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl) {
            super(pipelineHelper, spliterator, bl);
        }

        @Override
        AbstractWrappingSpliterator<P_IN, Integer, ?> wrap(Spliterator<P_IN> spliterator) {
            return new IntWrappingSpliterator<P_IN>((PipelineHelper<Integer>)this.ph, spliterator, this.isParallel);
        }

        @Override
        void initPartialTraversalState() {
            SpinedBuffer.OfInt ofInt = new SpinedBuffer.OfInt();
            this.buffer = ofInt;
            this.bufferSink = this.ph.wrapSink(ofInt::accept);
            this.pusher = () -> this.spliterator.tryAdvance(this.bufferSink);
        }

        @Override
        public Spliterator.OfInt trySplit() {
            return (Spliterator.OfInt)super.trySplit();
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            Objects.requireNonNull(intConsumer);
            boolean bl = this.doAdvance();
            if (bl) {
                intConsumer.accept(((SpinedBuffer.OfInt)this.buffer).get(this.nextToConsume));
            }
            return bl;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            if (this.buffer == null && !this.finished) {
                Objects.requireNonNull(intConsumer);
                this.init();
                this.ph.wrapAndCopyInto(intConsumer::accept, this.spliterator);
                this.finished = true;
            } else {
                while (this.tryAdvance(intConsumer)) {
                }
            }
        }
    }

    static final class LongWrappingSpliterator<P_IN>
    extends AbstractWrappingSpliterator<P_IN, Long, SpinedBuffer.OfLong>
    implements Spliterator.OfLong {
        LongWrappingSpliterator(PipelineHelper<Long> pipelineHelper, Supplier<Spliterator<P_IN>> supplier, boolean bl) {
            super(pipelineHelper, supplier, bl);
        }

        LongWrappingSpliterator(PipelineHelper<Long> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl) {
            super(pipelineHelper, spliterator, bl);
        }

        @Override
        AbstractWrappingSpliterator<P_IN, Long, ?> wrap(Spliterator<P_IN> spliterator) {
            return new LongWrappingSpliterator<P_IN>((PipelineHelper<Long>)this.ph, spliterator, this.isParallel);
        }

        @Override
        void initPartialTraversalState() {
            SpinedBuffer.OfLong ofLong = new SpinedBuffer.OfLong();
            this.buffer = ofLong;
            this.bufferSink = this.ph.wrapSink(ofLong::accept);
            this.pusher = () -> this.spliterator.tryAdvance(this.bufferSink);
        }

        @Override
        public Spliterator.OfLong trySplit() {
            return (Spliterator.OfLong)super.trySplit();
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            Objects.requireNonNull(longConsumer);
            boolean bl = this.doAdvance();
            if (bl) {
                longConsumer.accept(((SpinedBuffer.OfLong)this.buffer).get(this.nextToConsume));
            }
            return bl;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            if (this.buffer == null && !this.finished) {
                Objects.requireNonNull(longConsumer);
                this.init();
                this.ph.wrapAndCopyInto(longConsumer::accept, this.spliterator);
                this.finished = true;
            } else {
                while (this.tryAdvance(longConsumer)) {
                }
            }
        }
    }

    static abstract class SliceSpliterator<T, T_SPLITR extends Spliterator<T>> {
        final long sliceOrigin;
        final long sliceFence;
        T_SPLITR s;
        long index;
        long fence;

        SliceSpliterator(T_SPLITR T_SPLITR, long l, long l2, long l3, long l4) {
            assert (T_SPLITR.hasCharacteristics(16384));
            this.s = T_SPLITR;
            this.sliceOrigin = l;
            this.sliceFence = l2;
            this.index = l3;
            this.fence = l4;
        }

        protected abstract T_SPLITR makeSpliterator(T_SPLITR var1, long var2, long var4, long var6, long var8);

        public T_SPLITR trySplit() {
            long l;
            long l2;
            Spliterator spliterator;
            if (this.sliceOrigin >= this.fence) {
                return null;
            }
            if (this.index >= this.fence) {
                return null;
            }
            while (true) {
                if ((spliterator = this.s.trySplit()) == null) {
                    return null;
                }
                l2 = this.index + spliterator.estimateSize();
                l = Math.min(l2, this.sliceFence);
                if (this.sliceOrigin >= l) {
                    this.index = l;
                    continue;
                }
                if (l < this.sliceFence) break;
                this.s = spliterator;
                this.fence = l;
            }
            if (this.index >= this.sliceOrigin && l2 <= this.sliceFence) {
                this.index = l;
                return (T_SPLITR)spliterator;
            }
            this.index = l;
            return (T_SPLITR)this.makeSpliterator(spliterator, this.sliceOrigin, this.sliceFence, this.index, this.index);
        }

        public long estimateSize() {
            return this.sliceOrigin < this.fence ? this.fence - Math.max(this.sliceOrigin, this.index) : 0L;
        }

        public int characteristics() {
            return this.s.characteristics();
        }

        static final class OfDouble
        extends OfPrimitive<Double, Spliterator.OfDouble, DoubleConsumer>
        implements Spliterator.OfDouble {
            OfDouble(Spliterator.OfDouble ofDouble, long l, long l2) {
                super(ofDouble, l, l2);
            }

            OfDouble(Spliterator.OfDouble ofDouble, long l, long l2, long l3, long l4) {
                super(ofDouble, l, l2, l3, l4, null);
            }

            @Override
            protected Spliterator.OfDouble makeSpliterator(Spliterator.OfDouble ofDouble, long l, long l2, long l3, long l4) {
                return new OfDouble(ofDouble, l, l2, l3, l4);
            }

            @Override
            protected DoubleConsumer emptyConsumer() {
                return d -> {};
            }
        }

        static final class OfInt
        extends OfPrimitive<Integer, Spliterator.OfInt, IntConsumer>
        implements Spliterator.OfInt {
            OfInt(Spliterator.OfInt ofInt, long l, long l2) {
                super(ofInt, l, l2);
            }

            OfInt(Spliterator.OfInt ofInt, long l, long l2, long l3, long l4) {
                super(ofInt, l, l2, l3, l4, null);
            }

            @Override
            protected Spliterator.OfInt makeSpliterator(Spliterator.OfInt ofInt, long l, long l2, long l3, long l4) {
                return new OfInt(ofInt, l, l2, l3, l4);
            }

            @Override
            protected IntConsumer emptyConsumer() {
                return n -> {};
            }
        }

        static final class OfLong
        extends OfPrimitive<Long, Spliterator.OfLong, LongConsumer>
        implements Spliterator.OfLong {
            OfLong(Spliterator.OfLong ofLong, long l, long l2) {
                super(ofLong, l, l2);
            }

            OfLong(Spliterator.OfLong ofLong, long l, long l2, long l3, long l4) {
                super(ofLong, l, l2, l3, l4, null);
            }

            @Override
            protected Spliterator.OfLong makeSpliterator(Spliterator.OfLong ofLong, long l, long l2, long l3, long l4) {
                return new OfLong(ofLong, l, l2, l3, l4);
            }

            @Override
            protected LongConsumer emptyConsumer() {
                return l -> {};
            }
        }

        static abstract class OfPrimitive<T, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>, T_CONS>
        extends SliceSpliterator<T, T_SPLITR>
        implements Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> {
            OfPrimitive(T_SPLITR T_SPLITR, long l, long l2) {
                this(T_SPLITR, l, l2, 0L, Math.min(T_SPLITR.estimateSize(), l2));
            }

            private OfPrimitive(T_SPLITR T_SPLITR, long l, long l2, long l3, long l4) {
                super(T_SPLITR, l, l2, l3, l4);
            }

            @Override
            public boolean tryAdvance(T_CONS T_CONS) {
                Objects.requireNonNull(T_CONS);
                if (this.sliceOrigin >= this.fence) {
                    return false;
                }
                while (this.sliceOrigin > this.index) {
                    ((Spliterator.OfPrimitive)this.s).tryAdvance(this.emptyConsumer());
                    ++this.index;
                }
                if (this.index >= this.fence) {
                    return false;
                }
                ++this.index;
                return ((Spliterator.OfPrimitive)this.s).tryAdvance(T_CONS);
            }

            @Override
            public void forEachRemaining(T_CONS T_CONS) {
                Objects.requireNonNull(T_CONS);
                if (this.sliceOrigin >= this.fence) {
                    return;
                }
                if (this.index >= this.fence) {
                    return;
                }
                if (this.index >= this.sliceOrigin && this.index + ((Spliterator.OfPrimitive)this.s).estimateSize() <= this.sliceFence) {
                    ((Spliterator.OfPrimitive)this.s).forEachRemaining(T_CONS);
                    this.index = this.fence;
                } else {
                    while (this.sliceOrigin > this.index) {
                        ((Spliterator.OfPrimitive)this.s).tryAdvance(this.emptyConsumer());
                        ++this.index;
                    }
                    while (this.index < this.fence) {
                        ((Spliterator.OfPrimitive)this.s).tryAdvance(T_CONS);
                        ++this.index;
                    }
                }
            }

            protected abstract T_CONS emptyConsumer();

            /* synthetic */ OfPrimitive(Spliterator.OfPrimitive ofPrimitive, long l, long l2, long l3, long l4, 1 var10_6) {
                this(ofPrimitive, l, l2, l3, l4);
            }
        }

        static final class OfRef<T>
        extends SliceSpliterator<T, Spliterator<T>>
        implements Spliterator<T> {
            OfRef(Spliterator<T> spliterator, long l, long l2) {
                this(spliterator, l, l2, 0L, Math.min(spliterator.estimateSize(), l2));
            }

            private OfRef(Spliterator<T> spliterator, long l, long l2, long l3, long l4) {
                super(spliterator, l, l2, l3, l4);
            }

            @Override
            protected Spliterator<T> makeSpliterator(Spliterator<T> spliterator, long l, long l2, long l3, long l4) {
                return new OfRef<T>(spliterator, l, l2, l3, l4);
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                Objects.requireNonNull(consumer);
                if (this.sliceOrigin >= this.fence) {
                    return false;
                }
                while (this.sliceOrigin > this.index) {
                    this.s.tryAdvance(object -> {});
                    ++this.index;
                }
                if (this.index >= this.fence) {
                    return false;
                }
                ++this.index;
                return this.s.tryAdvance(consumer);
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                Objects.requireNonNull(consumer);
                if (this.sliceOrigin >= this.fence) {
                    return;
                }
                if (this.index >= this.fence) {
                    return;
                }
                if (this.index >= this.sliceOrigin && this.index + this.s.estimateSize() <= this.sliceFence) {
                    this.s.forEachRemaining(consumer);
                    this.index = this.fence;
                } else {
                    while (this.sliceOrigin > this.index) {
                        this.s.tryAdvance(object -> {});
                        ++this.index;
                    }
                    while (this.index < this.fence) {
                        this.s.tryAdvance(consumer);
                        ++this.index;
                    }
                }
            }
        }
    }

    static abstract class UnorderedSliceSpliterator<T, T_SPLITR extends Spliterator<T>> {
        static final int CHUNK_SIZE = 128;
        protected final T_SPLITR s;
        protected final boolean unlimited;
        private final long skipThreshold;
        private final AtomicLong permits;

        UnorderedSliceSpliterator(T_SPLITR T_SPLITR, long l, long l2) {
            this.s = T_SPLITR;
            this.unlimited = l2 < 0L;
            this.skipThreshold = l2 >= 0L ? l2 : 0L;
            this.permits = new AtomicLong(l2 >= 0L ? l + l2 : l);
        }

        UnorderedSliceSpliterator(T_SPLITR T_SPLITR, UnorderedSliceSpliterator<T, T_SPLITR> unorderedSliceSpliterator) {
            this.s = T_SPLITR;
            this.unlimited = unorderedSliceSpliterator.unlimited;
            this.permits = unorderedSliceSpliterator.permits;
            this.skipThreshold = unorderedSliceSpliterator.skipThreshold;
        }

        protected final long acquirePermits(long l) {
            long l2;
            long l3;
            assert (l > 0L);
            do {
                if ((l2 = this.permits.get()) != 0L) continue;
                return this.unlimited ? l : 0L;
            } while ((l3 = Math.min(l2, l)) > 0L && !this.permits.compareAndSet(l2, l2 - l3));
            if (this.unlimited) {
                return Math.max(l - l3, 0L);
            }
            if (l2 > this.skipThreshold) {
                return Math.max(l3 - (l2 - this.skipThreshold), 0L);
            }
            return l3;
        }

        protected final PermitStatus permitStatus() {
            if (this.permits.get() > 0L) {
                return PermitStatus.MAYBE_MORE;
            }
            return this.unlimited ? PermitStatus.UNLIMITED : PermitStatus.NO_MORE;
        }

        public final T_SPLITR trySplit() {
            if (this.permits.get() == 0L) {
                return null;
            }
            Spliterator spliterator = this.s.trySplit();
            return (T_SPLITR)(spliterator == null ? null : this.makeSpliterator(spliterator));
        }

        protected abstract T_SPLITR makeSpliterator(T_SPLITR var1);

        public final long estimateSize() {
            return this.s.estimateSize();
        }

        public final int characteristics() {
            return this.s.characteristics() & 0xFFFFBFAF;
        }

        static final class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, ArrayBuffer.OfDouble, Spliterator.OfDouble>
        implements Spliterator.OfDouble,
        DoubleConsumer {
            double tmpValue;

            OfDouble(Spliterator.OfDouble ofDouble, long l, long l2) {
                super(ofDouble, l, l2);
            }

            OfDouble(Spliterator.OfDouble ofDouble, OfDouble ofDouble2) {
                super(ofDouble, ofDouble2);
            }

            @Override
            public void accept(double d) {
                this.tmpValue = d;
            }

            @Override
            protected void acceptConsumed(DoubleConsumer doubleConsumer) {
                doubleConsumer.accept(this.tmpValue);
            }

            @Override
            protected ArrayBuffer.OfDouble bufferCreate(int n) {
                return new ArrayBuffer.OfDouble(n);
            }

            @Override
            protected Spliterator.OfDouble makeSpliterator(Spliterator.OfDouble ofDouble) {
                return new OfDouble(ofDouble, this);
            }
        }

        static final class OfInt
        extends OfPrimitive<Integer, IntConsumer, ArrayBuffer.OfInt, Spliterator.OfInt>
        implements Spliterator.OfInt,
        IntConsumer {
            int tmpValue;

            OfInt(Spliterator.OfInt ofInt, long l, long l2) {
                super(ofInt, l, l2);
            }

            OfInt(Spliterator.OfInt ofInt, OfInt ofInt2) {
                super(ofInt, ofInt2);
            }

            @Override
            public void accept(int n) {
                this.tmpValue = n;
            }

            @Override
            protected void acceptConsumed(IntConsumer intConsumer) {
                intConsumer.accept(this.tmpValue);
            }

            @Override
            protected ArrayBuffer.OfInt bufferCreate(int n) {
                return new ArrayBuffer.OfInt(n);
            }

            @Override
            protected Spliterator.OfInt makeSpliterator(Spliterator.OfInt ofInt) {
                return new OfInt(ofInt, this);
            }
        }

        static final class OfLong
        extends OfPrimitive<Long, LongConsumer, ArrayBuffer.OfLong, Spliterator.OfLong>
        implements Spliterator.OfLong,
        LongConsumer {
            long tmpValue;

            OfLong(Spliterator.OfLong ofLong, long l, long l2) {
                super(ofLong, l, l2);
            }

            OfLong(Spliterator.OfLong ofLong, OfLong ofLong2) {
                super(ofLong, ofLong2);
            }

            @Override
            public void accept(long l) {
                this.tmpValue = l;
            }

            @Override
            protected void acceptConsumed(LongConsumer longConsumer) {
                longConsumer.accept(this.tmpValue);
            }

            @Override
            protected ArrayBuffer.OfLong bufferCreate(int n) {
                return new ArrayBuffer.OfLong(n);
            }

            @Override
            protected Spliterator.OfLong makeSpliterator(Spliterator.OfLong ofLong) {
                return new OfLong(ofLong, this);
            }
        }

        static abstract class OfPrimitive<T, T_CONS, T_BUFF extends ArrayBuffer.OfPrimitive<T_CONS>, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>>
        extends UnorderedSliceSpliterator<T, T_SPLITR>
        implements Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> {
            OfPrimitive(T_SPLITR T_SPLITR, long l, long l2) {
                super(T_SPLITR, l, l2);
            }

            OfPrimitive(T_SPLITR T_SPLITR, OfPrimitive ofPrimitive) {
                super(T_SPLITR, ofPrimitive);
            }

            @Override
            public boolean tryAdvance(T_CONS T_CONS) {
                Objects.requireNonNull(T_CONS);
                while (this.permitStatus() != PermitStatus.NO_MORE) {
                    if (!((Spliterator.OfPrimitive)this.s).tryAdvance(this)) {
                        return false;
                    }
                    if (this.acquirePermits(1L) != 1L) continue;
                    this.acceptConsumed(T_CONS);
                    return true;
                }
                return false;
            }

            protected abstract void acceptConsumed(T_CONS var1);

            @Override
            public void forEachRemaining(T_CONS T_CONS) {
                PermitStatus permitStatus;
                Objects.requireNonNull(T_CONS);
                ArrayBuffer.OfPrimitive<Object> ofPrimitive = null;
                while ((permitStatus = this.permitStatus()) != PermitStatus.NO_MORE) {
                    if (permitStatus == PermitStatus.MAYBE_MORE) {
                        if (ofPrimitive == null) {
                            ofPrimitive = this.bufferCreate(128);
                        } else {
                            ofPrimitive.reset();
                        }
                        ArrayBuffer.OfPrimitive ofPrimitive2 = ofPrimitive;
                        long l = 0L;
                        while (((Spliterator.OfPrimitive)this.s).tryAdvance(ofPrimitive2) && ++l < 128L) {
                        }
                        if (l == 0L) {
                            return;
                        }
                        ofPrimitive.forEach(T_CONS, this.acquirePermits(l));
                        continue;
                    }
                    ((Spliterator.OfPrimitive)this.s).forEachRemaining(T_CONS);
                    return;
                }
            }

            protected abstract T_BUFF bufferCreate(int var1);
        }

        static final class OfRef<T>
        extends UnorderedSliceSpliterator<T, Spliterator<T>>
        implements Spliterator<T>,
        Consumer<T> {
            T tmpSlot;

            OfRef(Spliterator<T> spliterator, long l, long l2) {
                super(spliterator, l, l2);
            }

            OfRef(Spliterator<T> spliterator, OfRef<T> ofRef) {
                super(spliterator, ofRef);
            }

            @Override
            public final void accept(T t) {
                this.tmpSlot = t;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                Objects.requireNonNull(consumer);
                while (this.permitStatus() != PermitStatus.NO_MORE) {
                    if (!this.s.tryAdvance(this)) {
                        return false;
                    }
                    if (this.acquirePermits(1L) != 1L) continue;
                    consumer.accept(this.tmpSlot);
                    this.tmpSlot = null;
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                PermitStatus permitStatus;
                Objects.requireNonNull(consumer);
                ArrayBuffer.OfRef<T> ofRef = null;
                while ((permitStatus = this.permitStatus()) != PermitStatus.NO_MORE) {
                    if (permitStatus == PermitStatus.MAYBE_MORE) {
                        if (ofRef == null) {
                            ofRef = new ArrayBuffer.OfRef<T>(128);
                        } else {
                            ofRef.reset();
                        }
                        long l = 0L;
                        while (this.s.tryAdvance(ofRef) && ++l < 128L) {
                        }
                        if (l == 0L) {
                            return;
                        }
                        ofRef.forEach(consumer, this.acquirePermits(l));
                        continue;
                    }
                    this.s.forEachRemaining(consumer);
                    return;
                }
            }

            @Override
            protected Spliterator<T> makeSpliterator(Spliterator<T> spliterator) {
                return new OfRef<T>(spliterator, this);
            }
        }

        static enum PermitStatus {
            NO_MORE,
            MAYBE_MORE,
            UNLIMITED;

        }
    }

    static final class WrappingSpliterator<P_IN, P_OUT>
    extends AbstractWrappingSpliterator<P_IN, P_OUT, SpinedBuffer<P_OUT>> {
        WrappingSpliterator(PipelineHelper<P_OUT> pipelineHelper, Supplier<Spliterator<P_IN>> supplier, boolean bl) {
            super(pipelineHelper, supplier, bl);
        }

        WrappingSpliterator(PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl) {
            super(pipelineHelper, spliterator, bl);
        }

        WrappingSpliterator<P_IN, P_OUT> wrap(Spliterator<P_IN> spliterator) {
            return new WrappingSpliterator<P_IN, P_OUT>(this.ph, spliterator, this.isParallel);
        }

        @Override
        void initPartialTraversalState() {
            SpinedBuffer spinedBuffer;
            this.buffer = spinedBuffer = new SpinedBuffer();
            this.bufferSink = this.ph.wrapSink(spinedBuffer::accept);
            this.pusher = () -> this.spliterator.tryAdvance(this.bufferSink);
        }

        @Override
        public boolean tryAdvance(Consumer<? super P_OUT> consumer) {
            Objects.requireNonNull(consumer);
            boolean bl = this.doAdvance();
            if (bl) {
                consumer.accept(((SpinedBuffer)this.buffer).get(this.nextToConsume));
            }
            return bl;
        }

        @Override
        public void forEachRemaining(Consumer<? super P_OUT> consumer) {
            if (this.buffer == null && !this.finished) {
                Objects.requireNonNull(consumer);
                this.init();
                this.ph.wrapAndCopyInto(consumer::accept, this.spliterator);
                this.finished = true;
            } else {
                while (this.tryAdvance(consumer)) {
                }
            }
        }
    }
}

