/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TernaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class LikeEscapeOperatorNode
extends TernaryOperatorNode {
    boolean addedEquals;
    String escape;

    public void init(Object object, Object object2, Object object3) {
        super.init(object, object2, object3, ReuseFactory.getInteger(3), null);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        boolean bl;
        boolean bl2;
        super.bindExpression(fromList, subqueryList, list);
        String string = null;
        if (!this.leftOperand.requiresTypeFromContext() && !this.leftOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException("42884", (Object)"LIKE", (Object)"FUNCTION");
        }
        if (this.rightOperand != null && !this.rightOperand.requiresTypeFromContext() && !this.rightOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException("42884", (Object)"LIKE", (Object)"FUNCTION");
        }
        if (this.receiver.requiresTypeFromContext()) {
            this.receiver.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            if (!this.leftOperand.requiresTypeFromContext()) {
                this.receiver.setCollationInfo(this.leftOperand.getTypeServices());
            } else if (this.rightOperand != null && !this.rightOperand.requiresTypeFromContext()) {
                this.receiver.setCollationInfo(this.rightOperand.getTypeServices());
            } else {
                this.receiver.setCollationUsingCompilationSchema();
            }
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.receiver.getTypeId().isStringTypeId()) {
                this.leftOperand.setType(this.receiver.getTypeServices());
            } else {
                this.leftOperand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            }
            this.leftOperand.setCollationInfo(this.receiver.getTypeServices());
        }
        if (this.rightOperand != null && this.rightOperand.requiresTypeFromContext()) {
            if (this.receiver.getTypeId().isStringTypeId()) {
                this.rightOperand.setType(this.receiver.getTypeServices());
            } else {
                this.rightOperand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            }
            this.rightOperand.setCollationInfo(this.receiver.getTypeServices());
        }
        this.bindToBuiltIn();
        TypeCompiler typeCompiler = this.receiver.getTypeCompiler();
        TypeCompiler typeCompiler2 = this.leftOperand.getTypeCompiler();
        if (!this.receiver.getTypeId().isStringTypeId()) {
            throw StandardException.newException("42884", (Object)"LIKE", (Object)"FUNCTION");
        }
        if (!this.leftOperand.getTypeId().isStringTypeId()) {
            this.leftOperand = this.castArgToString(this.leftOperand);
            typeCompiler2 = this.leftOperand.getTypeCompiler();
        }
        if (this.rightOperand != null) {
            this.rightOperand = this.castArgToString(this.rightOperand);
        }
        if (bl2 = this.leftOperand instanceof CharConstantNode) {
            string = ((CharConstantNode)this.leftOperand).getString();
        }
        if (bl = this.rightOperand instanceof CharConstantNode) {
            this.escape = ((CharConstantNode)this.rightOperand).getString();
            if (this.escape.length() != 1) {
                throw StandardException.newException("22019", this.escape);
            }
        } else if (this.rightOperand == null) {
            bl = true;
        }
        if (!this.receiver.getTypeServices().compareCollationInfo(this.leftOperand.getTypeServices())) {
            throw StandardException.newException("42ZA2", this.receiver.getTypeServices().getSQLstring(), (Object)this.receiver.getTypeServices().getCollationName(), (Object)this.leftOperand.getTypeServices().getSQLstring(), (Object)this.leftOperand.getTypeServices().getCollationName());
        }
        if (this.receiver instanceof ColumnReference && bl2 && bl && Like.isOptimizable(string)) {
            String string2 = null;
            if (this.escape != null) {
                string2 = Like.stripEscapesNoPatternChars(string, this.escape.charAt(0));
            } else if (string.indexOf(95) == -1 && string.indexOf(37) == -1) {
                string2 = string;
            }
            if (string2 != null) {
                ValueNode valueNode = this.receiver.getClone();
                this.addedEquals = true;
                BinaryComparisonOperatorNode binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, valueNode, (ValueNode)this.getNodeFactory().getNode(61, string2, this.getContextManager()), Boolean.FALSE, this.getContextManager());
                binaryComparisonOperatorNode.setForQueryRewrite(true);
                binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)binaryComparisonOperatorNode.bindExpression(fromList, subqueryList, list);
                AndNode andNode = (AndNode)this.getNodeFactory().getNode(39, this, binaryComparisonOperatorNode, this.getContextManager());
                this.finishBindExpr();
                andNode.postBindFixup();
                return andNode;
            }
        }
        this.finishBindExpr();
        return this;
    }

    private void finishBindExpr() throws StandardException {
        boolean bl;
        this.bindComparisonOperator();
        boolean bl2 = bl = this.receiver.getTypeServices().isNullable() || this.leftOperand.getTypeServices().isNullable();
        if (this.rightOperand != null) {
            bl |= this.rightOperand.getTypeServices().isNullable();
        }
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, bl));
    }

    public void bindComparisonOperator() throws StandardException {
        TypeId typeId = this.receiver.getTypeId();
        TypeId typeId2 = this.leftOperand.getTypeId();
        if (!typeId.isStringTypeId()) {
            throw StandardException.newException("42X53", typeId.getSQLTypeName());
        }
        if (!typeId2.isStringTypeId()) {
            throw StandardException.newException("42X53", typeId2.getSQLTypeName());
        }
        if (this.rightOperand != null && !this.rightOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException("42X53", this.rightOperand.getTypeId().getSQLTypeName());
        }
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        BinaryComparisonOperatorNode binaryComparisonOperatorNode;
        QueryTreeNode queryTreeNode;
        Object object;
        boolean bl = false;
        String string = null;
        String string2 = null;
        super.preprocess(n, fromList, subqueryList, predicateList);
        if (this.receiver.getTypeId().getSQLTypeName().equals("CLOB")) {
            return this;
        }
        if (this.addedEquals) {
            return this;
        }
        if (!(this.leftOperand instanceof CharConstantNode) && !this.leftOperand.requiresTypeFromContext()) {
            return this;
        }
        if (!(this.receiver instanceof ColumnReference)) {
            return this;
        }
        if (this.receiver.getTypeServices().getCollationType() != 0) {
            return this;
        }
        if (this.leftOperand instanceof CharConstantNode) {
            object = ((CharConstantNode)this.leftOperand).getString();
            if (!Like.isOptimizable((String)object)) {
                return this;
            }
            int n2 = this.receiver.getTypeServices().getMaximumWidth();
            string = Like.greaterEqualString((String)object, this.escape, n2);
            string2 = Like.lessThanString((String)object, this.escape, n2);
            bl = !Like.isLikeComparisonNeeded((String)object);
        }
        object = null;
        ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        if (string2 != null || this.leftOperand.requiresTypeFromContext()) {
            queryTreeNode = this.leftOperand.requiresTypeFromContext() ? this.setupOptimizeStringFromParameter(this.leftOperand, this.rightOperand, "lessThanStringFromParameter", this.receiver.getTypeServices().getMaximumWidth()) : (QueryTreeNode)this.getNodeFactory().getNode(61, string2, this.getContextManager());
            binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(45, this.receiver.getClone(), queryTreeNode, Boolean.FALSE, this.getContextManager());
            binaryComparisonOperatorNode.setForQueryRewrite(true);
            binaryComparisonOperatorNode.bindComparisonOperator();
            binaryComparisonOperatorNode.setBetweenSelectivity();
            object = (AndNode)this.getNodeFactory().getNode(39, binaryComparisonOperatorNode, valueNode, this.getContextManager());
            ((AndNode)object).postBindFixup();
        }
        queryTreeNode = this.leftOperand.requiresTypeFromContext() ? this.setupOptimizeStringFromParameter(this.leftOperand, this.rightOperand, "greaterEqualStringFromParameter", this.receiver.getTypeServices().getMaximumWidth()) : (ValueNode)this.getNodeFactory().getNode(61, string, this.getContextManager());
        binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(42, this.receiver.getClone(), queryTreeNode, Boolean.FALSE, this.getContextManager());
        binaryComparisonOperatorNode.setForQueryRewrite(true);
        binaryComparisonOperatorNode.bindComparisonOperator();
        binaryComparisonOperatorNode.setBetweenSelectivity();
        object = object == null ? (AndNode)this.getNodeFactory().getNode(39, binaryComparisonOperatorNode, valueNode, this.getContextManager()) : (AndNode)this.getNodeFactory().getNode(39, binaryComparisonOperatorNode, object, this.getContextManager());
        ((AndNode)object).postBindFixup();
        if (!bl) {
            object = (AndNode)this.getNodeFactory().getNode(39, this, object, this.getContextManager());
            ((AndNode)object).postBindFixup();
        }
        this.setTransformed();
        return object;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.receiver.generateExpression(expressionClassBuilder, methodBuilder);
        this.receiverInterfaceType = this.receiver.getTypeCompiler().interfaceName();
        methodBuilder.upCast(this.receiverInterfaceType);
        this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.upCast(this.leftInterfaceType);
        if (this.rightOperand != null) {
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.upCast(this.rightInterfaceType);
        }
        methodBuilder.callMethod((short)185, null, this.methodName, this.resultInterfaceType, this.rightOperand == null ? 1 : 2);
    }

    private ValueNode setupOptimizeStringFromParameter(ValueNode valueNode, ValueNode valueNode2, String string, int n) throws StandardException {
        QueryTreeNode[] queryTreeNodeArray;
        if (valueNode2 != null) {
            string = string + "WithEsc";
        }
        StaticMethodCallNode staticMethodCallNode = (StaticMethodCallNode)this.getNodeFactory().getNode(85, string, "org.apache.derby.iapi.types.Like", this.getContextManager());
        staticMethodCallNode.internalCall = true;
        QueryTreeNode queryTreeNode = (QueryTreeNode)this.getNodeFactory().getNode(70, new Integer(n), this.getContextManager());
        if (valueNode2 == null) {
            QueryTreeNode[] queryTreeNodeArray2 = new QueryTreeNode[2];
            queryTreeNodeArray2[0] = valueNode;
            queryTreeNodeArray = queryTreeNodeArray2;
            queryTreeNodeArray2[1] = queryTreeNode;
        } else {
            QueryTreeNode[] queryTreeNodeArray3 = new QueryTreeNode[3];
            queryTreeNodeArray3[0] = valueNode;
            queryTreeNodeArray3[1] = valueNode2;
            queryTreeNodeArray = queryTreeNodeArray3;
            queryTreeNodeArray3[2] = queryTreeNode;
        }
        QueryTreeNode[] queryTreeNodeArray4 = queryTreeNodeArray;
        staticMethodCallNode.addParms(Arrays.asList(queryTreeNodeArray4));
        ValueNode valueNode3 = (ValueNode)this.getNodeFactory().getNode(36, staticMethodCallNode, this.getContextManager());
        valueNode3 = valueNode3.bindExpression(null, null, null);
        CastNode castNode = (CastNode)this.getNodeFactory().getNode(60, valueNode3, valueNode.getTypeServices(), this.getContextManager());
        castNode.bindCastNodeOnly();
        return castNode;
    }
}

