/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.spi.multiview;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.core.multiview.ContextAwareDescription;
import org.netbeans.core.multiview.MultiViewCloneableTopComponent;
import org.netbeans.core.multiview.MultiViewTopComponent;
import org.netbeans.core.multiview.SourceCheckDescription;
import org.netbeans.core.spi.multiview.Bundle;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public final class MultiViewFactory {
    public static final MultiViewElement BLANK_ELEMENT = new Blank();
    public static final Action NOOP_CLOSE_ACTION = new NoopAction();

    private MultiViewFactory() {
    }

    public static TopComponent createMultiView(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription) {
        return MultiViewFactory.createMultiView(multiViewDescriptionArray, multiViewDescription, MultiViewFactory.createDefaultCloseOpHandler());
    }

    public static TopComponent createMultiView(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, CloseOperationHandler closeOperationHandler) {
        if (multiViewDescriptionArray == null) {
            return null;
        }
        if (closeOperationHandler == null) {
            closeOperationHandler = MultiViewFactory.createDefaultCloseOpHandler();
        }
        MultiViewTopComponent multiViewTopComponent = new MultiViewTopComponent();
        multiViewTopComponent.setMultiViewDescriptions(multiViewDescriptionArray, multiViewDescription);
        multiViewTopComponent.setCloseOperationHandler(closeOperationHandler);
        return multiViewTopComponent;
    }

    public static CloneableTopComponent createCloneableMultiView(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription) {
        return MultiViewFactory.createCloneableMultiView(multiViewDescriptionArray, multiViewDescription, MultiViewFactory.createDefaultCloseOpHandler());
    }

    public static CloneableTopComponent createCloneableMultiView(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, CloseOperationHandler closeOperationHandler) {
        if (multiViewDescriptionArray == null) {
            return null;
        }
        if (closeOperationHandler == null) {
            closeOperationHandler = MultiViewFactory.createDefaultCloseOpHandler();
        }
        MultiViewCloneableTopComponent multiViewCloneableTopComponent = new MultiViewCloneableTopComponent();
        multiViewCloneableTopComponent.setMultiViewDescriptions(multiViewDescriptionArray, multiViewDescription);
        multiViewCloneableTopComponent.setCloseOperationHandler(closeOperationHandler);
        return multiViewCloneableTopComponent;
    }

    static CloseOperationState createSafeCloseState() {
        return new CloseOperationState(true, "ID_CLOSE_OK", NOOP_CLOSE_ACTION, NOOP_CLOSE_ACTION);
    }

    public static CloseOperationState createUnsafeCloseState(String string, Action action, Action action2) {
        return new CloseOperationState(false, string == null ? "" : string, action == null ? NOOP_CLOSE_ACTION : action, action2 == null ? NOOP_CLOSE_ACTION : action2);
    }

    static CloseOperationHandler createDefaultCloseOpHandler() {
        return new DefaultCloseHandler();
    }

    static MultiViewDescription createMultiViewDescription(Map map) {
        return new MapMVD(map, null, false);
    }

    private static final class MapMVD
    implements MultiViewDescription,
    ContextAwareDescription,
    SourceCheckDescription {
        private final Map map;
        private final Lookup context;
        private boolean isSplitDescription;

        public MapMVD(Map map, Lookup lookup, boolean bl) {
            this.map = map;
            this.context = lookup;
            this.isSplitDescription = bl;
        }

        private <T> T get(String string, Class<T> clazz) {
            Object v = this.map.get(string);
            if (v == null) {
                throw new NullPointerException(string + " attribute not specified for " + this.map.get("class"));
            }
            if (clazz.isInstance(v)) {
                return clazz.cast(v);
            }
            throw new IllegalArgumentException(string + " not of type " + clazz + " but " + v + " for " + this.map.get("class"));
        }

        @Override
        public int getPersistenceType() {
            if (!this.map.containsKey("persistenceType")) {
                return 2;
            }
            return this.get("persistenceType", Integer.class);
        }

        @Override
        public String getDisplayName() {
            return this.get("displayName", String.class);
        }

        @Override
        public Image getIcon() {
            if (!this.map.containsKey("iconBase")) {
                return null;
            }
            String string = this.get("iconBase", String.class);
            return ImageUtilities.loadImage((String)string, (boolean)true);
        }

        @Override
        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        @Override
        public String preferredID() {
            return this.get("preferredID", String.class);
        }

        @Override
        public MultiViewElement createElement() {
            String string = this.get("class", String.class);
            String string2 = (String)this.map.get("method");
            Exception exception = null;
            try {
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                if (classLoader == null) {
                    classLoader = MultiViewFactory.class.getClassLoader();
                }
                Class<?> clazz = Class.forName(string, true, classLoader);
                if (string2 == null) {
                    try {
                        Constructor<?> constructor = clazz.getConstructor(Lookup.class);
                        return (MultiViewElement)constructor.newInstance(this.context);
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                        return (MultiViewElement)constructor.newInstance(new Object[0]);
                    }
                }
                try {
                    Method method = clazz.getMethod(string2, Lookup.class);
                    return (MultiViewElement)method.invoke(null, this.context);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    exception = noSuchMethodException;
                    Method method = clazz.getMethod(string2, new Class[0]);
                    return (MultiViewElement)method.invoke(null, new Object[0]);
                }
            }
            catch (Exception exception3) {
                IllegalStateException illegalStateException;
                Throwable throwable = illegalStateException = new IllegalStateException("Cannot instantiate " + string, exception3);
                while (throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                throwable.initCause(exception);
                throw illegalStateException;
            }
        }

        @Override
        public ContextAwareDescription createContextAwareDescription(Lookup lookup, boolean bl) {
            return new MapMVD(this.map, lookup, bl);
        }

        @Override
        public boolean isSourceView() {
            return Boolean.TRUE.equals(this.map.get("sourceview"));
        }

        @Override
        public boolean isSplitDescription() {
            return this.isSplitDescription;
        }
    }

    private static final class NoopAction
    extends AbstractAction {
        private NoopAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private static final class DefaultCloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -3126744916624172427L;

        private DefaultCloseHandler() {
        }

        @Override
        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            if (closeOperationStateArray != null) {
                boolean bl = true;
                LinkedHashMap<String, CloseOperationState> linkedHashMap = new LinkedHashMap<String, CloseOperationState>();
                for (int i = 0; i < closeOperationStateArray.length; ++i) {
                    if (closeOperationStateArray[i].canClose()) continue;
                    linkedHashMap.put(closeOperationStateArray[i].getCloseWarningID(), closeOperationStateArray[i]);
                    bl = false;
                }
                if (!bl) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation(this.createPanel(linkedHashMap), 1);
                    Object[] objectArray = new Object[]{Bundle.CTL_Save(), Bundle.CTL_Discard(), NotifyDescriptor.CANCEL_OPTION};
                    confirmation.setOptions(objectArray);
                    Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (object == objectArray[0]) {
                        Iterator iterator = linkedHashMap.values().iterator();
                        while (iterator.hasNext()) {
                            Action action = ((CloseOperationState)iterator.next()).getProceedAction();
                            if (action == null) continue;
                            action.actionPerformed(new ActionEvent(this, 1001, "proceed"));
                        }
                    } else if (object == objectArray[1]) {
                        Iterator iterator = linkedHashMap.values().iterator();
                        while (iterator.hasNext()) {
                            Action action = ((CloseOperationState)iterator.next()).getDiscardAction();
                            if (action == null) continue;
                            action.actionPerformed(new ActionEvent(this, 1001, "discard"));
                        }
                    } else {
                        return false;
                    }
                }
            }
            return true;
        }

        private Object createPanel(Map<String, CloseOperationState> map) {
            if (map.size() == 1) {
                return this.findDescription(map.values().iterator().next());
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (CloseOperationState closeOperationState : map.values()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.findDescription(closeOperationState));
            }
            return stringBuilder;
        }

        private Object findDescription(CloseOperationState closeOperationState) {
            Action action = closeOperationState.getProceedAction();
            Object object = action.getValue("LongDescription");
            if (object == null) {
                object = action.getValue("ShortDescription");
            }
            if (object == null) {
                object = action.getValue("Name");
            }
            if (object == null) {
                object = closeOperationState.getCloseWarningID();
            }
            return object;
        }
    }

    private static final class Blank
    implements MultiViewElement,
    Serializable {
        private JPanel panel = new JPanel();
        private JPanel bar = new JPanel();

        Blank() {
        }

        @Override
        public void componentActivated() {
        }

        @Override
        public void componentClosed() {
        }

        @Override
        public void componentDeactivated() {
        }

        @Override
        public void componentHidden() {
        }

        @Override
        public void componentOpened() {
        }

        @Override
        public void componentShowing() {
        }

        @Override
        public Action[] getActions() {
            return new Action[0];
        }

        @Override
        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        @Override
        public JComponent getToolbarRepresentation() {
            return this.bar;
        }

        @Override
        public JComponent getVisualRepresentation() {
            return this.panel;
        }

        @Override
        public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        }

        @Override
        public UndoRedo getUndoRedo() {
            return null;
        }

        @Override
        public CloseOperationState canCloseElement() {
            return CloseOperationState.STATE_OK;
        }
    }
}

