/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.multiview.ContextAwareDescription;
import org.netbeans.core.multiview.MultiViewModel;
import org.netbeans.core.multiview.MultiViewPeer;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class TabsComponent
extends JPanel {
    private JComponent EMPTY;
    private static final String TOOLBAR_MARKER = "MultiViewPanel";
    MultiViewModel model;
    private MouseListener buttonMouseListener = null;
    private JComponent toolbarPanel;
    private JComponent toolbarPanelSplit;
    JPanel componentPanel;
    JPanel componentPanelSplit;
    private CardLayout cardLayout;
    private CardLayout cardLayoutSplit;
    private Set<MultiViewElement> alreadyAddedElements;
    private Set<MultiViewElement> alreadyAddedElementsSplit;
    private JToolBar bar = new JToolBar();
    private JToolBar barSplit;
    private JSplitPane splitPane;
    private AWTEventListener awtEventListener;
    private boolean isTopLeft = true;
    private JPanel topLeftComponent;
    private JPanel bottomRightComponent;
    private Dimension barMinSize;
    private Dimension panelMinSizep;
    private MultiViewDescription[] topBottomDescriptions = null;
    private PropertyChangeListener splitterPropertyChangeListener;
    private boolean removeSplit = false;
    private MultiViewPeer mvPeer;
    private boolean hiddenTriggeredByMultiViewButton = false;
    private static final boolean AQUA = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private boolean toolbarVisible = true;
    private Border buttonBorder = null;

    public TabsComponent(boolean bl) {
        Border border = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        this.bar.setBorder(border);
        this.bar.setFloatable(false);
        this.bar.setFocusable(true);
        if ("Windows".equals(UIManager.getLookAndFeel().getID()) && !TabsComponent.isXPTheme()) {
            this.bar.setRollover(true);
        } else if (AQUA) {
            this.bar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        this.startToggling();
        this.setToolbarBarVisible(bl);
    }

    public void setModel(MultiViewModel multiViewModel) {
        Serializable serializable;
        if (this.model != null) {
            this.bar.removeAll();
        }
        this.model = multiViewModel;
        this.componentPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.componentPanel.setLayout(this.cardLayout);
        this.add((Component)this.componentPanel, "Center");
        this.alreadyAddedElements = new HashSet<MultiViewElement>();
        MultiViewDescription[] multiViewDescriptionArray = multiViewModel.getDescriptions();
        MultiViewDescription multiViewDescription = multiViewModel.getActiveDescription();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.bar.setLayout(gridBagLayout);
        Serializable serializable2 = null;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
            boolean bl = true;
            if (multiViewDescriptionArray[i] instanceof ContextAwareDescription) {
                boolean bl2 = bl = !((ContextAwareDescription)multiViewDescriptionArray[i]).isSplitDescription();
            }
            if (!bl) continue;
            serializable = this.createButton(multiViewDescriptionArray[i]);
            multiViewModel.getButtonGroup().add((AbstractButton)serializable);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            n = Math.max(((JComponent)serializable).getPreferredSize().height, n);
            this.bar.add((Component)serializable, gridBagConstraints);
            n2 = Math.max(((JComponent)serializable).getPreferredSize().width, n2);
            if (multiViewDescriptionArray[i] != multiViewModel.getActiveDescription()) continue;
            serializable2 = serializable;
        }
        Enumeration<AbstractButton> enumeration = multiViewModel.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
            serializable = jToggleButton.getBorder().getBorderInsets(jToggleButton);
            jToggleButton.setPreferredSize(new Dimension(n2 + 10, n));
            jToggleButton.setMinimumSize(new Dimension(n2 + 10, n));
        }
        if (serializable2 != null) {
            serializable2.setSelected(true);
        }
        this.toolbarPanel = this.getEmptyInnerToolBar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.bar.add((Component)this.toolbarPanel, gridBagConstraints);
    }

    MultiViewDescription getTopComponentDescription() {
        return this.topBottomDescriptions == null ? this.model.getActiveDescription() : this.topBottomDescriptions[0];
    }

    MultiViewDescription getBottomComponentDescription() {
        return this.topBottomDescriptions == null ? this.model.getActiveDescription() : this.topBottomDescriptions[1];
    }

    void peerClearSplit() {
        MultiViewDescription multiViewDescription = this.topBottomDescriptions[0];
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.getAWTEventListener());
        this.splitPane.removePropertyChangeListener(this.splitterPropertyChangeListener);
        this.removeAll();
        this.splitPane = null;
        this.topBottomDescriptions = null;
        this.isTopLeft = true;
        this.topLeftComponent = null;
        this.bottomRightComponent = null;
        this.alreadyAddedElementsSplit = null;
        this.awtEventListener = null;
        this.barSplit = null;
        this.cardLayoutSplit = null;
        this.componentPanelSplit = null;
        this.toolbarPanelSplit = null;
        this.splitterPropertyChangeListener = null;
        this.mvPeer = null;
        this.add((Component)this.bar, "North");
        this.add((Component)this.componentPanel, "Center");
        this.model.setActiveDescription(multiViewDescription);
    }

    private void setupSplit() {
        Cloneable cloneable;
        Serializable serializable;
        this.topLeftComponent = new JPanel(new BorderLayout());
        this.barMinSize = this.bar.getMinimumSize();
        this.panelMinSizep = this.componentPanel.getMinimumSize();
        this.topLeftComponent.add((Component)this.bar, "North");
        this.topLeftComponent.add((Component)this.componentPanel, "Center");
        this.bottomRightComponent = new JPanel();
        this.barSplit = new JToolBar();
        Border border = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        this.barSplit.setBorder(border);
        this.barSplit.setFloatable(false);
        this.barSplit.setFocusable(true);
        if ("Windows".equals(UIManager.getLookAndFeel().getID()) && !TabsComponent.isXPTheme()) {
            this.barSplit.setRollover(true);
        } else if (AQUA) {
            this.barSplit.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.bottomRightComponent.setLayout(new BorderLayout());
        this.bottomRightComponent.add((Component)this.barSplit, "North");
        this.startTogglingSplit();
        this.setToolbarBarVisibleSplit(this.bar.isVisible());
        this.componentPanelSplit = new JPanel();
        this.cardLayoutSplit = new CardLayout();
        this.componentPanelSplit.setLayout(this.cardLayoutSplit);
        this.bottomRightComponent.add((Component)this.componentPanelSplit, "Center");
        this.alreadyAddedElementsSplit = new HashSet<MultiViewElement>();
        MultiViewDescription[] multiViewDescriptionArray = this.model.getDescriptions();
        MultiViewDescription multiViewDescription = this.model.getActiveDescription();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.barSplit.setLayout(gridBagLayout);
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
            if (!(multiViewDescriptionArray[i] instanceof ContextAwareDescription) || !((ContextAwareDescription)multiViewDescriptionArray[i]).isSplitDescription()) continue;
            serializable = this.createButton(multiViewDescriptionArray[i]);
            this.model.getButtonGroupSplit().add((AbstractButton)serializable);
            cloneable = new GridBagConstraints();
            ((GridBagConstraints)cloneable).anchor = 17;
            n = Math.max(((JComponent)serializable).getPreferredSize().height, n);
            this.barSplit.add((Component)serializable, cloneable);
            n2 = Math.max(((JComponent)serializable).getPreferredSize().width, n2);
        }
        Enumeration<AbstractButton> enumeration = this.model.getButtonGroupSplit().getElements();
        while (enumeration.hasMoreElements()) {
            serializable = (JToggleButton)enumeration.nextElement();
            cloneable = ((JComponent)serializable).getBorder().getBorderInsets((Component)serializable);
            ((JComponent)serializable).setPreferredSize(new Dimension(n2 + 10, n));
            ((JComponent)serializable).setMinimumSize(new Dimension(n2 + 10, n));
        }
        this.toolbarPanelSplit = this.getEmptyInnerToolBar();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).anchor = 13;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        this.barSplit.add((Component)this.toolbarPanelSplit, serializable);
    }

    void peerSplitComponent(int n, MultiViewPeer multiViewPeer, MultiViewDescription multiViewDescription, MultiViewDescription multiViewDescription2) {
        MultiViewDescription[] multiViewDescriptionArray = this.model.getDescriptions();
        this.mvPeer = multiViewPeer;
        MultiViewDescription multiViewDescription3 = this.model.getActiveDescription();
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.topBottomDescriptions = new MultiViewDescription[2];
            if (multiViewDescription != null && multiViewDescription2 != null) {
                this.topBottomDescriptions[0] = multiViewDescription;
                this.topBottomDescriptions[1] = multiViewDescription2;
            } else {
                int n2 = 0;
                for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
                    MultiViewDescription multiViewDescription4 = multiViewDescriptionArray[i];
                    if (!multiViewDescription4.getDisplayName().equals(multiViewDescription3.getDisplayName())) continue;
                    n2 = i;
                    break;
                }
                this.topBottomDescriptions[0] = multiViewDescriptionArray[n2];
                this.topBottomDescriptions[1] = multiViewDescriptionArray[n2 + 1];
            }
            this.setupSplit();
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setContinuousLayout(true);
            this.splitPane.setResizeWeight(0.5);
            this.splitPane.setBorder(BorderFactory.createEmptyBorder());
            this.removeAll();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.getAWTEventListener(), 48L);
            this.add((Component)this.splitPane, "Center");
            MultiViewDescription multiViewDescription5 = this.topBottomDescriptions[1];
            this.isTopLeft = false;
            this.model.setActiveDescription(multiViewDescription5);
            this.syncButtonsWithModel();
            MultiViewDescription multiViewDescription6 = this.topBottomDescriptions[0];
            this.isTopLeft = true;
            this.model.setActiveDescription(multiViewDescription6);
            this.syncButtonsWithModel();
        } else {
            this.topLeftComponent = (JPanel)this.splitPane.getTopComponent();
            this.bottomRightComponent = (JPanel)this.splitPane.getBottomComponent();
        }
        if (n != this.splitPane.getOrientation()) {
            this.splitPane.removePropertyChangeListener(this.splitterPropertyChangeListener);
            this.splitterPropertyChangeListener = null;
        }
        this.splitPane.setOrientation(n);
        this.splitPane.setTopComponent(this.topLeftComponent);
        this.splitPane.setBottomComponent(this.bottomRightComponent);
        this.splitPane.addPropertyChangeListener("dividerLocation", this.getSplitterPropertyChangeListener(n));
        this.topLeftComponent.setMinimumSize(new Dimension(0, 0));
        this.bottomRightComponent.setMinimumSize(new Dimension(0, 0));
    }

    private void syncButtonsWithModel() {
        this.model.setFreezeTabButtons(true);
        Enumeration<AbstractButton> enumeration = this.model.getButtonGroupSplit().getElements();
        while (enumeration.hasMoreElements()) {
            JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
            TabsButtonModel tabsButtonModel = (TabsButtonModel)jToggleButton.getModel();
            MultiViewDescription multiViewDescription = tabsButtonModel.getButtonsDescription();
            if (multiViewDescription != (this.isTopLeft ? this.topBottomDescriptions[0] : this.topBottomDescriptions[1])) continue;
            jToggleButton.setSelected(true);
        }
        this.model.setFreezeTabButtons(false);
    }

    private PropertyChangeListener getSplitterPropertyChangeListener(final int n) {
        if (this.splitterPropertyChangeListener == null) {
            this.splitterPropertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (TabsComponent.this.splitPane != null) {
                        int n8;
                        int n2;
                        int n3;
                        int n4 = Integer.parseInt(propertyChangeEvent.getNewValue().toString());
                        int n5 = TabsComponent.this.splitPane.getDividerSize();
                        if (n == 0) {
                            n3 = TabsComponent.this.splitPane.getHeight();
                            n2 = (int)TabsComponent.this.topLeftComponent.getMinimumSize().getHeight();
                            n8 = (int)TabsComponent.this.bottomRightComponent.getMinimumSize().getHeight();
                        } else {
                            n3 = TabsComponent.this.splitPane.getWidth();
                            n2 = (int)TabsComponent.this.topLeftComponent.getMinimumSize().getWidth();
                            n8 = (int)TabsComponent.this.bottomRightComponent.getMinimumSize().getWidth();
                        }
                        int n6 = n2;
                        int n7 = n3 - n8 - n5;
                        if (n4 <= n6 || n4 >= n7) {
                            TabsComponent.this.removeSplit = true;
                        } else {
                            TabsComponent.this.removeSplit = false;
                        }
                    }
                }
            };
        }
        return this.splitterPropertyChangeListener;
    }

    private AWTEventListener getAWTEventListener() {
        if (this.awtEventListener == null) {
            this.awtEventListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    if (TabsComponent.this.splitPane != null && mouseEvent.getID() == 501) {
                        Component component;
                        MultiViewDescription multiViewDescription = null;
                        Point point = mouseEvent.getLocationOnScreen();
                        SwingUtilities.convertPointFromScreen(point, TabsComponent.this.splitPane);
                        for (component = mouseEvent.getComponent(); component != null && component != TabsComponent.this.splitPane; component = component.getParent()) {
                        }
                        if (component == TabsComponent.this.splitPane && TabsComponent.this.splitPane.getTopComponent().getBounds().contains(point)) {
                            TabsComponent.this.isTopLeft = true;
                            multiViewDescription = TabsComponent.this.topBottomDescriptions[0];
                        } else if (component == TabsComponent.this.splitPane && TabsComponent.this.splitPane.getBottomComponent().getBounds().contains(point)) {
                            TabsComponent.this.isTopLeft = false;
                            multiViewDescription = TabsComponent.this.topBottomDescriptions[1];
                        }
                        if (!(multiViewDescription == null || TabsComponent.this.model.getActiveDescription().equals(multiViewDescription) && ((ContextAwareDescription)TabsComponent.this.model.getActiveDescription()).isSplitDescription() == ((ContextAwareDescription)multiViewDescription).isSplitDescription())) {
                            TabsComponent.this.model.setActiveDescription(multiViewDescription);
                        }
                    } else if (TabsComponent.this.splitPane != null && mouseEvent.getID() == 502 && TabsComponent.this.removeSplit) {
                        if (mouseEvent.getClickCount() != 0) {
                            return;
                        }
                        if (TabsComponent.this.mvPeer != null) {
                            TabsComponent.this.mvPeer.peerClearSplit();
                            TabsComponent.this.bar.setMinimumSize(TabsComponent.this.barMinSize);
                            TabsComponent.this.componentPanel.setMinimumSize(TabsComponent.this.panelMinSizep);
                        }
                        TabsComponent.this.removeSplit = false;
                    }
                }
            };
        }
        return this.awtEventListener;
    }

    private void changeSplitOrientation(int n) {
        this.splitPane.removePropertyChangeListener(this.splitterPropertyChangeListener);
        this.splitterPropertyChangeListener = null;
        this.splitPane.setOrientation(n);
        this.splitPane.setDividerLocation(0.5);
        this.splitPane.addPropertyChangeListener("dividerLocation", this.getSplitterPropertyChangeListener(n));
    }

    boolean isHiddenTriggeredByMultiViewButton() {
        return this.hiddenTriggeredByMultiViewButton;
    }

    boolean isShowing(MultiViewDescription multiViewDescription) {
        if (multiViewDescription == null) {
            return false;
        }
        if (this.splitPane == null) {
            return this.model.getActiveDescription() == multiViewDescription;
        }
        return this.isTopLeft ? this.topBottomDescriptions[1] == multiViewDescription : this.topBottomDescriptions[0] == multiViewDescription;
    }

    void switchToCard(MultiViewElement multiViewElement, String string, boolean bl) {
        if (bl) {
            this.switchToCardSplit(multiViewElement, string);
            return;
        }
        if (!this.alreadyAddedElements.contains(multiViewElement)) {
            this.componentPanel.add((Component)multiViewElement.getVisualRepresentation(), string);
            this.alreadyAddedElements.add(multiViewElement);
        }
        this.cardLayout.show(this.componentPanel, string);
    }

    private void switchToCardSplit(MultiViewElement multiViewElement, String string) {
        if (!this.alreadyAddedElementsSplit.contains(multiViewElement)) {
            this.componentPanelSplit.add((Component)multiViewElement.getVisualRepresentation(), string);
            this.alreadyAddedElementsSplit.add(multiViewElement);
        }
        this.cardLayoutSplit.show(this.componentPanelSplit, string);
    }

    void peerComponentClosed() {
        if (this.componentPanel != null) {
            this.componentPanel.removeAll();
        }
        if (this.alreadyAddedElements != null) {
            this.alreadyAddedElements.clear();
        }
        if (this.componentPanelSplit != null) {
            this.componentPanelSplit.removeAll();
        }
        if (this.alreadyAddedElementsSplit != null) {
            this.alreadyAddedElementsSplit.clear();
        }
    }

    void changeActiveManually(MultiViewDescription multiViewDescription) {
        Enumeration<AbstractButton> enumeration = this.model.getButtonGroup().getElements();
        MultiViewDescription multiViewDescription2 = this.model.getActiveDescription();
        if (multiViewDescription2 instanceof ContextAwareDescription && ((ContextAwareDescription)multiViewDescription2).isSplitDescription()) {
            enumeration = this.model.getButtonGroupSplit().getElements();
        }
        while (enumeration.hasMoreElements()) {
            TabsButtonModel tabsButtonModel;
            JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
            if (!(jToggleButton.getModel() instanceof TabsButtonModel) || !(tabsButtonModel = (TabsButtonModel)jToggleButton.getModel()).getButtonsDescription().getDisplayName().equals(multiViewDescription.getDisplayName())) continue;
            if (this.splitPane != null) {
                this.hiddenTriggeredByMultiViewButton = true;
                if (((ContextAwareDescription)multiViewDescription2).isSplitDescription()) {
                    this.model.getButtonGroupSplit().setSelected(jToggleButton.getModel(), true);
                    this.isTopLeft = false;
                    this.topBottomDescriptions[1] = tabsButtonModel.getButtonsDescription();
                } else {
                    this.model.getButtonGroup().setSelected(jToggleButton.getModel(), true);
                    this.isTopLeft = true;
                    this.topBottomDescriptions[0] = tabsButtonModel.getButtonsDescription();
                }
                this.model.fireActivateCurrent();
                this.hiddenTriggeredByMultiViewButton = false;
                break;
            }
            jToggleButton.setSelected(true);
            MultiViewElement multiViewElement = this.model.getElementForDescription(multiViewDescription);
            multiViewElement.getVisualRepresentation().requestFocus();
            break;
        }
    }

    void changeVisibleManually(MultiViewDescription multiViewDescription) {
        Enumeration<AbstractButton> enumeration = this.model.getButtonGroup().getElements();
        MultiViewDescription multiViewDescription2 = this.model.getActiveDescription();
        if (multiViewDescription2 instanceof ContextAwareDescription && ((ContextAwareDescription)multiViewDescription2).isSplitDescription()) {
            enumeration = this.model.getButtonGroupSplit().getElements();
            multiViewDescription = this.model.getActiveDescription();
        }
        while (enumeration.hasMoreElements()) {
            TabsButtonModel tabsButtonModel;
            JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
            if (!(jToggleButton.getModel() instanceof TabsButtonModel) || !(tabsButtonModel = (TabsButtonModel)jToggleButton.getModel()).getButtonsDescription().equals(multiViewDescription)) continue;
            jToggleButton.setSelected(true);
            break;
        }
    }

    private JToggleButton createButton(MultiViewDescription multiViewDescription) {
        JToggleButton jToggleButton = new JToggleButton();
        Mnemonics.setLocalizedText((AbstractButton)jToggleButton, (String)Actions.cutAmpersand((String)multiViewDescription.getDisplayName()));
        jToggleButton.setModel(new TabsButtonModel(multiViewDescription));
        jToggleButton.setRolloverEnabled(true);
        Border border = this.getButtonBorder();
        if (border != null) {
            jToggleButton.setBorder(border);
        }
        if (AQUA) {
            jToggleButton.putClientProperty("JButton.buttonType", "square");
            jToggleButton.putClientProperty("JComponent.sizeVariant", "small");
        }
        if (this.buttonMouseListener == null) {
            this.buttonMouseListener = new ButtonMouseListener();
        }
        jToggleButton.addMouseListener(this.buttonMouseListener);
        jToggleButton.setToolTipText(NbBundle.getMessage(TabsComponent.class, (String)"TabButton.tool_tip", (Object)jToggleButton.getText()));
        jToggleButton.setFocusable(true);
        jToggleButton.setFocusPainted(true);
        return jToggleButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInnerToolBar(JComponent jComponent, boolean bl) {
        if (bl) {
            this.setInnerToolBarSplit(jComponent);
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.toolbarPanel != null) {
                this.bar.remove(this.toolbarPanel);
            }
            if (jComponent == null) {
                jComponent = this.getEmptyInnerToolBar();
            }
            jComponent.putClientProperty(TOOLBAR_MARKER, "X");
            if (!AQUA) {
                jComponent.setBorder(null);
            } else {
                jComponent.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            }
            this.toolbarPanel = jComponent;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            this.toolbarPanel.setMinimumSize(new Dimension(10, 10));
            this.bar.add((Component)this.toolbarPanel, gridBagConstraints);
            this.bar.revalidate();
            this.bar.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInnerToolBarSplit(JComponent jComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.toolbarPanelSplit != null) {
                this.barSplit.remove(this.toolbarPanelSplit);
            }
            if (jComponent == null) {
                jComponent = this.getEmptyInnerToolBar();
            }
            jComponent.putClientProperty(TOOLBAR_MARKER, "X");
            if (!AQUA) {
                jComponent.setBorder(null);
            } else {
                jComponent.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            }
            this.toolbarPanelSplit = jComponent;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            this.toolbarPanelSplit.setMinimumSize(new Dimension(10, 10));
            this.barSplit.add((Component)this.toolbarPanelSplit, gridBagConstraints);
            this.barSplit.revalidate();
            this.barSplit.repaint();
        }
    }

    void setToolbarBarVisible(boolean bl) {
        if (this.toolbarVisible == bl) {
            return;
        }
        this.toolbarVisible = bl;
        this.bar.setVisible(bl);
    }

    void setToolbarBarVisibleSplit(boolean bl) {
        if (this.toolbarVisible == bl) {
            return;
        }
        this.toolbarVisible = bl;
        this.barSplit.setVisible(bl);
    }

    JComponent getEmptyInnerToolBar() {
        if (this.EMPTY == null) {
            this.EMPTY = new JPanel();
        }
        return this.EMPTY;
    }

    void requestFocusForSelectedButton() {
        this.bar.setFocusable(true);
        Enumeration<AbstractButton> enumeration = this.model.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
            if (!this.model.getButtonGroup().isSelected(jToggleButton.getModel())) continue;
            jToggleButton.requestFocus();
            return;
        }
        throw new IllegalStateException("How come none of the buttons is selected?");
    }

    void requestFocusForPane() {
        this.bar.setFocusable(false);
        this.componentPanel.requestFocus();
    }

    private Border getButtonBorder() {
        if (this.buttonBorder == null) {
            this.buttonBorder = UIManager.getBorder("nb.tabbutton.border");
        }
        return this.buttonBorder;
    }

    public static boolean isXPTheme() {
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return bl == null ? false : bl;
    }

    void startToggling() {
        ActionMap actionMap = this.bar.getActionMap();
        AbstractAction abstractAction = new TogglesGoEastAction();
        actionMap.put("navigateRight", abstractAction);
        InputMap inputMap = this.bar.getInputMap(1);
        abstractAction = new TogglesGoWestAction();
        actionMap.put("navigateLeft", abstractAction);
        abstractAction = new TogglesGoDownAction();
        actionMap.put("TogglesGoDown", abstractAction);
        actionMap.put("navigateUp", abstractAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke("ESCAPE");
        inputMap.put(keyStroke, "TogglesGoDown");
    }

    void startTogglingSplit() {
        ActionMap actionMap = this.barSplit.getActionMap();
        AbstractAction abstractAction = new TogglesGoEastAction();
        actionMap.put("navigateRight", abstractAction);
        InputMap inputMap = this.barSplit.getInputMap(1);
        abstractAction = new TogglesGoWestAction();
        actionMap.put("navigateLeft", abstractAction);
        abstractAction = new TogglesGoDownAction();
        actionMap.put("TogglesGoDown", abstractAction);
        actionMap.put("navigateUp", abstractAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke("ESCAPE");
        inputMap.put(keyStroke, "TogglesGoDown");
    }

    class ButtonMouseListener
    extends MouseAdapter {
        ButtonMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getComponent();
            abstractButton.getModel().setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getComponent();
            abstractButton.getModel().setRollover(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            mouseEvent.consume();
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getComponent();
            MultiViewModel multiViewModel = TabsComponent.this.model;
            if (multiViewModel != null) {
                if (TabsComponent.this.splitPane != null) {
                    ButtonModel buttonModel = abstractButton.getModel();
                    if (buttonModel instanceof TabsButtonModel) {
                        MultiViewDescription multiViewDescription = ((TabsButtonModel)buttonModel).getButtonsDescription();
                        TabsComponent.this.hiddenTriggeredByMultiViewButton = true;
                        if (((ContextAwareDescription)multiViewDescription).isSplitDescription()) {
                            multiViewModel.getButtonGroupSplit().setSelected(abstractButton.getModel(), true);
                            TabsComponent.this.isTopLeft = false;
                            ((TabsComponent)TabsComponent.this).topBottomDescriptions[1] = multiViewDescription;
                        } else {
                            multiViewModel.getButtonGroup().setSelected(abstractButton.getModel(), true);
                            TabsComponent.this.isTopLeft = true;
                            ((TabsComponent)TabsComponent.this).topBottomDescriptions[0] = multiViewDescription;
                        }
                        multiViewModel.fireActivateCurrent();
                        TabsComponent.this.hiddenTriggeredByMultiViewButton = false;
                    }
                    return;
                }
                multiViewModel.getButtonGroup().setSelected(abstractButton.getModel(), true);
                multiViewModel.fireActivateCurrent();
            }
        }
    }

    static class TabsButtonModel
    extends JToggleButton.ToggleButtonModel {
        private MultiViewDescription desc;

        public TabsButtonModel(MultiViewDescription multiViewDescription) {
            this.desc = multiViewDescription;
        }

        public MultiViewDescription getButtonsDescription() {
            return this.desc;
        }
    }

    private class TogglesGoDownAction
    extends AbstractAction {
        private TogglesGoDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TabsComponent.this.changeActiveManually(TabsComponent.this.model.getActiveDescription());
            TabsComponent.this.model.getActiveElement().getVisualRepresentation().requestFocusInWindow();
        }
    }

    private class TogglesGoEastAction
    extends AbstractAction {
        private TogglesGoEastAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MultiViewDescription[] multiViewDescriptionArray = TabsComponent.this.model.getDescriptions();
            MultiViewDescription multiViewDescription = TabsComponent.this.model.getActiveDescription();
            for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
                if (multiViewDescriptionArray[i] != multiViewDescription) continue;
                int n = i + 1;
                if (n >= multiViewDescriptionArray.length) {
                    n = 0;
                }
                TabsComponent.this.changeVisibleManually(multiViewDescriptionArray[n]);
                TabsComponent.this.requestFocusForSelectedButton();
            }
        }
    }

    private class TogglesGoWestAction
    extends AbstractAction {
        private TogglesGoWestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MultiViewDescription[] multiViewDescriptionArray = TabsComponent.this.model.getDescriptions();
            MultiViewDescription multiViewDescription = TabsComponent.this.model.getActiveDescription();
            for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
                if (multiViewDescriptionArray[i] != multiViewDescription) continue;
                int n = i - 1;
                if (n < 0) {
                    n = multiViewDescriptionArray.length - 1;
                }
                TabsComponent.this.changeVisibleManually(multiViewDescriptionArray[n]);
                TabsComponent.this.requestFocusForSelectedButton();
            }
        }
    }
}

