/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.memory;

import com.jrockit.mc.common.IMemberAccessor;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.IDiagnosticCommandService;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.column.ColumnsToolkit;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.rjmx.ui.column.TableColumnComposite;
import com.jrockit.mc.ui.handlers.InFocusHandlerActivator;
import com.jrockit.mc.ui.handlers.MCCommandItem;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.services.IServiceLocator;

public class HeapHistogram
extends MCClientSectionPart {
    private static final Pattern LINE_PATTERN = Pattern.compile("(\\d+)\\s+(\\d+)\\s+(.+)");
    private static final String DIAGNOSTIC_COMMAND = "GC.class_histogram -all=false";
    private final IDiagnosticCommandService service;
    private final Map<String, HistogramItem> model = new HashMap<String, HistogramItem>();
    private TableColumnComposite table;
    private final Action resetAction = new Action(Messages.HeapHistogram_RESET_DELTA_ACTION_TEXT){

        public void run() {
            for (HistogramItem item : HeapHistogram.this.model.values()) {
                item.memoryReference = item.memory;
            }
            HeapHistogram.this.table.getViewer().refresh();
        }
    };
    private final Action updateAction = new Action(Messages.HeapHistogram_UPDATE_ACTION_TEXT, RJMXUIPlugin.getDefault().getMCImageDescriptor("impact_high.png")){

        public void run() {
            try {
                HeapHistogram.this.refreshHandler.execute(null);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final IHandler refreshHandler = new AbstractHandler(){

        public Object execute(ExecutionEvent event) {
            boolean showWarning = ConsolePlugin.getDefault().getPreferenceStore().getBoolean("console.ui.heaphistogram.update.warning");
            boolean doUpdate = false;
            if (showWarning) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)HeapHistogram.this.getSection().getShell(), (String)Messages.HeapHistogram_WARNING_DIALOG_TITLE, (String)Messages.HeapHistogram_JVM_PERFORMANCE_WILL_BE_AFFECTED, (String)Messages.HeapHistogram_SHOW_WARNING_BEFORE_UPDATING, (boolean)true, null, null);
                if (dialog.getReturnCode() == 0) {
                    doUpdate = true;
                    if (!dialog.getToggleState()) {
                        ConsolePlugin.getDefault().getPreferenceStore().setValue("console.ui.heaphistogram.update.warning", false);
                    }
                }
            } else {
                doUpdate = true;
            }
            if (doUpdate) {
                new Job(Messages.HeapHistogram_UPDATING_HEAP_HISTOGRAM){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            final String result = HeapHistogram.this.service.runCtrlBreakHandlerWithResult(HeapHistogram.DIAGNOSTIC_COMMAND);
                            if (!monitor.isCanceled()) {
                                DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!HeapHistogram.this.table.isDisposed()) {
                                            boolean firstUpdate = HeapHistogram.this.model.size() == 0;
                                            HeapHistogram.this.parseHistogram(String.valueOf(result));
                                            if (firstUpdate) {
                                                for (HistogramItem item : HeapHistogram.this.model.values()) {
                                                    item.memoryReference = item.memory;
                                                }
                                            }
                                            HeapHistogram.this.table.getViewer().refresh();
                                            HeapHistogram.this.table.layout();
                                        }
                                    }
                                });
                            }
                            return Status.OK_STATUS;
                        }
                        catch (Exception e) {
                            return new Status(4, "com.jrockit.mc.console.ui", Messages.HeapHistogram_FAILED_TO_UPDATE, (Throwable)e);
                        }
                    }
                }.schedule();
            }
            return null;
        }
    };

    private HeapHistogram(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier, IDiagnosticCommandService service) {
        super(parent, toolkit, style, sectionIdentifier);
        this.service = service;
        this.resetAction.setDescription(Messages.HeapHistogram_RESET_DELTA_ACTION_DESCRIPTION);
        this.resetAction.setToolTipText(Messages.HeapHistogram_RESET_DELTA_ACTION_TOOLTOP);
        this.resetAction.setImageDescriptor(ConsolePlugin.getDefault().getMCImageDescriptor("undo_edit.gif"));
        this.updateAction.setDescription(Messages.HeapHistogram_UPDATE_ACTION_DESCRIPTION);
        this.updateAction.setToolTipText(Messages.HeapHistogram_UPDATE_ACTION_TOOLTIP);
        this.updateAction.setImageDescriptor(((ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class)).getImageDescriptor(ActionFactory.REFRESH.getCommandId()));
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) throws Exception {
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)ConsolePlugin.getDefault().getMCDialogSettings(), (String)this.getSectionIdentifier());
        IColumn classColumn = ColumnsToolkit.createColumn((String)Messages.HeapHistogram_CLASS_COLUMN_TEXT, (String)"name", HistogramItem.GET_CLASS);
        IColumn countColumn = ColumnsToolkit.createComparedColumn((String)Messages.HeapHistogram_INSTANCES_COLUMN_TEXT, (String)"count", HistogramItem.GET_COUNT);
        IColumn bytesColumn = ColumnsToolkit.createComparedColumn((String)Messages.HeapHistogram_SIZE_COLUMN_TEXT, (String)"size", HistogramItem.GET_SIZE);
        IColumn deltaColumn = ColumnsToolkit.createComparedColumn((String)Messages.HeapHistogram_DELTA_COLUMN_TEXT, (String)"delta", HistogramItem.GET_DELTA);
        this.table = new TableColumnComposite(section, 0, settings);
        this.table.addColumns(new IColumn[]{classColumn, countColumn, bytesColumn, deltaColumn});
        this.table.getViewer().setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table.getViewer().setInput(this.model.values());
        InFocusHandlerActivator.install((Control)this.table.getViewer().getControl(), (String)ActionFactory.REFRESH.getCommandId(), (IHandler)this.refreshHandler);
        MenuManager menuManager = this.table.getMenuManager();
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new MCCommandItem((IServiceLocator)this.getFormContainerSite(), ActionFactory.REFRESH));
        menuManager.add((IAction)this.resetAction);
        this.getMCToolBarManager().add((IAction)this.resetAction);
        this.getMCToolBarManager().add((IAction)this.updateAction);
        this.getMCToolBarManager().update();
        return this.table;
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.HeapHistogram_TITLE);
    }

    protected void parseHistogram(String histogram) {
        Matcher m = LINE_PATTERN.matcher(histogram);
        while (m.find()) {
            int count = Integer.parseInt(m.group(1));
            long memory = Long.parseLong(m.group(2));
            String className = m.group(3).trim();
            HistogramItem item = this.model.get(className);
            if (item == null) {
                item = new HistogramItem();
                item.className = className;
                this.model.put(className, item);
            }
            item.count = count;
            item.memory = memory;
        }
    }

    public static HeapHistogram create(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier, IConnectionHandle connection) {
        IDiagnosticCommandService service = (IDiagnosticCommandService)connection.getServiceOrNull(IDiagnosticCommandService.class);
        return service == null ? null : new HeapHistogram(parent, toolkit, style, sectionIdentifier, service);
    }

    private static class HistogramItem {
        String className;
        int count;
        long memory;
        long memoryReference;
        static final IMemberAccessor<String, HistogramItem> GET_CLASS = new IMemberAccessor<String, HistogramItem>(){

            public String getMember(HistogramItem i) {
                return TypeHandling.simplifyType((String)i.className);
            }
        };
        static final IMemberAccessor<Integer, HistogramItem> GET_COUNT = new IMemberAccessor<Integer, HistogramItem>(){

            public Integer getMember(HistogramItem i) {
                return i.count;
            }
        };
        static final IMemberAccessor<IQuantity, HistogramItem> GET_SIZE = new IMemberAccessor<IQuantity, HistogramItem>(){

            public IQuantity getMember(HistogramItem i) {
                return UnitLookup.BYTES.quantity(i.memory);
            }
        };
        static final IMemberAccessor<IQuantity, HistogramItem> GET_DELTA = new IMemberAccessor<IQuantity, HistogramItem>(){

            public IQuantity getMember(HistogramItem i) {
                return UnitLookup.BYTES.quantity(i.memory - i.memoryReference);
            }
        };

        private HistogramItem() {
        }
    }
}

