/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.editor;

import com.jrockit.mc.console.ui.editor.ConsoleEditor;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.core.AdapterUtil;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.ui.formpage.internal.MCFormPage;
import com.jrockit.mc.ui.misc.TemporaryMessage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.osgi.service.prefs.Preferences;

public class ConsoleTab
extends MCFormPage {
    private IMemento defaultConfig;
    private String id;

    public ConsoleTab() {
        super(null, "", "");
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public ConsoleEditor getEditor() {
        return (ConsoleEditor)super.getEditor();
    }

    public IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)AdapterUtil.getAdapter((Object)((Object)this.getEditor()), IConnectionHandle.class);
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.setInput((Object)this.getConnectionHandle());
        if (!this.getConnectionHandle().isConnected()) {
            this.showConnectionLostMessage();
        }
        super.createFormContent(managedForm);
    }

    protected IMemento loadState() {
        try {
            return XMLMemento.createReadRoot((Reader)new StringReader(this.getServerConfiguration().get(this.getId(), "")));
        }
        catch (Exception e) {
            return this.defaultConfig;
        }
    }

    protected IMemento getDefaultConfig() {
        return this.defaultConfig;
    }

    public String getId() {
        return this.id;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.id = config.getAttribute("id");
        this.defaultConfig = XMLMemento.createWriteRoot((String)this.id);
        IConfigurationElement[] ce = config.getChildren("class");
        if (ce.length == 1) {
            ConsoleTab.copyContent(ce[0], this.defaultConfig);
        }
    }

    public void dispose() {
        XMLMemento state = XMLMemento.createWriteRoot((String)this.getId());
        if (this.saveState((IMemento)state)) {
            StringWriter sw = new StringWriter();
            try {
                state.save((Writer)sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getServerConfiguration().put(this.getId(), sw.toString());
        }
        super.dispose();
    }

    protected boolean saveState(IMemento state) {
        return false;
    }

    private Preferences getServerConfiguration() {
        return RJMXPlugin.getDefault().getServerPreferences(this.getConnectionHandle().getServerDescriptor().getGUID());
    }

    private void showConnectionLostMessage() {
        IMessageManager manager = (IMessageManager)this.getAdapter(IMessageManager.class);
        this.showMessage(manager, Messages.ConsoleEditor_CONNECTION_LOST);
    }

    private void showMessage(IMessageManager manager, String stringMessage) {
        TemporaryMessage message = new TemporaryMessage(stringMessage, 3);
        message.setDelay(Integer.MAX_VALUE);
        message.show(manager, this.getSite().getShell().getDisplay());
    }

    protected void disableForm(IManagedForm managedForm, String message) {
        managedForm.getForm().getBody().setLayout((Layout)new FillLayout());
        managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), message, 72);
    }

    private static void copyContent(IConfigurationElement fromElement, IMemento toMemento) {
        String[] stringArray = fromElement.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            toMemento.putString(attr, fromElement.getAttribute(attr));
            ++n2;
        }
        toMemento.putTextData(fromElement.getValue());
        stringArray = fromElement.getChildren();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            ConsoleTab.copyContent((IConfigurationElement)child, toMemento.createChild(child.getName()));
            ++n2;
        }
    }
}

