/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application;

import com.jrockit.mc.rcp.application.ApplicationWorkbenchWindowAdvisor;
import com.jrockit.mc.rcp.application.BlockingWorkbenchErrorHandler;
import com.jrockit.mc.rcp.application.HighContrastModeChangeListener;
import com.jrockit.mc.rcp.application.OpenDocumentEventProcessor;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private final IApplicationContext m_context;
    private final OpenDocumentEventProcessor m_openDocProcessor;
    private AbstractStatusHandler workbenchErrorHandler;

    ApplicationWorkbenchAdvisor(IApplicationContext context, OpenDocumentEventProcessor openDocProcessor) {
        this.m_context = context;
        this.m_openDocProcessor = openDocProcessor;
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(this.m_context, configurer);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        configurer.setSaveAndRestore(true);
        this.initializeHighContrastModeListener();
    }

    private void initializeHighContrastModeListener() {
        Display current = Display.getCurrent();
        current.addListener(39, (Listener)new HighContrastModeChangeListener(current.getHighContrast()));
    }

    public String getInitialWindowPerspectiveId() {
        return "com.jrockit.mc.ui.idesupport.StandardPerspective";
    }

    public void eventLoopIdle(Display display) {
        this.m_openDocProcessor.openFiles();
        super.eventLoopIdle(display);
    }

    public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
        if (this.workbenchErrorHandler == null) {
            this.workbenchErrorHandler = new BlockingWorkbenchErrorHandler();
        }
        return this.workbenchErrorHandler;
    }
}

