/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.startup;

import com.sun.tools.visualvm.modules.startup.Utils;
import com.sun.tools.visualvm.modules.startup.dialogs.StartupDialog;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import org.openide.LifecycleManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;

final class VisualVMStartup
extends ModuleInstall {
    private static final boolean DISABLE_STARTUP_CHECK = Boolean.getBoolean("com.sun.tools.visualvm.modules.startup.DisableStartupCheck");
    private static final ResourceBundle bundle = NbBundle.getBundle(VisualVMStartup.class);
    private static final String ERROR_STARTUP_CAPTION = bundle.getString("VisualVMStartup_ErrorStartupCaption");
    private static final String INCORRECT_VERSION_MSG = bundle.getString("VisualVMStartup_IncorrectVersionMsg");
    private static final String JRE_MSG = bundle.getString("VisualVMStartup_JreMsg");
    private static boolean envChecked = false;

    VisualVMStartup() {
    }

    public void validate() {
        if (!VisualVMStartup.checkEnv()) {
            LifecycleManager.getDefault().exit();
        }
    }

    static synchronized boolean checkEnv() {
        if (envChecked) {
            return true;
        }
        envChecked = true;
        if (DISABLE_STARTUP_CHECK) {
            System.err.println("Starting with com.sun.tools.visualvm.modules.startup.DisableStartupCheck=true");
        } else {
            if (!VisualVMStartup.isJava6or7or8()) {
                VisualVMStartup.displayError6or7or8();
                return false;
            }
            if (!VisualVMStartup.isJDK()) {
                VisualVMStartup.displayErrorJRE();
                return false;
            }
        }
        return true;
    }

    private static void displayError6or7or8() {
        Utils.setSystemLaF();
        JDialog d = StartupDialog.create(ERROR_STARTUP_CAPTION, MessageFormat.format(INCORRECT_VERSION_MSG, System.getProperty("java.specification.version"), VisualVMStartup.getJavaInfo(), VisualVMStartup.getJvmInfo(), System.getProperties().getProperty("java.home", "unknown location")), 0);
        d.setVisible(true);
    }

    private static void displayErrorJRE() {
        Utils.setSystemLaF();
        JDialog d = StartupDialog.create(ERROR_STARTUP_CAPTION, MessageFormat.format(JRE_MSG, VisualVMStartup.getJavaInfo(), VisualVMStartup.getJvmInfo(), System.getProperties().getProperty("java.home", "unknown location")), 0);
        d.setVisible(true);
    }

    private static boolean isJava6or7or8() {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion == null) {
            return false;
        }
        return javaVersion.startsWith("1.6") || javaVersion.startsWith("1.7") || javaVersion.startsWith("1.8");
    }

    private static boolean isJDK() {
        Class<?> vmClass = null;
        try {
            vmClass = Class.forName("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return vmClass != null;
    }

    private static String getJavaInfo() {
        Properties systemProperties = System.getProperties();
        String javaVersion = systemProperties.getProperty("java.version", "unknown version");
        String vendorInfo = systemProperties.getProperty("java.vendor", "unknown vendor");
        return javaVersion + "; " + vendorInfo;
    }

    private static String getJvmInfo() {
        Properties systemProperties = System.getProperties();
        String vmName = systemProperties.getProperty("java.vm.name", "unknown name");
        String vmVerison = systemProperties.getProperty("java.vm.version", "");
        String vmInfo = systemProperties.getProperty("java.vm.info", "");
        return vmName + " (" + vmVerison + ", " + vmInfo + ")";
    }
}

