/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.components.ui.behaviors.ICreatePart;
import com.jrockit.mc.components.ui.behaviors.IShowable;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.design.view.PartHooker;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public final class DesignerComponentView
extends ViewPart {
    public static final String ID = "com.jrockit.mc.components.ui.design.DesignerComponentView";
    private final HashMap<ICreatePart, Control> m_componentLookup = new HashMap();
    private PartHooker m_partHooker;
    private PageBook m_pageBook;
    private Composite m_blank;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.initiliazePartHooker();
    }

    public void createPartControl(Composite parent) {
        this.m_pageBook = new PageBook(parent, 0);
        this.m_blank = this.createBlank();
        this.showInput();
    }

    protected Composite createBlank() {
        return new Composite((Composite)this.m_pageBook, 0);
    }

    private void showInput() {
        Object input = this.getPartHooker().getInput();
        if (this.m_pageBook != null && input instanceof IServiceLocator) {
            Object component = this.getComponent((IServiceLocator)input);
            this.createPartIfNotCreated(component);
            this.show(component);
        }
    }

    private void show(Object component) {
        Control control;
        if (component instanceof IShowable) {
            ((IShowable)component).show();
        }
        if ((control = this.m_componentLookup.get(component)) != null) {
            this.m_pageBook.showPage(control);
        } else {
            this.m_pageBook.showPage((Control)this.m_blank);
        }
    }

    private void createPartIfNotCreated(Object component) {
        ICreatePart createPart;
        Control control;
        if (component instanceof ICreatePart && (control = this.m_componentLookup.get(createPart = (ICreatePart)component)) == null) {
            control = createPart.createPart((Composite)this.m_pageBook);
            this.m_componentLookup.put(createPart, control);
        }
    }

    private Object getComponent(IServiceLocator sl) {
        UIScope components = sl.getService(UIScope.class);
        List<? super Object> comps = components.getComponents();
        if (!comps.isEmpty()) {
            return comps.get(0);
        }
        return null;
    }

    protected PartHooker getPartHooker() {
        return this.m_partHooker;
    }

    private void initiliazePartHooker() {
        this.m_partHooker = new PartHooker((IWorkbenchPart)this);
        this.m_partHooker.addObserver(new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                DesignerComponentView.this.showInput();
            }
        });
        this.m_partHooker.hookPart(this.m_partHooker.getBootstrapPart());
    }

    public void setFocus() {
        if (this.m_pageBook != null && this.m_pageBook.isDisposed()) {
            this.m_pageBook.setFocus();
        }
    }

    public void dispose() {
        if (this.getPartHooker() != null) {
            this.getPartHooker().dispose();
        }
        this.m_componentLookup.clear();
    }
}

