/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.IPersistenceService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRIService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AddAttibutesAction;
import com.jrockit.mc.rjmx.ui.internal.AttributeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.IAttributeSet;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.RemoveAttributeHandler;
import com.jrockit.mc.ui.handlers.MCCommandItem;
import com.jrockit.mc.ui.misc.MCArrayContentProvider;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.services.IServiceLocator;

public class PersistenceSectionPart
extends MCClientSectionPart
implements IAttributeSet {
    private final IPersistenceService manager;
    private final IMRIMetaDataService mds;
    private final IMRIService attributes;
    private TableViewer table;
    private final MenuManager mm = new MenuManager();

    public PersistenceSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier, IConnectionHandle connection) {
        super(parent, toolkit, style, sectionIdentifier);
        this.manager = (IPersistenceService)connection.getServiceOrDummy(IPersistenceService.class);
        this.mds = (IMRIMetaDataService)connection.getServiceOrDummy(IMRIMetaDataService.class);
        this.attributes = (IMRIService)connection.getServiceOrDummy(IMRIService.class);
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) throws Exception {
        Composite container = formToolkit.createComposite(section);
        this.table = new TableViewer(container);
        this.table.setContentProvider((IContentProvider)MCArrayContentProvider.INSTANCE);
        this.table.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider(this.mds, this.attributes));
        this.table.setInput((Object)this);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.table);
        this.getMCToolBarManager().add((IAction)new AddAttibutesAction(this.mds, this.attributes, this));
        this.getMCToolBarManager().add((IAction)new Action(Messages.ConfigurePersistenceAction_ENABLE, 2){
            {
                this.setImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("persistence-toggle-on-16.gif"));
                this.setDisabledImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("persistence-toggle-off-16.gif"));
                this.setToolTipText(Messages.ConfigurePersistenceAction_TOOLTIP_TEXT);
                this.setChecked(PersistenceSectionPart.this.manager.isRunning());
            }

            public void run() {
                if (this.isChecked()) {
                    try {
                        PersistenceSectionPart.this.manager.start();
                    }
                    catch (IOException e1) {
                        RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem activating persistence.", e1);
                    }
                } else {
                    PersistenceSectionPart.this.manager.stop();
                }
            }
        });
        container.setLayout((Layout)new GridLayout());
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = 60;
        this.table.getControl().setLayoutData((Object)gd2);
        this.mm.add((IContributionItem)new MCCommandItem((IServiceLocator)this.getFormContainerSite(), ActionFactory.DELETE));
        this.table.getTable().setMenu(this.mm.createContextMenu((Control)this.table.getTable()));
        RemoveAttributeHandler.install((Viewer)this.table, this);
        return container;
    }

    public void dispose() {
        this.mm.dispose();
        super.dispose();
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.ConfigurePersistenceAction_TEXT);
    }

    public boolean isEmpty() {
        return this.manager.getAttributes().length == 0;
    }

    public MRI[] elements() {
        return this.manager.getAttributes();
    }

    @Override
    public void add(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.manager.add(mri);
            ++n2;
        }
        this.table.refresh();
    }

    @Override
    public void remove(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.manager.remove(mri);
            ++n2;
        }
        this.table.refresh();
    }
}

