/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRIService;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.ui.attributes.MRIAttribute;
import com.jrockit.mc.rjmx.ui.attributes.MRIAttributeInspector;
import com.jrockit.mc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import com.jrockit.mc.rjmx.ui.column.Column;
import com.jrockit.mc.rjmx.ui.column.TreeColumnComposite;
import com.jrockit.mc.rjmx.ui.column.TypedLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.AddAttibutesAction;
import com.jrockit.mc.rjmx.ui.internal.IAttributeSet;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.RemoveAttributeHandler;
import com.jrockit.mc.rjmx.ui.internal.SectionPartManager;
import com.jrockit.mc.ui.handlers.MCCommandItem;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.services.IServiceLocator;

public class AttributeSectionPart
extends MCClientSectionPart
implements IAttributeSet {
    private static final String ATTRIBUTE_ID = "attribute";
    private MRIAttributeInspector inspector;
    private final SectionPartManager sectionPartManager;
    private final IConnectionHandle connection;
    private final IDialogSettings dialogSettings;
    private final Map<MRI, ReadOnlyMRIAttribute> model = new HashMap<MRI, ReadOnlyMRIAttribute>();
    private final IMRIValueListener listener = new IMRIValueListener(){

        public void valueChanged(final MRIValueEvent event) {
            DisplayToolkit.safeAsyncExec((Widget)AttributeSectionPart.this.getSection(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ReadOnlyMRIAttribute attribute;
                    if (!AttributeSectionPart.this.inspector.getControl().isDisposed() && (attribute = (ReadOnlyMRIAttribute)((Object)AttributeSectionPart.this.model.get(event.getSubscriptionAttribute()))) != null) {
                        attribute.updateValue(event.getValue());
                        AttributeSectionPart.this.inspector.getControl().getViewer().update((Object)attribute, null);
                    }
                }
            });
        }
    };

    public AttributeSectionPart(SectionPartManager sectionPartManager, Composite parent, FormToolkit toolkit, int style, String sectionIdentifier, IConnectionHandle connection, IDialogSettings dialogSettings) {
        super(parent, toolkit, style, sectionIdentifier);
        this.sectionPartManager = sectionPartManager;
        this.connection = connection;
        this.dialogSettings = dialogSettings;
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) throws Exception {
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)this.dialogSettings, (String)this.getSectionIdentifier());
        this.inspector = new MRIAttributeInspector(this.sectionPartManager, section, settings, this.connection, true);
        this.getMCToolBarManager().add((IAction)new AddAttibutesAction((IMRIMetaDataService)this.connection.getServiceOrDummy(IMRIMetaDataService.class), (IMRIService)this.connection.getServiceOrDummy(IMRIService.class), this, false), 0);
        TreeColumnComposite tree = this.inspector.getControl();
        tree.getMenuManager().add((IContributionItem)new Separator());
        tree.getMenuManager().add((IContributionItem)new MCCommandItem((IServiceLocator)this.getFormContainerSite(), ActionFactory.DELETE));
        RemoveAttributeHandler.install((Viewer)tree.getViewer(), this);
        tree.addColumns(new Column(Messages.AttributeSectionPart_OBJECT_NAME_COLUMN_HEADER, "objectName", new TypedLabelProvider<ReadOnlyMRIAttribute>(ReadOnlyMRIAttribute.class){

            @Override
            protected String getTextTyped(ReadOnlyMRIAttribute element) {
                return element.getMRI().getObjectName().getCanonicalName();
            }
        }));
        return tree;
    }

    @Override
    public void add(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            if (!this.model.containsKey(mri)) {
                this.model.put(mri, MRIAttribute.create(this.connection, mri));
                ((ISubscriptionService)this.connection.getServiceOrDummy(ISubscriptionService.class)).addMRIValueListener(mri, this.listener);
            }
            ++n2;
        }
        this.inspector.setInput(this.model.values());
    }

    @Override
    public void remove(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.model.remove(mri);
            ((ISubscriptionService)this.connection.getServiceOrDummy(ISubscriptionService.class)).removeMRIValueListener(mri, this.listener);
            ++n2;
        }
        this.inspector.setInput(this.model.values());
    }

    protected void initializeSection(Section section) {
    }

    public void saveState(IMemento state) {
        for (MRI mri : this.model.keySet()) {
            state.createChild(ATTRIBUTE_ID).putTextData(mri.getQualifiedName());
        }
    }

    public void restoreState(IMemento state) {
        this.model.clear();
        IMemento[] iMementoArray = state.getChildren(ATTRIBUTE_ID);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            this.add(MRI.createFromQualifiedName((String)child.getTextData().trim()));
            ++n2;
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public MRI[] elements() {
        return this.model.keySet().toArray(new MRI[this.model.keySet().size()]);
    }
}

