/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRIService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.column.TypedLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.ui.misc.SWTColorToolkit;
import java.awt.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class AttributeLabelProvider
extends TypedLabelProvider<MRI> {
    private final IMRIMetaDataService m_mds;
    private final IMRIService m_availableAttributes;
    private static final RGB UNAVAILABLE_COLOR = new RGB(192, 192, 192);

    public AttributeLabelProvider(IMRIMetaDataService mds, IMRIService availableAttributes) {
        super(MRI.class);
        this.m_mds = mds;
        this.m_availableAttributes = availableAttributes;
    }

    @Override
    protected String getTextTyped(MRI element) {
        return MRIMetaDataToolkit.getDisplayName((IMRIMetaDataService)this.m_mds, (MRI)element);
    }

    @Override
    protected String getToolTipTextTyped(MRI element) {
        String path = MBeanPropertiesOrderer.getAttributePath(element);
        String desc = this.m_mds.getMetaData(element).getDescription();
        return desc == null ? path : String.valueOf(path) + "\n" + desc;
    }

    @Override
    protected Image getImageTyped(MRI mri) {
        if (this.m_availableAttributes.isAttributeAvailable(mri)) {
            Color color = MRIMetaDataToolkit.getColor((IMRIMetaDataProvider)this.m_mds.getMetaData(mri));
            return SWTColorToolkit.getColorThumbnail((RGB)SWTColorToolkit.asRGB((Color)color));
        }
        return SWTColorToolkit.getColorThumbnail((RGB)UNAVAILABLE_COLOR);
    }

    @Override
    protected org.eclipse.swt.graphics.Color getForegroundTyped(MRI element) {
        if (this.m_availableAttributes.isAttributeAvailable(element)) {
            return null;
        }
        return SWTColorToolkit.getColor((RGB)UNAVAILABLE_COLOR);
    }
}

