/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common.integration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.global.Platform;

public class IntegrationUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.integration.Bundle");
    public static final String PLATFORM_JAVA_50 = messages.getString("IntegrationUtils_PlatformJava50");
    public static final String PLATFORM_JAVA_60 = messages.getString("IntegrationUtils_PlatformJava60");
    public static final String PLATFORM_JAVA_70 = messages.getString("IntegrationUtils_PlatformJava70");
    public static final String PLATFORM_JAVA_80 = messages.getString("IntegrationUtils_PlatformJava80");
    public static final String PLATFORM_JAVA_CVM = messages.getString("IntegrationUtils_PlatformJavaCvm");
    public static final String PLATFORM_WINDOWS_OS = messages.getString("IntegrationUtils_PlatformWindowsOs");
    public static final String PLATFORM_WINDOWS_AMD64_OS = messages.getString("IntegrationUtils_PlatformWindowsAmd64Os");
    public static final String PLATFORM_WINDOWS_CVM = messages.getString("IntegrationUtils_PlatformWindowsCvm");
    public static final String PLATFORM_LINUX_OS = messages.getString("IntegrationUtils_PlatformLinuxOs");
    public static final String PLATFORM_LINUX_AMD64_OS = messages.getString("IntegrationUtils_PlatformLinuxAmd64Os");
    public static final String PLATFORM_LINUX_ARM_OS = messages.getString("IntegrationUtils_PlatformLinuxArmOs");
    public static final String PLATFORM_LINUX_CVM = messages.getString("IntegrationUtils_PlatformLinuxCvm");
    public static final String PLATFORM_SOLARIS_INTEL_OS = messages.getString("IntegrationUtils_PlatformSolarisIntelOs");
    public static final String PLATFORM_SOLARIS_AMD64_OS = messages.getString("IntegrationUtils_PlatformSolarisAmd64Os");
    public static final String PLATFORM_SOLARIS_SPARC_OS = messages.getString("IntegrationUtils_PlatformSolarisSparcOs");
    public static final String PLATFORM_SOLARIS_SPARC64_OS = messages.getString("IntegrationUtils_PlatformSolarisSparc64Os");
    public static final String PLATFORM_MAC_OS = messages.getString("IntegrationUtils_PlatformMacOs");
    public static final String MODIFIED_FOR_PROFILER_STRING = messages.getString("IntegrationUtils_ModifiedForProfilerString");
    public static final String ORIGINAL_BACKUP_LOCATION_STRING = messages.getString("IntegrationUtils_OriginalBackupLocationString");
    private static final String APPLICATION_STRING = messages.getString("IntegrationUtils_ApplicationString");
    private static final String APPLET_STRING = messages.getString("IntegrationUtils_AppletString");
    private static final String SERVER_STRING = messages.getString("IntegrationUtils_ServerString");
    private static final String DATABASE_STRING = messages.getString("IntegrationUtils_DatabaseString");
    private static final String TARGET_STRING = messages.getString("IntegrationUtils_TargetString");
    private static final String JDK_50_NAME = messages.getString("IntegrationUtils_Jdk50Name");
    private static final String JDK_60_NAME = messages.getString("IntegrationUtils_Jdk60Name");
    private static final String JDK_70_NAME = messages.getString("IntegrationUtils_Jdk70Name");
    private static final String JDK_80_NAME = messages.getString("IntegrationUtils_Jdk80Name");
    private static final String JDK_CVM_NAME = messages.getString("IntegrationUtils_JdkCvmName");
    private static final String HTML_REMOTE_STRING = "&lt;" + messages.getString("IntegrationUtils_RemoteString") + "&gt;";
    private static final String EXPORT_SETENV_MESSAGE = messages.getString("IntegrationUtils_ExportSetenvMessage");
    private static final String REDUCE_OVERHEAD_MESSAGE = messages.getString("IntegrationUtils_ReduceOverheadMessage");
    private static final String COPY_FILE_NOT_FOUND_MESSAGE = messages.getString("IntegrationUtils_CopyFileNotFoundMessage");
    private static final String COPY_CANNOT_DELETE_FILE_MESSAGE = messages.getString("IntegrationUtils_CopyCannotDeleteFileMessage");
    private static final String COPY_ERROR_MESSAGE = messages.getString("IntegrationUtils_CopyErrorMessage");
    private static final String BACKUP_FILE_NOT_FOUND_MESSAGE = messages.getString("IntegrationUtils_BackupFileNotFoundMessage");
    private static final String BACKUP_CANNOT_DELETE_FILE_MESSAGE = messages.getString("IntegrationUtils_BackupCannotDeleteFileMessage");
    private static final String BACKUP_ERROR_MESSAGE = messages.getString("IntegrationUtils_BackupErrorMessage");
    private static final String BACKUP_ERROR_COPY_FILE_MESSAGE = messages.getString("IntegrationUtils_BackupErrorCopyFileMessage");
    private static final String RESTORE_FILE_NOT_FOUND_MESSAGE = messages.getString("IntegrationUtils_RestoreFileNotFoundMessage");
    private static final String RESTORE_CANNOT_DELETE_FILE_MESSAGE = messages.getString("IntegrationUtils_RestoreCannotDeleteFileMessage");
    private static final String RESTORE_ERROR_MESSAGE = messages.getString("IntegrationUtils_RestoreErrorMessage");
    private static final String MANUAL_REMOTE_STEP1_MESSAGE = messages.getString("IntegrationUtils_ManualRemoteStep1Message");
    private static final String MANUAL_REMOTE_STEP2_MESSAGE = messages.getString("IntegrationUtils_ManualRemoteStep2Message");
    private static final String REMOTE_ABSOLUTE_PATH_HINT = messages.getString("IntegrationUtils_RemoteAbsolutePathHint");
    private static final String SPACES_IN_PATH_WARNING_MSG = messages.getString("IntegrationUtils_SpacesInPathWarningMsg");
    public static final String FILE_BACKUP_EXTENSION = ".backup";
    private static final String BINARIES_TMP_PREFIX = "NBProfiler";
    private static final String BINARIES_TMP_EXT = ".link";

    public static String getAddProfilerLibrariesToPathString(String string, String string2, boolean bl, boolean bl2) {
        return IntegrationUtils.getExportEnvVariableValueString(string, IntegrationUtils.getNativePathEnvVariableString(string), IntegrationUtils.getNativeLibrariesPath(string, string2, bl) + IntegrationUtils.getClassPathSeparator(string) + IntegrationUtils.getEnvVariableReference(IntegrationUtils.getNativePathEnvVariableString(string), string), bl2);
    }

    public static String getAssignEnvVariableValueString(String string, String string2, String string3) {
        string3 = string3.trim();
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return IntegrationUtils.getExportCommandString(string) + " " + string2 + "=" + string3;
        }
        return string2 + "=" + (string3.contains(" ") ? "\"" + string3 + "\"" : string3);
    }

    public static String getBatchExtensionString(String string, String string2) {
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return string2 + ".bat";
        }
        return string2 + ".sh";
    }

    public static String getBatchExtensionString(String string) {
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return ".bat";
        }
        return ".sh";
    }

    public static String getCPUReduceOverheadHint() {
        return REDUCE_OVERHEAD_MESSAGE;
    }

    public static String getDirectorySeparator(String string) {
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return "\\";
        }
        return "/";
    }

    public static String getEnvVariableReference(String string, String string2) {
        if (IntegrationUtils.isWindowsPlatform(string2)) {
            return "%" + string + "%";
        }
        return "$" + string;
    }

    public static String getExportCommandString(String string) {
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return "SET";
        }
        return "export";
    }

    public static String getExportEnvVariableValueString(String string, String string2, String string3, boolean bl) {
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return IntegrationUtils.getAssignEnvVariableValueString(string, string2, string3);
        }
        if (string.equals(PLATFORM_LINUX_OS)) {
            return IntegrationUtils.getExportCommandString(string) + " " + IntegrationUtils.getAssignEnvVariableValueString(string, string2, string3);
        }
        return IntegrationUtils.getAssignEnvVariableValueString(string, string2, string3) + (bl ? "<br>" : IntegrationUtils.getLineBreak(string)) + IntegrationUtils.getExportCommandString(string) + " " + string2;
    }

    public static String getExportVSSetenvNote() {
        return EXPORT_SETENV_MESSAGE;
    }

    public static boolean isFileModifiedForProfiler(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.readLine();
            if (string == null) {
                bufferedReader.close();
                return false;
            }
            if (string.indexOf(MODIFIED_FOR_PROFILER_STRING) != -1) {
                bufferedReader.close();
                return true;
            }
            string = bufferedReader.readLine();
            if (string == null) {
                bufferedReader.close();
                return false;
            }
            if (string.indexOf(MODIFIED_FOR_PROFILER_STRING) != -1) {
                bufferedReader.close();
                return true;
            }
            bufferedReader.close();
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getJavaPlatformFromJavaVersionString(String string) {
        if (string.equals("jdk15")) {
            return PLATFORM_JAVA_50;
        }
        if (string.equals("jdk16")) {
            return PLATFORM_JAVA_60;
        }
        if (string.equals("jdk17")) {
            return PLATFORM_JAVA_70;
        }
        if (string.equals("jdk18")) {
            return PLATFORM_JAVA_80;
        }
        if (string.equals("cvm")) {
            return PLATFORM_JAVA_CVM;
        }
        return null;
    }

    public static String getJavaPlatformName(String string) {
        if (string.equals(PLATFORM_JAVA_50)) {
            return JDK_50_NAME;
        }
        if (string.equals(PLATFORM_JAVA_60)) {
            return JDK_60_NAME;
        }
        if (string.equals(PLATFORM_JAVA_70)) {
            return JDK_70_NAME;
        }
        if (string.equals(PLATFORM_JAVA_80)) {
            return JDK_80_NAME;
        }
        if (string.equals(PLATFORM_JAVA_CVM)) {
            return JDK_CVM_NAME;
        }
        return string;
    }

    public static String getJavaPlatformNativeLibrariesDirectoryName(String string) {
        if (string.equals(PLATFORM_JAVA_50)) {
            return "jdk15";
        }
        if (string.equals(PLATFORM_JAVA_60)) {
            return "jdk16";
        }
        if (string.equals(PLATFORM_JAVA_70)) {
            return "jdk16";
        }
        if (string.equals(PLATFORM_JAVA_80)) {
            return "jdk16";
        }
        if (string.equals(PLATFORM_JAVA_CVM)) {
            return "cvm";
        }
        throw new IllegalArgumentException("Unsupported platform " + string);
    }

    public static String getLibsDir(String string, boolean bl) {
        if (bl) {
            return HTML_REMOTE_STRING + IntegrationUtils.getDirectorySeparator(string) + "lib";
        }
        return Profiler.getDefault().getLibsDir();
    }

    public static String getLineBreak(String string) {
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return "\r\n";
        }
        return "\n";
    }

    public static String getLocalJavaPlatform() {
        int n = Platform.getJDKVersionNumber();
        if (n == 2) {
            return PLATFORM_JAVA_50;
        }
        if (n == 3) {
            return PLATFORM_JAVA_60;
        }
        if (n == 4) {
            return PLATFORM_JAVA_70;
        }
        if (n == 6) {
            return PLATFORM_JAVA_80;
        }
        return null;
    }

    public static String getLocalPlatform(int n) {
        if (n == -1) {
            n = Platform.getSystemArchitecture();
        }
        if (n == 32) {
            if (Platform.isWindows()) {
                return PLATFORM_WINDOWS_OS;
            }
            if (Platform.isLinux()) {
                return PLATFORM_LINUX_OS;
            }
            if (Platform.isSolarisIntel()) {
                return PLATFORM_SOLARIS_INTEL_OS;
            }
            if (Platform.isSolarisSparc()) {
                return PLATFORM_SOLARIS_SPARC_OS;
            }
            if (Platform.isMac()) {
                return PLATFORM_MAC_OS;
            }
            return PLATFORM_SOLARIS_SPARC_OS;
        }
        if (Platform.isWindows()) {
            return PLATFORM_WINDOWS_AMD64_OS;
        }
        if (Platform.isLinux()) {
            return PLATFORM_LINUX_AMD64_OS;
        }
        if (Platform.isSolarisIntel()) {
            return PLATFORM_SOLARIS_AMD64_OS;
        }
        if (Platform.isSolarisSparc()) {
            return PLATFORM_SOLARIS_SPARC64_OS;
        }
        if (Platform.isMac()) {
            return PLATFORM_MAC_OS;
        }
        return PLATFORM_SOLARIS_SPARC64_OS;
    }

    public static String getManualRemoteStep1(String string, String string2) {
        return MessageFormat.format(MANUAL_REMOTE_STEP1_MESSAGE, "JDK 5.0/6.0/7.0/8.0", string, HTML_REMOTE_STRING);
    }

    public static String getManualRemoteStep2(String string, String string2) {
        return MessageFormat.format(MANUAL_REMOTE_STEP2_MESSAGE, IntegrationUtils.getRemoteCalibrateCommandString(string, string2));
    }

    public static String getNativeLibrariesPath(String string, String string2, boolean bl) {
        return IntegrationUtils.getLibsDir(string, bl) + IntegrationUtils.getDirectorySeparator(string) + "deployed" + IntegrationUtils.getDirectorySeparator(string) + IntegrationUtils.getJavaPlatformNativeLibrariesDirectoryName(string2) + IntegrationUtils.getDirectorySeparator(string) + IntegrationUtils.getOSPlatformNativeLibrariesDirectoryName(string, bl);
    }

    public static String getNativePathEnvVariableString(String string) {
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return "Path";
        }
        return "LD_LIBRARY_PATH";
    }

    public static String getOSPlatformNativeLibrariesDirectoryName(String string, boolean bl) {
        if (string.equals(PLATFORM_WINDOWS_OS)) {
            return "windows";
        }
        if (string.equals(PLATFORM_WINDOWS_AMD64_OS)) {
            return "windows-amd64";
        }
        if (string.equals(PLATFORM_LINUX_OS)) {
            return "linux";
        }
        if (string.equals(PLATFORM_LINUX_AMD64_OS)) {
            return "linux-amd64";
        }
        if (string.equals(PLATFORM_LINUX_ARM_OS)) {
            return "linux-arm";
        }
        if (string.equals(PLATFORM_SOLARIS_INTEL_OS)) {
            return "solaris-i386";
        }
        if (string.equals(PLATFORM_SOLARIS_AMD64_OS)) {
            return "solaris-amd64";
        }
        if (string.equals(PLATFORM_SOLARIS_SPARC_OS)) {
            return "solaris-sparc";
        }
        if (string.equals(PLATFORM_SOLARIS_SPARC64_OS)) {
            return "solaris-sparcv9";
        }
        if (string.equals(PLATFORM_MAC_OS)) {
            return "mac";
        }
        return null;
    }

    public static String getClassPathSeparator(String string) {
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return ";";
        }
        return ":";
    }

    public static String getProfilerAgentCommandLineArgs(String string, String string2, boolean bl, int n) {
        return IntegrationUtils.getProfilerAgentCommandLineArgs(string, string2, bl, n, true);
    }

    public static String getProfilerAgentCommandLineArgs(String string, String string2, boolean bl, int n, boolean bl2) {
        if (IntegrationUtils.getNativeLibrariesPath(string, string2, bl).indexOf(32) == -1) {
            return IntegrationUtils.getProfilerAgentCommandLineArgsWithoutQuotes(string, string2, bl, n);
        }
        if (!IntegrationUtils.isWindowsPlatform(string)) {
            String string3 = IntegrationUtils.getLibsDir(string, bl);
            String string4 = IntegrationUtils.getProfilerAgentCommandLineArgsWithoutQuotes(string, string2, bl, n);
            return IntegrationUtils.fixLibsDirPath(string3, string4, bl2);
        }
        return "-agentpath:\"" + IntegrationUtils.getNativeLibrariesPath(string, string2, bl) + IntegrationUtils.getDirectorySeparator(string) + IntegrationUtils.getProfilerAgentLibraryFile(string) + "=" + IntegrationUtils.getLibsDir(string, bl) + "\"" + "," + n;
    }

    public static String fixLibsDirPath(String string, String string2) {
        return IntegrationUtils.fixLibsDirPath(string, string2, true);
    }

    public static String fixLibsDirPath(String string, String string2, boolean bl) {
        if (bl) {
            try {
                File file = File.createTempFile(BINARIES_TMP_PREFIX, BINARIES_TMP_EXT);
                String string3 = file.getAbsolutePath();
                file.delete();
                Runtime.getRuntime().exec(new String[]{"/bin/ln", "-s", string, string3});
                new File(string3).deleteOnExit();
                return string2.replace(string, string3);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return string2.replaceAll("agentpath:(.*?)=(.*?),(.*)", "agentpath:\"$1\"=\"$2\",$3");
    }

    public static String getProfilerAgentCommandLineArgsWithoutQuotes(String string, String string2, boolean bl, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((string2.equals(PLATFORM_JAVA_60) || string2.equals(PLATFORM_JAVA_70) || string2.equals(PLATFORM_JAVA_80)) && IntegrationUtils.isLinuxPlatform(string)) {
            stringBuilder.append(" -XX:+UseLinuxPosixThreadCPUClocks ");
        }
        stringBuilder.append("-agentpath:").append(IntegrationUtils.getNativeLibrariesPath(string, string2, bl)).append(IntegrationUtils.getDirectorySeparator(string)).append(IntegrationUtils.getProfilerAgentLibraryFile(string)).append("=").append(IntegrationUtils.getLibsDir(string, bl)).append(",").append(n);
        return stringBuilder.toString();
    }

    public static String getProfilerAgentCommandLineArgsWithoutQuotes(String string, String string2, boolean bl, int n, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((string2.equals(PLATFORM_JAVA_60) || string2.equals(PLATFORM_JAVA_70) || string2.equals(PLATFORM_JAVA_80)) && IntegrationUtils.isLinuxPlatform(string)) {
            stringBuilder.append(" -XX:+UseLinuxPosixThreadCPUClocks ");
        }
        String string4 = IntegrationUtils.getNativeLibrariesPath(string, string2, bl).replace(" ", string3 != null ? string3 : " ");
        String string5 = IntegrationUtils.getLibsDir(string, bl).replace(" ", string3 != null ? string3 : " ");
        String string6 = IntegrationUtils.getProfilerAgentLibraryFile(string).replace(" ", string3 != null ? string3 : " ");
        stringBuilder.append("-agentpath:").append(string4).append(IntegrationUtils.getDirectorySeparator(string)).append(string6).append("=").append(string5).append(",").append(n);
        return stringBuilder.toString();
    }

    public static String getProfilerAgentLibraryFile(String string) {
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return "profilerinterface.dll";
        }
        if (string.equals(PLATFORM_MAC_OS)) {
            return "libprofilerinterface.jnilib";
        }
        return "libprofilerinterface.so";
    }

    public static String getProfilerModifiedFileHeader(String string) {
        return IntegrationUtils.getSilentScriptCommentSign(string) + " " + MODIFIED_FOR_PROFILER_STRING + IntegrationUtils.getLineBreak(string);
    }

    public static String getProfilerModifiedReplaceFileHeader(String string) {
        return IntegrationUtils.getProfilerModifiedFileHeader(string) + IntegrationUtils.getSilentScriptCommentSign(string) + " " + ORIGINAL_BACKUP_LOCATION_STRING + IntegrationUtils.getLineBreak(string);
    }

    public static String getRemoteAbsolutePathHint() {
        return MessageFormat.format(REMOTE_ABSOLUTE_PATH_HINT, HTML_REMOTE_STRING);
    }

    public static String getRemoteCalibrateCommandString(String string, String string2) {
        String string3 = IntegrationUtils.isLinuxPlatform(string) ? (PLATFORM_JAVA_60.equals(string2) ? "-16" : "-15") : "";
        return HTML_REMOTE_STRING + IntegrationUtils.getDirectorySeparator(string) + "bin" + IntegrationUtils.getDirectorySeparator(string) + "calibrate" + IntegrationUtils.getBatchExtensionString(string, string3);
    }

    public static String getRemoteProfileCommandString(String string, String string2) {
        String string3 = PLATFORM_JAVA_50.equals(string2) ? "-15" : "-16";
        return HTML_REMOTE_STRING + IntegrationUtils.getDirectorySeparator(string) + "bin" + IntegrationUtils.getDirectorySeparator(string) + "profile" + IntegrationUtils.getBatchExtensionString(string, string3);
    }

    public static String getScriptCommentSign(String string) {
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return "rem";
        }
        return "#";
    }

    public static String getSilentScriptCommentSign(String string) {
        if (IntegrationUtils.isWindowsPlatform(string)) {
            return "@rem";
        }
        return "#";
    }

    public static String getSpacesInPathWarning() {
        return SPACES_IN_PATH_WARNING_MSG;
    }

    public static boolean isWindowsPlatform(String string) {
        return string.equals(PLATFORM_WINDOWS_OS) || string.equals(PLATFORM_WINDOWS_AMD64_OS) || string.equals(PLATFORM_WINDOWS_CVM);
    }

    public static boolean isLinuxPlatform(String string) {
        return string.equals(PLATFORM_LINUX_OS) || string.equals(PLATFORM_LINUX_AMD64_OS) || string.equals(PLATFORM_LINUX_ARM_OS) || string.equals(PLATFORM_LINUX_CVM);
    }

    public static String getXMLCommendEndSign() {
        return "-->";
    }

    public static String getXMLCommentStartSign() {
        return "<!--";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean backupFile(File file) {
        File file2 = new File(file.getAbsolutePath());
        File file3 = new File(file2.getAbsolutePath() + FILE_BACKUP_EXTENSION);
        if (!file2.exists()) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_FILE_NOT_FOUND_MESSAGE, file2.getAbsolutePath()));
            return false;
        }
        if (file3.exists() && !file3.delete()) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_CANNOT_DELETE_FILE_MESSAGE, file3.getAbsolutePath()));
            return false;
        }
        if (!file2.renameTo(file3)) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_ERROR_MESSAGE, file2.getAbsolutePath(), file3.getAbsolutePath()));
            return false;
        }
        try {
            file2 = new File(file.getAbsolutePath());
            file2.createNewFile();
            file3 = new File(file2.getAbsolutePath() + FILE_BACKUP_EXTENSION);
            FileChannel fileChannel = new FileOutputStream(file2).getChannel();
            try {
                boolean bl;
                FileChannel fileChannel2 = new FileInputStream(file3).getChannel();
                try {
                    fileChannel2.transferTo(0L, fileChannel2.size(), fileChannel);
                    bl = true;
                }
                catch (Throwable throwable) {
                    fileChannel2.close();
                    throw throwable;
                }
                fileChannel2.close();
                return bl;
            }
            finally {
                fileChannel.close();
            }
        }
        catch (Exception exception) {
            ProfilerLogger.severe((String)MessageFormat.format(BACKUP_ERROR_COPY_FILE_MESSAGE, file3.getAbsolutePath(), file2.getAbsolutePath(), exception));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(File file, File file2) {
        if (!file.exists()) {
            ProfilerLogger.severe((String)MessageFormat.format(COPY_FILE_NOT_FOUND_MESSAGE, file.getAbsolutePath()));
            return false;
        }
        if (file2.exists() && !file2.delete()) {
            ProfilerLogger.severe((String)MessageFormat.format(COPY_CANNOT_DELETE_FILE_MESSAGE, file2.getAbsolutePath()));
            return false;
        }
        try {
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            try {
                boolean bl;
                FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
                try {
                    fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
                    bl = true;
                }
                catch (Throwable throwable) {
                    fileChannel2.close();
                    throw throwable;
                }
                fileChannel2.close();
                return bl;
            }
            finally {
                fileChannel.close();
            }
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            ProfilerLogger.severe((String)MessageFormat.format(COPY_ERROR_MESSAGE, file.getAbsolutePath(), file2.getAbsolutePath()));
            return false;
        }
    }

    public static boolean fileBackupExists(File file) {
        File file2 = new File(file.getAbsolutePath());
        File file3 = new File(file2.getAbsolutePath() + FILE_BACKUP_EXTENSION);
        return file3.exists();
    }

    public static boolean restoreFile(File file) {
        File file2 = file;
        File file3 = new File(file2.getAbsolutePath() + FILE_BACKUP_EXTENSION);
        if (!file3.exists()) {
            ProfilerLogger.severe((String)MessageFormat.format(RESTORE_FILE_NOT_FOUND_MESSAGE, file3.getAbsolutePath(), file2.getAbsolutePath()));
            return false;
        }
        if (file2.exists() && !file2.delete()) {
            ProfilerLogger.severe((String)MessageFormat.format(RESTORE_CANNOT_DELETE_FILE_MESSAGE, file2.getAbsolutePath()));
            return false;
        }
        if (!file3.renameTo(file2)) {
            ProfilerLogger.severe((String)MessageFormat.format(RESTORE_ERROR_MESSAGE, file3.getAbsolutePath(), file2.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public static String getTemporaryBinariesLink(String string) {
        Pattern pattern = Pattern.compile("(/.*?NBProfiler.*?.link)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

