/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.ButtonFactory;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.core.multitabs.impl.ControlsToolbar;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.impl.ScrollAction;
import org.netbeans.core.multitabs.impl.TabTableUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;

abstract class AbstractTabDisplayer
extends TabDisplayer
implements MouseWheelListener {
    protected Controller controller;
    protected final JScrollPane scrollPane;
    protected final int orientation;
    private final JToolBar controls;
    private final JLabel lblFullPath = new JLabel();
    private final ScrollAction scrollLeft;
    private final ScrollAction scrollRight;
    private final ChangeListener fullPathListener;

    public AbstractTabDisplayer(TabDataModel tabDataModel, int n) {
        super(tabDataModel);
        Color color;
        this.setLayout(new BorderLayout(3, 3));
        this.orientation = n == 1 || n == 3 ? 0 : 1;
        this.scrollPane = new JScrollPane();
        this.controls = new ControlsToolbar();
        this.lblFullPath.setBorder(BorderFactory.createEmptyBorder(0, 3, 2, 3));
        Font font = this.lblFullPath.getFont();
        this.lblFullPath.setFont(font.deriveFont(font.getSize2D() - 2.0f));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        if (TabTableUI.IS_AQUA && null != (color = UIManager.getColor("NbSplitPane.background"))) {
            this.setBackground(color);
            this.setOpaque(true);
        }
        switch (n) {
            case 1: 
            case 3: {
                this.add((Component)this.scrollPane, "Center");
                jPanel.add((Component)this.controls, "North");
                this.add((Component)jPanel, "East");
                if (!Settings.getDefault().isShowFullPath()) break;
                this.add((Component)this.lblFullPath, "South");
                break;
            }
            case 2: 
            case 4: {
                this.add((Component)this.scrollPane, "Center");
                jPanel.add((Component)this.controls, "East");
                this.add((Component)jPanel, "North");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid orientation: " + n);
            }
        }
        this.configureScrollPane(this.scrollPane);
        this.scrollLeft = new ScrollAction(this.scrollPane, n, true);
        this.scrollRight = new ScrollAction(this.scrollPane, n, false);
        this.controls.add(ButtonFactory.createScrollLeftButton(tabDataModel, this.scrollLeft));
        this.controls.add(ButtonFactory.createScrollRightButton(tabDataModel, this.scrollRight));
        this.addMouseWheelListener(this);
        ProjectSupport.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractTabDisplayer.this.repaint();
                ProjectSupport.getDefault().removePropertyChangeListener(this);
            }
        });
        this.fullPathListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AbstractTabDisplayer.this.updateFullPath();
            }
        };
    }

    private void configureScrollPane(JScrollPane jScrollPane) {
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setFocusable(false);
        jScrollPane.setWheelScrollingEnabled(false);
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                AbstractTabDisplayer.this.showSelectedTab();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    @Override
    public void attach(Controller controller) {
        this.controller = controller;
        this.controls.add(ButtonFactory.createDropDownButton(controller));
        this.controls.add(ButtonFactory.createMaximizeButton(controller));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (null != this.controller) {
            this.controller.addSelectionChangeListener(this.fullPathListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (null != this.controller) {
            this.controller.removeSelectionChangeListener(this.fullPathListener);
        }
    }

    private void updateFullPath() {
        TabData tabData;
        if (!this.lblFullPath.isVisible() || null == this.controller) {
            return;
        }
        String string = null;
        int n = this.controller.getSelectedIndex();
        if (n >= 0 && null != (tabData = this.tabModel.getTab(n))) {
            string = tabData.getTooltip();
        }
        this.lblFullPath.setText(string);
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.scrollLeft.mouseWheelMoved(mouseWheelEvent);
        if (mouseWheelEvent.isConsumed()) {
            return;
        }
        this.scrollRight.mouseWheelMoved(mouseWheelEvent);
    }

    private void showSelectedTab() {
        if (null == this.controller) {
            return;
        }
        int n = this.controller.getSelectedIndex();
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.getTabBounds(n);
        if (null == rectangle) {
            return;
        }
        this.scrollPane.getViewport().scrollRectToVisible(rectangle);
    }
}

