/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Chunk;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkHeader;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkLoader;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkMetadata;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IByteInput;
import com.jrockit.mc.flightrecorder.internal.parser.binary.RandomAccessFileInput;
import com.jrockit.mc.flightrecorder.internal.parser.binary.RepositoryBuilder;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.GlobalObjectPool;
import com.jrockit.mc.flightrecorder.spi.IRepository;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;

public final class FlightRecordingLoader
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(FlightRecordingLoader.class.getName());
    private final RandomAccessFile raf;
    private final List<ChunkHeader> chunks = new ArrayList<ChunkHeader>();
    private final ITimeRange range;
    private int maxChunkSize;
    private final ILoadingMonitor monitor;
    private static final ILoadingMonitor NOP_MONITOR = new ILoadingMonitor(){

        @Override
        public void setWorkSize(int totalWork) {
        }

        @Override
        public void done() {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public void doWork(int work) {
        }
    };

    public FlightRecordingLoader(File file) throws Exception {
        this(file, NOP_MONITOR);
    }

    public FlightRecordingLoader(File file, ILoadingMonitor monitor) throws Exception {
        this.monitor = monitor;
        this.raf = new RandomAccessFile(file, "r");
        long nextChunkPos = 0L;
        int chunkIndex = 0;
        RandomAccessFileInput input = new RandomAccessFileInput(this.raf, 2000);
        while (nextChunkPos < this.raf.length()) {
            ChunkHeader ch = new ChunkHeader(input, chunkIndex++, nextChunkPos);
            this.chunks.add(ch);
            nextChunkPos += (long)ch.getChunkSize();
            this.maxChunkSize = Math.max(this.maxChunkSize, ch.getChunkSize());
        }
        ChunkMetadata first = new ChunkMetadata(input, this.chunks.get(0));
        ChunkMetadata last = new ChunkMetadata(input, this.chunks.get(this.chunks.size() - 1));
        this.range = new TimeRange(first.getStartTimeNanos(), last.getEndTimeNanos());
    }

    public ITimeRange getRecordingRange() {
        return this.range;
    }

    public FlightRecording load() throws Exception {
        return this.load(null);
    }

    public FlightRecording load(ITimeRange range) throws Exception {
        Runtime rt = Runtime.getRuntime();
        long availableMemory = rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
        int threadCount = (int)Math.min((long)Math.max(rt.availableProcessors(), 2), Math.max(availableMemory / ((long)this.maxChunkSize * 10L), 1L));
        ExecutorService service = Executors.newFixedThreadPool(threadCount);
        ThreadLocal<IByteInput> input = new ThreadLocal<IByteInput>(){

            @Override
            protected IByteInput initialValue() {
                return new RandomAccessFileInput(FlightRecordingLoader.this.raf, FlightRecordingLoader.this.maxChunkSize);
            }
        };
        ArrayList<Future<Chunk>> futures = new ArrayList<Future<Chunk>>();
        GlobalObjectPool globalObjects = new GlobalObjectPool();
        if (range == null) {
            for (ChunkHeader c : this.chunks) {
                futures.add(service.submit(new ChunkLoader(c, null, input, globalObjects)));
            }
        } else {
            RandomAccessFileInput metaDataInput = new RandomAccessFileInput(this.raf, 2000);
            for (ChunkHeader c : this.chunks) {
                ChunkMetadata md = new ChunkMetadata(metaDataInput, c);
                if (md.getEndTimeNanos() <= range.getStartTimestamp() || md.getStartTimeNanos() >= range.getEndTimestamp()) continue;
                futures.add(service.submit(new ChunkLoader(c, md, input, globalObjects)));
            }
        }
        service.shutdown();
        this.monitor.setWorkSize(futures.size());
        RepositoryBuilder repositoryBuilder = new RepositoryBuilder();
        int i = 0;
        while (i < futures.size()) {
            repositoryBuilder.addChunk((Chunk)((Future)futures.get(i)).get());
            this.monitor.doWork(1);
            if (this.monitor.isCanceled()) {
                service.shutdownNow();
                throw new InterruptedException("Canceled");
            }
            ++i;
        }
        IRepository repo = repositoryBuilder.buildRepository(globalObjects.getAllProducers());
        LOGGER.fine("Loaded FlightRecording with " + this.chunks.size() + " chunks, " + repo.getEventTypes().size() + " event types and " + globalObjects.getAllProducers().size() + " producers");
        return new FlightRecording(repo);
    }

    @Override
    public void close() throws IOException {
        IOToolkit.closeSilently((Closeable)this.raf);
    }

    public static FlightRecording loadFile(File file) {
        FlightRecording flightRecording;
        FlightRecordingLoader loader = null;
        try {
            loader = new FlightRecordingLoader(file);
            flightRecording = loader.load();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(loader);
                throw throwable;
            }
        }
        IOToolkit.closeSilently((Closeable)loader);
        return flightRecording;
    }

    public static interface ILoadingMonitor {
        public void setWorkSize(int var1);

        public void done();

        public boolean isCanceled();

        public void doWork(int var1);
    }
}

