/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.ArchiveResources;
import org.netbeans.JarClassLoader;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.NetigsoLoader;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.modules.ModuleInfo;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;

public abstract class NetigsoFramework {
    private ModuleManager mgr;

    protected NetigsoFramework() {
        if (!this.getClass().getName().equals("org.netbeans.core.netigso.Netigso")) {
            throw new IllegalStateException();
        }
    }

    final NetigsoFramework bindTo(ModuleManager moduleManager) {
        try {
            NetigsoFramework netigsoFramework = (NetigsoFramework)this.clone();
            assert (netigsoFramework != this);
            netigsoFramework.mgr = moduleManager;
            return netigsoFramework;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Util.err.log(Level.INFO, null, cloneNotSupportedException);
            this.mgr = moduleManager;
            return this;
        }
    }

    protected abstract void prepare(Lookup var1, Collection<? extends Module> var2);

    protected abstract Set<String> start(Collection<? extends Module> var1);

    protected abstract void start();

    protected abstract void shutdown();

    protected abstract Set<String> createLoader(ModuleInfo var1, ProxyClassLoader var2, File var3) throws IOException;

    protected Enumeration<URL> findResources(Module module, String string) {
        return Enumerations.empty();
    }

    protected abstract void reload(Module var1) throws IOException;

    protected abstract void stopLoader(ModuleInfo var1, ClassLoader var2);

    protected ClassLoader findFrameworkClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected int defaultStartLevel() {
        return 0;
    }

    protected final byte[] fromArchive(ArchiveResources archiveResources, String string) throws IOException {
        return JarClassLoader.archive.getData(archiveResources, string);
    }

    protected final ClassLoader createClassLoader(String string) {
        Module module = this.findModule(string);
        return module == null ? null : new NetigsoLoader(module);
    }

    protected final Module findModule(String string) {
        return this.mgr.get(string);
    }
}

