/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.osx;

import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.HostUtils;
import com.sun.media.jfxmediaimpl.platform.Platform;
import com.sun.media.jfxmediaimpl.platform.osx.OSXMedia;
import com.sun.media.jfxmediaimpl.platform.osx.OSXMediaPlayer;

public final class OSXPlatform
extends Platform {
    private static final String[] CONTENT_TYPES = new String[]{"video/mp4", "audio/x-m4a", "video/x-m4v", "application/vnd.apple.mpegurl", "audio/mpegurl"};

    public static Platform getPlatformInstance() {
        return OSXPlatformInitializer.globalInstance;
    }

    private OSXPlatform() {
    }

    @Override
    public void preloadPlatform() {
    }

    @Override
    public boolean loadPlatform() {
        if (!HostUtils.isMacOSX()) {
            return false;
        }
        try {
            OSXPlatform.osxPlatformInit();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (Logger.canLog(1)) {
                Logger.logMsg(1, "Unable to load OSX platform.");
            }
            return false;
        }
        return true;
    }

    @Override
    public String[] getSupportedContentTypes() {
        String[] stringArray = new String[CONTENT_TYPES.length];
        System.arraycopy(CONTENT_TYPES, 0, stringArray, 0, CONTENT_TYPES.length);
        return stringArray;
    }

    @Override
    public Media createMedia(Locator locator) {
        return new OSXMedia(locator);
    }

    @Override
    public Object prerollMediaPlayer(Locator locator) {
        return new OSXMediaPlayer(locator);
    }

    @Override
    public MediaPlayer createMediaPlayer(Locator locator, Object object) {
        if (object instanceof OSXMediaPlayer) {
            OSXMediaPlayer oSXMediaPlayer = (OSXMediaPlayer)object;
            oSXMediaPlayer.initializePlayer();
            return oSXMediaPlayer;
        }
        return null;
    }

    private static native void osxPlatformInit();

    private static final class OSXPlatformInitializer {
        private static final OSXPlatform globalInstance = new OSXPlatform();

        private OSXPlatformInitializer() {
        }
    }
}

