/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;

public class NGSubScene
extends NGNode {
    private int rtWidth;
    private int rtHeight;
    private RTTexture rtt;
    private RTTexture resolveRTT = null;
    private NGNode root = null;
    private boolean renderSG = true;
    private final boolean depthBuffer;
    private final boolean antiAliasing;
    private Paint fillPaint;
    private NGCamera camera;
    private NGLightBase[] lights;
    private boolean isOpaque = false;

    public NGSubScene(boolean bl, boolean bl2) {
        this.depthBuffer = bl;
        this.antiAliasing = bl2;
    }

    private NGSubScene() {
        this(false, false);
    }

    public void setRoot(NGNode nGNode) {
        this.root = nGNode;
    }

    public void setFillPaint(Object object) {
        this.fillPaint = (Paint)object;
    }

    public void setCamera(NGCamera nGCamera) {
        this.camera = nGCamera == null ? NGCamera.INSTANCE : nGCamera;
    }

    public void setWidth(float f) {
        int n = (int)Math.ceil(f);
        if (this.rtWidth != n) {
            this.rtWidth = n;
            this.geometryChanged();
            this.invalidateRTT();
        }
    }

    public void setHeight(float f) {
        int n = (int)Math.ceil(f);
        if (this.rtHeight != n) {
            this.rtHeight = n;
            this.geometryChanged();
            this.invalidateRTT();
        }
    }

    public NGLightBase[] getLights() {
        return this.lights;
    }

    public void setLights(NGLightBase[] nGLightBaseArray) {
        this.lights = nGLightBaseArray;
    }

    public void markContentDirty() {
        this.visualsChanged();
    }

    @Override
    protected void visualsChanged() {
        this.renderSG = true;
        super.visualsChanged();
    }

    @Override
    protected void geometryChanged() {
        this.renderSG = true;
        super.geometryChanged();
    }

    private void invalidateRTT() {
        if (this.rtt != null) {
            this.rtt.dispose();
            this.rtt = null;
        }
    }

    @Override
    protected boolean hasOverlappingContents() {
        return false;
    }

    private void applyBackgroundFillPaint(Graphics graphics) {
        this.isOpaque = true;
        if (this.fillPaint != null) {
            if (this.fillPaint instanceof Color) {
                Color color = (Color)this.fillPaint;
                this.isOpaque = (double)color.getAlpha() >= 1.0;
                graphics.clear(color);
            } else {
                if (!this.fillPaint.isOpaque()) {
                    graphics.clear();
                    this.isOpaque = false;
                }
                graphics.setPaint(this.fillPaint);
                graphics.fillRect(0.0f, 0.0f, this.rtt.getContentWidth(), this.rtt.getContentHeight());
            }
        } else {
            this.isOpaque = false;
            graphics.clear();
        }
    }

    @Override
    public void renderForcedContent(Graphics graphics) {
        this.root.renderForcedContent(graphics);
    }

    @Override
    protected void renderContent(Graphics graphics) {
        if ((double)this.rtWidth <= 0.0 || (double)this.rtHeight <= 0.0) {
            return;
        }
        if (this.rtt != null) {
            this.rtt.lock();
            if (this.rtt.isSurfaceLost()) {
                this.renderSG = true;
                this.rtt = null;
            }
        }
        if (this.renderSG || !this.root.isClean()) {
            Object object;
            if (this.rtt == null) {
                object = graphics.getResourceFactory();
                this.rtt = object.createRTTexture(this.rtWidth, this.rtHeight, Texture.WrapMode.CLAMP_NOT_NEEDED, this.antiAliasing);
            }
            object = this.rtt.createGraphics();
            object.setLights(this.lights);
            object.setDepthBuffer(this.depthBuffer);
            if (this.camera != null) {
                object.setCamera(this.camera);
            }
            this.applyBackgroundFillPaint((Graphics)object);
            object.setTransform(BaseTransform.IDENTITY_TRANSFORM);
            this.root.render((Graphics)object);
            this.root.clearDirtyTree();
            this.renderSG = false;
        }
        if (this.antiAliasing) {
            int n = this.rtt.getContentX();
            int n2 = this.rtt.getContentY();
            int n3 = n + this.rtt.getContentWidth();
            int n4 = n2 + this.rtt.getContentHeight();
            if ((this.isOpaque || graphics.getCompositeMode() == CompositeMode.SRC) && graphics.getTransformNoClone().isTranslateOrIdentity() && !graphics.isDepthTest()) {
                int n5 = (int)(graphics.getTransformNoClone().getMxt() + 0.5);
                int n6 = (int)(graphics.getTransformNoClone().getMyt() + 0.5);
                int n7 = n + n5;
                int n8 = n2 + n6;
                int n9 = n3 + n5;
                int n10 = n4 + n6;
                int n11 = graphics.getRenderTarget().getContentWidth();
                int n12 = graphics.getRenderTarget().getContentHeight();
                int n13 = n9 > n11 ? n11 - n9 : 0;
                int n14 = n10 > n12 ? n12 - n10 : 0;
                graphics.blit(this.rtt, null, n, n2, n3 + n13, n4 + n14, n7, n8, n9 + n13, n10 + n14);
            } else {
                if (this.resolveRTT != null && (this.resolveRTT.getContentWidth() < this.rtt.getContentWidth() || this.resolveRTT.getContentHeight() < this.rtt.getContentHeight())) {
                    this.resolveRTT.dispose();
                    this.resolveRTT = null;
                }
                if (this.resolveRTT == null || this.resolveRTT.isSurfaceLost()) {
                    this.resolveRTT = graphics.getResourceFactory().createRTTexture(this.rtWidth, this.rtHeight, Texture.WrapMode.CLAMP_NOT_NEEDED, false);
                } else {
                    this.resolveRTT.lock();
                }
                graphics.blit(this.rtt, this.resolveRTT, n, n2, n3, n4, n, n2, n3, n4);
                graphics.drawTexture(this.resolveRTT, this.rtt.getContentX(), this.rtt.getContentY(), this.rtt.getContentWidth(), this.rtt.getContentHeight());
                this.resolveRTT.unlock();
            }
        } else {
            graphics.drawTexture(this.rtt, this.rtt.getContentX(), this.rtt.getContentY(), this.rtt.getContentWidth(), this.rtt.getContentHeight());
        }
        this.rtt.unlock();
    }

    public NGCamera getCamera() {
        return this.camera;
    }
}

