/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.ColorPickerSkin;
import com.sun.javafx.scene.control.skin.CustomColorDialog;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;

public class ColorPalette
extends Region {
    private static final int SQUARE_SIZE = 15;
    private static final int NUM_OF_COLUMNS = 12;
    private static final int NUM_OF_ROWS = 10;
    ColorPickerGrid colorPickerGrid;
    final Hyperlink customColorLink = new Hyperlink(ColorPickerSkin.getString("customColorLink"));
    CustomColorDialog customColorDialog = null;
    private ColorPicker colorPicker;
    private final GridPane customColorGrid = new GridPane();
    private final Separator separator = new Separator();
    private final Label customColorLabel = new Label(ColorPickerSkin.getString("customColorLabel"));
    private final List<ColorSquare> customSquares = FXCollections.observableArrayList();
    private PopupControl popupControl;
    private ColorSquare focusedSquare;
    private ContextMenu contextMenu = null;
    private Color mouseDragColor = null;
    private boolean dragDetected = false;
    private final ColorSquare hoverSquare = new ColorSquare(null);

    public ColorPalette(final ColorPicker colorPicker) {
        this.getStyleClass().add("color-palette-region");
        this.colorPicker = colorPicker;
        this.colorPickerGrid = new ColorPickerGrid();
        this.colorPickerGrid.requestFocus();
        this.colorPickerGrid.setFocusTraversable(true);
        this.customColorLabel.setAlignment(Pos.CENTER_LEFT);
        this.customColorLink.setPrefWidth(this.colorPickerGrid.prefWidth(-1.0));
        this.customColorLink.setAlignment(Pos.CENTER);
        this.customColorLink.setFocusTraversable(true);
        this.customColorLink.setVisited(true);
        this.customColorLink.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                if (ColorPalette.this.customColorDialog == null) {
                    ColorPalette.this.customColorDialog = new CustomColorDialog(ColorPalette.this.popupControl);
                    ColorPalette.this.customColorDialog.customColorProperty().addListener((observableValue, color, color2) -> colorPicker.setValue(ColorPalette.this.customColorDialog.customColorProperty().get()));
                    ColorPalette.this.customColorDialog.setOnSave(() -> {
                        Color color = (Color)ColorPalette.this.customColorDialog.customColorProperty().get();
                        ColorSquare colorSquare = new ColorSquare(color, true);
                        ColorPalette.this.customSquares.add(colorSquare);
                        ColorPalette.this.buildCustomColors();
                        colorPicker.getCustomColors().add(color);
                        ColorPalette.this.updateSelection(color);
                        Event.fireEvent(colorPicker, new ActionEvent());
                        colorPicker.hide();
                    });
                    ColorPalette.this.customColorDialog.setOnUse(() -> {
                        Event.fireEvent(colorPicker, new ActionEvent());
                        colorPicker.hide();
                    });
                }
                ColorPalette.this.customColorDialog.setCurrentColor((Color)colorPicker.valueProperty().get());
                if (ColorPalette.this.popupControl != null) {
                    ColorPalette.this.popupControl.setAutoHide(false);
                }
                ColorPalette.this.customColorDialog.show();
                ColorPalette.this.customColorDialog.setOnHidden(windowEvent -> {
                    if (ColorPalette.this.popupControl != null) {
                        ColorPalette.this.popupControl.setAutoHide(true);
                    }
                });
            }
        });
        this.initNavigation();
        this.customColorGrid.getStyleClass().add("color-picker-grid");
        this.customColorGrid.setVisible(false);
        this.customColorGrid.setFocusTraversable(true);
        for (Color color : colorPicker.getCustomColors()) {
            this.customSquares.add(new ColorSquare(color, true));
        }
        this.buildCustomColors();
        colorPicker.getCustomColors().addListener(new ListChangeListener<Color>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Color> change) {
                ColorPalette.this.customSquares.clear();
                for (Color color : colorPicker.getCustomColors()) {
                    ColorPalette.this.customSquares.add(new ColorSquare(color, true));
                }
                ColorPalette.this.buildCustomColors();
            }
        });
        VBox vBox = new VBox();
        vBox.getStyleClass().add("color-palette");
        vBox.getChildren().addAll((Node[])new Node[]{this.colorPickerGrid, this.customColorLabel, this.customColorGrid, this.separator, this.customColorLink});
        this.hoverSquare.setMouseTransparent(true);
        this.hoverSquare.getStyleClass().addAll((String[])new String[]{"hover-square"});
        this.setFocusedSquare(null);
        this.getChildren().addAll((Node[])new Node[]{vBox, this.hoverSquare});
    }

    private void setFocusedSquare(ColorSquare colorSquare) {
        double d;
        double d2;
        this.focusedSquare = colorSquare;
        this.hoverSquare.setVisible(this.focusedSquare != null);
        if (this.focusedSquare == null) {
            return;
        }
        this.hoverSquare.rectangle.setFill(this.focusedSquare.rectangle.getFill());
        Bounds bounds = colorSquare.localToScene(colorSquare.getLayoutBounds());
        double d3 = bounds.getMinX();
        double d4 = bounds.getMinY();
        double d5 = d2 = this.hoverSquare.getScaleX() == 1.0 ? 0.0 : this.hoverSquare.getWidth() / 4.0;
        if (this.colorPicker.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            d3 = this.focusedSquare.getLayoutX();
            d = -this.focusedSquare.getWidth() + d2;
        } else {
            d = this.focusedSquare.getWidth() / 2.0 + d2;
        }
        this.hoverSquare.setLayoutX(this.snapPosition(d3) - d);
        this.hoverSquare.setLayoutY(this.snapPosition(d4) - this.focusedSquare.getHeight() / 2.0 + (this.hoverSquare.getScaleY() == 1.0 ? 0.0 : this.focusedSquare.getHeight() / 4.0));
    }

    private void buildCustomColors() {
        int n = 0;
        int n2 = 0;
        int n3 = this.customSquares.size() % 12;
        int n4 = n3 == 0 ? 0 : 12 - n3;
        this.customColorGrid.getChildren().clear();
        if (this.customSquares.isEmpty()) {
            this.customColorLabel.setVisible(false);
            this.customColorLabel.setManaged(false);
            this.customColorGrid.setVisible(false);
            this.customColorGrid.setManaged(false);
            return;
        }
        this.customColorLabel.setVisible(true);
        this.customColorLabel.setManaged(true);
        this.customColorGrid.setVisible(true);
        this.customColorGrid.setManaged(true);
        if (this.contextMenu == null) {
            MenuItem menuItem = new MenuItem(ColorPickerSkin.getString("removeColor"));
            menuItem.setOnAction(actionEvent -> {
                ColorSquare colorSquare = (ColorSquare)this.contextMenu.getOwnerNode();
                this.colorPicker.getCustomColors().remove(colorSquare.rectangle.getFill());
                this.customSquares.remove(colorSquare);
                this.buildCustomColors();
            });
            this.contextMenu = new ContextMenu(menuItem);
        }
        for (ColorSquare colorSquare : this.customSquares) {
            this.customColorGrid.add(colorSquare, n, n2);
            if (++n != 12) continue;
            n = 0;
            ++n2;
        }
        for (int i = 0; i < n4; ++i) {
            ColorSquare colorSquare;
            colorSquare = new ColorSquare(null);
            this.customColorGrid.add(colorSquare, n, n2);
            ++n;
        }
        this.requestLayout();
    }

    private void initNavigation() {
        boolean bl = this.colorPicker.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
        this.setOnKeyPressed(keyEvent -> {
            switch (keyEvent.getCode()) {
                case LEFT: {
                    if (bl) {
                        this.processRightKey((KeyEvent)keyEvent);
                    } else {
                        this.processLeftKey((KeyEvent)keyEvent);
                    }
                    keyEvent.consume();
                    break;
                }
                case RIGHT: {
                    if (bl) {
                        this.processLeftKey((KeyEvent)keyEvent);
                    } else {
                        this.processRightKey((KeyEvent)keyEvent);
                    }
                    keyEvent.consume();
                    break;
                }
                case UP: {
                    this.processUpKey((KeyEvent)keyEvent);
                    keyEvent.consume();
                    break;
                }
                case DOWN: {
                    this.processDownKey((KeyEvent)keyEvent);
                    keyEvent.consume();
                    break;
                }
                case SPACE: 
                case ENTER: {
                    this.processSelectKey((KeyEvent)keyEvent);
                    keyEvent.consume();
                    break;
                }
            }
        });
    }

    private void processSelectKey(KeyEvent keyEvent) {
        if (this.focusedSquare != null) {
            this.focusedSquare.selectColor(keyEvent);
        }
    }

    private void processLeftKey(KeyEvent keyEvent) {
        ColorSquare colorSquare;
        int n;
        for (n = 119; n >= 0; --n) {
            ColorSquare colorSquare2 = this.colorPickerGrid.getSquares().get(n);
            if (colorSquare2 != this.focusedSquare) continue;
            ColorSquare colorSquare3 = this.colorPickerGrid.getSquares().get(n != 0 ? n - 1 : 119);
            colorSquare3.requestFocus();
            this.setFocusedSquare(colorSquare3);
            return;
        }
        int n2 = this.customColorGrid.getChildren().size();
        for (n = n2 - 1; n >= 0; --n) {
            colorSquare = (ColorSquare)this.customColorGrid.getChildren().get(n);
            if (colorSquare != this.focusedSquare) continue;
            ColorSquare colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n != 0 ? n - 1 : n2 - 1);
            colorSquare4.requestFocus();
            this.setFocusedSquare(colorSquare4);
            return;
        }
        if (n == -1) {
            colorSquare = this.colorPickerGrid.getSquares().get(119);
            this.setFocusedSquare(colorSquare);
        }
    }

    private void processUpKey(KeyEvent keyEvent) {
        ColorSquare colorSquare;
        int n;
        for (n = 119; n >= 0; --n) {
            ColorSquare colorSquare2 = this.colorPickerGrid.getSquares().get(n);
            if (colorSquare2 != this.focusedSquare) continue;
            ColorSquare colorSquare3 = this.colorPickerGrid.getSquares().get(n - 12 >= 0 ? n - 12 : 108 + n);
            colorSquare3.requestFocus();
            this.setFocusedSquare(colorSquare3);
            return;
        }
        int n2 = this.customColorGrid.getChildren().size();
        for (n = n2 - 1; n >= 0; --n) {
            colorSquare = (ColorSquare)this.customColorGrid.getChildren().get(n);
            ColorSquare colorSquare4 = null;
            if (colorSquare != this.focusedSquare) continue;
            if (n - 12 >= 0) {
                colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n - 12);
            } else {
                int n3 = GridPane.getRowIndex((Node)this.customColorGrid.getChildren().get(n2 - 1));
                colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n3 * 12 + n);
            }
            colorSquare4.requestFocus();
            this.setFocusedSquare(colorSquare4);
            return;
        }
        if (n == -1) {
            colorSquare = this.colorPickerGrid.getSquares().get(119);
            this.setFocusedSquare(colorSquare);
        }
    }

    private void processRightKey(KeyEvent keyEvent) {
        ColorSquare colorSquare;
        int n;
        for (n = 0; n < 120; ++n) {
            ColorSquare colorSquare2 = this.colorPickerGrid.getSquares().get(n);
            if (colorSquare2 != this.focusedSquare) continue;
            ColorSquare colorSquare3 = this.colorPickerGrid.getSquares().get(n != 119 ? n + 1 : 0);
            colorSquare3.requestFocus();
            this.setFocusedSquare(colorSquare3);
            return;
        }
        int n2 = this.customColorGrid.getChildren().size();
        for (n = 0; n < n2; ++n) {
            colorSquare = (ColorSquare)this.customColorGrid.getChildren().get(n);
            if (colorSquare != this.focusedSquare) continue;
            ColorSquare colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n != n2 - 1 ? n + 1 : 0);
            colorSquare4.requestFocus();
            this.setFocusedSquare(colorSquare4);
            return;
        }
        if (n == n2) {
            colorSquare = this.colorPickerGrid.getSquares().get(0);
            this.setFocusedSquare(colorSquare);
        }
    }

    private void processDownKey(KeyEvent keyEvent) {
        ColorSquare colorSquare;
        int n;
        for (n = 0; n < 120; ++n) {
            ColorSquare colorSquare2 = this.colorPickerGrid.getSquares().get(n);
            if (colorSquare2 != this.focusedSquare) continue;
            ColorSquare colorSquare3 = this.colorPickerGrid.getSquares().get(n + 12 < 120 ? n + 12 : n - 108);
            colorSquare3.requestFocus();
            this.setFocusedSquare(colorSquare3);
            return;
        }
        int n2 = this.customColorGrid.getChildren().size();
        for (n = 0; n < n2; ++n) {
            colorSquare = (ColorSquare)this.customColorGrid.getChildren().get(n);
            ColorSquare colorSquare4 = null;
            if (colorSquare != this.focusedSquare) continue;
            if (n + 12 < n2) {
                colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n + 12);
            } else {
                int n3 = GridPane.getRowIndex((Node)this.customColorGrid.getChildren().get(n2 - 1));
                colorSquare4 = (ColorSquare)this.customColorGrid.getChildren().get(n - n3 * 12);
            }
            colorSquare4.requestFocus();
            this.setFocusedSquare(colorSquare4);
            return;
        }
        if (n == n2) {
            colorSquare = this.colorPickerGrid.getSquares().get(0);
            this.setFocusedSquare(colorSquare);
        }
    }

    public void setPopupControl(PopupControl popupControl) {
        this.popupControl = popupControl;
    }

    public ColorPickerGrid getColorGrid() {
        return this.colorPickerGrid;
    }

    public boolean isCustomColorDialogShowing() {
        if (this.customColorDialog != null) {
            return this.customColorDialog.isVisible();
        }
        return false;
    }

    public void clearFocus() {
        this.colorPickerGrid.requestFocus();
    }

    public void updateSelection(Color color) {
        this.setFocusedSquare(null);
        for (ColorSquare colorSquare : this.colorPickerGrid.getSquares()) {
            if (!colorSquare.rectangle.getFill().equals(color)) continue;
            this.setFocusedSquare(colorSquare);
            return;
        }
        for (ColorSquare colorSquare : this.customSquares) {
            if (!colorSquare.rectangle.getFill().equals(color)) continue;
            this.setFocusedSquare(colorSquare);
            return;
        }
    }

    class ColorPickerGrid
    extends GridPane {
        private final List<ColorSquare> squares;
        double[] rawValues = new double[]{255.0, 255.0, 255.0, 242.0, 242.0, 242.0, 230.0, 230.0, 230.0, 204.0, 204.0, 204.0, 179.0, 179.0, 179.0, 153.0, 153.0, 153.0, 128.0, 128.0, 128.0, 102.0, 102.0, 102.0, 77.0, 77.0, 77.0, 51.0, 51.0, 51.0, 26.0, 26.0, 26.0, 0.0, 0.0, 0.0, 0.0, 51.0, 51.0, 0.0, 26.0, 128.0, 26.0, 0.0, 104.0, 51.0, 0.0, 51.0, 77.0, 0.0, 26.0, 153.0, 0.0, 0.0, 153.0, 51.0, 0.0, 153.0, 77.0, 0.0, 153.0, 102.0, 0.0, 153.0, 153.0, 0.0, 102.0, 102.0, 0.0, 0.0, 51.0, 0.0, 26.0, 77.0, 77.0, 26.0, 51.0, 153.0, 51.0, 26.0, 128.0, 77.0, 26.0, 77.0, 102.0, 26.0, 51.0, 179.0, 26.0, 26.0, 179.0, 77.0, 26.0, 179.0, 102.0, 26.0, 179.0, 128.0, 26.0, 179.0, 179.0, 26.0, 128.0, 128.0, 26.0, 26.0, 77.0, 26.0, 51.0, 102.0, 102.0, 51.0, 77.0, 179.0, 77.0, 51.0, 153.0, 102.0, 51.0, 102.0, 128.0, 51.0, 77.0, 204.0, 51.0, 51.0, 204.0, 102.0, 51.0, 204.0, 128.0, 51.0, 204.0, 153.0, 51.0, 204.0, 204.0, 51.0, 153.0, 153.0, 51.0, 51.0, 102.0, 51.0, 77.0, 128.0, 128.0, 77.0, 102.0, 204.0, 102.0, 77.0, 179.0, 128.0, 77.0, 128.0, 153.0, 77.0, 102.0, 230.0, 77.0, 77.0, 230.0, 128.0, 77.0, 230.0, 153.0, 77.0, 230.0, 179.0, 77.0, 230.0, 230.0, 77.0, 179.0, 179.0, 77.0, 77.0, 128.0, 77.0, 102.0, 153.0, 153.0, 102.0, 128.0, 230.0, 128.0, 102.0, 204.0, 153.0, 102.0, 153.0, 179.0, 102.0, 128.0, 255.0, 102.0, 102.0, 255.0, 153.0, 102.0, 255.0, 179.0, 102.0, 255.0, 204.0, 102.0, 255.0, 255.0, 77.0, 204.0, 204.0, 102.0, 102.0, 153.0, 102.0, 128.0, 179.0, 179.0, 128.0, 153.0, 255.0, 153.0, 128.0, 230.0, 179.0, 128.0, 179.0, 204.0, 128.0, 153.0, 255.0, 128.0, 128.0, 255.0, 153.0, 128.0, 255.0, 204.0, 128.0, 255.0, 230.0, 102.0, 255.0, 255.0, 102.0, 230.0, 230.0, 128.0, 128.0, 179.0, 128.0, 153.0, 204.0, 204.0, 153.0, 179.0, 255.0, 179.0, 153.0, 255.0, 204.0, 153.0, 204.0, 230.0, 153.0, 179.0, 255.0, 153.0, 153.0, 255.0, 179.0, 128.0, 255.0, 204.0, 153.0, 255.0, 230.0, 128.0, 255.0, 255.0, 128.0, 230.0, 230.0, 153.0, 153.0, 204.0, 153.0, 179.0, 230.0, 230.0, 179.0, 204.0, 255.0, 204.0, 179.0, 255.0, 230.0, 179.0, 230.0, 230.0, 179.0, 204.0, 255.0, 179.0, 179.0, 255.0, 179.0, 153.0, 255.0, 230.0, 179.0, 255.0, 230.0, 153.0, 255.0, 255.0, 153.0, 230.0, 230.0, 179.0, 179.0, 230.0, 179.0, 204.0, 255.0, 255.0, 204.0, 230.0, 255.0, 230.0, 204.0, 255.0, 255.0, 204.0, 255.0, 255.0, 204.0, 230.0, 255.0, 204.0, 204.0, 255.0, 204.0, 179.0, 255.0, 230.0, 204.0, 255.0, 255.0, 179.0, 255.0, 255.0, 204.0, 230.0, 230.0, 204.0, 204.0, 255.0, 204.0};

        public ColorPickerGrid() {
            this.getStyleClass().add("color-picker-grid");
            this.setId("ColorCustomizerColorGrid");
            int n = 0;
            int n2 = 0;
            this.setFocusTraversable(true);
            this.squares = FXCollections.observableArrayList();
            int n3 = this.rawValues.length / 3;
            Color[] colorArray = new Color[n3];
            for (int i = 0; i < n3; ++i) {
                colorArray[i] = new Color(this.rawValues[i * 3] / 255.0, this.rawValues[i * 3 + 1] / 255.0, this.rawValues[i * 3 + 2] / 255.0, 1.0);
                ColorSquare colorSquare = new ColorSquare(colorArray[i]);
                this.squares.add(colorSquare);
            }
            for (ColorSquare colorSquare : this.squares) {
                this.add(colorSquare, n, n2);
                if (++n != 12) continue;
                n = 0;
                ++n2;
            }
            this.setOnMouseDragged(mouseEvent -> {
                int n;
                int n2;
                int n3;
                if (!ColorPalette.this.dragDetected) {
                    ColorPalette.this.dragDetected = true;
                    ColorPalette.this.mouseDragColor = (Color)ColorPalette.this.colorPicker.getValue();
                }
                if ((n3 = (n2 = (int)(mouseEvent.getX() / 16.0)) + (n = (int)(mouseEvent.getY() / 16.0)) * 12) < 120) {
                    ColorPalette.this.colorPicker.setValue((Color)this.squares.get((int)n3).rectangle.getFill());
                    ColorPalette.this.updateSelection((Color)ColorPalette.this.colorPicker.getValue());
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
                if (ColorPalette.this.colorPickerGrid.getBoundsInLocal().contains(mouseEvent.getX(), mouseEvent.getY())) {
                    ColorPalette.this.updateSelection((Color)ColorPalette.this.colorPicker.getValue());
                    ColorPalette.this.colorPicker.fireEvent(new ActionEvent());
                    ColorPalette.this.colorPicker.hide();
                } else if (ColorPalette.this.mouseDragColor != null) {
                    ColorPalette.this.colorPicker.setValue(ColorPalette.this.mouseDragColor);
                    ColorPalette.this.updateSelection(ColorPalette.this.mouseDragColor);
                }
                ColorPalette.this.dragDetected = false;
            });
        }

        public List<ColorSquare> getSquares() {
            return this.squares;
        }

        @Override
        protected double computePrefWidth(double d) {
            return 192.0;
        }

        @Override
        protected double computePrefHeight(double d) {
            return 160.0;
        }
    }

    class ColorSquare
    extends StackPane {
        Rectangle rectangle;
        boolean isEmpty = false;

        public ColorSquare(Color color) {
            this(color, false);
        }

        public ColorSquare(Color color, boolean bl) {
            this.getStyleClass().add("color-square");
            this.setFocusTraversable(true);
            this.rectangle = new Rectangle(15.0, 15.0);
            if (color == null) {
                this.rectangle.setFill(Color.WHITE);
                this.isEmpty = true;
            } else {
                this.rectangle.setFill(color);
            }
            this.rectangle.setSmooth(false);
            this.rectangle.setStrokeType(StrokeType.INSIDE);
            String string = ColorPickerSkin.tooltipString(color);
            Tooltip.install(this, new Tooltip(string == null ? "" : string));
            this.rectangle.getStyleClass().add("color-rect");
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
                if (!ColorPalette.this.dragDetected && mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 1) {
                    if (!this.isEmpty) {
                        Color color = (Color)this.rectangle.getFill();
                        ColorPalette.this.colorPicker.setValue(color);
                        ColorPalette.this.colorPicker.fireEvent(new ActionEvent());
                        ColorPalette.this.updateSelection(color);
                        mouseEvent.consume();
                    }
                    ColorPalette.this.colorPicker.hide();
                } else if ((mouseEvent.getButton() == MouseButton.SECONDARY || mouseEvent.getButton() == MouseButton.MIDDLE) && bl && ColorPalette.this.contextMenu != null) {
                    if (!ColorPalette.this.contextMenu.isShowing()) {
                        ColorPalette.this.contextMenu.show(this, Side.RIGHT, 0.0, 0.0);
                        Utils.addMnemonics(ColorPalette.this.contextMenu, this.getScene(), ColorPalette.this.colorPicker.impl_isShowMnemonics());
                    } else {
                        ColorPalette.this.contextMenu.hide();
                        Utils.removeMnemonics(ColorPalette.this.contextMenu, this.getScene());
                    }
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, mouseEvent -> ColorPalette.this.setFocusedSquare(this));
            this.addEventHandler(MouseEvent.MOUSE_EXITED, mouseEvent -> ColorPalette.this.setFocusedSquare(null));
            this.getChildren().add(this.rectangle);
        }

        public void selectColor(KeyEvent keyEvent) {
            if (this.rectangle.getFill() != null) {
                if (this.rectangle.getFill() instanceof Color) {
                    ColorPalette.this.colorPicker.setValue((Color)this.rectangle.getFill());
                    ColorPalette.this.colorPicker.fireEvent(new ActionEvent());
                }
                keyEvent.consume();
            }
            ColorPalette.this.colorPicker.hide();
        }
    }
}

