/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.wizards.InstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.OperationDescriptionStep;
import org.netbeans.modules.autoupdate.ui.wizards.OperationPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.netbeans.modules.autoupdate.ui.wizards.UninstallUnitWizardModel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class UninstallStep
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.wizards.UninstallStep");
    private OperationPanel panel;
    private PanelBodyContainer component;
    private UninstallUnitWizardModel model = null;
    private WizardDescriptor wd = null;
    private OperationSupport.Restarter restarter = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final String HEAD_UNINSTALL = "UninstallStep_Header_Uninstall_Head";
    private static final String CONTENT_UNINSTALL = "UninstallStep_Header_Uninstall_Content";
    private static final String HEAD_DEACTIVATE = "UninstallStep_Header_Deactivate_Head";
    private static final String CONTENT_DEACTIVATE = "UninstallStep_Header_Deactivate_Content";
    private static final String HEAD_ACTIVATE = "UninstallStep_Header_Activate_Head";
    private static final String CONTENT_ACTIVATE = "UninstallStep_Header_Activate_Content";
    private static final String HEAD_DEACTIVATE_DONE = "UninstallStep_Header_DeactivateDone_Head";
    private static final String CONTENT_DEACTIVATE_DONE = "UninstallStep_Header_DeactivateDone_Content";
    private static final String HEAD_ACTIVATE_DONE = "UninstallStep_Header_ActivateDone_Head";
    private static final String CONTENT_ACTIVATE_DONE = "UninstallStep_Header_ActivateDone_Content";
    private static final String HEAD_UNINSTALL_DONE = "UninstallStep_Header_UninstallDone_Head";
    private static final String CONTENT_UNINSTALL_DONE = "UninstallStep_Header_UninstallDone_Content";
    private static final String HEAD_DEACTIVATE_FAILED = "UninstallStep_Header_DeactivateFailed_Head";
    private static final String CONTENT_DEACTIVATE_FAILED = "UninstallStep_Header_DeactivateFailed_Content";
    private static final String HEAD_ACTIVATE_FAILED = "UninstallStep_Header_ActivateFailed_Head";
    private static final String CONTENT_ACTIVATE_FAILED = "UninstallStep_Header_ActivateFailed_Content";
    private static final String HEAD_UNINSTALL_FAILED = "UninstallStep_Header_UninstallFailed_Head";
    private static final String CONTENT_UNINSTALL_FAILED = "UninstallStep_Header_UninstallFailed_Content";
    private static final String UNINSTALL_PROGRESS_NAME = "UninstallStep_ProgressName_Uninstall";
    private static final String ACTIVATE_PROGRESS_NAME = "UninstallStep_ProgressName_Activate";
    private static final String DEACTIVATE_PROGRESS_NAME = "UninstallStep_ProgressName_Deactivate";
    private static final String HEAD_RESTART = "UninstallStep_Header_Restart_Head";
    private static final String CONTENT_RESTART = "UninstallStep_Header_Restart_Content";
    private boolean wasStored = false;

    public UninstallStep(UninstallUnitWizardModel uninstallUnitWizardModel) {
        this.model = uninstallUnitWizardModel;
    }

    public boolean isFinishPanel() {
        return true;
    }

    public PanelBodyContainer getComponent() {
        if (this.component == null) {
            this.panel = new OperationPanel(false);
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("run-action".equals(propertyChangeEvent.getPropertyName())) {
                        UninstallStep.this.doAction();
                    }
                }
            });
            switch (this.model.getOperation()) {
                case UNINSTALL: {
                    this.component = new PanelBodyContainer(this.getBundle(HEAD_UNINSTALL, new Object[0]), this.getBundle(CONTENT_UNINSTALL, new Object[0]), this.panel);
                    break;
                }
                case ENABLE: {
                    this.component = new PanelBodyContainer(this.getBundle(HEAD_ACTIVATE, new Object[0]), this.getBundle(CONTENT_ACTIVATE, new Object[0]), this.panel);
                    break;
                }
                case DISABLE: {
                    this.component = new PanelBodyContainer(this.getBundle(HEAD_DEACTIVATE, new Object[0]), this.getBundle(CONTENT_DEACTIVATE, new Object[0]), this.panel);
                    break;
                }
                default: {
                    assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                    break;
                }
            }
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
        }
        return this.component;
    }

    private void doAction() {
        OperationSupport.Restarter restarter = null;
        try {
            restarter = this.handleAction();
            if (restarter != null) {
                this.presentActionNeedsRestart(restarter);
            } else {
                this.presentActionDone();
            }
        }
        catch (OperationException operationException) {
            this.presentActionFailed(operationException);
        }
        this.fireChange();
    }

    private OperationSupport.Restarter handleAction() throws OperationException {
        assert (this.model.getBaseContainer() != null) : "getBaseContainers() returns not null container.";
        OperationSupport operationSupport = (OperationSupport)this.model.getBaseContainer().getSupport();
        assert (operationSupport != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
        ProgressHandle progressHandle = null;
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                progressHandle = ProgressHandleFactory.createHandle((String)this.getBundle(UNINSTALL_PROGRESS_NAME, new Object[0]));
                break;
            }
            case ENABLE: {
                progressHandle = ProgressHandleFactory.createHandle((String)this.getBundle(ACTIVATE_PROGRESS_NAME, new Object[0]));
                break;
            }
            case DISABLE: {
                progressHandle = ProgressHandleFactory.createHandle((String)this.getBundle(DEACTIVATE_PROGRESS_NAME, new Object[0]));
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
        JComponent jComponent = ProgressHandleFactory.createProgressComponent(progressHandle);
        JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
        JLabel jLabel2 = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
        this.model.modifyOptionsForDisabledCancel(this.wd);
        this.panel.waitAndSetProgressComponents(jLabel, jComponent, jLabel2);
        OperationSupport.Restarter restarter = null;
        try {
            restarter = operationSupport.doOperation(progressHandle);
            this.panel.waitAndSetProgressComponents(jLabel, jComponent, new JLabel(this.getBundle("UninstallStep_Done", new Object[0])));
        }
        catch (OperationException operationException) {
            this.err.log(Level.INFO, operationException.getMessage(), operationException);
            this.panel.waitAndSetProgressComponents(jLabel, jComponent, new JLabel(this.getBundle("UninstallStep_Failed", operationException.getLocalizedMessage())));
            throw operationException;
        }
        return restarter;
    }

    private void presentActionDone() {
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.component.setHeadAndContent(this.getBundle(HEAD_UNINSTALL_DONE, new Object[0]), this.getBundle(CONTENT_UNINSTALL_DONE, new Object[0]));
                break;
            }
            case ENABLE: {
                this.component.setHeadAndContent(this.getBundle(HEAD_ACTIVATE_DONE, new Object[0]), this.getBundle(CONTENT_ACTIVATE_DONE, new Object[0]));
                break;
            }
            case DISABLE: {
                this.component.setHeadAndContent(this.getBundle(HEAD_DEACTIVATE_DONE, new Object[0]), this.getBundle(CONTENT_DEACTIVATE_DONE, new Object[0]));
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
        this.model.modifyOptionsForDoClose(this.wd);
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.panel.setBody(this.getBundle("UninstallStep_UninstallDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            case ENABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_ActivateDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            case DISABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_DeactivateDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
    }

    private void presentActionFailed(OperationException operationException) {
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.component.setHeadAndContent(this.getBundle(HEAD_UNINSTALL_FAILED, new Object[0]), this.getBundle(CONTENT_UNINSTALL_FAILED, new Object[0]));
                break;
            }
            case ENABLE: {
                this.component.setHeadAndContent(this.getBundle(HEAD_ACTIVATE_FAILED, new Object[0]), this.getBundle(CONTENT_ACTIVATE_FAILED, new Object[0]));
                break;
            }
            case DISABLE: {
                this.component.setHeadAndContent(this.getBundle(HEAD_DEACTIVATE_FAILED, new Object[0]), this.getBundle(CONTENT_DEACTIVATE_FAILED, new Object[0]));
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
        this.model.modifyOptionsForFailed(this.wd);
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.panel.setBody(this.getBundle("UninstallStep_UninstallFailed_Text", operationException.getLocalizedMessage()), this.model.getAllVisibleUpdateElements());
                break;
            }
            case ENABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_ActivateFailed_Text", operationException.getLocalizedMessage()), OperationDescriptionStep.prepareBrokenDependenciesForShow(this.model));
                break;
            }
            case DISABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_DeactivateFailed_Text", operationException.getLocalizedMessage()), this.model.getAllVisibleUpdateElements());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
    }

    private void presentActionNeedsRestart(OperationSupport.Restarter restarter) {
        this.component.setHeadAndContent(this.getBundle(HEAD_RESTART, new Object[0]), this.getBundle(CONTENT_RESTART, new Object[0]));
        this.model.modifyOptionsForDoClose(this.wd, true);
        this.restarter = restarter;
        this.panel.setRestartButtonsVisible(true);
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.panel.setBody(this.getBundle("UninstallStep_UninstallDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            case ENABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_ActivateDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            case DISABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_DeactivateDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wd = wizardDescriptor;
        this.wasStored = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeSettings(WizardDescriptor wizardDescriptor) {
        assert (!WizardDescriptor.PREVIOUS_OPTION.equals(wizardDescriptor.getValue())) : "Cannot invoke Back in this case.";
        if (this.wasStored) {
            return;
        }
        this.wasStored = true;
        if (WizardDescriptor.CANCEL_OPTION.equals(wizardDescriptor.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wizardDescriptor.getValue())) {
            try {
                this.model.doCleanup(true);
                return;
            }
            catch (OperationException operationException) {
                Logger.getLogger(UninstallStep.class.getName()).log(Level.INFO, operationException.getMessage(), operationException);
            }
            return;
        }
        if (this.restarter != null) {
            final OperationSupport operationSupport = (OperationSupport)this.model.getBaseContainer().getSupport();
            assert (operationSupport != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
            if (this.panel.restartNow()) {
                try {
                    operationSupport.doRestart(this.restarter, null);
                    return;
                }
                catch (OperationException operationException) {
                    this.err.log(Level.INFO, operationException.getMessage(), operationException);
                }
                return;
            }
            operationSupport.doRestartLater(this.restarter);
            try {
                this.model.doCleanup(false);
            }
            catch (OperationException operationException) {
                this.err.log(Level.INFO, operationException.getMessage(), operationException);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        operationSupport.doRestart(UninstallStep.this.restarter, null);
                    }
                    catch (OperationException operationException) {
                        UninstallStep.this.err.log(Level.INFO, operationException.getMessage(), operationException);
                    }
                }
            };
            InstallStep.notifyRestartNeeded(runnable, this.getBundle("UninstallSupport_RestartNeeded", new Object[0]));
            return;
        }
        try {
            this.model.doCleanup(!WizardDescriptor.FINISH_OPTION.equals(wizardDescriptor.getValue()));
            return;
        }
        catch (OperationException operationException) {
            this.err.log(Level.INFO, operationException.getMessage(), operationException);
        }
    }

    public boolean isValid() {
        return true;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        UninstallStep uninstallStep = this;
        synchronized (uninstallStep) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(InstallStep.class, (String)string, (Object[])objectArray);
    }
}

