/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml;

import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLAttribute;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLAttributeInstance;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLNodeType;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class XMLTagInstance {
    private final List<XMLAttributeInstance> m_attributeInstances = new ArrayList<XMLAttributeInstance>();
    private final List<XMLTagInstance> m_childElements = new ArrayList<XMLTagInstance>();
    private final XMLTag m_tag;
    private final XMLTagInstance m_parent;
    private String m_content = "";

    XMLTagInstance(XMLTagInstance parent, XMLTag tag) {
        this.m_parent = parent;
        this.m_tag = tag;
    }

    public XMLTag getTag() {
        return this.m_tag;
    }

    public List<XMLAttributeInstance> getAttributeInstances() {
        return this.m_attributeInstances;
    }

    public List<XMLTagInstance> getTagsInstances() {
        return this.m_childElements;
    }

    public XMLTagInstance getParent() {
        return this.m_parent;
    }

    public XMLTagInstance create(String tag, Map<String, String> attributes) {
        for (XMLTag xmlTag : this.getTag().getTags()) {
            if (!tag.equalsIgnoreCase(xmlTag.getName())) continue;
            XMLTagInstance element = new XMLTagInstance(this, xmlTag);
            for (XMLAttribute attribute : xmlTag.getAttributes()) {
                XMLAttributeInstance ia = new XMLAttributeInstance(attribute);
                element.getAttributeInstances().add(ia);
                if (!attributes.containsKey(attribute.getName())) continue;
                ia.setValue(attributes.get(attribute.getName()));
            }
            this.m_childElements.add(element);
            return element;
        }
        throw new IllegalArgumentException(String.valueOf(tag) + " is not allowed under " + this.getTag().getName());
    }

    public boolean remove(XMLTagInstance instance) {
        return this.m_childElements.remove(instance);
    }

    public void setContent(String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content can't be null. Use empty string if missing");
        }
        this.m_content = content;
    }

    public boolean hasContent() {
        return this.getTag().getType() == XMLNodeType.ELEMENT_WITH_CONTENT;
    }

    public XMLTagInstance create(XMLTag tag) {
        return this.create(tag.getName(), new HashMap<String, String>());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(this.getTag().getName());
        for (XMLAttributeInstance a : this.getAttributeInstances()) {
            builder.append(" ");
            builder.append(a.getAttribute().getName());
            builder.append("=\"");
            builder.append(a.getValue());
            builder.append("\"");
        }
        builder.append("/>");
        return builder.toString();
    }

    public String getValue(XMLAttribute attribute) {
        for (XMLAttributeInstance i : this.m_attributeInstances) {
            if (!i.getAttribute().equals(attribute)) continue;
            return i.getValue();
        }
        throw new IllegalArgumentException("Unknown attribute '" + attribute.getName() + "' in element '" + this.getTag().getName() + "'");
    }

    public boolean setValue(XMLAttribute attribute, String newValue) {
        for (XMLAttributeInstance i : this.m_attributeInstances) {
            if (!i.getAttribute().equals(attribute)) continue;
            return i.setValue(newValue);
        }
        throw new IllegalArgumentException("Unknown attribute '" + attribute.getName() + "' in element '" + this.getTag().getName() + "'");
    }

    public List<XMLTagInstance> getTagsInstances(XMLTag tag) {
        ArrayList<XMLTagInstance> elements = new ArrayList<XMLTagInstance>();
        for (XMLTagInstance element : this.m_childElements) {
            if (element.getTag() != tag) continue;
            elements.add(element);
        }
        return elements;
    }

    public XMLTagInstance findTagWithAttribute(XMLTag tag, XMLAttribute attribute, String value) {
        for (XMLTagInstance element : this.m_childElements) {
            if (element.getTag() != tag || !value.equals(element.getValue(attribute))) continue;
            return element;
        }
        return null;
    }

    public String getContent() {
        if (this.hasContent()) {
            return this.m_content;
        }
        return "";
    }
}

