/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.LogRecord;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.uihandler.Bundle;
import org.netbeans.modules.uihandler.Installer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.io.NbObjectInputStream;
import org.openide.windows.WindowManager;

class AfterRestartExceptions
implements Runnable {
    private static final Set<String> scheduledThrowableClasses = new HashSet<String>(Arrays.asList(OutOfMemoryError.class.getName(), "org.netbeans.modules.deadlock.detector.Detector$DeadlockDetectedException"));
    private static final Object IOLock = new Object();
    private static volatile Set<LogRecord> afterRestartRecords;

    private AfterRestartExceptions() {
    }

    static boolean schedule(LogRecord logRecord) {
        Throwable throwable;
        Throwable throwable2 = logRecord.getThrown();
        if (throwable2 == null) {
            return false;
        }
        while ((throwable = throwable2.getCause()) != null && throwable.getStackTrace().length != 0) {
            throwable2 = throwable;
        }
        String string = throwable2.getClass().getName();
        if (scheduledThrowableClasses.contains(string)) {
            if (OutOfMemoryError.class.getName().equals(string)) {
                AfterRestartExceptions.addHeapDump(logRecord);
            }
            return AfterRestartExceptions.save(logRecord);
        }
        return false;
    }

    private static File getLogRecordsFile() {
        File file = Installer.logsDirectory();
        if (file == null) {
            return null;
        }
        return new File(file, AfterRestartExceptions.class.getSimpleName());
    }

    private static void addHeapDump(LogRecord logRecord) {
        File file = Installer.getHeapDump();
        if (file != null) {
            String string = file.getAbsolutePath();
            Object[] objectArray = logRecord.getParameters();
            if (objectArray == null) {
                objectArray = new Object[]{string};
            } else {
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray.length] = string;
                objectArray = objectArray2;
            }
            logRecord.setParameters(objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean save(LogRecord logRecord) {
        File file = AfterRestartExceptions.getLogRecordsFile();
        ObjectOutputStream objectOutputStream = null;
        Object object = IOLock;
        synchronized (object) {
            boolean bl;
            try {
                objectOutputStream = new ObjectOutputStream(new FileOutputStream(file, true));
                objectOutputStream.writeObject(logRecord);
                bl = true;
            }
            catch (IOException iOException) {
                boolean bl2 = false;
                return bl2;
            }
            return bl;
            finally {
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException3) {}
                }
            }
        }
    }

    static void report() {
        if (AfterRestartExceptions.readRecords()) {
            WindowManager.getDefault().invokeWhenUIReady((Runnable)new AfterRestartExceptions());
        }
    }

    static boolean isAfterRestartRecord(LogRecord logRecord) {
        Set<LogRecord> set = afterRestartRecords;
        return set != null && set.contains(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean readRecords() {
        File file = AfterRestartExceptions.getLogRecordsFile();
        if (file == null || !file.exists()) {
            return false;
        }
        LinkedHashSet<LogRecord> linkedHashSet = new LinkedHashSet<LogRecord>();
        ObjectInputStream objectInputStream = null;
        Object object = IOLock;
        synchronized (object) {
            try {
                objectInputStream = new NbObjectInputStream((InputStream)new FileInputStream(file));
                while (true) {
                    Object object2;
                    if (!((object2 = objectInputStream.readObject()) instanceof LogRecord)) {
                        continue;
                    }
                    linkedHashSet.add((LogRecord)object2);
                }
            }
            catch (IOException iOException) {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                file.delete();
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                file.delete();
                catch (Throwable throwable) {
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    file.delete();
                    throw throwable;
                }
            }
        }
        if (linkedHashSet.isEmpty()) {
            return false;
        }
        afterRestartRecords = linkedHashSet;
        return true;
    }

    @Override
    public void run() {
        final Set<LogRecord> set = afterRestartRecords;
        String string = Bundle.MSG_AfterRestartReportQuestion();
        String string2 = Bundle.TTL_AfterRestartReport();
        int n = 3;
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)Bundle.BTN_ReviewAndReport());
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, string2, n, 3, new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton);
        Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
        if (object == jButton) {
            Installer.RP.post(new Runnable(){

                @Override
                public void run() {
                    Installer.displaySummary("ERROR_URL", true, false, true, Installer.DataType.DATA_UIGESTURE, new ArrayList<LogRecord>(set), null, true);
                    Installer.setSelectedExcParams(null);
                    afterRestartRecords = null;
                }
            });
            return;
        }
    }
}

