/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.exceptions;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import org.netbeans.lib.uihandler.BugTrackingAccessor;
import org.netbeans.modules.exceptions.ExceptionsSettings;
import org.netbeans.modules.uihandler.Installer;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ReporterResultTopComponent
extends TopComponent
implements HyperlinkListener {
    private static ReporterResultTopComponent instance;
    private static final RequestProcessor RP;
    private static final Logger LOG;
    private static boolean showUpload;
    private static final String ICON_PATH = "org/netbeans/modules/exceptions/reporter.png";
    private static final String PREFERRED_ID = "ReporterResultTopComponent";
    private JEditorPane dataDisplayer;
    private JButton jButton1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    private ReporterResultTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"CTL_ReporterResultTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"HINT_ReporterResultTopComponent"));
        this.dataDisplayer.addHyperlinkListener(this);
        this.dataDisplayer.setContentType("text/html");
        this.dataDisplayer.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        Image image = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
        this.setIcon(image);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.dataDisplayer = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.dataDisplayer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.dataDisplayer.setEditable(false);
        this.jScrollPane1.setViewportView(this.dataDisplayer);
        this.add(this.jScrollPane1, "Center");
        this.jPanel1.setPreferredSize(new Dimension(320, 35));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ReporterResultTopComponent.class, (String)"ReporterResultTopComponent.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReporterResultTopComponent.this.jButton1ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jButton1).addContainerGap(173, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.add(this.jPanel1, "First");
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        RP.post((Runnable)new URLDisplayer(true));
    }

    public static synchronized ReporterResultTopComponent getDefault() {
        if (instance == null) {
            instance = new ReporterResultTopComponent();
        }
        return instance;
    }

    public static synchronized ReporterResultTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(ReporterResultTopComponent.class.getName()).warning("Cannot find ReporterResultTopComponent component. It will not be located properly in the window system.");
            return ReporterResultTopComponent.getDefault();
        }
        if (topComponent instanceof ReporterResultTopComponent) {
            return (ReporterResultTopComponent)topComponent;
        }
        Logger.getLogger(ReporterResultTopComponent.class.getName()).warning("There seem to be multiple components with the 'ReporterResultTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ReporterResultTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        if (showUpload) {
            return;
        }
        RP.post((Runnable)new URLDisplayer(false));
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public static void showUploadDone(final URL uRL) {
        if (EventQueue.isDispatchThread()) {
            try {
                ReporterResultTopComponent.findInstance().showUploadDoneImpl(uRL);
            }
            catch (IOException iOException) {
                ReporterResultTopComponent.handleIOException(uRL, iOException);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReporterResultTopComponent.findInstance().showUploadDoneImpl(uRL);
                    }
                    catch (IOException iOException) {
                        ReporterResultTopComponent.handleIOException(uRL, iOException);
                    }
                }
            });
        }
    }

    private void showUploadDoneImpl(URL uRL) throws IOException {
        assert (EventQueue.isDispatchThread());
        showUpload = true;
        this.open();
        showUpload = false;
        this.loadPage(uRL, true);
    }

    private void loadPage(URL uRL, boolean bl) {
        assert (EventQueue.isDispatchThread());
        this.dataDisplayer.setText(ReporterResultTopComponent.getLoadingPage(uRL));
        RP.post((Runnable)new PageUploader(uRL, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL uploadURL(URL uRL) throws IOException {
        assert (!EventQueue.isDispatchThread());
        File file = File.createTempFile("loading", ".html");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setReadTimeout(200000);
            uRLConnection.setDoOutput(false);
            uRLConnection.setDoInput(true);
            uRLConnection.setRequestProperty("User-Agent", "NetBeans");
            InputStream inputStream = uRLConnection.getInputStream();
            if (inputStream == null) {
                throw new IOException("Null input stream from " + uRLConnection);
            }
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
            }
            finally {
                inputStream.close();
            }
        }
        finally {
            fileOutputStream.close();
        }
        return Utilities.toURI((File)file).toURL();
    }

    private static void handleIOException(URL uRL, IOException iOException) {
        ReporterResultTopComponent.handleIOException(uRL.toString(), iOException);
    }

    private static void handleIOException(final String string, IOException iOException) {
        LOG.log(Level.INFO, "URL Loading failed", iOException);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                instance.dataDisplayer.setText(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"no_data_found", (Object)string));
            }
        });
    }

    private static String getLoadingPage(URL uRL) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><head><title></title></head><body>");
        stringBuilder.append(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"LoadingMessage"));
        stringBuilder.append("<a href=\"").append(uRL.toString()).append("\">").append(uRL).append("</a>");
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    @Override
    public void hyperlinkUpdate(final HyperlinkEvent hyperlinkEvent) {
        if (!HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
            return;
        }
        BugTrackingAccessor bugTrackingAccessor = (BugTrackingAccessor)Lookup.getDefault().lookup(BugTrackingAccessor.class);
        if (bugTrackingAccessor != null) {
            SimpleAttributeSet simpleAttributeSet;
            Object object;
            AttributeSet attributeSet = hyperlinkEvent.getSourceElement().getAttributes();
            Object object2 = attributeSet.getAttribute(HTML.getTag("a"));
            if (object2 instanceof SimpleAttributeSet && (object = (simpleAttributeSet = (SimpleAttributeSet)object2).getAttribute(HTML.getAttributeKey("id"))) != null) {
                try {
                    Integer.parseInt(object.toString());
                    LOG.log(Level.FINE, "Open issue {0}", object);
                    bugTrackingAccessor.openIssue(object.toString());
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.log(Level.INFO, "Invalid id attribute", numberFormatException);
                }
            }
        } else {
            LOG.log(Level.INFO, "Bugzilla Accessor not found");
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                HtmlBrowser.URLDisplayer.getDefault().showURL(hyperlinkEvent.getURL());
            }
        });
    }

    static {
        RP = new RequestProcessor("ReporterResultTopComponentLoader", 3);
        LOG = Logger.getLogger(ReporterResultTopComponent.class.getName());
        showUpload = false;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ReporterResultTopComponent.getDefault();
        }
    }

    private class PageUploader
    implements Runnable {
        private URL localData = null;
        private final URL url;
        private final boolean show;

        private PageUploader(URL uRL, boolean bl) {
            this.url = uRL;
            this.show = bl;
        }

        @Override
        public void run() {
            try {
                if (EventQueue.isDispatchThread()) {
                    if (this.show) {
                        ReporterResultTopComponent reporterResultTopComponent = ReporterResultTopComponent.this;
                        reporterResultTopComponent.requestVisible();
                        reporterResultTopComponent.requestActive();
                    }
                    ReporterResultTopComponent.this.dataDisplayer.setPage(this.localData);
                } else {
                    LOG.log(Level.FINE, "Loading: {0}", this.url);
                    this.localData = ReporterResultTopComponent.uploadURL(this.url);
                    EventQueue.invokeLater(this);
                }
            }
            catch (IOException iOException) {
                ReporterResultTopComponent.handleIOException(this.url, iOException);
            }
        }
    }

    private class URLDisplayer
    implements Runnable {
        private String urlStr = null;
        private final boolean show;

        public URLDisplayer(boolean bl) {
            this.show = bl;
        }

        @Override
        public void run() {
            if (EventQueue.isDispatchThread()) {
                try {
                    ReporterResultTopComponent.this.loadPage(new URL(this.urlStr), this.show);
                }
                catch (MalformedURLException malformedURLException) {
                    ReporterResultTopComponent.handleIOException(this.urlStr, malformedURLException);
                }
            } else {
                String string = new ExceptionsSettings().getUserName();
                if (string != null && !"".equals(string)) {
                    this.urlStr = NbBundle.getMessage(ReporterResultTopComponent.class, (String)"userNameURL") + string;
                } else {
                    String string2 = Installer.findIdentity();
                    if (string2 != null) {
                        this.urlStr = NbBundle.getMessage(ReporterResultTopComponent.class, (String)"userIdURL") + string2;
                    }
                }
                if (this.urlStr == null) {
                    return;
                }
                EventQueue.invokeLater(this);
            }
        }
    }
}

