/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class MIMEResolverProcessor
extends LayerGeneratingProcessor {
    private static final String SUFFIX = ".xml";

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(MIMEResolver.Registration.class.getCanonicalName());
        hashSet.add(MIMEResolver.ExtensionRegistration.class.getCanonicalName());
        hashSet.add(MIMEResolver.NamespaceRegistration.class.getCanonicalName());
        return hashSet;
    }

    @Override
    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        Annotation annotation;
        for (Element element : roundEnvironment.getElementsAnnotatedWith(MIMEResolver.Registration.class)) {
            annotation = element.getAnnotation(MIMEResolver.Registration.class);
            this.registerDefinition(element, annotation.resource(), (MIMEResolver.Registration)annotation);
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(MIMEResolver.ExtensionRegistration.class)) {
            annotation = element.getAnnotation(MIMEResolver.ExtensionRegistration.class);
            this.registerExt(element, (MIMEResolver.ExtensionRegistration)annotation);
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(MIMEResolver.NamespaceRegistration.class)) {
            annotation = element.getAnnotation(MIMEResolver.NamespaceRegistration.class);
            this.registerNamespace(element, (MIMEResolver.NamespaceRegistration)annotation);
        }
        return true;
    }

    private void registerExt(Element element, MIMEResolver.ExtensionRegistration extensionRegistration) throws LayerGenerationException {
        LayerBuilder layerBuilder = this.layer(element);
        LayerBuilder.File file = layerBuilder.file("Services/MIMEResolver/" + this.getName(element).replace('.', '-') + "-Extension" + SUFFIX);
        file.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        file.stringvalue("instanceClass", MIMEResolver.class.getName());
        file.stringvalue("mimeType", extensionRegistration.mimeType());
        int n = 0;
        for (String string : extensionRegistration.extension()) {
            file.stringvalue("ext." + n++, string);
        }
        file.position(extensionRegistration.position());
        int n2 = 0;
        for (String string : extensionRegistration.showInFileChooser()) {
            file.bundlevalue("fileChooser." + n2++, string);
        }
        file.bundlevalue("displayName", extensionRegistration.displayName());
        file.write();
    }

    private void registerDefinition(Element element, String string, MIMEResolver.Registration registration) throws LayerGenerationException {
        String string2 = LayerBuilder.absolutizeResource(element, string);
        LayerBuilder layerBuilder = this.layer(element);
        javax.tools.FileObject fileObject = layerBuilder.validateResource(string2, element, registration, null, false);
        LayerBuilder.File file = layerBuilder.file("Services/MIMEResolver/" + this.getName(element).replace('.', '-') + "-Registration" + SUFFIX);
        file.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        file.stringvalue("instanceClass", MIMEResolver.class.getName());
        file.serialvalue("bytes", this.generateInstanceResolver(fileObject, element, file, registration));
        file.position(registration.position());
        int n = 0;
        for (String string3 : registration.showInFileChooser()) {
            file.bundlevalue("fileChooser." + n++, string3);
        }
        file.bundlevalue("displayName", registration.displayName());
        file.write();
    }

    private byte[] generateInstanceResolver(javax.tools.FileObject fileObject, Element element, LayerBuilder.File file, MIMEResolver.Registration registration) throws LayerGenerationException {
        try {
            int n;
            InputStream inputStream = fileObject.openInputStream();
            FileObject fileObject2 = FileUtil.createMemoryFileSystem().getRoot().createData("resolver.xml");
            OutputStream outputStream = fileObject2.getOutputStream();
            while ((n = inputStream.read()) != -1) {
                outputStream.write(n);
            }
            outputStream.close();
            inputStream.close();
            MIMEResolver mIMEResolver = MIMEResolverImpl.forDescriptor(fileObject2, false);
            this.setFileChooserRelatedAttributes(registration, mIMEResolver, file);
            byte[] byArray = MIMEResolverImpl.toStream(mIMEResolver);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(byArray);
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            LayerGenerationException layerGenerationException = new LayerGenerationException("Cannot process " + fileObject, element);
            layerGenerationException.initCause(iOException);
            throw layerGenerationException;
        }
    }

    private void registerNamespace(Element element, MIMEResolver.NamespaceRegistration namespaceRegistration) throws LayerGenerationException {
        LayerBuilder layerBuilder = this.layer(element);
        LayerBuilder.File file = layerBuilder.file("Services/MIMEResolver/" + this.getName(element).replace('.', '-') + "-Namespace" + SUFFIX);
        file.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        file.stringvalue("instanceClass", MIMEResolver.class.getName());
        file.stringvalue("mimeType", namespaceRegistration.mimeType());
        int n = 0;
        for (String string : namespaceRegistration.doctypePublicId()) {
            file.stringvalue("doctype." + n++, string);
        }
        n = 0;
        for (String string : namespaceRegistration.checkedExtension()) {
            file.stringvalue("ext." + n++, string);
        }
        n = 0;
        for (String string : namespaceRegistration.acceptedExtension()) {
            file.stringvalue("accept." + n++, string);
        }
        n = 0;
        file.stringvalue("element", namespaceRegistration.elementName());
        for (String string : namespaceRegistration.elementNS()) {
            file.stringvalue("ns." + n++, string);
        }
        file.position(namespaceRegistration.position());
        file.bundlevalue("displayName", namespaceRegistration.displayName());
        file.write();
    }

    private String getName(Element element) {
        if (element.getKind().isClass() || element.getKind().isInterface()) {
            return this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
        }
        if (element.getKind() == ElementKind.PACKAGE) {
            return element.getSimpleName().toString();
        }
        return this.getName(element.getEnclosingElement()) + '.' + element.getSimpleName();
    }

    private Set<String> unq(String[] stringArray) {
        return this.unq(Arrays.asList(stringArray));
    }

    private Set<String> unq(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(collection);
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    private void setFileChooserRelatedAttributes(MIMEResolver.Registration registration, MIMEResolver mIMEResolver, LayerBuilder.File file) {
        if (registration.showInFileChooser().length > 0) {
            String[] stringArray = MIMEResolverImpl.getMIMETypes(mIMEResolver);
            List<String> list = ((FilterInfo)((Object)mIMEResolver)).getExtensions();
            int n = 0;
            for (String object : this.unq(list)) {
                file.stringvalue("ext." + n++, object);
            }
            int n2 = 0;
            for (String string : this.unq(stringArray)) {
                file.stringvalue("mimeType." + n2++, string);
            }
            boolean bl = false;
            for (String string : ((FilterInfo)((Object)mIMEResolver)).getFileNames()) {
                void var8_12;
                file.stringvalue("fileName." + (int)(++var8_12), string);
            }
        }
    }

    static interface FilterInfo {
        public List<String> getExtensions();

        public List<String> getFileNames();
    }
}

