/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.threads;

import java.awt.Color;
import org.netbeans.lib.profiler.global.CommonConstants;

public class ThreadData {
    static final byte NO_STATE = 127;
    private final Object dataLock;
    private String className;
    private String name;
    private byte[] threadStates;
    private long[] timeStamps;
    private int capacity;
    private int curSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadData(String string, String string2) {
        Object object = this.dataLock = new Object();
        synchronized (object) {
            this.capacity = 50;
            this.timeStamps = new long[this.capacity];
            this.threadStates = new byte[this.capacity];
            this.curSize = 0;
        }
        this.name = string;
        this.className = string2;
    }

    public String getClassName() {
        return this.className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getFirstState() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 127;
            }
            return this.threadStates[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstTimeStamp() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 0L;
            }
            return this.timeStamps[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getLastState() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 127;
            }
            return this.threadStates[this.curSize - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastTimeStamp() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 0L;
            }
            return this.timeStamps[this.curSize - 1];
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getStateAt(int n) {
        Object object = this.dataLock;
        synchronized (object) {
            return this.threadStates[n];
        }
    }

    public static Color getThreadStateColor(int n) {
        switch (n) {
            case -1: {
                return CommonConstants.THREAD_STATUS_UNKNOWN_COLOR;
            }
            case 0: {
                return CommonConstants.THREAD_STATUS_ZOMBIE_COLOR;
            }
            case 1: {
                return CommonConstants.THREAD_STATUS_RUNNING_COLOR;
            }
            case 2: {
                return CommonConstants.THREAD_STATUS_SLEEPING_COLOR;
            }
            case 3: {
                return CommonConstants.THREAD_STATUS_MONITOR_COLOR;
            }
            case 4: {
                return CommonConstants.THREAD_STATUS_WAIT_COLOR;
            }
            case 5: {
                return CommonConstants.THREAD_STATUS_PARK_COLOR;
            }
        }
        return CommonConstants.THREAD_STATUS_UNKNOWN_COLOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getThreadStateColorAt(int n) {
        Object object = this.dataLock;
        synchronized (object) {
            return ThreadData.getThreadStateColor(this.threadStates[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeStampAt(int n) {
        Object object = this.dataLock;
        synchronized (object) {
            return this.timeStamps[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long l, byte by) {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == this.capacity) {
                long[] lArray = this.timeStamps;
                byte[] byArray = this.threadStates;
                int n = this.capacity;
                this.capacity *= 2;
                this.timeStamps = new long[this.capacity];
                this.threadStates = new byte[this.capacity];
                System.arraycopy(lArray, 0, this.timeStamps, 0, n);
                System.arraycopy(byArray, 0, this.threadStates, 0, n);
            }
            this.timeStamps[this.curSize] = l;
            this.threadStates[this.curSize] = by;
            ++this.curSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStates() {
        Object object = this.dataLock;
        synchronized (object) {
            this.capacity = 50;
            this.timeStamps = new long[this.capacity];
            this.threadStates = new byte[this.capacity];
            this.curSize = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.dataLock;
        synchronized (object) {
            return this.curSize;
        }
    }
}

