/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.results.locks.MonitorInfo;

class ThreadInfo {
    private final int threadId;
    private final Map<MonitorInfo, Monitor> monitors;
    private OpenMonitor openMonitor;
    private final String threadName;
    private final String threadClassName;

    ThreadInfo(int n, String string, String string2) {
        this.threadId = n;
        this.threadName = string;
        this.threadClassName = string2;
        this.monitors = new HashMap<MonitorInfo, Monitor>();
    }

    void openMonitor(MonitorInfo monitorInfo, long l) {
        assert (this.openMonitor == null);
        this.openMonitor = new OpenMonitor(monitorInfo, l);
        monitorInfo.openThread(this, l);
    }

    void closeMonitor(MonitorInfo monitorInfo, long l) {
        assert (this.openMonitor != null);
        assert (monitorInfo.equals(this.openMonitor.monitor));
        long l2 = l - this.openMonitor.timeStamp;
        this.addMonitor(monitorInfo, l2);
        this.openMonitor = null;
        monitorInfo.closeThread(this, l);
    }

    private void addMonitor(MonitorInfo monitorInfo, long l) {
        Monitor monitor = this.monitors.get(monitorInfo);
        if (monitor == null) {
            this.monitors.put(monitorInfo, new Monitor(monitorInfo, l));
        } else {
            monitor.addWait(l);
        }
    }

    void timeAdjust(long l) {
        if (this.openMonitor != null) {
            this.openMonitor.timeAdjust(l);
            this.openMonitor.monitor.timeAdjust(l);
        }
    }

    List<Monitor> cloneMonitorDetails() {
        ArrayList<Monitor> arrayList = new ArrayList<Monitor>(this.monitors.size());
        for (Monitor monitor : this.monitors.values()) {
            arrayList.add(new Monitor(monitor));
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ThreadInfo) {
            ThreadInfo threadInfo = (ThreadInfo)object;
            return threadInfo.threadId == this.threadId;
        }
        return false;
    }

    public int hashCode() {
        return this.threadId;
    }

    String getName() {
        return this.threadName;
    }

    static class Monitor {
        final MonitorInfo monitor;
        long count;
        long waitTime;

        private Monitor(MonitorInfo monitorInfo, long l) {
            this.monitor = monitorInfo;
            this.waitTime = l;
            this.count = 1L;
        }

        Monitor(Monitor monitor) {
            this.monitor = monitor.monitor;
            this.count = monitor.count;
            this.waitTime = monitor.waitTime;
        }

        private void addWait(long l) {
            this.waitTime += l;
            ++this.count;
        }
    }

    private static class OpenMonitor {
        final MonitorInfo monitor;
        long timeStamp;

        OpenMonitor(MonitorInfo monitorInfo, long l) {
            this.monitor = monitorInfo;
            this.timeStamp = l;
        }

        private void timeAdjust(long l) {
            this.timeStamp += l;
        }
    }
}

