/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.util.Collections;
import java.util.List;
import org.netbeans.lib.profiler.results.locks.LockCCTNode;
import org.netbeans.lib.profiler.results.locks.MonitorInfo;
import org.netbeans.lib.profiler.results.locks.ThreadInfo;
import org.netbeans.lib.profiler.results.locks.ThreadLockCCTNode;

class MonitorCCTNode
extends LockCCTNode {
    private final MonitorInfo monitor;
    private final List<MonitorInfo.ThreadDetail> threads;
    private long allTime;
    private long allCount;

    MonitorCCTNode(LockCCTNode lockCCTNode, MonitorInfo monitorInfo, List<MonitorInfo.ThreadDetail> list) {
        super(lockCCTNode);
        this.monitor = monitorInfo;
        this.threads = list;
    }

    MonitorCCTNode(ThreadLockCCTNode threadLockCCTNode, ThreadInfo.Monitor monitor) {
        super(threadLockCCTNode);
        this.monitor = monitor.monitor;
        this.allTime = monitor.waitTime;
        this.allCount = monitor.count;
        this.threads = Collections.EMPTY_LIST;
    }

    @Override
    public String getNodeName() {
        return this.monitor.getName();
    }

    @Override
    public long getTime() {
        if (this.allTime == 0L) {
            this.summarize();
        }
        return this.allTime;
    }

    @Override
    public long getWaits() {
        if (this.allCount == 0L) {
            this.summarize();
        }
        return this.allCount;
    }

    @Override
    public boolean isMonitorNode() {
        return true;
    }

    public int hashCode() {
        return this.monitor.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof MonitorCCTNode) {
            return this.monitor.equals(((MonitorCCTNode)object).monitor);
        }
        return false;
    }

    private void summarize() {
        for (MonitorInfo.ThreadDetail threadDetail : this.threads) {
            this.allTime += threadDetail.waitTime;
            this.allCount += threadDetail.count;
        }
    }

    @Override
    void computeChildren() {
        super.computeChildren();
        for (MonitorInfo.ThreadDetail threadDetail : this.threads) {
            this.addChild(new ThreadLockCCTNode(this, threadDetail));
        }
    }
}

