/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.locks.AbstractLockDataFrameProcessor;

public class LockDataFrameProcessor
extends AbstractLockDataFrameProcessor {
    @Override
    public void doProcessDataFrame(ByteBuffer byteBuffer) {
        block9: while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            switch (by) {
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    continue block9;
                }
                case 29: {
                    char c = byteBuffer.getChar();
                    long l = LockDataFrameProcessor.getTimeStamp(byteBuffer);
                    char c2 = byteBuffer.getChar();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profile Point Hit " + c + ", threadId=" + c + ", timeStamp=" + l);
                    }
                    this.fireProfilingPoint(c2, c, l);
                    continue block9;
                }
                case 13: {
                    this.currentThreadId = byteBuffer.getChar();
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block9;
                    LOGGER.log(Level.FINEST, "Change current thread , tId={0}", this.currentThreadId);
                    continue block9;
                }
                case 11: {
                    char c = byteBuffer.getChar();
                    String string = LockDataFrameProcessor.getString(byteBuffer);
                    String string2 = LockDataFrameProcessor.getString(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new thread , tId={0}", c);
                    }
                    this.fireNewThread(c, string, string2);
                    this.currentThreadId = c;
                    continue block9;
                }
                case 28: {
                    int n = byteBuffer.getInt();
                    String string = LockDataFrameProcessor.getString(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new monitor , mId={0} , className={1}", new Object[]{n, string});
                    }
                    this.fireNewMonitor(n, string);
                    continue block9;
                }
                case 22: 
                case 23: {
                    long l = LockDataFrameProcessor.getTimeStamp(byteBuffer);
                    long l2 = -1L;
                    int n = byteBuffer.getInt();
                    if (by == 22) {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Monitor entry , tId={0} , monitorId={1}", new Object[]{this.currentThreadId, n});
                        }
                        this.fireMonitorEntry(this.currentThreadId, l, l2, n);
                    }
                    if (by != 23) continue block9;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Monitor exit , tId={0} , monitorId={1}", new Object[]{this.currentThreadId, n});
                    }
                    this.fireMonitorExit(this.currentThreadId, l, l2, n);
                    continue block9;
                }
                case 5: {
                    long l = LockDataFrameProcessor.getTimeStamp(byteBuffer);
                    long l3 = LockDataFrameProcessor.getTimeStamp(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Adjust time , tId={0}", this.currentThreadId);
                    }
                    this.fireAdjustTime(this.currentThreadId, l, l3);
                    continue block9;
                }
            }
            LOGGER.severe("*** Profiler Engine: internal error: got unknown event type in LockDataFrameProcessor: " + by + " at " + byteBuffer.position());
        }
    }
}

