/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch.recent;

import java.awt.EventQueue;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.quicksearch.CategoryResult;
import org.netbeans.modules.quicksearch.CommandEvaluator;
import org.netbeans.modules.quicksearch.ProviderModel;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.netbeans.modules.quicksearch.recent.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class RecentSearches {
    private static final int MAX_ITEMS = 5;
    private static final long FIVE_DAYS = 432000000L;
    private LinkedList<ResultsModel.ItemResult> recent = new LinkedList();
    private static RecentSearches instance;
    private static final char dateSep = ':';
    private static final Pattern RECENT_PREFS_PATTERN;
    private static RequestProcessor RP;
    private static final String RECENT_SEARCHES = "recentSearches";

    private RecentSearches() {
        this.readRecentFromPrefs();
    }

    public static RecentSearches getDefault() {
        if (instance == null) {
            instance = new RecentSearches();
        }
        return instance;
    }

    public void add(ResultsModel.ItemResult itemResult) {
        Date date = new GregorianCalendar().getTime();
        for (ResultsModel.ItemResult itemResult2 : this.recent) {
            if (!this.stripHTMLnames(itemResult2.getDisplayName()).equals(this.stripHTMLnames(itemResult.getDisplayName()))) continue;
            itemResult2.setDate(date);
            return;
        }
        if ("SearchSetup".equals(itemResult.getAction().getClass().getSimpleName())) {
            return;
        }
        if (this.recent.size() >= 5) {
            this.recent.removeLast();
        }
        itemResult.setDate(date);
        this.recent.addFirst(itemResult);
        this.storeRecentToPrefs();
    }

    public List<ResultsModel.ItemResult> getSearches() {
        LinkedList<ResultsModel.ItemResult> linkedList = new LinkedList<ResultsModel.ItemResult>();
        for (ResultsModel.ItemResult itemResult : this.recent) {
            if (new GregorianCalendar().getTime().getTime() - itemResult.getDate().getTime() >= 432000000L) continue;
            linkedList.add(itemResult);
        }
        return linkedList;
    }

    private Preferences prefs() {
        return NbPreferences.forModule(RecentSearches.class);
    }

    private void storeRecentToPrefs() {
        Iterator iterator = this.recent.iterator();
        for (int i = 0; i < 5; ++i) {
            if (iterator.hasNext()) {
                ResultsModel.ItemResult itemResult = (ResultsModel.ItemResult)iterator.next();
                CategoryResult categoryResult = itemResult.getCategory();
                ProviderModel.Category category = categoryResult == null ? null : categoryResult.getCategory();
                String string = category == null ? null : this.stripHTMLnames(category.getDisplayName());
                this.prefs().put(RECENT_SEARCHES + i, this.stripHTMLnames(itemResult.getDisplayName()) + ':' + itemResult.getDate().getTime() + (string == null ? "" : ':' + string));
                continue;
            }
            this.prefs().put(RECENT_SEARCHES + i, "");
        }
    }

    private void readRecentFromPrefs() {
        for (int i = 0; i < 5; ++i) {
            String string = this.prefs().get(RECENT_SEARCHES + i, "");
            Matcher matcher = RECENT_PREFS_PATTERN.matcher(string);
            if (!matcher.find()) continue;
            try {
                String string2 = matcher.group(1);
                long l = Long.parseLong(matcher.group(2));
                String string3 = matcher.group(3);
                ResultsModel.ItemResult itemResult = new ResultsModel.ItemResult(null, new FakeAction(string2, string3), string2, new Date(l));
                this.recent.add(itemResult);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                Logger logger = Logger.getLogger(RecentSearches.class.getName());
                logger.log(Level.INFO, "Failed to read recent searches", string);
            }
        }
    }

    private String stripHTMLnames(String string) {
        return this.translateHTMLEntities(string.replaceAll("<.*?>", "")).trim();
    }

    private String translateHTMLEntities(String string) {
        return string.replaceAll("\\&amp;", "&");
    }

    static {
        RECENT_PREFS_PATTERN = Pattern.compile("^(.*):(\\d{8,})(?::(.*))?$");
        RP = new RequestProcessor(RecentSearches.class.getName(), 2);
    }

    public final class FakeAction
    implements Runnable {
        private String name;
        private String category;
        private Runnable action;

        private FakeAction(String string, String string2) {
            this.name = string;
            this.category = string2;
        }

        @Override
        public void run() {
            if (this.action == null || this.action instanceof FakeAction) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        FakeAction.this.findAndRunAction();
                    }
                });
            } else {
                this.action.run();
            }
        }

        private void findAndRunAction() {
            final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)Bundle.LBL_SearchingRecentResult(), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    atomicBoolean.set(true);
                    return true;
                }
            });
            progressHandle.start();
            ResultsModel resultsModel = ResultsModel.getInstance();
            Task task = CommandEvaluator.evaluate(this.stripHTMLandPackageNames(this.name), resultsModel);
            RP.post((Runnable)task);
            int n = 0;
            boolean bl = false;
            while (n++ < 30 && !atomicBoolean.get()) {
                if (this.checkActionWasFound(resultsModel, true)) {
                    bl = true;
                    break;
                }
                if (!task.isFinished()) continue;
                bl = this.checkActionWasFound(resultsModel, false);
                break;
            }
            progressHandle.finish();
            if (!bl && !atomicBoolean.get()) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.MSG_RecentResultNotFound(), 1);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
            }
        }

        private boolean checkActionWasFound(ResultsModel resultsModel, boolean bl) {
            if (bl) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
            }
            int n = resultsModel.getSize();
            for (int i = 0; i < n; ++i) {
                ResultsModel.ItemResult itemResult = (ResultsModel.ItemResult)resultsModel.getElementAt(i);
                if (!this.nameMatches(itemResult) || !this.categoryMatches(itemResult)) continue;
                this.action = itemResult.getAction();
                if (this.action instanceof FakeAction) continue;
                EventQueue.invokeLater(this.action);
                return true;
            }
            return false;
        }

        private boolean nameMatches(ResultsModel.ItemResult itemResult) {
            return RecentSearches.this.stripHTMLnames(itemResult.getDisplayName()).equals(RecentSearches.this.stripHTMLnames(this.name));
        }

        private boolean categoryMatches(ResultsModel.ItemResult itemResult) {
            if (this.category == null) {
                return true;
            }
            if (itemResult.getCategory() == null || itemResult.getCategory().getCategory() == null) {
                return false;
            }
            return RecentSearches.this.stripHTMLnames(itemResult.getCategory().getCategory().getDisplayName()).equals(RecentSearches.this.stripHTMLnames(this.category));
        }

        private String stripHTMLandPackageNames(String string) {
            string = RecentSearches.this.stripHTMLnames(string);
            return string.replaceAll("\\(.*\\)", "").trim();
        }
    }
}

