/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.core.options.keymap.api.KeyStrokeUtils;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.LayersBridge;
import org.netbeans.modules.options.keymap.ShortcutsFinderImpl;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;

class MutableShortcutsModel
extends ShortcutsFinderImpl
implements ShortcutsFinder.Writer {
    private volatile String currentProfile;
    private Map<String, List<Object>[]> categoryToActionsCache = new HashMap<String, List<Object>[]>();
    private volatile Map<String, Map<ShortcutAction, Set<String>>> modifiedProfiles = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private volatile Set<String> revertedProfiles = new HashSet<String>();
    private volatile Set<ShortcutAction> revertedActions = new HashSet<ShortcutAction>();
    private volatile Set<String> deletedProfiles = new HashSet<String>();
    @NullAllowed
    private ShortcutsFinder master;
    private volatile boolean dirty;
    private List<ChangeListener> chListeners;
    private volatile boolean applyInProgress = false;

    public MutableShortcutsModel(@NonNull KeymapModel keymapModel, ShortcutsFinder shortcutsFinder) {
        super(keymapModel);
        this.master = shortcutsFinder == null ? (ShortcutsFinder)Lookup.getDefault().lookup(ShortcutsFinder.class) : shortcutsFinder;
    }

    String getProfileDisplayName(String string) {
        String string2 = this.model.getProfileName(string);
        return string2 != null ? string2 : string;
    }

    List<String> getProfiles() {
        HashSet<String> hashSet = new HashSet<String>(this.model.getProfiles());
        hashSet.addAll(this.modifiedProfiles.keySet());
        ArrayList<String> arrayList = new ArrayList<String>(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    boolean isChangedProfile(String string) {
        return this.modifiedProfiles.containsKey(string);
    }

    boolean isCustomProfile(String string) {
        return this.model.isCustomProfile(string);
    }

    synchronized boolean deleteOrRestoreProfile(String string) {
        if (this.model.isCustomProfile(string)) {
            this.deletedProfiles.add(string);
            this.modifiedProfiles.remove(string);
            this.clearShortcuts(string);
            this.setDirty();
            return true;
        }
        this.modifiedProfiles.remove(string);
        this.revertedProfiles.add(string);
        this.clearShortcuts(string);
        this.setDirty();
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.chListeners == null) {
            this.chListeners = new LinkedList<ChangeListener>();
        }
        this.chListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.chListeners != null) {
            this.chListeners.remove(changeListener);
        }
    }

    protected void fireChanged() {
        if (this.chListeners == null || this.chListeners.isEmpty()) {
            return;
        }
        ChangeListener[] changeListenerArray = this.chListeners.toArray(new ChangeListener[this.chListeners.size()]);
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : changeListenerArray) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    protected String getCurrentProfile() {
        if (this.currentProfile == null) {
            return this.model.getCurrentProfile();
        }
        return this.currentProfile;
    }

    void setCurrentProfile(String string) {
        this.currentProfile = string;
        this.setDirty();
    }

    void setDirty() {
        boolean bl = this.dirty;
        this.dirty = true;
        if (bl != this.dirty) {
            this.fireChanged();
        }
    }

    synchronized void cloneProfile(String string) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        this.cloneProfile("", hashMap);
        this.modifiedProfiles.put(string, hashMap);
        this.deletedProfiles.remove(string);
        this.setDirty();
    }

    private void cloneProfile(String string, Map<ShortcutAction, Set<String>> map) {
        for (Object object : this.getItems(string)) {
            String[] stringArray = this.getShortcuts((ShortcutAction)object);
            map.put((ShortcutAction)object, new HashSet<String>(Arrays.asList(stringArray)));
        }
    }

    @Override
    public ShortcutAction findActionForShortcut(String string) {
        return this.findActionForShortcut(string, "", false, null, "");
    }

    Collection<ShortcutAction> filterSameScope(Set<ShortcutAction> set, ShortcutAction shortcutAction) {
        return KeymapModel.filterSameScope(set, shortcutAction);
    }

    Set<ShortcutAction> findActionForShortcutPrefix(String string) {
        HashSet<ShortcutAction> hashSet = new HashSet<ShortcutAction>();
        if (string.length() == 0) {
            return hashSet;
        }
        if (string.contains(" ")) {
            this.findActionForShortcut(string.substring(0, string.lastIndexOf(32)), "", true, hashSet, string);
        } else {
            this.findActionForShortcut(string, "", true, hashSet, string);
        }
        return hashSet;
    }

    private ShortcutAction findActionForShortcut(String string, String string2, boolean bl, Set<ShortcutAction> set, String string3) {
        Map<ShortcutAction, Set<String>> map = this.modifiedProfiles.get(this.getCurrentProfile());
        if (map != null) {
            for (Map.Entry object : map.entrySet()) {
                for (Object object2 : (Set)object.getValue()) {
                    if (bl) {
                        if (!((String)object2).equals(string) && (!((String)object2).startsWith(string3) || !string.equals(string3) || !((String)object2).contains(" "))) continue;
                        set.add((ShortcutAction)object.getKey());
                        continue;
                    }
                    if (!((String)object2).equals(string)) continue;
                    return (ShortcutAction)object.getKey();
                }
            }
        }
        for (Object object : this.getItems(string2)) {
            Object object2;
            ShortcutAction shortcutAction = (ShortcutAction)object;
            object2 = this.getShortcuts(shortcutAction);
            int n = ((String[])object2).length;
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    if (!((String)object2[i]).equals(string) && (!((String)object2[i]).startsWith(string3) || !string.equals(string3) || !((String)object2[i]).contains(" "))) continue;
                    set.add(shortcutAction);
                    continue;
                }
                if (!((String)object2[i]).equals(string)) continue;
                return shortcutAction;
            }
        }
        return null;
    }

    @Override
    protected ShortcutAction findActionForId(String string, String string2, boolean bl) {
        for (Object object : this.getItems(string2)) {
            String string3 = bl ? LayersBridge.getOrigActionClass((ShortcutAction)object) : ((ShortcutAction)object).getId();
            if (string3 == null || !string.equals(string3)) continue;
            return (ShortcutAction)object;
        }
        return null;
    }

    @Override
    protected Map<ShortcutAction, Set<String>> getKeymap(String string) {
        Map<ShortcutAction, Set<String>> map = this.revertedProfiles.contains(string) ? this.model.getKeymapDefaults(string) : super.getKeymap(string);
        Map<ShortcutAction, Set<String>> map2 = this.modifiedProfiles.get(string);
        if (map2 != null) {
            map = new HashMap<ShortcutAction, Set<String>>(map);
            map.putAll(map2);
        }
        return map;
    }

    @Override
    public String[] getShortcuts(ShortcutAction shortcutAction) {
        Map<ShortcutAction, Set<String>> map;
        String string = this.getCurrentProfile();
        Map<ShortcutAction, Set<String>> map2 = this.modifiedProfiles.get(string);
        if (map2 != null && (map = map2).containsKey(shortcutAction)) {
            Set<String> set = map.get(shortcutAction);
            return set.toArray(new String[set.size()]);
        }
        return super.getShortcuts(shortcutAction);
    }

    public Set<String> getAllCurrentlyUsedShortcuts() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String string = this.getCurrentProfile();
        HashSet<ShortcutAction> hashSet = new HashSet<ShortcutAction>();
        Map<ShortcutAction, Set<String>> map = this.modifiedProfiles.get(string);
        if (map != null) {
            hashSet.addAll(map.keySet());
            for (Map.Entry<ShortcutAction, Set<String>> entry : map.entrySet()) {
                for (String string2 : entry.getValue()) {
                    linkedHashSet.add(string2);
                    if (!string2.contains(" ")) continue;
                    linkedHashSet.add(string2.substring(0, string2.indexOf(32)));
                }
            }
        }
        for (Map.Entry<ShortcutAction, Set<String>> entry : this.getProfileMap(string).entrySet()) {
            if (hashSet.contains(entry.getKey())) continue;
            for (String string2 : entry.getValue()) {
                linkedHashSet.add(string2);
                if (!string2.contains(" ")) continue;
                linkedHashSet.add(string2.substring(0, string2.indexOf(32)));
            }
        }
        return linkedHashSet;
    }

    void addShortcut(ShortcutAction shortcutAction, String string) {
        ShortcutAction shortcutAction2 = this.findActionForShortcut(string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(Arrays.asList(this.getShortcuts(shortcutAction)));
        linkedHashSet.add(string);
        this.setShortcuts(shortcutAction, linkedHashSet);
    }

    synchronized Collection<ShortcutAction> revertShortcutsToDefault(ShortcutAction shortcutAction, boolean bl) {
        if (this.model.isCustomProfile(this.getCurrentProfile())) {
            return null;
        }
        Map<ShortcutAction, Set<String>> map = this.model.getKeymapDefaults(this.getCurrentProfile());
        Set<String> set = (map = MutableShortcutsModel.convertFromEmacs(map)).get(shortcutAction);
        if (set == null) {
            set = Collections.emptySet();
        }
        HashSet<ShortcutAction> hashSet = new HashSet<ShortcutAction>();
        for (String object : set) {
            ShortcutAction shortcutAction2 = this.findActionForShortcut(object);
            if (shortcutAction2 == null || shortcutAction2.equals(shortcutAction)) continue;
            hashSet.add(shortcutAction2);
        }
        Collection<ShortcutAction> collection = KeymapModel.filterSameScope(hashSet, shortcutAction);
        if (!collection.isEmpty() && !bl) {
            return hashSet;
        }
        this.revertedActions.add(shortcutAction);
        this.setShortcuts(shortcutAction, set);
        for (ShortcutAction shortcutAction2 : collection) {
            String[] stringArray = this.getShortcuts(shortcutAction2);
            HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList(stringArray));
            hashSet2.removeAll(set);
            this.setShortcuts(shortcutAction2, hashSet2);
        }
        return null;
    }

    @Override
    public synchronized void setShortcuts(ShortcutAction shortcutAction, Set<String> set) {
        Map<ShortcutAction, Set<String>> map = this.modifiedProfiles.get(this.getCurrentProfile());
        if (map == null) {
            map = new HashMap<ShortcutAction, Set<String>>();
            this.modifiedProfiles.put(this.getCurrentProfile(), map);
        }
        map.put(shortcutAction, set);
        this.setDirty();
    }

    public void removeShortcut(ShortcutAction shortcutAction, String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(this.getShortcuts(shortcutAction)));
        linkedHashSet.remove(string);
        this.setShortcuts(shortcutAction, linkedHashSet);
    }

    @Override
    public void apply() {
        this.postApply();
    }

    private Map<String, Map<ShortcutAction, Set<String>>> cloneProfileMap(Map<String, Map<ShortcutAction, Set<String>>> map) {
        HashMap<String, Map<ShortcutAction, Set<String>>> hashMap = new HashMap<String, Map<ShortcutAction, Set<String>>>(map.size());
        for (Map.Entry<String, Map<ShortcutAction, Set<String>>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), new HashMap<ShortcutAction, Set<String>>(entry.getValue()));
        }
        return hashMap;
    }

    synchronized Task postApply() {
        if (this.applyInProgress) {
            return null;
        }
        this.applyInProgress = true;
        final HashSet<String> hashSet = new HashSet<String>(this.revertedProfiles);
        final HashSet<ShortcutAction> hashSet2 = new HashSet<ShortcutAction>(this.revertedActions);
        final Map<String, Map<ShortcutAction, Set<String>>> map = this.cloneProfileMap(this.modifiedProfiles);
        final HashSet<String> hashSet3 = new HashSet<String>(this.deletedProfiles);
        final String string = this.currentProfile;
        return RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (String string222 : hashSet) {
                    try {
                        MutableShortcutsModel.this.model.revertProfile(string222);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
                if (!hashSet2.isEmpty()) {
                    try {
                        MutableShortcutsModel.this.model.revertActions(hashSet2);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
                for (String string222 : map.keySet()) {
                    Map map2 = (Map)map.get(string222);
                    map2 = MutableShortcutsModel.convertToEmacs(map2);
                    MutableShortcutsModel.this.model.changeKeymap(string222, map2);
                }
                for (String string222 : hashSet3) {
                    MutableShortcutsModel.this.model.deleteProfile(string222);
                }
                Object object = string;
                if (object == null) {
                    object = MutableShortcutsModel.this.model.getCurrentProfile();
                }
                MutableShortcutsModel.this.model.setCurrentProfile((String)object);
                MutableShortcutsModel.this.clearState();
                MutableShortcutsModel.this.model = new KeymapModel();
                MutableShortcutsModel.this.applyInProgress = false;
                MutableShortcutsModel.this.clearCache();
                if (MutableShortcutsModel.this.master != null) {
                    MutableShortcutsModel.this.master.refreshActions();
                }
            }
        });
    }

    public boolean isChanged() {
        return this.dirty || !this.modifiedProfiles.isEmpty() || !this.deletedProfiles.isEmpty() || !this.revertedProfiles.isEmpty() || !this.revertedActions.isEmpty();
    }

    private synchronized void clearState() {
        this.modifiedProfiles = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        this.deletedProfiles = new HashSet<String>();
        this.revertedActions = new HashSet<ShortcutAction>();
        this.revertedProfiles = new HashSet<String>();
        this.currentProfile = null;
        this.dirty = false;
    }

    public void cancel() {
        this.clearState();
    }

    Map<String, Map<ShortcutAction, Set<String>>> getModifiedProfiles() {
        return this.modifiedProfiles;
    }

    Set<String> getDeletedProfiles() {
        return this.deletedProfiles;
    }

    void setModifiedProfiles(Map<String, Map<ShortcutAction, Set<String>>> map) {
        this.modifiedProfiles = map;
    }

    void setDeletedProfiles(Set<String> set) {
        this.deletedProfiles = set;
    }

    private static Map<ShortcutAction, Set<String>> convertToEmacs(Map<ShortcutAction, Set<String>> map) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : map.entrySet()) {
            ShortcutAction shortcutAction = entry.getKey();
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : entry.getValue()) {
                KeyStroke[] keyStrokeArray;
                if (string.length() == 0 || (keyStrokeArray = MutableShortcutsModel.getKeyStrokes(string, " ")) == null) continue;
                StringBuffer stringBuffer = new StringBuffer(Utilities.keyToString((KeyStroke)keyStrokeArray[0], (boolean)true));
                int n = keyStrokeArray.length;
                for (int i = 1; i < n; ++i) {
                    stringBuffer.append(' ').append(Utilities.keyToString((KeyStroke)keyStrokeArray[i], (boolean)true));
                }
                hashSet.add(stringBuffer.toString());
            }
            hashMap.put(shortcutAction, hashSet);
        }
        return hashMap;
    }

    private static KeyStroke[] getKeyStrokes(String string, String string2) {
        if (string.length() == 0) {
            return new KeyStroke[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = KeyStrokeUtils.getKeyStroke(string3);
            if (keyStroke == null) {
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    public Set<String> getCategories() {
        return this.model.getActionCategories();
    }

    public List<Object> getItems(String string) {
        return this.getItems(string, true);
    }

    public List<Object> getItems(String string, boolean bl) {
        List<Object>[] listArray = this.categoryToActionsCache.get(string);
        if (listArray == null) {
            ArrayList<ShortcutAction> arrayList = new ArrayList<ShortcutAction>();
            List list = Collections.emptyList();
            HashSet<String> hashSet = new HashSet<String>(this.model.getActionCategories());
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.startsWith(string)) {
                    iterator.remove();
                    continue;
                }
                if (string.length() <= 0 || string2.length() <= string.length() || string2.charAt(string.length()) == '/') continue;
                iterator.remove();
            }
            for (String string2 : hashSet) {
                Set<ShortcutAction> set = this.model.getActions(string2);
                arrayList.addAll(set);
                if (string2.length() != string.length()) continue;
                list = new ArrayList<ShortcutAction>(set);
            }
            Collections.sort(arrayList, new KeymapViewModel.ActionsComparator());
            if (!list.isEmpty()) {
                Collections.sort(list, new KeymapViewModel.ActionsComparator());
            }
            listArray = new List[]{arrayList, list};
            this.categoryToActionsCache.put(string, listArray);
        }
        return bl ? listArray[0] : listArray[1];
    }

    boolean differsFromDefault(String string) {
        if (this.modifiedProfiles.containsKey(string)) {
            return true;
        }
        if (this.revertedProfiles.contains(string)) {
            return false;
        }
        return !this.model.getKeymapDefaults(string).equals(this.model.getKeymap(string));
    }
}

